/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.ase;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.RMSServerStatusSO;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RMSASE
extends RMSServerStatusSO
implements ASE,
Comparable {
    String _lastMonitored = null;
    String _monitoredBy = null;
    String _versionString = null;
    private static final String GET_ASES = "GET_ASES";
    private static final String GET_ASE = "GET_ASE";
    private static final Object[][] contents = new Object[][]{{"GET_ASES", new Integer(1500), "get servers ASE"}, {"GET_ASE", new Integer(1500), "get servers {0}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSASE(String string, RMSDomain rMSDomain) {
        super(string, rMSDomain);
        this.setState(3);
        this.clearReasons();
    }

    public int compareTo(Object object) {
        if (object instanceof RMSASE) {
            return this.getName().compareTo(((RMSASE)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-RMSASE object.");
        return -1;
    }

    @Override
    public String getServerType() {
        return "Adaptive Server Enterprise";
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "ASE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASE getASE(String string, RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        RMSASE rMSASE = null;
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_ASE, n, string);
            Dbg.wassert(string2 != null, "Unable to get server command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (string3 != null && string3.equals(string) && string4 != null && string4.equalsIgnoreCase("ASE")) {
                        rMSASE = new RMSASE(string, rMSDomain);
                        rMSASE._lastMonitored = rSMResultSet.getColumnString(3);
                        rMSASE._versionString = rSMResultSet.getColumnString(4);
                        rMSASE.setState(rSMResultSet.getColumnInt(5));
                        String string5 = rSMResultSet.getColumnString(7);
                        if (string5 != null && string5.length() > 0) {
                            rMSASE.addReason(string5);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return rMSASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getASEs(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain connection parameter.");
        ArrayList<RMSASE> arrayList = new ArrayList<RMSASE>(1);
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_ASES, n);
            Dbg.wassert(string != null, "Unable to get ASE command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    RMSASE rMSASE = new RMSASE(string2, rMSDomain);
                    String string3 = rSMResultSet.getColumnString(2);
                    if (!string3.equalsIgnoreCase(rMSASE.getRMSType())) continue;
                    rMSASE._lastMonitored = rSMResultSet.getColumnString(3);
                    rMSASE._versionString = rSMResultSet.getColumnString(4);
                    rMSASE.setState(rSMResultSet.getColumnInt(5));
                    String string4 = rSMResultSet.getColumnString(7);
                    if (string4 != null && string4.length() > 0) {
                        rMSASE.addReason(string4);
                    }
                    arrayList.add(rMSASE);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public String getVersionString() {
        return this._versionString != null ? this._versionString : "";
    }

    @Override
    public String getLastMonitoredDate() {
        return this._lastMonitored != null ? this._lastMonitored : "";
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("ASERes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("ASERes", "DOWN_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("ASERes", "SUSPECT_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("ASERes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("ASERes", "UNKNOWN_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected ASE State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    @Override
    public void enableReplication() throws SQLException {
    }

    @Override
    public boolean areRAThreadsEnabled() throws SQLException {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean loginExists(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user name parameter.");
        boolean bl = false;
        return bl;
    }

    @Override
    public void addLogin(String string, String string2) throws SQLException {
    }

    @Override
    public void unlockLogin(String string) throws SQLException {
    }

    @Override
    public boolean supportsMasterDB() {
        return false;
    }
}

