/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.asa.ASAComboBox;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.CmdSummaryDlg;
import com.sybase.rsmplugin.components.ConfigModalDlg;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ServerStatusSO;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.connection.ConnWizInitPanel;
import com.sybase.rsmplugin.components.connection.ConnWizMaintPanel;
import com.sybase.rsmplugin.components.connection.ConnWizRAPanel;
import com.sybase.rsmplugin.components.connection.ConnWizRAUserPanel;
import com.sybase.rsmplugin.components.connection.ConnWizRSPanel;
import com.sybase.rsmplugin.components.connection.ConnWizServerPanel;
import com.sybase.rsmplugin.components.connection.ConnWizTypePanel;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentParameter;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentParameter;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.ServerInterfaces;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddConnWizard
extends BaseWizard {
    protected SCPageController[] _pages = null;
    protected int _summaryPageIdx = 0;
    protected BaseContainer _container;
    protected String _domain = null;
    protected String _DS = null;
    protected String _DB = null;
    protected String _controllingRS = null;
    protected String _maintUser = null;
    protected String _maintPwd = null;
    protected boolean _isPrimary = false;
    protected String _raUser = null;
    protected String _raPwd = null;
    protected String _ra = null;
    protected List _raParamList = null;
    protected boolean _isMRA = false;
    protected boolean _init = false;
    protected boolean _trunc = false;
    protected boolean _initRA = false;

    public AddConnWizard(BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2, String string, String string2) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null BaseContainer parameter.");
        this._container = baseContainer;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        this._controllingRS = string;
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty environment name parameter.");
        this._domain = string2;
    }

    public AddConnWizard(BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2, String string, String string2, String string3) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null BaseContainer parameter.");
        this._container = baseContainer;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server name parameter.");
        this._DS = string;
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        this._DB = string2;
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty environment name parameter.");
        this._domain = string3;
    }

    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null environment connection attribute.");
        return this._domain;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("ConnectionRes", "ADD_CONN_WIZARD_TITLE");
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new ControllingRSPage(this), new DBPage(this), new MaintPage(this), new ConnTypePage(this), new RAPage(this), new RAUserPage(this), new RAInitPage(this), new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    return AddConnWizard.this.toFormattedString();
                }
            }};
            this._summaryPageIdx = this._pages.length;
        }
        return this._pages;
    }

    public String toFormattedString() {
        String string = "";
        String string2 = this._DS + "." + this._DB;
        string = this._isPrimary ? string + BundleManager.getString("ConnectionRes", "CONN_WIZ_SUM_PRI", string2) + "\n" : string + BundleManager.getString("ConnectionRes", "CONN_WIZ_SUM_REP", string2) + "\n";
        string = string + BundleManager.getString("ConnectionRes", "SUMMARY_RS", this._controllingRS) + "\n";
        string = string + BundleManager.getString("ConnectionRes", "SUMMARY_MAINT_USER", this._maintUser) + "\n";
        if (this._isPrimary) {
            string = string + BundleManager.getString("ConnectionRes", "SUMMARY_RA_USER", this._raUser) + "\n";
            if (this._ra != null) {
                string = string + BundleManager.getString("ConnectionRes", "SUMMARY_RA", this._ra) + "\n";
                if (this._isMRA) {
                    if (this._init) {
                        string = string + BundleManager.getString("ConnectionRes", "CONN_WIZ_PDB_INIT") + "\n";
                    }
                    if (this._trunc) {
                        string = string + BundleManager.getString("ConnectionRes", "CONN_WIZ_TRUNC") + "\n";
                    }
                    if (this._init) {
                        string = string + BundleManager.getString("ConnectionRes", "CONN_WIZ_RA_INIT") + "\n";
                    }
                } else if (this._init) {
                    string = string + BundleManager.getString("ConnectionRes", "CONN_WIZ_PDB_XLOG") + "\n";
                }
            }
        }
        return string;
    }

    @Override
    public boolean onWizardFinish() {
        Object object;
        this.getDialogSupport().startWait();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        PhyConnection phyConnection = semanticFactory.getPhyConnection(this._controllingRS, this._DS, this._DB);
        phyConnection.setMaintUser(this._maintUser);
        phyConnection.setMaintPwd(this._maintPwd);
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._isPrimary) {
            if (this._ra != null && this._ra.length() > 0) {
                bl = this.saveConfigParams(arrayList);
                if (bl) {
                    bl = phyConnection.createNonASEPrimary(this._raUser, this._raPwd, arrayList);
                }
                if (bl && this._init) {
                    object = semanticFactory.getLANRepAgent(this._ra);
                    if (object != null) {
                        try {
                            String string = BundleManager.getString("LANRepAgentRes", "INIT_STATUS", object.getName());
                            arrayList.add(string);
                            object.initialize();
                        }
                        catch (SQLException sQLException) {
                            String string = MessageText.formatExceptionMessage(sQLException);
                            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
                            arrayList.add("E. " + string);
                            bl = false;
                        }
                    } else {
                        MirrorRepAgent mirrorRepAgent = semanticFactory.getMirrorRepAgent(this._ra);
                        if (mirrorRepAgent != null) {
                            try {
                                String string = BundleManager.getString("MirrorRepAgentRes", "INIT_STATUS", mirrorRepAgent.getName());
                                arrayList.add(string);
                                mirrorRepAgent.pdbInitialize(this._trunc);
                                if (this._initRA) {
                                    string = BundleManager.getString("MirrorRepAgentRes", "RA_INIT_STATUS", mirrorRepAgent.getName());
                                    arrayList.add(string);
                                    mirrorRepAgent.raInitialize();
                                }
                            }
                            catch (SQLException sQLException) {
                                String string = MessageText.formatExceptionMessage(sQLException);
                                PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
                                arrayList.add("E. " + string);
                                bl = false;
                            }
                        }
                    }
                }
            } else {
                bl = phyConnection.createPrimary(this._raUser, this._raPwd, arrayList);
            }
        } else {
            object = semanticFactory.getDataServer(this._DS);
            if (object != null) {
                bl = object instanceof ASE ? phyConnection.createReplicate(arrayList) : phyConnection.createNonASEReplicate(arrayList);
            }
        }
        this.getDialogSupport().endWait();
        if (arrayList.size() > 0) {
            arrayList.add(BundleManager.getString("ConnectionRes", "END_OF_PROCESS_SUMMARY"));
            object = new CmdSummaryDlg(PluginSupport.getDialogSupport(this.getJDialog()), arrayList);
            ((CmdSummaryDlg)object).setDescription(this.getTitle());
            ((CmdSummaryDlg)object).showDialog();
        }
        if (bl) {
            super.onWizardFinish();
            PluginSupport.refreshDomain(this._container);
        }
        return bl;
    }

    protected boolean saveConfigParams(List list) {
        String string = BundleManager.getString("LANRepAgentRes", "SUM_SET_PARAM", this._ra);
        list.add(string);
        boolean bl = true;
        if (this._raParamList != null && this._ra != null) {
            ListIterator listIterator = this._raParamList.listIterator();
            while (listIterator.hasNext()) {
                try {
                    RSMObjectRow rSMObjectRow;
                    if (this._isMRA) {
                        rSMObjectRow = (MirrorRepAgentParameter)listIterator.next();
                        ((MirrorRepAgentParameter)rSMObjectRow).alter(this._ra);
                        continue;
                    }
                    rSMObjectRow = (LANRepAgentParameter)listIterator.next();
                    ((LANRepAgentParameter)rSMObjectRow).alter(this._ra);
                }
                catch (SQLException sQLException) {
                    string = MessageText.formatExceptionMessage(sQLException);
                    PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
                    list.add("E. " + string);
                    bl = false;
                }
            }
        }
        return bl;
    }

    class RAInitPage
    extends BaseWizardPage
    implements ActionListener {
        private ConnWizInitPanel _goPage;

        public RAInitPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "CONN_WIZ_INIT_TITLE"));
            this._goPage = new ConnWizInitPanel();
            this._goPage.btn_configRA.addActionListener((ActionListener)this);
            this._goPage.chk_initPDB.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
            LANRepAgent lANRepAgent = semanticFactory.getLANRepAgent(AddConnWizard.this._ra);
            this._goPage.chk_initPDB.setSelected(AddConnWizard.this._init);
            if (AddConnWizard.this._isMRA) {
                this._goPage.txt_initPDB.setText(BundleManager.getString("ConnectionRes", "CONN_WIZ_PDB_INIT_DESC"));
                this._goPage.chk_trunc.setVisible(true);
                this._goPage.chk_trunc.setEnabled(true);
                this._goPage.chk_trunc.setSelected(AddConnWizard.this._trunc);
                this._goPage.chk_initRA.setVisible(true);
                this._goPage.chk_initRA.setEnabled(true);
                this._goPage.chk_initRA.setSelected(AddConnWizard.this._initRA);
            } else {
                this._goPage.txt_initPDB.setText(BundleManager.getString("ConnectionRes", "CONN_WIZ_PDB_XLOG_DESC"));
                this._goPage.chk_trunc.setVisible(false);
                this._goPage.chk_trunc.setEnabled(false);
                this._goPage.chk_trunc.setSelected(false);
                this._goPage.chk_initRA.setVisible(false);
                this._goPage.chk_initRA.setEnabled(false);
                this._goPage.chk_initRA.setSelected(false);
            }
            try {
                if (AddConnWizard.this._raParamList != null) {
                    AddConnWizard.this._raParamList.clear();
                    AddConnWizard.this._raParamList = null;
                }
                AddConnWizard.this._raParamList = AddConnWizard.this._isMRA ? semanticFactory.getMirrorRepAgentParameters(AddConnWizard.this._ra) : semanticFactory.getLANRepAgentParameters(AddConnWizard.this._ra);
                this.configure();
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this.enableBackButton(true);
            this.enableNextButton(true);
            this._goPage.btn_configRA.requestFocus();
            return true;
        }

        public void configure() {
            Object object;
            String string;
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
            ServerInterfaces serverInterfaces = null;
            try {
                serverInterfaces = new ServerInterfaces();
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
                serverInterfaces = null;
            }
            EnvDomain envDomain = (EnvDomain)PluginSupport.getDomain(AddConnWizard.this.getDomainName());
            ConnAttributes connAttributes = envDomain.getServer(AddConnWizard.this._controllingRS);
            if (connAttributes != null) {
                string = connAttributes.getHost();
                if (string == null || string.length() == 0) {
                    string = serverInterfaces.getHostName(AddConnWizard.this._controllingRS);
                }
                if (string != null && string.length() > 0) {
                    this.setParameter("rs_host_name", string);
                }
                if ((object = connAttributes.getPort()) == null || ((String)object).length() == 0) {
                    object = serverInterfaces.getPortNumber(AddConnWizard.this._controllingRS);
                }
                if (object != null && ((String)object).length() > 0) {
                    this.setParameter("rs_port_number", (String)object);
                }
            }
            if ((string = this.getParameter("use_rssd")) != null) {
                String string2;
                if (string.equalsIgnoreCase("true") && (object = envDomain.getRSSDServer(AddConnWizard.this._controllingRS)) != null) {
                    String string3;
                    String string4;
                    String string5;
                    string2 = ((ConnAttributes)object).getHost();
                    if (string2 == null || string2.length() == 0) {
                        string2 = serverInterfaces.getHostName(((ConnAttributes)object).getServer());
                    }
                    if (string2 != null && string2.length() > 0) {
                        this.setParameter("rssd_host_name", string2);
                    }
                    if ((string5 = ((ConnAttributes)object).getPort()) == null || string5.length() == 0) {
                        string5 = serverInterfaces.getPortNumber(((ConnAttributes)object).getServer());
                    }
                    if (string5 != null && string5.length() > 0) {
                        this.setParameter("rssd_port_number", string5);
                    }
                    if ((string4 = ((ConnAttributes)object).getUser()) != null && string4.length() > 0) {
                        this.setParameter("rssd_username", string4);
                    }
                    if ((string3 = ((ConnAttributes)object).getPassword()) != null && string3.length() > 0) {
                        this.setParameter("rssd_password", string3);
                    }
                }
                if ((object = semanticFactory.getRepServer(AddConnWizard.this._controllingRS)) != null && !object.isEmbeddedRSSD() && (string2 = object.getRSSDDatabase()) != null && string2.length() > 0) {
                    this.setParameter("rssd_database_name", string2);
                }
            }
            this.setParameter("rs_username", AddConnWizard.this._raUser);
            this.setParameter("rs_password", AddConnWizard.this._raPwd);
            this.setParameter("rs_source_ds", AddConnWizard.this._DS);
            this.setParameter("rs_source_db", AddConnWizard.this._DB);
        }

        protected String getParameter(String string) {
            ListIterator listIterator = AddConnWizard.this._raParamList.listIterator();
            while (listIterator.hasNext()) {
                ConfigParameter configParameter = (ConfigParameter)listIterator.next();
                if (!configParameter.getName().equals(string)) continue;
                return configParameter.getPendingValue();
            }
            return null;
        }

        protected void setParameter(String string, String string2) {
            ListIterator listIterator = AddConnWizard.this._raParamList.listIterator();
            while (listIterator.hasNext()) {
                ConfigParameter configParameter = (ConfigParameter)listIterator.next();
                if (!configParameter.getName().equals(string)) continue;
                configParameter.setPendingValue(string2);
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddConnWizard.this._init = this._goPage.chk_initPDB.isSelected();
            AddConnWizard.this._trunc = this._goPage.chk_trunc.isSelected();
            AddConnWizard.this._initRA = this._goPage.chk_initRA.isSelected();
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_configRA) {
                ConfigModalDlg configModalDlg = new ConfigModalDlg(PluginSupport.getDialogSupport(this.getController().getJDialog()), AddConnWizard.this._raParamList, AddConnWizard.this._ra);
                configModalDlg.showModalDialog();
            } else if (actionEvent.getSource() == this._goPage.chk_initPDB && this._goPage.chk_trunc.isEnabled() && this._goPage.chk_initPDB.isSelected()) {
                this._goPage.chk_trunc.setSelected(false);
            }
        }
    }

    class RAUserPage
    extends BaseWizardPage
    implements DocumentListener {
        private ConnWizRAUserPanel _goPage;

        public RAUserPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "WIZ_RA_TITLE"));
            this._goPage = new ConnWizRAUserPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = AddConnWizard.this._DB + "_rep_agent";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddConnWizard.this._raUser = this._goPage.fld_username.getText();
            AddConnWizard.this._raPwd = this._goPage.fld_password.getPasswordString();
            if (AddConnWizard.this._raPwd.equals("        ")) {
                AddConnWizard.this._raPwd = "rep_agent_ps";
            }
            if (AddConnWizard.this._ra == null) {
                return AddConnWizard.this._summaryPageIdx;
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class RAPage
    extends BaseWizardPage
    implements ActionListener {
        private ConnWizRAPanel _goPage;

        public RAPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "CONN_WIZ_RA_TITLE"));
            this._goPage = new ConnWizRAPanel();
            this.enableBackButton(false);
        }

        @Override
        public boolean onSetActive() {
            this.enableBackButton(true);
            this.load();
            if (AddConnWizard.this._ra != null && AddConnWizard.this._ra.length() > 0) {
                this._goPage.cbx_repagent.setSelectedItem(AddConnWizard.this._ra);
            }
            this._goPage.cbx_repagent.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddConnWizard.this._ra = this._goPage.cbx_repagent.getSelectedItem().toString();
            String string = BundleManager.getString("ConnectionRes", "CONN_WIZ_ASE_RAT");
            if (AddConnWizard.this._ra.equals(string)) {
                AddConnWizard.this._ra = null;
            } else {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
                MirrorRepAgent mirrorRepAgent = semanticFactory.getMirrorRepAgent(AddConnWizard.this._ra);
                AddConnWizard.this._isMRA = mirrorRepAgent != null;
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(AddConnWizard.this.getDomainName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddConnWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(AddConnWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_repagent.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
            if (semanticFactory != null) {
                ASE aSE = semanticFactory.getASE(AddConnWizard.this._DS);
                if (aSE != null) {
                    this._goPage.cbx_repagent.addItem((Object)BundleManager.getString("ConnectionRes", "CONN_WIZ_ASE_RAT"));
                    ListIterator listIterator = semanticFactory.getMirrorRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        MirrorRepAgent mirrorRepAgent = (MirrorRepAgent)listIterator.next();
                        this._goPage.cbx_repagent.addItem((Object)mirrorRepAgent.getName());
                    }
                } else {
                    ServerStatusSO serverStatusSO;
                    ListIterator listIterator = semanticFactory.getLANRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        serverStatusSO = (LANRepAgent)listIterator.next();
                        this._goPage.cbx_repagent.addItem((Object)serverStatusSO.getName());
                    }
                    listIterator = semanticFactory.getMirrorRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        serverStatusSO = (MirrorRepAgent)listIterator.next();
                        this._goPage.cbx_repagent.addItem((Object)serverStatusSO.getName());
                    }
                }
            }
            this.setButtons();
        }

        protected void setButtons() {
            Object object = this._goPage.cbx_repagent.getSelectedItem();
            this.enableNextButton(object != null);
        }
    }

    class ConnTypePage
    extends BaseWizardPage {
        private ConnWizTypePanel _goPage;

        public ConnTypePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "CONN_WIZ_TYPE_TITLE"));
            this._goPage = new ConnWizTypePanel();
            this.enableNextButton(true);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.rbn_replicate.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public int onWizardNext() {
            AddConnWizard.this._isPrimary = this._goPage.rbn_primary.isSelected();
            if (AddConnWizard.this._isPrimary) {
                RepAgent repAgent;
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
                ASE aSE = semanticFactory.getASE(AddConnWizard.this._DS);
                if (aSE != null && (repAgent = semanticFactory.getRepAgent(AddConnWizard.this._DS, AddConnWizard.this._DB)).isEnabled()) {
                    PluginSupport.showWarning(this.getDialogSupport().getParentWindow(), BundleManager.getString("ConnectionRes", "CONN_WIZ_ENABLED_RA_WARNING", AddConnWizard.this._DB), null);
                }
                return 0;
            }
            return AddConnWizard.this._summaryPageIdx;
        }
    }

    class MaintPage
    extends BaseWizardPage
    implements DocumentListener {
        private ConnWizMaintPanel _goPage;

        public MaintPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "WIZ_MAINT_TITLE"));
            this._goPage = new ConnWizMaintPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = AddConnWizard.this._DB + "_maint";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddConnWizard.this._maintUser = this._goPage.fld_username.getText();
            AddConnWizard.this._maintPwd = this._goPage.fld_password.getPasswordString();
            if (AddConnWizard.this._maintPwd.equals("        ")) {
                AddConnWizard.this._maintPwd = "maint_ps";
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class DBPage
    extends BaseWizardPage
    implements ActionListener {
        private ConnWizServerPanel _goPage;

        public DBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "CONN_WIZ_DB_TITLE"));
            this._goPage = new ConnWizServerPanel();
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            if (AddConnWizard.this._DS != null && AddConnWizard.this._DS.length() > 0) {
                this._goPage.cbx_server.addItem((Object)AddConnWizard.this._DS);
                this._goPage.cbx_database.addItem((Object)AddConnWizard.this._DB);
                this._goPage.cbx_server.setEnabled(false);
                this._goPage.cbx_database.setEnabled(false);
                this._goPage.btn_addServer.setEnabled(false);
            } else {
                this._goPage.cbx_server.setEnabled(true);
                this._goPage.cbx_database.setEnabled(true);
                this._goPage.btn_addServer.setEnabled(true);
                this._goPage.btn_addServer.addActionListener((ActionListener)this);
            }
            this.setButtons();
        }

        @Override
        public boolean onSetActive() {
            if (this._goPage.cbx_server.isEnabled()) {
                this.load();
                if (AddConnWizard.this._DS != null && AddConnWizard.this._DS.length() > 0) {
                    this._goPage.cbx_server.setSelectedItem(AddConnWizard.this._DS);
                }
                if (AddConnWizard.this._DB != null && AddConnWizard.this._DB.length() > 0) {
                    this._goPage.cbx_database.setSelectedItem(AddConnWizard.this._DB);
                }
                this._goPage.cbx_server.requestFocus();
            } else {
                this.getDialogSupport().getStandardButtonById(32).requestFocus();
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            if (this._goPage.cbx_server.isEnabled()) {
                AddConnWizard.this._DS = this._goPage.cbx_server.getSelectedItem().toString();
                AddConnWizard.this._DB = this._goPage.cbx_database.getSelectedItem().toString();
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    this.loadDatabases(object.toString(), this._goPage.cbx_database);
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(AddConnWizard.this.getDomainName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddConnWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(AddConnWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            this.loadDataServers(this._goPage.cbx_server);
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object = this._goPage.cbx_server.getSelectedItem();
            if (object != null) {
                this.loadDatabases(object.toString(), this._goPage.cbx_database);
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_database.getSelectedItem() != null);
        }

        protected void loadDataServers(ASAComboBox aSAComboBox) {
            Dbg.wassert(aSAComboBox != null, "Null combobox parameter.");
            aSAComboBox.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
            if (semanticFactory != null) {
                ListIterator listIterator = semanticFactory.getDataServers().listIterator();
                while (listIterator.hasNext()) {
                    DataServer dataServer = (DataServer)listIterator.next();
                    aSAComboBox.addItem((Object)dataServer.getName());
                }
            }
        }

        protected void loadDatabases(String string, ASAComboBox aSAComboBox) {
            SemanticFactory semanticFactory;
            Dbg.wassert(aSAComboBox != null, "Null combobox parameter.");
            aSAComboBox.removeAllItems();
            if (string != null && string.length() > 0 && (semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName())) != null) {
                try {
                    List list = semanticFactory.getPhyConnectionsForDataServer(string);
                    ListIterator listIterator = semanticFactory.getDatabases(string).listIterator();
                    while (listIterator.hasNext()) {
                        Database database = (Database)listIterator.next();
                        boolean bl = false;
                        ListIterator listIterator2 = list.listIterator();
                        while (listIterator2.hasNext() && !bl) {
                            PhyConnection phyConnection = (PhyConnection)listIterator2.next();
                            if (!phyConnection.getDB().equals(database.getName())) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        aSAComboBox.addItem((Object)database.getName());
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
    }

    class ControllingRSPage
    extends BaseWizardPage
    implements ActionListener {
        private ConnWizRSPanel _goPage;

        public ControllingRSPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("ConnectionRes", "CONN_WIZ_RS_TITLE"));
            this._goPage = new ConnWizRSPanel();
            this.enableBackButton(false);
        }

        @Override
        public void onInitDialog() {
            if (AddConnWizard.this._controllingRS != null && AddConnWizard.this._controllingRS.length() > 0) {
                this._goPage.cbx_repserver.addItem((Object)AddConnWizard.this._controllingRS);
                this._goPage.cbx_repserver.setEditable(false);
                this._goPage.cbx_repserver.setEnabled(false);
                this._goPage.btn_addServer.setEnabled(false);
                this.enableNextButton(true);
                this.getDialogSupport().getStandardButtonById(32).requestFocus();
            } else {
                this._goPage.cbx_repserver.setEnabled(true);
                this._goPage.btn_addServer.setEnabled(true);
                this._goPage.btn_addServer.addActionListener((ActionListener)this);
                this._goPage.cbx_repserver.requestFocus();
            }
        }

        @Override
        public boolean onSetActive() {
            if (this._goPage.cbx_repserver.isEnabled()) {
                this.load();
                if (AddConnWizard.this._controllingRS != null && AddConnWizard.this._controllingRS.length() > 0) {
                    this._goPage.cbx_repserver.setSelectedItem(AddConnWizard.this._controllingRS);
                }
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            if (this._goPage.cbx_repserver.isEnabled()) {
                AddConnWizard.this._controllingRS = this._goPage.cbx_repserver.getSelectedItem().toString();
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(AddConnWizard.this.getDomainName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddConnWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(AddConnWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_repserver.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddConnWizard.this.getDomainName());
            if (semanticFactory != null) {
                ListIterator listIterator = semanticFactory.getRepServers().listIterator();
                while (listIterator.hasNext()) {
                    RepServer repServer = (RepServer)listIterator.next();
                    this._goPage.cbx_repserver.addItem((Object)repServer.getName());
                }
            }
            this.setButtons();
        }

        protected void setButtons() {
            Object object = this._goPage.cbx_repserver.getSelectedItem();
            this.enableNextButton(object != null);
        }
    }
}

