/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ConnParameter
implements RSMObjectRow,
ConfigParameter {
    public static final int NAME_COLUMN = 0;
    public static final int DATATYPE_COLUMN = 1;
    public static final int DEFAULT_COLUMN = 2;
    public static final int LEGAL_VALUE_COLUMN = 3;
    public static final int CATEGORY_COLUMN = 4;
    public static final int RESTART_COLUMN = 5;
    public static final int SERVER_RESTART_YES = 0;
    public static final int SERVER_RESTART_NO = 1;
    public static final int CONN_RESTART_YES = 2;
    public static final int CONN_RESTART_NO = 3;
    public static final Object[][] _details = new Object[][]{{"batch", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"batch_begin", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"command_retry", new Integer(0), "3", "range: 0,50000", "General", new Integer(2)}, {"db_packet_size", new Integer(0), "512", " ", "General", new Integer(2)}, {"disk_affinity", new Integer(2), "off", " ", "General", new Integer(1)}, {"dist_stop_unsupported_cmd", new Integer(3), "off", "list: on, off", "General", new Integer(2)}, {"dsi_bulk_copy", new Integer(3), "off", "list: on, off", "General", new Integer(2)}, {"dsi_bulk_threshold", new Integer(0), "1000", "range: 1, 2147483648", "General", new Integer(2)}, {"dsi_charset_convert", new Integer(2), "on", "list: on, allow, off", "General", new Integer(2)}, {"dsi_cmd_batch_size", new Integer(0), "8192", " ", "General", new Integer(2)}, {"dsi_cmd_separator", new Integer(2), "\n", " ", "General", new Integer(2)}, {"dsi_commit_check_locks_intrvl", new Integer(0), "1000", "range: 0, 86400000", "General", new Integer(2)}, {"dsi_commit_check_locks_logs", new Integer(0), "200", "range: 1, 1000000", "General", new Integer(2)}, {"dsi_commit_check_locks_max", new Integer(0), "400", "range: 0, 1000000", "General", new Integer(2)}, {"dsi_commit_control", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"dsi_exec_request_sproc", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"dsi_fadeout_time", new Integer(0), "600", " ", "General", new Integer(2)}, {"dsi_ignore_underscore_name", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"dsi_keep_triggers", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"dsi_large_xact_size", new Integer(0), "100", "minimum: 4", "General", new Integer(2)}, {"dsi_max_cmds_to_log", new Integer(0), "-1", " ", "General", new Integer(2)}, {"dsi_max_text_to_log", new Integer(0), "-1", " ", "General", new Integer(2)}, {"dsi_max_xacts_in_group", new Integer(0), "20", "range: 1, 100 ", "General", new Integer(2)}, {"dsi_non_blocking_commit", new Integer(0), "0", "range: 0, 60", "General", new Integer(2)}, {"dsi_num_large_xact_threads", new Integer(0), "0", " ", "General", new Integer(2)}, {"dsi_num_threads", new Integer(0), "1", "range: 1, 255", "General", new Integer(2)}, {"dsi_partitioning_rule", new Integer(2), "none", " ", "General", new Integer(2)}, {"dsi_quoted_identifiers", new Integer(3), "off", "list: on, off", "General", new Integer(2)}, {"dsi_replication", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"dsi_serialization_method", new Integer(2), "wait_for_commit", "list: none, no_wait, wait_for_start, wait_for_commit, isolation_level_3, check_rows, single_transaction_per_origin", "General", new Integer(2)}, {"dsi_sql_data_style", new Integer(2), "", "db2, notes, watcom, sqlremote", "General", new Integer(2)}, {"dsi_sqt_max_cache_size", new Integer(0), "0", " ", "General", new Integer(2)}, {"dsi_text_convert_multiplier", new Integer(1), "1.0", " ", "General", new Integer(2)}, {"dsi_xact_group_size", new Integer(0), "65536", "range: -1, 2147483647", "General", new Integer(2)}, {"dump_load", new Integer(3), "on", "list: on, off", "General", new Integer(2)}, {"exec_cmds_per_timeslice", new Integer(0), "5", "range: 1, 2147483648", "General", new Integer(2)}, {"exec_sqm_write_request_limit", new Integer(0), "16384", "range: 16384, 983040", "General", new Integer(2)}, {"md_sqm_write_request_limit", new Integer(0), "100000", "range: 65536, 983040", "General", new Integer(2)}, {"msg_confidentiality", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"msg_integrity", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"msg_origin_check", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"msg_replay_detection", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"msg_sequence_check", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"mutual_auth", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"parallel_dsi", new Integer(3), "off", "list: on, off", "General", new Integer(2)}, {"save_interval", new Integer(0), "0", "", "General", new Integer(2)}, {"security_mechanism", new Integer(2), "", " ", "General", new Integer(2)}, {"unified_login", new Integer(3), "not_required", "list: required, not_required", "General", new Integer(2)}, {"use_security_services", new Integer(2), "default", "list: on, off, default", "General", new Integer(2)}};
    private String _name;
    private String _currentValue;
    private String _pendingValue;
    private String _originalPendingValue;
    private String _defaultValue;
    private String _legalValues;
    private String _status;
    private int _datatype;
    private static final int COLUMN_COUNT = 3;

    public ConnParameter(String string, String string2, String string3) {
        this._name = string;
        this._currentValue = string2;
        this._pendingValue = string3;
        this._defaultValue = null;
        this._legalValues = null;
        this._status = null;
        this._datatype = -1;
        this.resetOriginalPendingValue();
    }

    public ConnParameter(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        this._name = string;
        this._currentValue = string2;
        this._pendingValue = string3;
        this._defaultValue = string4;
        this._legalValues = string5;
        this._status = string6;
        this._datatype = n;
        this.resetOriginalPendingValue();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract void alter(String var1, String var2, String var3) throws SQLException;

    public abstract String getRCLScript(String var1, String var2, String var3);

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getCurrentValue();
            }
            case 2: {
                if (!this.isModified() && this.getOriginalPendingValue().equals(this.getCurrentValue())) {
                    return "";
                }
                if (this.getDatatype() == 4) {
                    return "********";
                }
                return this.getPendingValue();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                this._name = (String)object;
                break;
            }
            case 1: {
                this._currentValue = (String)object;
                break;
            }
            case 2: {
                this._pendingValue = (String)object;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public String getPendingValue() {
        return this._pendingValue;
    }

    @Override
    public void setPendingValue(String string) {
        if (string != null && !this._pendingValue.equals(string)) {
            this._pendingValue = string;
        }
    }

    protected String getOriginalPendingValue() {
        return this._originalPendingValue;
    }

    public void resetOriginalPendingValue() {
        this._originalPendingValue = this._pendingValue;
    }

    @Override
    public boolean isModified() {
        return !this.getPendingValue().equals(this.getOriginalPendingValue());
    }

    @Override
    public String getDefaultValue() {
        if (this._defaultValue != null) {
            return this._defaultValue;
        }
        int n = this.getDetails();
        if (n == -1) {
            return " ";
        }
        return _details[n][2].toString();
    }

    @Override
    public String getStatus() {
        if (this._status != null) {
            return this._status;
        }
        int n = this.getDetails();
        if (n == -1) {
            return BundleManager.getString("ComponentRes", "Connection/route restart required");
        }
        int n2 = (Integer)_details[n][5];
        switch (n2) {
            case 0: {
                return BundleManager.getString("ComponentRes", "DISP_RESTART_YES_TEXT");
            }
            case 1: {
                return BundleManager.getString("ComponentRes", "DISP_RESTART_NO_TEXT");
            }
            case 2: {
                return BundleManager.getString("ComponentRes", "Connection/route restart required");
            }
            case 3: {
                return BundleManager.getString("ComponentRes", "Connection/route restart not required");
            }
        }
        return BundleManager.getString("ComponentRes", "Connection/route restart not required");
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public String getLegalValues() {
        if (this._legalValues != null) {
            return this._legalValues;
        }
        int n = this.getDetails();
        if (n == -1) {
            return " ";
        }
        return _details[n][3].toString();
    }

    @Override
    public String getExplanation() {
        String string;
        try {
            String string2 = "com.sybase.rsmplugin.resources.ConnParamDescRes";
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
            string = resourceBundle.getString(this.getName());
        }
        catch (MissingResourceException missingResourceException) {
            string = " ";
        }
        return string;
    }

    @Override
    public int getDatatype() {
        if (this._datatype != -1) {
            return this._datatype;
        }
        int n = this.getDetails();
        if (n == -1) {
            return 2;
        }
        return (Integer)_details[n][1];
    }

    protected int getDetails() {
        int n = 0;
        int n2 = _details.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            String string = (String)_details[n3][0];
            int n4 = this.getName().compareTo(string);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 >= 0) continue;
            n2 = n3 - 1;
        }
        return -1;
    }
}

