/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.ConnParameter;
import com.sybase.rsmplugin.components.connection.ConnPropGeneralPanel;
import com.sybase.rsmplugin.components.connection.ConnPropSecurityPanel;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.errorclass.ErrorClass;
import com.sybase.rsmplugin.components.functionstringclass.FunctionStringClass;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConnProperties
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected PhyConnection _so;
    protected BaseItem _item;
    protected List _paramList;
    private String _fsClass = null;
    private String _errorClass = null;
    private String _maintPwd = null;

    public ConnProperties(PhyConnection phyConnection, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) throws SQLException {
        super(sCDialogSupport2);
        Dbg.wassert(phyConnection != null, "Null PhyConnection parameter.");
        this._so = phyConnection;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        this._so.getConnDetails();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(phyConnection.getDomainName());
        try {
            phyConnection.loadProperties();
            this._paramList = semanticFactory.getConnParameters(phyConnection.getControllingRS(), phyConnection.getDS(), phyConnection.getDB());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
    }

    public PhyConnection getPhyConn() {
        return this._so;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("ConnectionRes", "PROPERTIES_TITLE", this.getPhyConn().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = this.getPhyConn().isControlledByRSMS() ? new SCPageController[]{new GeneralPage(this), new ConfigPage((BaseProperties)this, this._paramList)} : new SCPageController[]{new GeneralPage(this), new SecurityPage(this), new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        try {
            this.getPhyConn().alter(this._fsClass, this._errorClass, this._maintPwd);
            if (this.getItem() != null && this.getItem().getParent() != null) {
                this.getItem().getParent().refresh();
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            bl = true;
        }
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            ConnParameter connParameter = (ConnParameter)listIterator.next();
            if (connParameter == null) continue;
            try {
                connParameter.alter(this.getPhyConn().getControllingRS(), this.getPhyConn().getDS(), this.getPhyConn().getDB());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        try {
            this.getPhyConn().alter(this._fsClass, this._errorClass, this._maintPwd);
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            bl = true;
        }
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            ConnParameter connParameter = (ConnParameter)listIterator.next();
            if (connParameter == null) continue;
            try {
                connParameter.alter(this.getPhyConn().getControllingRS(), this.getPhyConn().getDS(), this.getPhyConn().getDB());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            super.onApply();
        }
    }

    class SecurityPage
    extends BasePropertyPage
    implements DocumentListener {
        private ConnPropSecurityPanel _goPage;

        public SecurityPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("ConnectionRes", "CONN_PROP_SECURITY_PAGE_TAB"));
            this._goPage = new ConnPropSecurityPanel();
        }

        @Override
        public void onInitDialog() {
            if (ConnProperties.this.getPhyConn().getMaintUser() != null) {
                this._goPage.fld_username.setText(ConnProperties.this.getPhyConn().getMaintUser());
            }
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
        }

        @Override
        public boolean onOk() {
            boolean bl = true;
            if (this.isModified()) {
                String string = this._goPage.fld_password.getPasswordString();
                String string2 = this._goPage.fld_confirmPwd.getPasswordString();
                if (string != null && string2 != null && !string.equals("        ")) {
                    if (string.equals(string2)) {
                        ConnProperties.this._maintPwd = string;
                    } else {
                        PluginSupport.showValidationError(BundleManager.getString("ConnectionRes", "PWD_MISMATCH"));
                        bl = false;
                    }
                }
            }
            return bl;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private ConnPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("ConnectionRes", "GENERAL_PAGE_TAG"));
            this._goPage = new ConnPropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(ConnProperties.this.getPhyConn().getName());
            this._goPage.fld_raStatus.setText(ConnProperties.this.getPhyConn().getRepAgentStateString());
            this._goPage.fld_dsiStatus.setText(ConnProperties.this.getPhyConn().getDSIStateString());
            this._goPage.fld_reason.setText(ConnProperties.this.getPhyConn().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(ConnProperties.this.getPhyConn().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(ConnProperties.this.getPhyConn().getDomainName());
            Dbg.wassert(semanticFactory != null, "Unable to get semantic factory for '" + ConnProperties.this.getPhyConn().getDomainName() + "'.");
            this._goPage.fld_rsController.setText(ConnProperties.this.getPhyConn().getControllingRS());
            this._goPage.fld_connType.setText(ConnProperties.this.getPhyConn().getConnectionType());
            if (ConnProperties.this.getPhyConn().isControlledByRSMS()) {
                this._goPage.lbl_logicalConn.setVisible(false);
                this._goPage.fld_logicalConn.setVisible(false);
                this._goPage.lbl_isRSSD.setVisible(false);
                this._goPage.fld_isRSSD.setVisible(false);
                this._goPage.sep1.setVisible(false);
                this._goPage.lbl_fsClass.setVisible(false);
                this._goPage.cbx_fsClass.setVisible(false);
                this._goPage.lbl_errorClass.setVisible(false);
                this._goPage.cbx_errorClass.setVisible(false);
            } else {
                ListIterator listIterator;
                if (ConnProperties.this.getPhyConn().isPartOfLogicalConnection()) {
                    this._goPage.fld_logicalConn.setText(ConnProperties.this.getPhyConn().getLogicalConnection());
                }
                if (ConnProperties.this.getPhyConn().isRSSD()) {
                    this._goPage.fld_isRSSD.setText(BundleManager.getString("ConnectionRes", "DISP_YES_TEXT"));
                } else {
                    this._goPage.fld_isRSSD.setText(BundleManager.getString("ConnectionRes", "DISP_NO_TEXT"));
                }
                try {
                    listIterator = semanticFactory.getFunctionStringClasses(ConnProperties.this.getPhyConn().getControllingRS()).listIterator();
                    while (listIterator.hasNext()) {
                        FunctionStringClass functionStringClass = (FunctionStringClass)listIterator.next();
                        this._goPage.cbx_fsClass.addItem((Object)functionStringClass.getName());
                    }
                    int n = this._goPage.cbx_fsClass.findItem(ConnProperties.this.getPhyConn().getFunctionStringClass());
                    if (n >= 0) {
                        this._goPage.cbx_fsClass.setSelectedIndex(n);
                    }
                    this._goPage.cbx_fsClass.addActionListener((ActionListener)this);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                try {
                    listIterator = semanticFactory.getErrorClasses(ConnProperties.this.getPhyConn().getControllingRS()).listIterator();
                    while (listIterator.hasNext()) {
                        ErrorClass errorClass = (ErrorClass)listIterator.next();
                        this._goPage.cbx_errorClass.addItem((Object)errorClass.getName());
                    }
                    int n = this._goPage.cbx_fsClass.findItem(ConnProperties.this.getPhyConn().getErrorClass());
                    if (n >= 0) {
                        this._goPage.cbx_errorClass.setSelectedIndex(n);
                    }
                    this._goPage.cbx_errorClass.addActionListener((ActionListener)this);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                ConnProperties.this._fsClass = this._goPage.cbx_fsClass.getSelectedItem().toString();
                ConnProperties.this._errorClass = this._goPage.cbx_errorClass.getSelectedItem().toString();
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), ConnProperties.this.getPhyConn().getReasons(), ConnProperties.this.getPhyConn().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }
    }
}

