/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.ase.ASEContainer;
import com.sybase.rsmplugin.components.connection.ConnProperties;
import com.sybase.rsmplugin.components.connection.ExceptionLogDlg;
import com.sybase.rsmplugin.components.connection.FilterDlg;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.connection.ResumeDlg;
import com.sybase.rsmplugin.components.connection.SuspendDlg;
import com.sybase.rsmplugin.components.hds.HDSContainer;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repagent.RepAgentProp;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RCLEditor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class ConnectionBase
extends BaseContainer
implements StatusItem {
    private static final int CMD_EXCEPTIONS = 3008;
    private static final int CMD_RA_PROPS = 3009;
    private static final int FILTER_STATE = 3010;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;
    private PhyConnection _so;

    public ConnectionBase(PhyConnection phyConnection, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(phyConnection != null, "Null physical connection semantic object parameter.");
        this._so = phyConnection;
        StatusManager.addStatusItem(this);
    }

    public ConnectionBase(PhyConnection phyConnection) {
        Dbg.wassert(phyConnection != null, "Null physical connection semantic object parameter.");
        this._so = phyConnection;
        StatusManager.addStatusItem(this);
    }

    public PhyConnection getPhyConnection() {
        return this._so;
    }

    public ImageIcon getUpIcon() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getConnectionUp());
        }
        return _iconUp;
    }

    public ImageIcon getDownIcon() {
        if (_iconDown == null) {
            _iconDown = new ImageIcon(RSMImages.getConnectionDown());
        }
        return _iconDown;
    }

    public ImageIcon getSuspectIcon() {
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getConnectionSuspect());
        }
        return _iconSuspect;
    }

    @Override
    public String getName() {
        return this.getPhyConnection().getName();
    }

    @Override
    public Icon getStandardImage() {
        return this.getUpIcon();
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getPhyConnection().isWarning()) {
            return this.getSuspectIcon();
        }
        if (this.getPhyConnection().isUp()) {
            return this.getUpIcon();
        }
        return this.getDownIcon();
    }

    @Override
    public String getDisplayName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                if (this.getParent() instanceof ASEContainer || this.getParent() instanceof HDSContainer) {
                    string = this.getPhyConnection().getDB();
                    break;
                }
                string = this.getPhyConnection().getName();
                break;
            }
            case 1: {
                string = this.getPhyConnection().getRepAgentStateString();
                break;
            }
            case 2: {
                string = this.getPhyConnection().getDSIStateString();
                break;
            }
            case 3: {
                string = this.getPhyConnection().getReason();
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106 || n == 3007 || n == 3006 || n == 3010;
    }

    @Override
    public SCMenu getContextMenu() {
        RepAgent repAgent;
        ASE aSE;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getPhyConnection().getDomainName());
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu(BundleManager.getString("ConnectionRes", "MENU_ADD_CONN"));
        defaultSCMenu.setMnemonic((int)BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_ADD_CONN"));
        String string = BundleManager.getString("ConnectionRes", "MENU_RESUME");
        String string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_RESUME");
        char c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_RESUME");
        MenuItem menuItem = new MenuItem(3006, string, string2, c);
        defaultSCMenu.addItem((SCMenuItem)menuItem);
        string = BundleManager.getString("ConnectionRes", "MENU_SUSPEND");
        string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_SUSPEND");
        c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_SUSPEND");
        menuItem = new MenuItem(3007, string, string2, c);
        defaultSCMenu.addItem((SCMenuItem)menuItem);
        string = BundleManager.getString("ConnectionRes", "MENU_FILTER");
        string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_FILTER");
        c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_FILTER");
        menuItem = new MenuItem(3010, string, string2, c);
        defaultSCMenu.addItem((SCMenuItem)menuItem);
        if (!this.getPhyConnection().isControlledByRSMS()) {
            string = BundleManager.getString("ConnectionRes", "MENU_EXCEPTIONS");
            string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_EXCEPTIONS");
            c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_EXCEPTIONS");
            menuItem = new MenuItem(3008, string, string2, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        if (this.getPhyConnection().isPrimary() && (aSE = semanticFactory.getASE(this.getPhyConnection().getDS())) != null && (repAgent = semanticFactory.getRepAgent(this.getPhyConnection().getDS(), this.getPhyConnection().getDB())) != null && repAgent.isEnabled()) {
            string = BundleManager.getString("ConnectionRes", "MENU_RA_PROPS");
            string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_RA_PROPS");
            c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_RA_PROPS");
            menuItem = new MenuItem(3009, string, string2, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        if (!this.getPhyConnection().isControlledByRSMS()) {
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        }
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getPhyConnection().isControlledByRSMS()) {
            return 64;
        }
        return 96;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof ConnectionBase)) continue;
                    ((ConnectionBase)baseItem).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(ConnProperties.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                try {
                    SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                    ConnProperties connProperties = new ConnProperties(this.getPhyConnection(), this, sCDialogSupport2);
                    connProperties.showDialog();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                break;
            }
            case 3009: {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getPhyConnection().getDomainName());
                Dbg.wassert(semanticFactory != null, "Unexpected missing semantic factory for connection: " + this.getPhyConnection().getDomainName());
                RepAgent repAgent = semanticFactory.getRepAgent(this.getPhyConnection().getDS(), this.getPhyConnection().getDB());
                repAgent.setControllingRS(this.getPhyConnection().getControllingRS());
                BaseController baseController = PluginSupport.getDialog(RepAgentProp.class, repAgent.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                RepAgentProp repAgentProp = new RepAgentProp(repAgent, this, sCDialogSupport2);
                repAgentProp.showDialog();
                break;
            }
            case 3008: {
                BaseController baseController = PluginSupport.getDialog(ExceptionLogDlg.class, this.getPhyConnection().getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                ExceptionLogDlg exceptionLogDlg = new ExceptionLogDlg(sCDialogSupport2, this.getPhyConnection());
                exceptionLogDlg.showDialog();
                break;
            }
            case 3007: {
                BaseItem baseItem;
                BaseController baseController = PluginSupport.getDialog(SuspendDlg.class, this.getPhyConnection().getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
                while (enumeration.hasMoreElements()) {
                    baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof ConnectionBase)) continue;
                    arrayList.add(((ConnectionBase)baseItem).getPhyConnection());
                }
                if (arrayList.size() <= 0) break;
                baseItem = PluginSupport.getDialogSupport(jFrame);
                SuspendDlg suspendDlg = new SuspendDlg(arrayList, (SCDialogSupport2)baseItem);
                suspendDlg.showDialog();
                break;
            }
            case 3006: {
                BaseItem baseItem;
                BaseController baseController = PluginSupport.getDialog(ResumeDlg.class, this.getPhyConnection().getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
                while (enumeration.hasMoreElements()) {
                    baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof ConnectionBase)) continue;
                    arrayList.add(((ConnectionBase)baseItem).getPhyConnection());
                }
                if (arrayList.size() <= 0) break;
                baseItem = PluginSupport.getDialogSupport(jFrame);
                ResumeDlg resumeDlg = new ResumeDlg(arrayList, (SCDialogSupport2)baseItem);
                resumeDlg.showDialog();
                break;
            }
            case 3010: {
                BaseItem baseItem;
                BaseController baseController = PluginSupport.getDialog(FilterDlg.class, this.getPhyConnection().getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
                while (enumeration.hasMoreElements()) {
                    baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof ConnectionBase)) continue;
                    arrayList.add(((ConnectionBase)baseItem).getPhyConnection());
                }
                if (arrayList.size() <= 0) break;
                baseItem = PluginSupport.getDialogSupport(jFrame);
                FilterDlg filterDlg = new FilterDlg(arrayList, (SCDialogSupport2)baseItem);
                filterDlg.showDialog();
                break;
            }
            case 3001: {
                try {
                    RCLEditor.open(this.getPhyConnection().getRCLScript());
                    break;
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
    }

    protected void drop() {
        try {
            this.getPhyConnection().delete();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    public void setState(int n) {
        this.getPhyConnection().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getPhyConnection().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getPhyConnection().getDomainName();
    }

    @Override
    public String getType() {
        return this.getPhyConnection().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getPhyConnection().getStateString();
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DatabaseRes", "COL_HEADER_FOLDERS")};
    }
}

