/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.central.SCItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.ConnectionBase;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefFolder;
import com.sybase.rsmplugin.components.dbsubscription.DBSubFolder;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedureFolder;
import com.sybase.rsmplugin.components.table.TableFolder;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.util.Dbg;

public class ConnectionContainer
extends ConnectionBase
implements RMContainer,
StatusItem {
    private static final String CLASS_ID = "connection.ConnectionContainer";

    public ConnectionContainer(PhyConnection phyConnection, BaseContainer baseContainer) {
        super(phyConnection, baseContainer);
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    @Override
    public void open(int n) {
        if (!this.isOpen()) {
            super.open(n);
            String string = this.getPhyConnection().getControllingRS();
            Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling repserver.");
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Dbg.wassert(semanticFactory != null, "Null semantic factory for domain named: " + this.getDomainName());
            RepServer repServer = semanticFactory.getRepServer(this.getPhyConnection().getControllingRS());
            int n2 = repServer.getVersionNumber();
            DataServer dataServer = semanticFactory.getDataServer(this.getPhyConnection().getDS());
            if (!this.getPhyConnection().isMasterDBConnection()) {
                this.addItem((SCItem)new TableFolder(this.getDomainName(), this, this.getPhyConnection().getDS(), this.getPhyConnection().getDB(), string));
                if (dataServer != null && dataServer.supportsStoredProcedures()) {
                    this.addItem((SCItem)new StoredProcedureFolder(this.getDomainName(), this, this.getPhyConnection().getDS(), this.getPhyConnection().getDB(), string));
                }
            }
            if (dataServer != null && dataServer.supportsDBLevelReplication()) {
                if (this.getPhyConnection().isPrimary() && n2 >= 1260) {
                    this.addItem((SCItem)new DBRepDefFolder(this.getDomainName(), this, this.getPhyConnection().getDS(), this.getPhyConnection().getDB(), string));
                    this.addItem((SCItem)new DBSubFolder(this.getDomainName(), this, this.getPhyConnection().getDS(), this.getPhyConnection().getDB(), string));
                } else if (this.getPhyConnection().isReplicate() && n2 >= 1260) {
                    this.addItem((SCItem)new DBSubFolder(this.getDomainName(), this, this.getPhyConnection().getDS(), this.getPhyConnection().getDB(), string));
                }
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DatabaseRes", "COL_HEADER_FOLDERS")};
    }
}

