/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.ExternalSecurity;
import com.sybase.rsmplugin.components.connection.ConnParameter;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainConnParameter
extends ConnParameter {
    private EnvDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_PARAM = "SET_PARAM";
    private static final String GET_PARAMS_NEW = "GET_PARAMS_NEW";
    public static final int VIVACI_VERSION_NR = 1501;
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(1200), "rmp_connection_demand {0}, {1}, {2}"}, {"GET_PARAMS_NEW", new Integer(1200), "admin config, \"connection\", {0}, {1}"}, {"SET_PARAM", new Integer(1200), "alter connection to {0}.{1} set {2} to ''{3}''"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainConnParameter(String string, String string2, String string3, EnvDomain envDomain) {
        super(string, string2, string3);
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public DomainConnParameter(String string, String string2, String string3, String string4, String string5, String string6, int n, EnvDomain envDomain) {
        super(string, string2, string3, string4, string5, string6, n);
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List getConnParameters(String string, String string2, String string3, EnvDomain envDomain) throws SQLException {
        ArrayList<DomainConnParameter> arrayList = new ArrayList<DomainConnParameter>();
        int n = envDomain.getVersionNumber(string);
        if (n < 1501) {
            Object[] objectArray = new String[]{string, string2, string3};
            String string4 = _cmdBundle.getCommand(GET_PARAMS, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get load command, repserver version: " + n);
            RSMConnection rSMConnection = envDomain.getRSSD(string);
            if (rSMConnection == null) return arrayList;
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                if (!rSMResultSet.getNextRow()) return arrayList;
                int n2 = rSMResultSet.getResultSetMetaData().getColumnCount();
                for (int i = 1; i <= n2; ++i) {
                    String string5 = rSMResultSet.getResultSetMetaData().getColumnName(i);
                    if (string5.equalsIgnoreCase("sec_options")) {
                        int n3 = rSMResultSet.getColumnInt(i);
                        String[][] stringArray = ExternalSecurity.getOptions(n3);
                        for (int j = 0; j < stringArray.length; ++j) {
                            DomainConnParameter domainConnParameter = new DomainConnParameter(stringArray[j][0], stringArray[j][1], stringArray[j][1], envDomain);
                            arrayList.add(domainConnParameter);
                        }
                        continue;
                    }
                    String string6 = rSMResultSet.getColumnString(i);
                    DomainConnParameter domainConnParameter = new DomainConnParameter(string5, string6, string6, envDomain);
                    arrayList.add(domainConnParameter);
                }
                return arrayList;
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        if (n < 1501) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
        Object[] objectArray = new String[]{string2, string3};
        String string7 = _cmdBundle.getCommand(GET_PARAMS_NEW, n, objectArray);
        Dbg.wassert((string7 = string7.trim()) != null, "Unable to get load command, repserver version: " + n);
        RSMConnection rSMConnection = envDomain.getConnection(string);
        if (rSMConnection == null) return arrayList;
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string7);
            while (rSMResultSet.getNextRow()) {
                String string8 = rSMResultSet.getColumnString(1);
                String string9 = rSMResultSet.getColumnString(2);
                String string10 = rSMResultSet.getColumnString(3);
                String string11 = rSMResultSet.getColumnString(4);
                String string12 = rSMResultSet.getColumnString(5);
                String string13 = rSMResultSet.getColumnString(6);
                String string14 = rSMResultSet.getColumnString(7);
                int n4 = 2;
                if (string13.equalsIgnoreCase("integer")) {
                    n4 = 0;
                } else if (string13.equalsIgnoreCase("real")) {
                    n4 = 1;
                } else if (string13.equalsIgnoreCase("string")) {
                    n4 = 2;
                } else if (string13.equalsIgnoreCase("boolean")) {
                    n4 = 3;
                } else if (string13.equalsIgnoreCase("password")) {
                    n4 = 4;
                }
                DomainConnParameter domainConnParameter = new DomainConnParameter(string8, string10, string9, string11, string12, string14, n4, envDomain);
                arrayList.add(domainConnParameter);
            }
            return arrayList;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database name parameter.");
        if (this.isModified()) {
            RSMConnection rSMConnection = this.getDomain().getConnection(string);
            if (rSMConnection != null) {
                int n = rSMConnection.getVersionNumber();
                Object[] objectArray = new String[]{string2, string3, this.getName(), this.getPendingValue()};
                String string4 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
                Dbg.wassert(string4 != null, "Unable to get set parameter command, repserver version: " + n);
                try {
                    rSMConnection.execute(string4);
                    this.resetOriginalPendingValue();
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
            }
        }
    }

    @Override
    public String getRCLScript(String string, String string2, String string3) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database name parameter.");
        String string4 = "";
        if (!this.getCurrentValue().equals(this.getDefaultValue())) {
            int n = this.getDomain().getVersionNumber(string);
            Object[] objectArray = new String[]{string2, string3, this.getName(), this.getCurrentValue()};
            string4 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get set parameter command, repserver version: " + n);
        }
        return string4;
    }
}

