/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.BaseSemantic;
import com.sybase.rsmplugin.components.EnvStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.ase.DomainASE;
import com.sybase.rsmplugin.components.connection.ConnParameter;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.functionstringclass.DomainFunctionStringClass;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.rsthread.RSThread;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.sql.SQLScript;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainPhyConnection
extends EnvStatusSO
implements PhyConnection {
    private static final int RA_ALREADY_RESUMED = 15168;
    private static final int DSI_ALREADY_SUSPENDED = 15163;
    private static final int DSI_ALREADY_RESUMED = 15164;
    private static final String STANDBY_CONN_TYPE = "S";
    private static final String REPLICATE_CONN_SCRIPT = "rsinsrep";
    private static final String PRIMARY_CONN_SCRIPT = "rsinspri";
    private static final String DEFAULT_ERROR_CLASS = "rs_sqlserver_error_class";
    protected boolean _connExists = false;
    private String _repServer = null;
    private String _ds = null;
    private String _db = null;
    private String _lds = null;
    private String _ldb = null;
    private boolean _isStandby = false;
    private int _type = 0;
    private static final int HIDE_STATE = 6;
    private boolean _isRSSD = false;
    private String _fsClass = null;
    private String _errorClass = null;
    private String _maintUser = null;
    private String _maintPwd = null;
    private static final String GET_CONNS = "GET_CONNS";
    private static final String GET_KNOWN_CONNS = "GET_KNOWN_CONNS";
    private static final String LOAD_CONN = "LOAD_CONN";
    private static final String GET_CONN_DETAILS = "GET_CONN_DETAILS";
    private static final String ALTER_CONN = "ALTER_CONN";
    private static final String CREATE_PRI_CONN = "CREATE_PRI_CONN";
    private static final String CREATE_REP_CONN = "CREATE_REP_CONN";
    private static final String CREATE_ACTIVE_CONN = "CREATE_ACTIVE_CONN";
    private static final String CREATE_STDBY_CONN = "CREATE_STDBY_CONN";
    private static final String DROP_CONN = "DROP_CONN";
    private static final String RESUME_CONN = "RESUME_CONN";
    private static final String SUSPEND_CONN = "SUSPEND_CONN";
    private static final String RESUME_LOG = "RESUME_LOG";
    private static final String SUSPEND_LOG = "SUSPEND_LOG";
    private static final String GET_STATUS = "GET_STATUS";
    private static final Object[][] contents = new Object[][]{{"GET_CONNS", new Integer(1200), "rmp_connections ''{0}'', ''{1}'', ''{2}''"}, {"GET_KNOWN_CONNS", new Integer(1200), "rmp_all_connections"}, {"GET_CONN_DETAILS", new Integer(1200), "rmp_connection_details ''{0}'', ''{1}''"}, {"LOAD_CONN", new Integer(1200), "rmp_connection_demand {0}, {1}, {2}"}, {"ALTER_CONN", new Integer(1200), "alter connection to {0}.{1} set {2} to {3}"}, {"CREATE_PRI_CONN", new Integer(1200), "create connection to \"{0}\".\"{1}\"\n\tset error class to \"{2}\"\n\tset function string class to \"{3}\"\n\tset username \"{4}\"\n\tset password \"{5}\"\n\twith log transfer on"}, {"CREATE_REP_CONN", new Integer(1200), "create connection to \"{0}\".\"{1}\"\n\tset error class to \"{2}\"\n\tset function string class to \"{3}\"\n\tset username \"{4}\"\n\tset password \"{5}\"\n"}, {"CREATE_ACTIVE_CONN", new Integer(1200), "create connection to \"{0}\".\"{1}\"\n\tset error class to \"{2}\"\n\tset function string class to \"{3}\"\n\tset username \"{4}\"\n\tset password \"{5}\"\n\twith log transfer on\n\tas active for \"{6}\".\"{7}\""}, {"CREATE_STDBY_CONN", new Integer(1200), "create connection to \"{0}\".\"{1}\"\n\tset error class to \"{2}\"\n\tset function string class to \"{3}\"\n\tset username \"{4}\"\n\tset password \"{5}\"\n\twith log transfer on\n\tas standby for \"{6}\".\"{7}\"\n\t{8}"}, {"DROP_CONN", new Integer(1200), "drop connection to \"{0}\".\"{1}\""}, {"RESUME_CONN", new Integer(1200), "resume connection to \"{0}\".\"{1}\" {2}"}, {"SUSPEND_CONN", new Integer(1200), "suspend connection to \"{0}\".\"{1}\" {2}"}, {"RESUME_LOG", new Integer(1200), "resume log transfer from \"{0}\".\"{1}\""}, {"SUSPEND_LOG", new Integer(1200), "suspend log transfer from \"{0}\".\"{1}\""}, {"GET_STATUS", new Integer(1200), "admin who, no_trunc"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainPhyConnection(String string, String string2, String string3, EnvDomain envDomain) {
        super(string2 + "." + string3, envDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DB parameter.");
        this._repServer = string;
        this._ds = string2;
        this._db = string3;
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setRepAgentState(3);
            this.setDSIState(3);
        }
    }

    @Override
    public Object clone() {
        DomainPhyConnection domainPhyConnection = null;
        try {
            domainPhyConnection = (DomainPhyConnection)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Dbg.wassert(false, "Unexpected exception thrown.");
        }
        return domainPhyConnection;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._ds != null && this._ds.length() > 0, "Null or empty data server name attribute.");
        return this._ds;
    }

    @Override
    public String getDB() {
        Dbg.wassert(this._db != null && this._db.length() > 0, "Null or empty database name attribute.");
        return this._db;
    }

    @Override
    public boolean isMasterDBConnection() {
        boolean bl = this.getDB().equals("master");
        return bl;
    }

    @Override
    public String getLDS() {
        Dbg.wassert(this._lds != null && this._lds.length() > 0, "Null or empty logical data server. This connection is not part of a logical connection.");
        Dbg.wassert(this._ldb != null && this._ldb.length() > 0, "Null or empty logical database.");
        return this._lds;
    }

    @Override
    public void setLDS(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical data server parameter.");
        this._lds = string;
    }

    @Override
    public String getLDB() {
        Dbg.wassert(this._lds != null && this._lds.length() > 0, "Null or empty logical data server. This connection is not part of a logical connection.");
        Dbg.wassert(this._ldb != null && this._ldb.length() > 0, "Null or empty logical database.");
        return this._ldb;
    }

    @Override
    public void setLDB(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical database parameter.");
        this._ldb = string;
    }

    @Override
    public boolean isPartOfLogicalConnection() {
        return this._lds != null && this._lds.length() > 0;
    }

    @Override
    public String getLogicalConnection() {
        if (this.isPartOfLogicalConnection()) {
            return this.getLDS() + "." + this.getLDB();
        }
        return null;
    }

    @Override
    public boolean isStandby() {
        return this._isStandby;
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._repServer != null && this._repServer.length() > 0, "Null or empty RS name attribute.");
        return this._repServer;
    }

    @Override
    public boolean isRepAgentActive() {
        return this.getRepAgentState() == 5;
    }

    @Override
    public boolean isRepAgentSuspended() {
        return this.getRepAgentState() == 2;
    }

    @Override
    public boolean isRepAgentUnknown() {
        return this.getRepAgentState() == 3;
    }

    @Override
    public boolean isRepAgentFiltered() {
        return this.getRepAgentState() == 6;
    }

    @Override
    public String getRepAgentStateString() {
        String string = "";
        if (this.isPrimary()) {
            if (this.isRepAgentFiltered()) {
                string = BundleManager.getString("ConnectionRes", "FILTERED_STATE");
            } else if (this.isRepAgentActive()) {
                string = BundleManager.getString("ConnectionRes", "ACTIVE_STATE");
            } else if (this.isRepAgentSuspended()) {
                string = BundleManager.getString("ConnectionRes", "SUSPENDED_STATE");
            } else if (this.isRepAgentUnknown()) {
                string = BundleManager.getString("ConnectionRes", "UNKNOWN_STATE");
            }
        }
        return string;
    }

    protected int getRepAgentState() {
        return this.get1stState();
    }

    protected void setRepAgentState(int n) {
        Dbg.wassert(n == 5 || n == 2 || n == 3 || n == 6, "Invalid rep agent status value.");
        this.setDualState(n, this.get2ndState());
    }

    @Override
    public boolean isDSIActive() {
        return this.getDSIState() == 5;
    }

    @Override
    public boolean isDSISuspended() {
        return this.getDSIState() == 2;
    }

    @Override
    public boolean isDSIUnknown() {
        return this.getDSIState() == 3;
    }

    @Override
    public boolean isDSIFiltered() {
        return this.getDSIState() == 6;
    }

    @Override
    public String getDSIStateString() {
        String string = "";
        if (this.isDSIFiltered()) {
            string = BundleManager.getString("ConnectionRes", "FILTERED_STATE");
        } else if (this.isDSIActive()) {
            string = BundleManager.getString("ConnectionRes", "ACTIVE_STATE");
        } else if (this.isDSISuspended()) {
            string = BundleManager.getString("ConnectionRes", "SUSPENDED_STATE");
        } else if (this.isDSIUnknown()) {
            string = BundleManager.getString("ConnectionRes", "UNKNOWN_STATE");
        }
        return string;
    }

    protected int getDSIState() {
        return this.get2ndState();
    }

    protected void setDSIState(int n) {
        Dbg.wassert(n == 5 || n == 2 || n == 3 || n == 6, "Invalid DSI status value.");
        this.setDualState(this.get1stState(), n);
    }

    @Override
    public boolean isUp() {
        if (this.isReplicate()) {
            return this.isDSIActive() || this.isDSIFiltered();
        }
        return !(!this.isDSIFiltered() && !this.isDSIActive() || !this.isRepAgentFiltered() && !this.isRepAgentActive());
    }

    @Override
    public boolean isError() {
        if (this.isReplicate()) {
            return !this.isDSIFiltered() && this.isDSISuspended();
        }
        return !this.isDSIFiltered() && this.isDSISuspended() || !this.isRepAgentFiltered() && this.isRepAgentSuspended();
    }

    @Override
    public boolean isWarning() {
        if (this.isPrimary()) {
            return (this.isDSIFiltered() || this.isDSIActive()) && !this.isRepAgentFiltered() && this.isRepAgentUnknown();
        }
        return false;
    }

    protected boolean isFiltered() {
        return this.isReplicate() && this.isDSIFiltered() || this.isPrimary() && this.isRepAgentFiltered() && this.isDSIFiltered();
    }

    @Override
    public String getStateString() {
        String string = "";
        if (this.isFiltered()) {
            string = BundleManager.getString("ConnectionRes", "FILTERED_STATE");
        } else if (this.isUp()) {
            string = BundleManager.getString("ConnectionRes", "ACTIVE_STATE");
        } else if (this.isWarning()) {
            string = BundleManager.getString("ConnectionRes", "UNKNOWN_STATE");
        } else if (this.isError()) {
            string = BundleManager.getString("ConnectionRes", "SUSPENDED_STATE");
        }
        return string;
    }

    @Override
    public boolean isReplicate() {
        return this._type == 0;
    }

    @Override
    public boolean isPrimary() {
        return this._type == 1;
    }

    @Override
    public String getConnectionType() {
        String string = "";
        string = this.isPartOfLogicalConnection() ? (this.isStandby() ? BundleManager.getString("ConnectionRes", "CONN_TYPE_STANDBY") : BundleManager.getString("ConnectionRes", "CONN_TYPE_ACTIVE")) : (this.isPrimary() ? BundleManager.getString("ConnectionRes", "CONN_TYPE_PRIMARY") : BundleManager.getString("ConnectionRes", "CONN_TYPE_REPLICATE"));
        return string;
    }

    @Override
    public boolean isRSSD() {
        return this._isRSSD;
    }

    @Override
    public String getFunctionStringClass() {
        if (this._fsClass == null || this._fsClass.length() == 0) {
            return DomainFunctionStringClass.getDefaultFunctionStringClass(this.getDS(), this.getDomain());
        }
        return this._fsClass;
    }

    @Override
    public void setFunctionStringClass(String string) {
        this._fsClass = string;
    }

    @Override
    public String getErrorClass() {
        if (this._errorClass == null || this._errorClass.length() == 0) {
            return DEFAULT_ERROR_CLASS;
        }
        return this._errorClass;
    }

    @Override
    public void setErrorClass(String string) {
        this._errorClass = string;
    }

    @Override
    public String getMaintUser() {
        return this._maintUser;
    }

    @Override
    public void setMaintUser(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty maintenance user parameter.");
        this._maintUser = string;
    }

    @Override
    public String getMaintPwd() {
        if (this._maintPwd == null) {
            return "";
        }
        return this._maintPwd;
    }

    @Override
    public void setMaintPwd(String string) {
        this._maintPwd = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getConnections(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<DomainPhyConnection> arrayList = new ArrayList<DomainPhyConnection>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            int n = envDomain.getVersionNumber(string);
            Object[] objectArray = new String[]{string, "*", "*"};
            String string2 = _cmdBundle.getCommand(GET_CONNS, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to get suspend command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    if (string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    DomainPhyConnection domainPhyConnection = new DomainPhyConnection(string3, string4, string5, envDomain);
                    domainPhyConnection.loadDetails(rSMResultSet);
                    domainPhyConnection._connExists = true;
                    arrayList.add(domainPhyConnection);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getKnownConnections(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<DomainPhyConnection> arrayList = new ArrayList<DomainPhyConnection>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            int n = envDomain.getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(GET_KNOWN_CONNS, n);
            Dbg.wassert(string2 != null, "Unable to get suspend command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    if (string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    DomainPhyConnection domainPhyConnection = new DomainPhyConnection(string3, string4, string5, envDomain);
                    domainPhyConnection.loadDetails(rSMResultSet);
                    domainPhyConnection._connExists = true;
                    arrayList.add(domainPhyConnection);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    public static List getConnectionsForDataServer(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty ase server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = semanticFactory.getPhyConnections(repServer.getName()).listIterator();
            while (listIterator2.hasNext()) {
                PhyConnection phyConnection = (PhyConnection)listIterator2.next();
                if (!phyConnection.getDS().equals(string)) continue;
                arrayList.add(phyConnection);
            }
        }
        return arrayList;
    }

    public static List getConnectionsForLANRepAgent(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Rep Agent server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        LANRepAgent lANRepAgent = semanticFactory.getLANRepAgent(string);
        if (lANRepAgent != null) {
            String string2 = lANRepAgent.getSourceDS();
            String string3 = lANRepAgent.getSourceDB();
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                List list = DomainPhyConnection.getConnectionsForDataServer(string2, envDomain);
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    if (!phyConnection.getDS().equals(string2) || !phyConnection.getDB().equals(string3)) continue;
                    arrayList.add(phyConnection);
                }
            }
        }
        return arrayList;
    }

    public static List getConnectionsForMirrorRepAgent(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Rep Agent server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        MirrorRepAgent mirrorRepAgent = semanticFactory.getMirrorRepAgent(string);
        if (mirrorRepAgent != null) {
            String string2 = mirrorRepAgent.getSourceDS();
            String string3 = mirrorRepAgent.getSourceDB();
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                List list = DomainPhyConnection.getConnectionsForDataServer(string2, envDomain);
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    if (!phyConnection.getDS().equals(string2) || !phyConnection.getDB().equals(string3)) continue;
                    arrayList.add(phyConnection);
                }
            }
        }
        return arrayList;
    }

    public static List getConnectionsForDirectConnect(String string, EnvDomain envDomain) throws SQLException {
        return DomainPhyConnection.getConnectionsForDataServer(string, envDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getControllingRS());
        if (rSMConnection != null) {
            int n = this.getDomain().getVersionNumber(this.getControllingRS());
            Object[] objectArray = new String[]{this.getControllingRS(), this.getDS(), this.getDB()};
            String string = _cmdBundle.getCommand(GET_CONNS, n, objectArray);
            Dbg.wassert(string != null, "Unable to get the query connection command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.loadDetails(rSMResultSet);
                    this._connExists = true;
                } else {
                    this._connExists = false;
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
    }

    @Override
    public boolean exists() {
        return this._connExists;
    }

    protected void loadDetails(RSMResultSet rSMResultSet) throws SQLException {
        if (rSMResultSet != null) {
            String string;
            int n = rSMResultSet.getColumnInt(4);
            this._type = n > 0 ? 1 : 0;
            this._isRSSD = rSMResultSet.getColumnInt(5) == 0;
            String string2 = rSMResultSet.getColumnString(6);
            if (string2.equals(STANDBY_CONN_TYPE)) {
                this._isStandby = true;
            }
            if ((string = rSMResultSet.getColumnString(7)) != null && string.trim().length() > 0) {
                this._lds = string;
            }
            if ((string = rSMResultSet.getColumnString(8)) != null && string.trim().length() > 0) {
                this._ldb = string;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createPrimary(String string, String string2, List list) {
        String string3;
        Object object;
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl = true;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep agent user name parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        DomainASE domainASE = (DomainASE)semanticFactory.getASE(this.getDS());
        Dbg.wassert(domainASE != null, "Cannot retrieve ASESO for ASE: " + this.getDS());
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_ADD_PRI", this.getName()));
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (aSEConnection != null) {
            try {
                aSEConnection.use(this.getDB());
                object = new SQLScript();
                string3 = this.getConnScript(PRIMARY_CONN_SCRIPT);
                ((SQLScript)object).execute(aSEConnection, string3);
            }
            catch (SQLException sQLException) {
                string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("E. " + string3);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            String string4 = BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS());
            PluginSupport.LogErrorMessage(string4, string4);
            list.add("W. " + string4);
            return false;
        }
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_GRANT_PUBLIC", this.getName()));
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_get_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_update_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_marker", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_check_repl_stat", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        this.initMaintUser(list);
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CREATE_PRI", this.getName()));
            this._type = 1;
            this.create();
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string3);
            bl = false;
        }
        if (bl) {
            String string5;
            object = semanticFactory.getRepAgent(this.getDS(), this.getDB());
            object.setControllingRS(this.getControllingRS());
            object.setUsername(string);
            object.setPassword(string2);
            try {
                list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CFG_RA", this.getName()));
                this.createRSUser(string, string2);
                object.configure();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
            try {
                list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_START_RA", this.getName()));
                object.start();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
        }
        return bl;
    }

    @Override
    public boolean createNonASEPrimary(String string, String string2, List list) {
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl = true;
        if (bl) {
            try {
                this.createRSUser(string, string2);
                list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CREATE_PRI", this.getName()));
                this._type = 1;
                this.create();
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("E. " + string3);
                bl = false;
            }
        }
        return bl;
    }

    protected void createRSUser(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty user parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty password parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        RSUser rSUser = null;
        ListIterator listIterator = semanticFactory.getRSUsers(this.getControllingRS()).listIterator();
        while (listIterator.hasNext()) {
            RSUser rSUser2 = (RSUser)listIterator.next();
            if (!rSUser2.getName().equals(string)) continue;
            rSUser = rSUser2;
            break;
        }
        if (rSUser == null) {
            rSUser = semanticFactory.getRSUser(string, this.getControllingRS());
            rSUser.setPassword(string2);
            rSUser.setSourcePermission(true);
            rSUser.create();
        } else {
            rSUser.alter(string2, rSUser.isSAPermissionSet(), true, rSUser.isCreatePermissionSet(), rSUser.isSubscribePermissionSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createReplicate(List list) {
        String string;
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl = true;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        DomainASE domainASE = (DomainASE)semanticFactory.getASE(this.getDS());
        Dbg.wassert(domainASE != null, "Cannot retrieve ASESO for ASE: " + this.getDS());
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_ADD_REP", this.getName()));
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (aSEConnection != null) {
            try {
                aSEConnection.use(this.getDB());
                SQLScript sQLScript = new SQLScript();
                string = this.getConnScript(REPLICATE_CONN_SCRIPT);
                sQLScript.execute(aSEConnection, string);
            }
            catch (SQLException sQLException) {
                string = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            String string2 = BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS());
            PluginSupport.LogErrorMessage(string2, string2);
            list.add("W. " + string2);
            return false;
        }
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_GRANT_PUBLIC", this.getName()));
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_get_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_update_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
        this.initMaintUser(list);
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CREATE_REP", this.getName()));
            this._type = 0;
            this.create();
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean createNonASEReplicate(List list) {
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl = true;
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CREATE_REP", this.getName()));
            this._type = 0;
            this.create();
        }
        catch (SQLException sQLException) {
            String string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create() throws SQLException {
        String string = null;
        Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getErrorClass(), this.getFunctionStringClass(), this.getMaintUser(), this.getMaintPwd()};
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            if (this.isPrimary()) {
                string = _cmdBundle.getCommand(CREATE_PRI_CONN, n, objectArray);
                Dbg.wassert(string != null, "Unable to get create primary command, repserver version: " + n);
            } else if (this.isReplicate()) {
                string = _cmdBundle.getCommand(CREATE_REP_CONN, n, objectArray);
                Dbg.wassert(string != null, "Unable to get create replicate command, repserver version: " + n);
            } else {
                Dbg.wassert(false, "Unexpected connection type.");
            }
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createActive(String string, String string2, boolean bl, List list) {
        String string3;
        Object object;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep agent user name parameter.");
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl2 = true;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        DomainASE domainASE = (DomainASE)semanticFactory.getASE(this.getDS());
        Dbg.wassert(domainASE != null, "Cannot retrieve ASESO for ASE: " + this.getDS());
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_ADD_PRI", this.getName()));
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (aSEConnection != null) {
            try {
                aSEConnection.use(this.getDB());
                object = new SQLScript();
                string3 = this.getConnScript(PRIMARY_CONN_SCRIPT);
                ((SQLScript)object).execute(aSEConnection, string3);
            }
            catch (SQLException sQLException) {
                string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string3);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            String string4 = BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS());
            PluginSupport.LogErrorMessage(string4, string4);
            list.add("W. " + string4);
            return false;
        }
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_GRANT_PUBLIC", this.getName()));
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_get_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_update_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_marker", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_check_repl_stat", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.setReplicate("rs_update_lastcommit", this.getDB());
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        this.initMaintUser(list);
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CREATE_PRI", this.getName()));
            this.createActive();
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string3);
            bl2 = false;
        }
        this.getDomain().getFilterManager().setDSIFilter(this.getName(), true);
        if (bl2) {
            String string5;
            object = semanticFactory.getRepAgent(this.getDS(), this.getDB());
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CFG_RA", this.getName()));
            if (bl) {
                try {
                    object.setRepToStandby();
                }
                catch (SQLException sQLException) {
                    string5 = MessageText.formatExceptionMessage(sQLException);
                    PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                    list.add("W. " + string5);
                }
            }
            object.setControllingRS(this.getControllingRS());
            object.setUsername(string);
            object.setPassword(string2);
            try {
                this.createRSUser(string, string2);
                object.configure();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
            try {
                object.setSendWarmStandbyXact();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
            try {
                list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_START_RA", this.getName()));
                object.start();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createActive() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getErrorClass(), this.getFunctionStringClass(), this.getMaintUser(), this.getMaintPwd(), this.getLDS(), this.getLDB()};
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(CREATE_ACTIVE_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get create active connection command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public boolean changeToActive(List list) {
        String string;
        Dbg.wassert(list != null, "Null summary list parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        RepAgent repAgent = semanticFactory.getRepAgent(this.getDS(), this.getDB());
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_MAKE_WS"));
        try {
            repAgent.setSendWarmStandbyXact();
            this.getDomain().getFilterManager().setDSIFilter(this.getName(), true);
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_START_RA", this.getName()));
            repAgent.start();
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createStandby(String string, String string2, boolean bl, boolean bl2, List list) {
        String string3;
        Object object;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep agent user name parameter.");
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl3 = true;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        DomainASE domainASE = (DomainASE)semanticFactory.getASE(this.getDS());
        Dbg.wassert(domainASE != null, "Cannot retrieve ASESO for ASE: " + this.getDS());
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_ADD_REP", this.getName()));
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (aSEConnection != null) {
            try {
                aSEConnection.use(this.getDB());
                object = new SQLScript();
                string3 = this.getConnScript(PRIMARY_CONN_SCRIPT);
                ((SQLScript)object).execute(aSEConnection, string3);
            }
            catch (SQLException sQLException) {
                string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("E. " + string3);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            String string4 = BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS());
            PluginSupport.LogErrorMessage(string4, string4);
            list.add("W. " + string4);
            return false;
        }
        list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_GRANT_PUBLIC", this.getName()));
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_get_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_update_lastcommit", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_marker", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.grantPermission("public", this.getDB(), "rs_check_repl_stat", "execute");
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        try {
            domainASE.setReplicate("rs_update_lastcommit", this.getDB());
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string3);
        }
        this.initMaintUser(list);
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CREATE_REP", this.getName()));
            this.createStandby(bl2);
        }
        catch (SQLException sQLException) {
            string3 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string3);
            bl3 = false;
        }
        this.getDomain().getFilterManager().setRepAgentFilter(this.getName(), true);
        if (bl3) {
            String string5;
            object = semanticFactory.getRepAgent(this.getDS(), this.getDB());
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CFG_RA", this.getName()));
            try {
                object.setRepToStandby();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
            object.setControllingRS(this.getControllingRS());
            object.setUsername(string);
            object.setPassword(string2);
            try {
                this.createRSUser(string, string2);
                object.configure();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
            try {
                object.setSendWarmStandbyXact();
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
            try {
                if (bl && bl2) {
                    list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_START_RA", this.getName()));
                    object.start();
                }
            }
            catch (SQLException sQLException) {
                string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("W. " + string5);
            }
        }
        if ((aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS())) != null) {
            try {
                aSEConnection.use("master");
            }
            catch (SQLException sQLException) {
            }
            finally {
                aSEConnection.unlock();
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createStandby(boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getErrorClass(), this.getFunctionStringClass(), this.getMaintUser(), this.getMaintPwd(), this.getLDS(), this.getLDB(), bl ? "use dump marker" : ""};
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(CREATE_STDBY_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get create active connection command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    protected void initMaintUser(List list) {
        String string;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        DomainASE domainASE = (DomainASE)semanticFactory.getASE(this.getDS());
        Dbg.wassert(domainASE != null, "Cannot retrieve ASESO for ASE: " + this.getDS());
        try {
            Object[] objectArray = new String[]{this.getMaintUser(), domainASE.getName()};
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_MAINT_USER", objectArray));
            if (!domainASE.loginExists(this.getMaintUser())) {
                domainASE.addLogin(this.getMaintUser(), this.getMaintPwd());
            } else {
                list.add("W. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_MAINT_EXISTS", objectArray));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string2, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string2);
            return;
        }
        try {
            domainASE.unlockLogin(this.getMaintUser());
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_ALIAS", this.getName()));
            domainASE.aliasUser(this.getMaintUser(), this.getDB());
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
        try {
            list.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_GRANT_ROLE", this.getDS()));
            domainASE.grantRole(this.getMaintUser(), this.getDB(), "replication_role");
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("W. " + string);
        }
    }

    @Override
    public void delete() throws SQLException {
        this.drop();
        this.getDomain().getFilterManager().setRepAgentFilter(this.getName(), false);
        this.getDomain().getFilterManager().setDSIFilter(this.getName(), false);
        if (this.isPrimary()) {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
            LANRepAgent lANRepAgent = semanticFactory.getLANRepAgent(this.getDS(), this.getDB());
            if (lANRepAgent != null) {
                lANRepAgent.removePDB();
            } else {
                ASE aSE;
                MirrorRepAgent mirrorRepAgent = semanticFactory.getMirrorRepAgent(this.getDS(), this.getDB());
                if (mirrorRepAgent == null && (aSE = semanticFactory.getASE(this.getDS())) != null) {
                    try {
                        RepAgent repAgent = semanticFactory.getRepAgent(this.getDS(), this.getDB());
                        repAgent.setControllingRS(this.getControllingRS());
                        repAgent.stop(true);
                        repAgent.waitForState(2, 60);
                        repAgent.disable();
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drop() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            Object[] objectArray = new String[]{this.getDS(), this.getDB()};
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(DROP_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get drop command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getConnDetails() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getControllingRS());
        if (rSMConnection != null) {
            int n = this.getDomain().getVersionNumber(this.getControllingRS());
            Object[] objectArray = new String[]{this.getDS(), this.getDB()};
            String string = _cmdBundle.getCommand(GET_CONN_DETAILS, n, objectArray);
            Dbg.wassert(string != null, "Unable to get the query connection details command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.setErrorClass(rSMResultSet.getColumnString(3));
                    this.setFunctionStringClass(rSMResultSet.getColumnString(4));
                    this.setMaintUser(rSMResultSet.getColumnString(5));
                    this.setMaintPwd(rSMResultSet.getColumnString(6));
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
    }

    public void monitor(List list) {
        boolean bl;
        boolean bl2;
        Dbg.wassert(list != null, "Null thread SO list parameter.");
        this.setRepAgentState(3);
        this.setDSIState(5);
        this.clearReasons();
        boolean bl3 = this.getDomain().getFilterManager().isRepAgentFiltered(this.getName());
        if (bl3) {
            this.setRepAgentState(6);
        }
        if (bl2 = this.getDomain().getFilterManager().isDSIFiltered(this.getName())) {
            this.setDSIState(6);
        }
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomain().getName());
        RepServer repServer = semanticFactory.getRepServer(this.getControllingRS());
        boolean bl4 = bl = this.isRSSD() && repServer.isEmbeddedRSSD();
        if (this.isPrimary() && !bl3 && !bl) {
            this.monitorRA();
        }
        boolean bl5 = bl2;
        boolean bl6 = !this.isRepAgentActive() && bl3;
        ListIterator listIterator = list.listIterator();
        while (!(!listIterator.hasNext() || bl5 && bl6)) {
            RSThread rSThread = (RSThread)listIterator.next();
            if (!rSThread.getComponentName().equals(this.getName())) continue;
            if (!bl5 && rSThread.isDSI()) {
                bl5 = true;
                if (rSThread.isDown() || rSThread.isSuspended()) {
                    this.setDSIState(2);
                    this.addReason(BundleManager.getString("ConnectionRes", "CONN_DSI_DOWN", this.getName()));
                }
            }
            if (bl6 || !rSThread.isRepAgent()) continue;
            bl6 = true;
            if (!rSThread.isDown() && !rSThread.isSuspended()) continue;
            this.setRepAgentState(2);
            this.addReason(BundleManager.getString("ConnectionRes", "CONN_RA_DOWN", this.getName()));
        }
    }

    protected void monitorRA() {
        BaseSemantic baseSemantic;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        ASE aSE = semanticFactory.getASE(this.getDS());
        if (aSE != null && this.getRepAgentState() == 3) {
            baseSemantic = semanticFactory.getRepAgent(this.getDS(), this.getDB());
            baseSemantic.loadStatus();
            switch (baseSemantic.getState()) {
                case 3: {
                    this.setRepAgentState(3);
                    this.addReason(BundleManager.getString("ConnectionRes", "CONN_RA_UNKNOWN", this.getName()));
                    break;
                }
                case 6: {
                    this.setRepAgentState(2);
                    this.addReason(baseSemantic.getReason());
                    break;
                }
                case 2: {
                    this.setRepAgentState(2);
                    this.addReason(baseSemantic.getReason());
                    break;
                }
                default: {
                    this.setRepAgentState(5);
                }
            }
        }
        if (this.getRepAgentState() == 3) {
            try {
                baseSemantic = semanticFactory.getLANRepAgent(this.getDS(), this.getDB());
                if (baseSemantic != null) {
                    if (baseSemantic.isUp()) {
                        this.setRepAgentState(5);
                    } else {
                        this.setRepAgentState(2);
                        this.addReason(BundleManager.getString("ConnectionRes", "CONN_LRA_DOWN", baseSemantic.getName()));
                    }
                }
            }
            catch (SQLException sQLException) {
                this.setRepAgentState(2);
                this.addReason(sQLException.getLocalizedMessage());
            }
        }
        if (this.getRepAgentState() == 3) {
            try {
                baseSemantic = semanticFactory.getMirrorRepAgent(this.getDS(), this.getDB());
                if (baseSemantic != null) {
                    if (baseSemantic.isUp()) {
                        this.setRepAgentState(5);
                    } else {
                        this.setRepAgentState(2);
                        this.addReason(BundleManager.getString("ConnectionRes", "CONN_LRA_DOWN", baseSemantic.getName()));
                    }
                }
            }
            catch (SQLException sQLException) {
                this.setRepAgentState(2);
                this.addReason(sQLException.getLocalizedMessage());
            }
        }
        if (this.getRepAgentState() == 3) {
            this.addReason(BundleManager.getString("ConnectionRes", "CONN_RA_UNKNOWN", this.getName()));
        }
    }

    @Override
    public void alter(String string, String string2, String string3) throws SQLException {
        if (string != null && !this.getFunctionStringClass().equals(string)) {
            this.alter("function string class", string, false);
            this.setFunctionStringClass(string);
        }
        if (string2 != null && !this.getErrorClass().equals(string2)) {
            this.alter("error class", string2, false);
            this.setErrorClass(string2);
        }
        if (string3 != null && this.getMaintPwd().equals(string3)) {
            this.alter("password", string3, false);
            this.setMaintPwd(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alter(String string, String string2, boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            Object[] objectArray = new String[]{this.getDS(), this.getDB(), string, bl ? "'" + string2 + "'" : string2};
            int n = rSMConnection.getVersionNumber();
            String string3 = _cmdBundle.getCommand(ALTER_CONN, n, objectArray);
            Dbg.wassert(string3 != null, "Unable to get alter connection command, repserver version: " + n);
            try {
                rSMConnection.execute(string3);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void resume(final List list, String string, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        if (list != null && list.size() > 0) {
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            DomainPhyConnection domainPhyConnection = (DomainPhyConnection)listIterator.next();
                            this.setStatus(BundleManager.getString("ConnectionRes", "RESUME_DLG_TITLE", domainPhyConnection.getName()));
                            if (bl) {
                                domainPhyConnection.resumeRepAgent();
                            }
                            if (!bl2) continue;
                            domainPhyConnection.resumeDSI(bl3, bl4);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (Exception exception) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(exception), MessageText.formatExceptionMessage(exception));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(exception));
                    }
                    DomainPhyConnection.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resumeRepAgent() throws SQLException, Exception {
        Object object;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        boolean bl = false;
        ASE aSE = semanticFactory.getASE(this.getDS());
        if (aSE != null && (object = semanticFactory.getRepAgent(this.getDS(), this.getDB())) != null && object.isEnabled()) {
            object.setControllingRS(this.getControllingRS());
            object.start();
            bl = true;
        }
        if (!bl && (object = semanticFactory.getLANRepAgent(this.getDS(), this.getDB())) != null) {
            object.resume();
            bl = true;
        }
        if (!bl && (object = semanticFactory.getMirrorRepAgent(this.getDS(), this.getDB())) != null) {
            object.resume();
            bl = true;
        }
        if (!bl) {
            throw new Exception(BundleManager.getString("ConnectionRes", "SUSPEND_FAILED", this.getName()));
        }
        object = this.getDomain().getConnection(this.getControllingRS());
        if (object == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        Object[] objectArray = new String[]{this.getDS(), this.getDB()};
        int n = ((RSMConnection)object).getVersionNumber();
        String string = _cmdBundle.getCommand(RESUME_LOG, n, objectArray);
        Dbg.wassert(string != null, "Unable to get resume log transfer command, repserver version: " + n);
        try {
            ((RSMConnection)object).execute(string);
            return;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 15168) return;
            throw sQLException;
        }
        finally {
            ((RSMConnection)object).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resumeDSI(boolean bl, boolean bl2) throws SQLException {
        Dbg.wassert(!bl || !bl2, "Skip and execute cannot both be set to true.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        String string = bl ? "skip transaction" : (bl2 ? "execute transaction" : "");
        Object[] objectArray = new String[]{this.getDS(), this.getDB(), string};
        int n = rSMConnection.getVersionNumber();
        String string2 = _cmdBundle.getCommand(RESUME_CONN, n, objectArray);
        Dbg.wassert(string2 != null, "Unable to get resume connection command, repserver version: " + n);
        try {
            rSMConnection.execute(string2);
            return;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 15164) return;
            throw sQLException;
        }
        finally {
            rSMConnection.unlock();
        }
    }

    @Override
    public void suspend(final List list, String string, final boolean bl, final boolean bl2, final boolean bl3) {
        if (list != null && list.size() > 0) {
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            DomainPhyConnection domainPhyConnection = (DomainPhyConnection)listIterator.next();
                            this.setStatus(BundleManager.getString("ConnectionRes", "SUSPEND_DLG_TITLE", domainPhyConnection.getName()));
                            if (bl) {
                                domainPhyConnection.suspendRepAgent();
                            }
                            if (!bl2) continue;
                            domainPhyConnection.suspendDSI(bl3);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (Exception exception) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(exception), MessageText.formatExceptionMessage(exception));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(exception));
                    }
                    DomainPhyConnection.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    @Override
    public void suspendRepAgent() throws SQLException, Exception {
        BaseSemantic baseSemantic;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        boolean bl = false;
        ASE aSE = semanticFactory.getASE(this.getDS());
        if (aSE != null && (baseSemantic = semanticFactory.getRepAgent(this.getDS(), this.getDB())) != null && baseSemantic.isEnabled()) {
            baseSemantic.setControllingRS(this.getControllingRS());
            baseSemantic.stop(false);
            bl = true;
        }
        if (!bl && (baseSemantic = semanticFactory.getLANRepAgent(this.getDS(), this.getDB())) != null) {
            baseSemantic.suspend();
            bl = true;
        }
        if (!bl && (baseSemantic = semanticFactory.getMirrorRepAgent(this.getDS(), this.getDB())) != null) {
            baseSemantic.suspend();
            bl = true;
        }
        if (!bl) {
            throw new Exception(BundleManager.getString("ConnectionRes", "SUSPEND_FAILED", this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void suspendDSI(boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        Object[] objectArray = new String[]{this.getDS(), this.getDB(), bl ? "with nowait" : ""};
        int n = rSMConnection.getVersionNumber();
        String string = _cmdBundle.getCommand(SUSPEND_CONN, n, objectArray);
        Dbg.wassert(string != null, "Unable to get suspend connection command, repserver version: " + n);
        try {
            rSMConnection.execute(string);
            return;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 15163) return;
            throw sQLException;
        }
        finally {
            rSMConnection.unlock();
        }
    }

    protected String getConnScript(String string) throws SQLException {
        int n = 1200;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection == null) {
            throw new SQLException(BundleManager.getString("ConnectionRes", "CONN_RS_VERSION_NOT_FND"), "_RSM_", 5);
        }
        n = rSMConnection.getVersionNumber();
        rSMConnection.unlock();
        String string2 = null;
        SQLScript sQLScript = new SQLScript();
        for (int i = 0; i < RSConnection.SUPPORTED_VERSION_LIST.length; ++i) {
            String string3 = string + String.valueOf(RSConnection.SUPPORTED_VERSION_LIST[i]) + ".sql";
            if (sQLScript.findScript(string3)) {
                string2 = string3;
            }
            if (RSConnection.SUPPORTED_VERSION_LIST[i] >= n) break;
        }
        if (string2 == null) {
            throw new SQLException(BundleManager.getString("ConnectionRes", "CONN_SCRIPT_NOT_FND", String.valueOf(n)), "_RSM_", 5);
        }
        return string2;
    }

    @Override
    public void filter(List list, boolean bl, boolean bl2) {
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                DomainPhyConnection domainPhyConnection = (DomainPhyConnection)listIterator.next();
                domainPhyConnection.filter(bl, bl2);
            }
            this.getDomain().refreshStatus();
        }
    }

    @Override
    public void filter(boolean bl, boolean bl2) {
        if (this.isPrimary() || !bl) {
            this.getDomain().getFilterManager().setRepAgentFilter(this.getName(), bl);
        }
        this.getDomain().getFilterManager().setDSIFilter(this.getName(), bl2);
    }

    @Override
    public String getRCLScript() throws SQLException {
        String string = "";
        this.getConnDetails();
        String string2 = null;
        Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getErrorClass(), this.getFunctionStringClass(), this.getMaintUser(), "********"};
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        if (this.isPrimary()) {
            string2 = _cmdBundle.getCommand(CREATE_PRI_CONN, n, objectArray);
        } else if (this.isReplicate()) {
            string2 = _cmdBundle.getCommand(CREATE_REP_CONN, n, objectArray);
        }
        string = "-- Create Database Connection " + this.getName() + "\n" + string2;
        String string3 = "";
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        List list = semanticFactory.getConnParameters(this.getControllingRS(), this.getDS(), this.getDB());
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ConnParameter connParameter = (ConnParameter)listIterator.next();
                String string4 = connParameter.getRCLScript(this.getControllingRS(), this.getDS(), this.getDB());
                if (string4 == null || string4.length() <= 0) continue;
                string3 = string3 + string4 + "\n";
            }
        }
        if (string3.length() > 0) {
            string = string + "\ngo\n";
            string = string + "-- Set connection configuration parameters for " + this.getName() + "\n";
            string = string + string3;
        }
        return string;
    }

    @Override
    public String getActiveRCLScript() throws SQLException {
        this.getConnDetails();
        Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getErrorClass(), this.getFunctionStringClass(), this.getMaintUser(), "********", this.getLDS(), this.getLDB()};
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        String string = _cmdBundle.getCommand(CREATE_ACTIVE_CONN, n, objectArray);
        String string2 = "-- Create Active Database Connection " + this.getName() + "\n" + string;
        String string3 = "";
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        List list = semanticFactory.getConnParameters(this.getControllingRS(), this.getDS(), this.getDB());
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ConnParameter connParameter = (ConnParameter)listIterator.next();
                String string4 = connParameter.getRCLScript(this.getControllingRS(), this.getDS(), this.getDB());
                if (string4 == null || string4.length() <= 0) continue;
                string3 = string3 + string4 + "\n";
            }
        }
        if (string3.length() > 0) {
            string2 = string2 + "\ngo\n";
            string2 = string2 + "-- Set connection configuration parameters for " + this.getName() + "\n";
            string2 = string2 + string3;
        }
        return string2;
    }

    @Override
    public String getStandbyRCLScript() throws SQLException {
        this.getConnDetails();
        Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getErrorClass(), this.getFunctionStringClass(), this.getMaintUser(), "********", this.getLDS(), this.getLDB(), ""};
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        String string = _cmdBundle.getCommand(CREATE_STDBY_CONN, n, objectArray);
        String string2 = "-- Create Standby Database Connection " + this.getName() + "\n" + string;
        String string3 = "";
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        List list = semanticFactory.getConnParameters(this.getControllingRS(), this.getDS(), this.getDB());
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ConnParameter connParameter = (ConnParameter)listIterator.next();
                String string4 = connParameter.getRCLScript(this.getControllingRS(), this.getDS(), this.getDB());
                if (string4 == null || string4.length() <= 0) continue;
                string3 = string3 + string4 + "\n";
            }
        }
        if (string3.length() > 0) {
            string2 = string2 + "\ngo\n";
            string2 = string2 + "-- Set connection configuration parameters for " + this.getName() + "\n";
            string2 = string2 + string3;
        }
        return string2;
    }
}

