/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.Date;

public abstract class ExceptionLog
implements RSMObjectRow {
    protected String _rs;
    protected String _tranID;
    protected String _sys_trans_id;
    protected String _app_trans_name;
    protected String _orig_site;
    protected String _orig_db;
    protected Date _orig_time;
    protected String _orig_user;
    protected Date _log_time;
    protected String _ds_error;
    protected String _ds_errmsg;
    protected String _error_proc;
    protected int _error_src_line;
    protected int _err_output_line;
    protected String _log_reason;
    protected String _trans_status;
    protected String _app_usr;
    protected String _app_pwd;
    private static final int COLUMN_COUNT = 6;

    public ExceptionLog(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server parameter.");
        this._rs = string;
    }

    public String getControllingRS() {
        return this._rs;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getTranID();
            }
            case 1: {
                return this.getLogTime();
            }
            case 2: {
                return this.getOrigin();
            }
            case 3: {
                return this.getOriginUser();
            }
            case 4: {
                return this.getOriginTime();
            }
            case 5: {
                return this.getAppName();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    public String getTranID() {
        return this._tranID;
    }

    public Date getLogTime() {
        return this._log_time;
    }

    public String getSysTransID() {
        return this._sys_trans_id;
    }

    public String getAppName() {
        return this._app_trans_name;
    }

    public String getOrigin() {
        if (this._orig_db != null && this._orig_db.length() > 0) {
            return this._orig_site + "." + this._orig_db;
        }
        return this._orig_site;
    }

    public String getOriginSite() {
        return this._orig_site;
    }

    public String getOriginDB() {
        return this._orig_db;
    }

    public Date getOriginTime() {
        return this._orig_time;
    }

    public String getOriginUser() {
        return this._orig_user;
    }

    public String getError(boolean bl) {
        String string = "";
        if (this._log_reason != null) {
            String string2 = this._log_reason.trim();
            if (string2.equals("O")) {
                string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_ORPHAN", this._error_proc) + "\n";
            } else if (string2.equals("E")) {
                string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_MAPPED", this._error_proc) + "\n";
            } else if (string2.equals("S")) {
                string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_SKIPPED", this._error_proc) + "\n";
            } else if (string2.equals("D")) {
                string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_SYSADMIN", this._error_proc) + "\n";
            }
        }
        if (this._ds_errmsg != null && this._ds_errmsg.trim().length() > 0) {
            if (this._ds_error != null && this._ds_error.trim().length() > 0) {
                string = string + this._ds_error + " - ";
            }
            string = string + this._ds_errmsg + "\n";
        }
        if (this._error_proc != null && this._error_proc.trim().length() > 0) {
            string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_PROC", this._error_proc.trim());
        }
        if (bl) {
            if (this._err_output_line > 0) {
                string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_LINE_NR", String.valueOf(this._err_output_line));
            }
        } else if (this._error_src_line > 0) {
            string = string + BundleManager.getString("ConnectionRes", "EXC_LOG_ERR_MSG_LINE_NR", String.valueOf(this._error_src_line));
        }
        return string;
    }

    public String getAppUser() {
        return this._app_usr;
    }

    public String getAppPwd() {
        return this._app_pwd;
    }

    public abstract String getCommand(boolean var1) throws SQLException;

    public abstract void purge() throws SQLException;

    public abstract void submitCommand(String var1) throws SQLException;
}

