/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.WsqlParser;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.connection.ExcLogConnectDlg;
import com.sybase.rsmplugin.components.connection.ExceptionLog;
import com.sybase.rsmplugin.components.connection.ExceptionLogPanel;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.util.DateCellRenderer;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExceptionLogDlg
extends BaseDialog {
    protected SCPageController[] _page = null;
    protected PhyConnection _conn;

    public ExceptionLogDlg(SCDialogSupport2 sCDialogSupport2, PhyConnection phyConnection) {
        super(sCDialogSupport2);
        Dbg.wassert(phyConnection != null, "Null connection parameter.");
        this._conn = phyConnection;
        try {
            this._conn.getConnDetails();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    public PhyConnection getConnection() {
        return this._conn;
    }

    @Override
    public void showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(false);
        this.getDialogSupport().setHelpButton(false);
        PluginSupport.registerDialog(this);
        this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("ConnectionRes", "EXC_LOG_DLG_TITLE", this.getConnection().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new ExceptionLogPage()};
        }
        return this._page;
    }

    class ExceptionLogPage
    extends BasePage
    implements ActionListener,
    ListSelectionListener,
    ASASpinBoxChangeListener {
        private ExceptionLogPanel _goPage = new ExceptionLogPanel();
        private int _frameIdx = 0;
        private DateFormat _dateFormat = DateFormat.getDateTimeInstance(3, 3);

        @Override
        public void onInitDialog() {
            this._goPage.tbl_exceptions.getSelectionModel().addListSelectionListener(this);
            this._goPage.btn_show.addActionListener((ActionListener)this);
            this._goPage.btn_close.addActionListener((ActionListener)this);
            this._goPage.btn_purge.addActionListener((ActionListener)this);
            this._goPage.btn_selectAll.addActionListener((ActionListener)this);
            this._goPage.btn_submit.addActionListener((ActionListener)this);
            this._goPage.rbn_rcl.addActionListener((ActionListener)this);
            this._goPage.rbn_sql.addActionListener((ActionListener)this);
            this.setDisplayDate();
            this._goPage.spn_hours.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
            this.loadASEServers();
            this._goPage.cbx_originDS.addActionListener(this);
            this._goPage.tbl_exceptions.getColumnModel().getColumn(1).setCellRenderer(new DateCellRenderer());
            this._goPage.tbl_exceptions.getColumnModel().getColumn(4).setCellRenderer(new DateCellRenderer());
            this.setButtons();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.showCommand();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_show) {
                this.displayExceptions();
            } else if (actionEvent.getSource() == this._goPage.btn_close) {
                ExceptionLogDlg.this.closeDialog();
            } else if (actionEvent.getSource() == this._goPage.btn_purge) {
                this.purgeExceptions();
            } else if (actionEvent.getSource() == this._goPage.btn_selectAll) {
                this._goPage.tbl_exceptions.requestFocus();
                this._goPage.tbl_exceptions.selectAll();
            } else if (actionEvent.getSource() == this._goPage.btn_submit) {
                ExceptionLog exceptionLog;
                int n = this._goPage.tbl_exceptions.getSelectedRow();
                if (n >= 0 && (exceptionLog = (ExceptionLog)this._goPage.tbl_exceptions.getRSMObjectRow(n)) != null) {
                    this.resubmitCommand(exceptionLog);
                }
            } else if (actionEvent.getSource() == this._goPage.rbn_rcl || actionEvent.getSource() == this._goPage.rbn_sql) {
                this.showCommand();
            } else if (actionEvent.getSource() == this._goPage.cbx_originDS) {
                String string = this._goPage.cbx_originDS.getSelectedString();
                this.loadDatabases(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resubmitCommand(ExceptionLog exceptionLog) {
            Dbg.wassert(exceptionLog != null, "Null exception log object parameter.");
            String string = this._goPage.txt_editor.getText();
            if (this._goPage.rbn_sql.isSelected() && string != null && string.length() > 0) {
                ExcLogConnectDlg excLogConnectDlg = new ExcLogConnectDlg(PluginSupport.getDialogSupport(ExceptionLogDlg.this.getJDialog()), ExceptionLogDlg.this.getConnection().getName());
                excLogConnectDlg.setUsername(ExceptionLogDlg.this.getConnection().getMaintUser());
                if (excLogConnectDlg.showDialog()) {
                    ConnAttributes connAttributes = new ConnAttributes();
                    connAttributes.setType("ASE");
                    connAttributes.setServer(ExceptionLogDlg.this.getConnection().getDS());
                    connAttributes.setUser(excLogConnectDlg.getUsername());
                    connAttributes.setPassword(excLogConnectDlg.getPassword());
                    connAttributes.setCharset(excLogConnectDlg.getCharset());
                    connAttributes.setLanguage(excLogConnectDlg.getLanguage());
                    ASEConnection aSEConnection = new ASEConnection(connAttributes);
                    try {
                        ExceptionLogDlg.this.getDialogSupport().startWait();
                        aSEConnection.open();
                        String string2 = ExceptionLogDlg.this.getConnection().getDB();
                        if (string2 != null && string2.length() > 0) {
                            aSEConnection.use(string2);
                        }
                        aSEConnection.execute(string);
                        exceptionLog.purge();
                        this.displayExceptions();
                        this.showCommand();
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    }
                    finally {
                        aSEConnection.close();
                        ExceptionLogDlg.this.getDialogSupport().endWait();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showCommand() {
            ExceptionLog exceptionLog = null;
            int n = this._goPage.tbl_exceptions.getSelectedRow();
            if (n >= 0) {
                exceptionLog = (ExceptionLog)this._goPage.tbl_exceptions.getRSMObjectRow(n);
            }
            if (exceptionLog == null) {
                this._goPage.txt_editor.setText("");
                this._goPage.txt_error.setText("");
            } else {
                boolean bl = this._goPage.rbn_sql.isSelected();
                if (bl) {
                    this._goPage.txt_editor.setEditorType((Parser)WsqlParser.getInstance());
                } else {
                    this._goPage.txt_editor.setEditorType((Parser)null);
                }
                try {
                    ExceptionLogDlg.this.getDialogSupport().startWait();
                    this._goPage.txt_editor.setText(exceptionLog.getCommand(bl));
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    this._goPage.txt_editor.setText("");
                }
                finally {
                    ExceptionLogDlg.this.getDialogSupport().endWait();
                }
                this._goPage.txt_error.setText(exceptionLog.getError(bl));
            }
            this.setButtons();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayExceptions() {
            this._goPage.tbl_exceptions.clear();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(ExceptionLogDlg.this.getConnection().getDomainName());
            Dbg.wassert(semanticFactory != null, "Unable to get semantic factory for '" + ExceptionLogDlg.this.getConnection().getDomainName() + "'.");
            try {
                ExceptionLogDlg.this.getDialogSupport().startWait();
                List list = semanticFactory.getExceptionLog(ExceptionLogDlg.this.getConnection().getDS(), ExceptionLogDlg.this.getConnection().getDB(), this._goPage.cbx_originDS.getSelectedString(), this._goPage.cbx_originDB.getSelectedString(), this._goPage.spn_hours.getValue(), ExceptionLogDlg.this.getConnection().getControllingRS());
                if (list.size() > 0) {
                    this._goPage.tbl_exceptions.addRows(list);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                ExceptionLogDlg.this.getDialogSupport().endWait();
            }
            if (this._goPage.tbl_exceptions.getRowCount() > 0) {
                this._goPage.tbl_exceptions.requestFocus();
            }
            this._goPage.tbl_exceptions.refresh();
            this.showCommand();
        }

        protected void purgeExceptions() {
            if (this._goPage.tbl_exceptions.getSelectedRowCount() > 0 && PluginSupport.askQuestion(BundleManager.getString("ConnectionRes", "EXC_LOG_CONFIRM_PURGE"), ExceptionLogDlg.this.getDialogSupport().getJDialog(), false)) {
                ExceptionLogDlg.this.getDialogSupport().startWait();
                try {
                    int[] nArray = this._goPage.tbl_exceptions.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        ExceptionLog exceptionLog = (ExceptionLog)this._goPage.tbl_exceptions.getRSMObjectRow(nArray[i]);
                        if (exceptionLog == null) continue;
                        exceptionLog.purge();
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                ExceptionLogDlg.this.getDialogSupport().endWait();
                this.displayExceptions();
                this.showCommand();
            }
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.setDisplayDate();
        }

        protected void setDisplayDate() {
            int n = this._goPage.spn_hours.getValue();
            if (n > 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date());
                gregorianCalendar.add(10, -this._goPage.spn_hours.getValue());
                this._goPage.lbl_date.setText(BundleManager.getString("ConnectionRes", "EXC_LOG_DISP_DATE", this._dateFormat.format(gregorianCalendar.getTime())));
            } else {
                this._goPage.lbl_date.setText(BundleManager.getString("ConnectionRes", "EXC_LOG_DEF_HOURS"));
            }
        }

        protected void setButtons() {
            this._goPage.btn_selectAll.setEnabled(this._goPage.tbl_exceptions.getRowCount() > 0);
            boolean bl = this._goPage.tbl_exceptions.getSelectedRowCount() > 0;
            this._goPage.btn_purge.setEnabled(bl);
            this._goPage.rbn_rcl.setEnabled(bl);
            this._goPage.rbn_sql.setEnabled(bl);
            this._goPage.btn_submit.setEnabled(bl && this._goPage.txt_editor.getText().length() > 0 && this._goPage.rbn_sql.isSelected());
        }

        protected void loadASEServers() {
            this._goPage.cbx_originDS.removeAllItems();
            this._goPage.cbx_originDS.addItem("");
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(ExceptionLogDlg.this.getConnection().getDomainName());
            if (semanticFactory != null) {
                ListIterator listIterator = semanticFactory.getASEs().listIterator();
                while (listIterator.hasNext()) {
                    ASE aSE = (ASE)listIterator.next();
                    this._goPage.cbx_originDS.addItem(aSE.getName());
                }
            }
        }

        protected void loadDatabases(String string) {
            SemanticFactory semanticFactory;
            this._goPage.cbx_originDB.removeAllItems();
            this._goPage.cbx_originDB.addItem("");
            if (string != null && string.length() > 0 && (semanticFactory = PluginSupport.getSemanticFactory(ExceptionLogDlg.this.getConnection().getDomainName())) != null) {
                try {
                    ListIterator listIterator = semanticFactory.getPhyConnectionsForDataServer(string).listIterator();
                    while (listIterator.hasNext()) {
                        PhyConnection phyConnection = (PhyConnection)listIterator.next();
                        this._goPage.cbx_originDB.addItem(phyConnection.getDB());
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
    }
}

