/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseDialog;
import com.sybase.rsmplugin.components.BaseDialogPage;
import com.sybase.rsmplugin.components.connection.FilterDlgPanel;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;

public class FilterDlg
extends BaseDialog {
    protected SCPageController[] _page = null;
    protected List _connList;
    boolean _filterRA = false;
    boolean _filterDSI = false;

    public FilterDlg(List list, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(list != null && list.size() > 0, "Null or empty PhyConnection List parameter.");
        this._connList = list;
        this.initialize();
    }

    protected void initialize() {
        if (this.getConnectionList().size() > 0) {
            ListIterator listIterator = this.getConnectionList().listIterator();
            PhyConnection phyConnection = (PhyConnection)listIterator.next();
            this._filterRA = phyConnection.isRepAgentFiltered();
            this._filterDSI = phyConnection.isDSIFiltered();
            boolean bl = false;
            boolean bl2 = false;
            while (listIterator.hasNext() && !bl && !bl2) {
                phyConnection = (PhyConnection)listIterator.next();
                bl = bl || phyConnection.isRepAgentFiltered() != this._filterRA;
                bl2 = bl2 || phyConnection.isDSIFiltered() != this._filterDSI;
            }
            this._filterRA = bl ? false : this._filterRA;
            this._filterDSI = bl2 ? false : this._filterDSI;
        } else {
            this._filterRA = false;
            this._filterDSI = false;
        }
    }

    public List getConnectionList() {
        return this._connList;
    }

    @Override
    public String getTitle() {
        PhyConnection phyConnection = (PhyConnection)this.getConnectionList().get(0);
        String string = phyConnection.getName();
        if (this.getConnectionList().size() > 1) {
            string = string + ", ...";
        }
        return BundleManager.getString("ConnectionRes", "FILTER_DLG_TITLE", string);
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new FilterPage(this)};
        }
        return this._page;
    }

    @Override
    public boolean onOk() {
        PhyConnection phyConnection = (PhyConnection)this.getConnectionList().get(0);
        try {
            phyConnection.filter(this.getConnectionList(), this._filterRA, this._filterDSI);
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return super.onOk();
    }

    protected boolean isPrimary() {
        if (this.getConnectionList().size() > 1) {
            return true;
        }
        PhyConnection phyConnection = (PhyConnection)this.getConnectionList().get(0);
        return phyConnection.isPrimary();
    }

    class FilterPage
    extends BaseDialogPage {
        private FilterDlgPanel _goPage;

        public FilterPage(BaseDialog baseDialog) {
            super(baseDialog);
            this._goPage = new FilterDlgPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.chk_filterRA.setSelected(FilterDlg.this._filterRA);
            this._goPage.chk_filterDSI.setSelected(FilterDlg.this._filterDSI);
            this._goPage.chk_filterRA.setEnabled(FilterDlg.this.isPrimary());
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public boolean onOk() {
            FilterDlg.this._filterRA = this._goPage.chk_filterRA.isSelected();
            FilterDlg.this._filterDSI = this._goPage.chk_filterDSI.isSelected();
            return super.onOk();
        }
    }
}

