/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseFolder;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.AddConnWizard;
import com.sybase.rsmplugin.components.connection.ConnectionItem;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class PhyConnectionFolder
extends BaseFolder
implements RMContainer {
    public static final int CMD_ADD_CONN = 3000;
    private static final String CLASS_ID = "connection.PhyConnectionFolder";
    private String _name = BundleManager.getString("ConnectionRes", "COL_FOLDER_NAME");
    private String _connName;

    public PhyConnectionFolder(String string, BaseContainer baseContainer) {
        super(baseContainer);
        this._connName = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getRepServerName() {
        return this.getParent().getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public SCMenu getCreationMenu() {
        DefaultSCMenu defaultSCMenu = null;
        Domain domain = PluginSupport.getDomain(this._connName);
        if (domain != null && domain.isEnvironment()) {
            defaultSCMenu = new DefaultSCMenu();
            String string = BundleManager.getString("ConnectionRes", "MENU_ADD_CONN");
            String string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_ADD_CONN");
            char c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_ADD_CONN");
            ImageIcon imageIcon = new ImageIcon(RSMImages.getConnectionUp());
            MenuItem menuItem = new MenuItem(3000, string, string2, c, imageIcon);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        return defaultSCMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3000: {
                BaseController baseController = PluginSupport.getDialog(AddConnWizard.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                AddConnWizard addConnWizard = new AddConnWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), this.getRepServerName(), this._connName);
                addConnWizard.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            Domain domain = PluginSupport.getDomain(this._connName);
            if (domain != null && domain.isEnvironment()) {
                this.addItem((SCItem)new AddConnectionItem(this));
            }
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._connName);
            String string = this.getParent().getName();
            try {
                ListIterator listIterator = semanticFactory.getPhyConnections(string).listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    ConnectionItem connectionItem = new ConnectionItem(phyConnection, this);
                    this.addItem((SCItem)connectionItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("ConnectionRes", "COL_HEADER_CONN"), BundleManager.getString("ConnectionRes", "COL_HEADER_RA_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_DSI_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_REASON")};
    }

    class AddConnectionItem
    extends BaseAddItem {
        public AddConnectionItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("ConnectionRes", "ADD_CONN_ITEM"), RSMImages.getAddConnection());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(AddConnWizard.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                AddConnWizard addConnWizard = new AddConnWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), PhyConnectionFolder.this.getRepServerName(), PhyConnectionFolder.this._connName);
                addConnWizard.showDialog();
            }
        }
    }
}

