/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.connection;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.BaseStatusSO;
import com.sybase.rsmplugin.components.RMSStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMSPhyConnection
extends RMSStatusSO
implements PhyConnection {
    private static final String RMS_RA_CONNECTION = "RA Connection";
    private static final String RMS_DSI_CONNECTION = "DSI Connection";
    protected boolean _connExists = false;
    private String _ds = null;
    private String _db = null;
    private String _lds = null;
    private String _ldb = null;
    private boolean _isStandby = false;
    private int _type = 0;
    private static final int HIDE_STATE = 6;
    private static final String GET_CONNS = "GET_CONNS";
    private static final String GET_CONN = "GET_CONN";
    private static final String RESUME_CONN = "RESUME_CONN";
    private static final String SUSPEND_CONN = "SUSPEND_CONN";
    private static final String RESUME_LOG = "RESUME_LOG";
    private static final String GET_FILTER = "GET_FILTER";
    private static final String FILTER_RA = "FILTER_RA";
    private static final String FILTER_DSI = "FILTER_DSI";
    private static final Object[][] contents = new Object[][]{{"GET_CONNS", new Integer(15000), "get connections for {0}"}, {"GET_CONN", new Integer(15000), "get connections for {0}, {1}"}, {"RESUME_CONN", new Integer(15000), "resume dsi {0} for {1} {2}"}, {"SUSPEND_CONN", new Integer(15000), "suspend dsi {0} for {1} {2}"}, {"RESUME_LOG", new Integer(15000), "resume rep agent {0} for {1}"}, {"GET_FILTER", new Integer(15001), "filter {0} for {1}"}, {"FILTER_RA", new Integer(15001), "filter {0} for {1} rep agent={2}"}, {"FILTER_DSI", new Integer(15001), "filter {0} for {1} dsi={2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSPhyConnection(String string, String string2, String string3, RMSDomain rMSDomain) {
        super(string, string2 + "." + string3, rMSDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DB parameter.");
        this._ds = string2;
        this._db = string3;
        this.setRepAgentState(3);
        this.setDSIState(3);
        this.clearReasons();
    }

    @Override
    public Object clone() {
        RMSPhyConnection rMSPhyConnection = null;
        try {
            rMSPhyConnection = (RMSPhyConnection)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Dbg.wassert(false, "Unexpected exception thrown.");
        }
        return rMSPhyConnection;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "Connection";
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._ds != null && this._ds.length() > 0, "Null or empty data server name attribute.");
        return this._ds;
    }

    @Override
    public String getDB() {
        Dbg.wassert(this._db != null && this._db.length() > 0, "Null or empty database name attribute.");
        return this._db;
    }

    @Override
    public boolean isMasterDBConnection() {
        return false;
    }

    @Override
    public String getLDS() {
        Dbg.wassert(this._lds != null && this._lds.length() > 0, "Null or empty logical data server. This connection is not part of a logical connection.");
        Dbg.wassert(this._ldb != null && this._ldb.length() > 0, "Null or empty logical database.");
        return this._lds;
    }

    @Override
    public void setLDS(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical data server parameter.");
        this._lds = string;
    }

    @Override
    public String getLDB() {
        Dbg.wassert(this._lds != null && this._lds.length() > 0, "Null or empty logical data server. This connection is not part of a logical connection.");
        Dbg.wassert(this._ldb != null && this._ldb.length() > 0, "Null or empty logical database.");
        return this._ldb;
    }

    @Override
    public void setLDB(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical database parameter.");
        this._ldb = string;
    }

    @Override
    public boolean isPartOfLogicalConnection() {
        return this._lds != null && this._lds.length() > 0;
    }

    @Override
    public String getLogicalConnection() {
        if (this.isPartOfLogicalConnection()) {
            return this.getLDS() + "." + this.getLDB();
        }
        return null;
    }

    @Override
    public boolean isStandby() {
        return this._isStandby;
    }

    @Override
    public String getControllingRS() {
        return this.getControllingServer();
    }

    @Override
    public boolean isRepAgentActive() {
        return this.getRepAgentState() == 5;
    }

    @Override
    public boolean isRepAgentSuspended() {
        return this.getRepAgentState() == 2;
    }

    @Override
    public boolean isRepAgentUnknown() {
        return this.getRepAgentState() == 3;
    }

    @Override
    public boolean isRepAgentFiltered() {
        return this.getRepAgentState() == 6;
    }

    @Override
    public String getRepAgentStateString() {
        String string = "";
        if (this.isPrimary()) {
            if (this.isRepAgentFiltered()) {
                string = BundleManager.getString("ConnectionRes", "FILTERED_STATE");
            } else if (this.isRepAgentActive()) {
                string = BundleManager.getString("ConnectionRes", "ACTIVE_STATE");
            } else if (this.isRepAgentSuspended()) {
                string = BundleManager.getString("ConnectionRes", "SUSPENDED_STATE");
            } else if (this.isRepAgentUnknown()) {
                string = BundleManager.getString("ConnectionRes", "UNKNOWN_STATE");
            }
        }
        return string;
    }

    protected int getRepAgentState() {
        return this.get1stState();
    }

    public void setRepAgentState(int n) {
        Dbg.wassert(n == 5 || n == 2 || n == 3 || n == 6, "Invalid rep agent status value.");
        this.setDualState(n, this.get2ndState());
    }

    @Override
    public boolean isDSIActive() {
        return this.getDSIState() == 5;
    }

    @Override
    public boolean isDSISuspended() {
        return this.getDSIState() == 2;
    }

    @Override
    public boolean isDSIUnknown() {
        return this.getDSIState() == 3;
    }

    @Override
    public boolean isDSIFiltered() {
        return this.getDSIState() == 6;
    }

    @Override
    public String getDSIStateString() {
        String string = "";
        if (this.isDSIFiltered()) {
            string = BundleManager.getString("ConnectionRes", "FILTERED_STATE");
        } else if (this.isDSIActive()) {
            string = BundleManager.getString("ConnectionRes", "ACTIVE_STATE");
        } else if (this.isDSISuspended()) {
            string = BundleManager.getString("ConnectionRes", "SUSPENDED_STATE");
        } else if (this.isDSIUnknown()) {
            string = BundleManager.getString("ConnectionRes", "UNKNOWN_STATE");
        }
        return string;
    }

    protected int getDSIState() {
        return this.get2ndState();
    }

    public void setDSIState(int n) {
        Dbg.wassert(n == 5 || n == 2 || n == 3 || n == 6, "Invalid DSI status value.");
        this.setDualState(this.get1stState(), n);
    }

    @Override
    public boolean isUp() {
        if (this.isReplicate()) {
            return this.isDSIActive() || this.isDSIFiltered();
        }
        return !(!this.isDSIFiltered() && !this.isDSIActive() || !this.isRepAgentFiltered() && !this.isRepAgentActive());
    }

    @Override
    public boolean isError() {
        if (this.isReplicate()) {
            return !this.isDSIFiltered() && this.isDSISuspended();
        }
        return !this.isDSIFiltered() && this.isDSISuspended() || !this.isRepAgentFiltered() && this.isRepAgentSuspended();
    }

    @Override
    public boolean isWarning() {
        if (this.isPrimary()) {
            return (this.isDSIFiltered() || this.isDSIActive()) && !this.isRepAgentFiltered() && this.isRepAgentUnknown();
        }
        return false;
    }

    protected boolean isFiltered() {
        return this.isReplicate() && this.isDSIFiltered() || this.isPrimary() && this.isRepAgentFiltered() && this.isDSIFiltered();
    }

    @Override
    public String getStateString() {
        String string = "";
        if (this.isFiltered()) {
            string = BundleManager.getString("ConnectionRes", "FILTERED_STATE");
        } else if (this.isUp()) {
            string = BundleManager.getString("ConnectionRes", "ACTIVE_STATE");
        } else if (this.isWarning()) {
            string = BundleManager.getString("ConnectionRes", "UNKNOWN_STATE");
        } else if (this.isError()) {
            string = BundleManager.getString("ConnectionRes", "SUSPENDED_STATE");
        }
        return string;
    }

    @Override
    public boolean isReplicate() {
        return this._type == 0;
    }

    @Override
    public boolean isPrimary() {
        return this._type == 1;
    }

    @Override
    public String getConnectionType() {
        String string = "";
        string = this.isPartOfLogicalConnection() ? (this.isStandby() ? BundleManager.getString("ConnectionRes", "CONN_TYPE_STANDBY") : BundleManager.getString("ConnectionRes", "CONN_TYPE_ACTIVE")) : (this.isPrimary() ? BundleManager.getString("ConnectionRes", "CONN_TYPE_PRIMARY") : BundleManager.getString("ConnectionRes", "CONN_TYPE_REPLICATE"));
        return string;
    }

    @Override
    public boolean isRSSD() {
        return false;
    }

    @Override
    public String getFunctionStringClass() {
        return null;
    }

    @Override
    public void setFunctionStringClass(String string) {
    }

    @Override
    public String getErrorClass() {
        return null;
    }

    @Override
    public void setErrorClass(String string) {
    }

    @Override
    public String getMaintUser() {
        return null;
    }

    @Override
    public void setMaintUser(String string) {
    }

    @Override
    public String getMaintPwd() {
        return null;
    }

    @Override
    public void setMaintPwd(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List getConnectionsForServer(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_CONNS, n, string);
            Dbg.wassert(string2 != null, "Unable to get connection query command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3;
                    Object object;
                    String string4 = rSMResultSet.getColumnString(1);
                    String string5 = rSMResultSet.getColumnString(2);
                    String string6 = rSMResultSet.getColumnString(3);
                    ListIterator listIterator = arrayList.listIterator();
                    Object object2 = null;
                    while (listIterator.hasNext() && object2 == null) {
                        object = (RMSPhyConnection)listIterator.next();
                        if (!((RMSStatusSO)object).getName().equals(string5)) continue;
                        object2 = object;
                    }
                    if (object2 != null) {
                        ((RMSPhyConnection)object2)._type = 1;
                    } else {
                        object = MessageText.parseRSComponent(string5);
                        if (((String[])object).length == 2) {
                            object2 = new RMSPhyConnection(string4, (String)object[0], (String)object[1], rMSDomain);
                            ((RMSPhyConnection)object2)._connExists = true;
                            arrayList.add(object2);
                            ((RMSPhyConnection)object2)._type = string6.equalsIgnoreCase(RMS_RA_CONNECTION) ? 1 : 0;
                        }
                    }
                    int n2 = rSMResultSet.getColumnInt(5);
                    if (((RMSPhyConnection)object2).isPrimary()) {
                        ((RMSPhyConnection)object2).setRepAgentState(n2);
                    } else {
                        ((RMSPhyConnection)object2).setDSIState(n2);
                    }
                    if ((string3 = rSMResultSet.getColumnString(7)) == null || string3.length() <= 0) continue;
                    ((BaseStatusSO)object2).addReason(string3);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    public static List getConnections(String string, RMSDomain rMSDomain) throws SQLException {
        return RMSPhyConnection.getConnectionsForServer(string, rMSDomain);
    }

    public static List getConnectionsAll(RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<PhyConnection> arrayList = new ArrayList<PhyConnection>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(rMSDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = semanticFactory.getPhyConnections(repServer.getName()).listIterator();
            while (listIterator2.hasNext()) {
                PhyConnection phyConnection = (PhyConnection)listIterator2.next();
                arrayList.add(phyConnection);
            }
        }
        return arrayList;
    }

    public static List getKnownConnections(String string, RMSDomain rMSDomain) throws SQLException {
        return RMSPhyConnection.getConnections(string, rMSDomain);
    }

    public static List getConnectionsForDataServer(String string, RMSDomain rMSDomain) throws SQLException {
        return RMSPhyConnection.getConnectionsForServer(string, rMSDomain);
    }

    public static List getConnectionsForLANRepAgent(String string, RMSDomain rMSDomain) throws SQLException {
        return RMSPhyConnection.getConnectionsForServer(string, rMSDomain);
    }

    public static List getConnectionsForMirrorRepAgent(String string, RMSDomain rMSDomain) throws SQLException {
        return RMSPhyConnection.getConnectionsForServer(string, rMSDomain);
    }

    public static List getConnectionsForDirectConnect(String string, RMSDomain rMSDomain) throws SQLException {
        return RMSPhyConnection.getConnectionsForServer(string, rMSDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{this.getControllingRS(), this.getName()};
            String string = _cmdBundle.getCommand(GET_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get the query connection command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                this._connExists = false;
                this.clearReasons();
                this._type = 0;
                while (rSMResultSet.getNextRow()) {
                    String string2;
                    this._connExists = true;
                    String string3 = rSMResultSet.getColumnString(3);
                    if (string3.equalsIgnoreCase(RMS_RA_CONNECTION)) {
                        this._type = 1;
                    }
                    int n2 = rSMResultSet.getColumnInt(5);
                    if (string3.equalsIgnoreCase(RMS_RA_CONNECTION)) {
                        this.setRepAgentState(n2);
                    } else {
                        this.setDSIState(n2);
                    }
                    if ((string2 = rSMResultSet.getColumnString(7)) == null || string2.length() <= 0) continue;
                    this.addReason(string2);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }

    @Override
    public void loadProperties() throws SQLException {
    }

    @Override
    public boolean exists() {
        return this._connExists;
    }

    @Override
    public boolean createPrimary(String string, String string2, List list) {
        return false;
    }

    @Override
    public boolean createNonASEPrimary(String string, String string2, List list) {
        return false;
    }

    @Override
    public boolean createReplicate(List list) {
        return false;
    }

    @Override
    public boolean createNonASEReplicate(List list) {
        return false;
    }

    @Override
    public boolean createActive(String string, String string2, boolean bl, List list) {
        return false;
    }

    @Override
    public boolean changeToActive(List list) {
        return false;
    }

    @Override
    public boolean createStandby(String string, String string2, boolean bl, boolean bl2, List list) {
        return false;
    }

    @Override
    public void delete() throws SQLException {
    }

    @Override
    public void getConnDetails() throws SQLException {
        this.load();
    }

    @Override
    public void alter(String string, String string2, String string3) throws SQLException {
    }

    @Override
    public void resume(final List list, String string, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        if (list != null && list.size() > 0) {
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            RMSPhyConnection rMSPhyConnection = (RMSPhyConnection)listIterator.next();
                            this.setStatus(BundleManager.getString("ConnectionRes", "RESUME_DLG_TITLE", rMSPhyConnection.getName()));
                            if (bl) {
                                rMSPhyConnection.resumeRepAgent();
                            }
                            if (!bl2) continue;
                            rMSPhyConnection.resumeDSI(bl3, bl4);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSPhyConnection.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resumeRepAgent() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        RepAgent repAgent = semanticFactory.getRepAgent(this.getDS(), this.getDB());
        repAgent.setControllingRS(this.getControllingRS());
        repAgent.start();
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        Object[] objectArray = new String[]{this.getName(), this.getControllingRS()};
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(RESUME_LOG, n, objectArray);
        Dbg.wassert(string != null, "Unable to get resume log transfer command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resumeDSI(boolean bl, boolean bl2) throws SQLException {
        Dbg.wassert(!bl || !bl2, "Skip and execute cannot both be set to true.");
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        String string = bl ? "skip transaction" : (bl2 ? "execute transaction" : "");
        Object[] objectArray = new String[]{this.getName(), this.getControllingRS(), string};
        int n = this.getDomain().getRMSVersionNumber();
        String string2 = _cmdBundle.getCommand(RESUME_CONN, n, objectArray);
        Dbg.wassert(string2 != null, "Unable to get resume connection command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void suspend(final List list, String string, final boolean bl, final boolean bl2, final boolean bl3) {
        if (list != null && list.size() > 0) {
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            RMSPhyConnection rMSPhyConnection = (RMSPhyConnection)listIterator.next();
                            this.setStatus(BundleManager.getString("ConnectionRes", "SUSPEND_DLG_TITLE", rMSPhyConnection.getName()));
                            if (bl) {
                                rMSPhyConnection.suspendRepAgent();
                            }
                            if (!bl2) continue;
                            rMSPhyConnection.suspendDSI(bl3);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSPhyConnection.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    @Override
    public void suspendRepAgent() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        RepAgent repAgent = semanticFactory.getRepAgent(this.getDS(), this.getDB());
        repAgent.setControllingRS(this.getControllingRS());
        repAgent.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void suspendDSI(boolean bl) throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        Object[] objectArray = new String[]{this.getName(), this.getControllingRS(), bl ? "with nowait" : ""};
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(SUSPEND_CONN, n, objectArray);
        Dbg.wassert(string != null, "Unable to get suspend connection command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void filter(List list, boolean bl, boolean bl2) throws SQLException {
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                RMSPhyConnection rMSPhyConnection = (RMSPhyConnection)listIterator.next();
                rMSPhyConnection.filter(bl, bl2);
            }
            this.getDomain().refreshStatus();
        }
    }

    @Override
    public void filter(boolean bl, boolean bl2) throws SQLException {
        this.filterRA(bl);
        this.filterDSI(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filterRA(boolean bl) throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        Object[] objectArray = new String[]{this.getName(), this.getControllingRS(), bl ? "on" : "off"};
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(FILTER_RA, n, objectArray);
        if (string != null && string.length() > 0) {
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
                PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
                return;
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        } else {
            rMSConnection.unlock();
            throw new SQLException(BundleManager.getString("ConnectionRes", "RMS_UPGRADE_REQUIRED"), "_RSM_", 12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filterDSI(boolean bl) throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        Object[] objectArray = new String[]{this.getName(), this.getControllingRS(), bl ? "on" : "off"};
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(FILTER_DSI, n, objectArray);
        if (string != null && string.length() > 0) {
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
                PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
                return;
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        } else {
            rMSConnection.unlock();
            throw new SQLException(BundleManager.getString("ConnectionRes", "RMS_UPGRADE_REQUIRED"), "_RSM_", 12);
        }
    }

    @Override
    public String getRCLScript() throws SQLException {
        String string = "";
        return string;
    }

    @Override
    public String getActiveRCLScript() throws SQLException {
        String string = "";
        return string;
    }

    @Override
    public String getStandbyRCLScript() throws SQLException {
        String string = "";
        return string;
    }
}

