/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.database;

import com.sybase.central.SCItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.AddConnWizard;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedureFolder;
import com.sybase.rsmplugin.components.table.TableFolder;
import com.sybase.rsmplugin.util.Dbg;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DatabaseContainer
extends BaseContainer
implements RMContainer {
    private static final String CLASS_ID = "database.DatabaseContainer";
    private static final int CMD_EXCEPTIONS = 3000;
    private static final int CMD_RA_PROPS = 3001;
    private Database _so;
    private static ImageIcon _icon = null;

    public DatabaseContainer(Database database, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(database != null, "Null database semantic object parameter.");
        this._so = database;
    }

    public Database getDatabase() {
        return this._so;
    }

    public String getDomainName() {
        return this.getDatabase().getDomainName();
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (_icon == null) {
            _icon = new ImageIcon(RSMImages.getDatabase());
        }
        return _icon;
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
        }
        return "";
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            this.addItem((SCItem)new AddConnectionItem(this));
            String string = this._so.getDataServer();
            String string2 = this._so.getName();
            if (!this.getDatabase().isMasterDB()) {
                this.addItem((SCItem)new TableFolder(this._so.getDomainName(), this, string, string2));
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._so.getDomainName());
                DataServer dataServer = semanticFactory.getDataServer(string);
                if (dataServer != null && dataServer.supportsStoredProcedures()) {
                    this.addItem((SCItem)new StoredProcedureFolder(this._so.getDomainName(), this, string, string2));
                }
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DatabaseRes", "COL_HEADER_FOLDERS")};
    }

    class AddConnectionItem
    extends BaseAddItem {
        public AddConnectionItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("ConnectionRes", "ADD_CONN_ITEM"), RSMImages.getAddConnection());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(AddConnWizard.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                AddConnWizard addConnWizard = new AddConnWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), DatabaseContainer.this.getDatabase().getDataServer(), DatabaseContainer.this.getDatabase().getName(), DatabaseContainer.this.getDomainName());
                addConnWizard.showDialog();
            }
        }
    }
}

