/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.database;

import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainDatabase
implements Database {
    private EnvDomain _domain = null;
    private String _DS;
    private String _name = null;
    private int _status;
    private int _dbid;

    public DomainDatabase(String string, String string2, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._DS = string;
        this._name = string2;
        this._domain = envDomain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain connection attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty database name attribute.");
        return this._name;
    }

    @Override
    public boolean isMasterDB() {
        return this.getName().equals("master");
    }

    @Override
    public String getDataServer() {
        Dbg.wassert(this._DS != null && this._DS.length() > 0, "Null or empty data server name attribute.");
        return this._DS;
    }

    @Override
    public int getDBID() {
        return this._dbid;
    }

    public void setDBID(int n) {
        this._dbid = n;
    }

    @Override
    public int getStatus() {
        return this._status;
    }

    @Override
    public void setStatus(int n) {
        this._status = n;
    }

    public static List getDatabases(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        List list = new ArrayList();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        DataServer dataServer = semanticFactory.getDataServer(string);
        if (dataServer != null) {
            list = dataServer.getDatabases();
        }
        return list;
    }
}

