/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbrepdef;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDef;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefProp;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RCLEditor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DBRepDefItem
extends BaseItem
implements RMItem {
    private static final String CLASS_ID = "dbrepdef.DBRepDefContainer";
    private static final int CMD_EXCEPTIONS = 3008;
    private static final int CMD_RA_PROPS = 3009;
    private String _rs;
    private String _ds;
    private String _db;
    private DBRepDef _so;
    private static ImageIcon _icon = null;
    private static DefaultSCMenu _contextMenu = null;

    public DBRepDefItem(DBRepDef dBRepDef, BaseContainer baseContainer, String string, String string2, String string3) {
        super(baseContainer);
        Dbg.wassert(dBRepDef != null, "Null physical connection semantic object parameter.");
        this._so = dBRepDef;
        this._rs = string;
        this._ds = string2;
        this._db = string3;
    }

    public DBRepDef getDBRepDef() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (_icon == null) {
            _icon = new ImageIcon(RSMImages.getDBRepDef());
        }
        return _icon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                String string = this._so.getDS() + "." + this._so.getDB();
                return string;
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        if (_contextMenu == null) {
            _contextMenu = new DefaultSCMenu();
            _contextMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
            _contextMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            _contextMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            _contextMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        }
        return _contextMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof DBRepDefItem)) continue;
                    ((DBRepDefItem)baseItem).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 100: 
            case 107: {
                try {
                    this._so.loadDBRepDef();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                BaseController baseController = PluginSupport.getDialog(DBRepDefProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                DBRepDefProp dBRepDefProp = new DBRepDefProp(this, sCDialogSupport2);
                dBRepDefProp.showDialog();
                break;
            }
            case 3001: {
                try {
                    this._so.loadDBRepDef();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                RCLEditor.open(this.getRCLScript());
            }
        }
    }

    public void drop() {
        try {
            this._so.drop();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    public Hashtable getPropertyHashtable() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put("NAME", this._so.getName());
        return hashtable;
    }

    public String getRCLScript() {
        String string = "-- Create Database Replication Definition " + this._so.getName() + "\n";
        string = string + "create database replication definition " + this._so.getName() + "\n";
        string = string + "\twith primary at " + this._so.getDS() + "." + this._so.getDB() + "\n";
        string = string + "\t" + this.formatDDLFilter(this._so.getDDLFilter()) + "\n";
        string = string + "\t" + this.formatTablesFilter(this._so.getTableFilters()) + "\n";
        string = string + "\t" + this.formatFunctionsFilter(this._so.getFunctionFilters()) + "\n";
        string = string + "\t" + this.formatTransactionsFilter(this._so.getTransactionFilters()) + "\n";
        string = string + "\t" + this.formatSysProcsFilter(this._so.getSysProcFilters()) + "\n";
        return string;
    }

    public String formatSuspendDSI() {
        if (!this._so.getSuspendDSI()) {
            return "";
        }
        return "with dsi_suspended";
    }

    public String formatDDLFilter(boolean bl) {
        if (!bl) {
            return "not replicate DDL";
        }
        return "replicate DDL";
    }

    public String formatTablesFilter(List list) {
        String string = "";
        if (!this._so.isTableFilterPresent() && !this._so.isExcludeTables()) {
            string = "replicate tables";
            return string;
        }
        if (!this._so.isTableFilterPresent() && this._so.isExcludeTables()) {
            string = "not replicate tables";
            return string;
        }
        if (!list.isEmpty() && this._so.isExcludeTables() && this._so.isTableFilterPresent()) {
            string = "not replicate tables in (";
        } else if (!list.isEmpty() && !this._so.isExcludeTables() && this._so.isTableFilterPresent()) {
            string = "replicate tables in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String[] stringArray = new String[2];
                stringArray = (String[])listIterator.next();
                string = string + stringArray[0] + "." + stringArray[1];
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            if (this._so.getFreeFormTables() != null && this._so.getFreeFormTables().length() > 0) {
                string = string + ",";
                string = string + this._so.getFreeFormTables();
            }
            string = string + ")";
        } else if (this._so.getFreeFormTables() != null && this._so.getFreeFormTables().length() > 0) {
            if (this._so.isExcludeTables()) {
                string = "not replicate tables in (";
            } else if (!this._so.isExcludeTables()) {
                string = "replicate tables in (";
            }
            string = string + this._so.getFreeFormTables();
            string = string + ")";
        }
        return string;
    }

    public String formatFunctionsFilter(List list) {
        String string = "";
        if (!this._so.isFunctionFilterPresent() && !this._so.isExcludeFunctions()) {
            string = "replicate functions";
            return string;
        }
        if (!this._so.isFunctionFilterPresent() && this._so.isExcludeFunctions()) {
            string = "not replicate functions";
            return string;
        }
        if (!list.isEmpty() && this._so.isExcludeFunctions() && this._so.isFunctionFilterPresent()) {
            string = "not replicate functions in (";
        } else if (!list.isEmpty() && !this._so.isExcludeFunctions() && this._so.isFunctionFilterPresent()) {
            string = "replicate functions in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String[] stringArray = new String[2];
                stringArray = (String[])listIterator.next();
                string = string + stringArray[0] + "." + stringArray[1];
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    public String formatTransactionsFilter(List list) {
        String string = "";
        if (!this._so.isTransactionFilterPresent() && !this._so.isExcludeTransactions()) {
            string = "replicate transactions";
            return string;
        }
        if (!this._so.isTransactionFilterPresent() && this._so.isExcludeTransactions()) {
            string = "not replicate transactions";
            return string;
        }
        if (!list.isEmpty() && this._so.isExcludeTransactions() && this._so.isTransactionFilterPresent()) {
            string = "not replicate transactions in (";
        } else if (!list.isEmpty() && !this._so.isExcludeTransactions() && this._so.isTransactionFilterPresent()) {
            string = "replicate transactions in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String[] stringArray = new String[2];
                stringArray = (String[])listIterator.next();
                string = string + stringArray[0] + "." + stringArray[1];
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            if (this._so.getFreeFormTransactions() != null && this._so.getFreeFormTransactions().length() > 0) {
                string = string + ",";
                string = string + this._so.getFreeFormTransactions();
            }
            string = string + ")";
        } else if (this._so.getFreeFormTransactions() != null && this._so.getFreeFormTransactions().length() > 0) {
            if (this._so.isExcludeTransactions()) {
                string = "not replicate transactions in (";
            } else if (!this._so.isExcludeTransactions()) {
                string = "replicate transactions in (";
            }
            string = string + this._so.getFreeFormTransactions();
            string = string + ")";
        }
        return string;
    }

    public String formatSysProcsFilter(List list) {
        String string = "";
        if (!this._so.isSysProcFilterPresent() && !this._so.isExcludeSysProcs()) {
            string = "replicate system procedures";
            return string;
        }
        if (!this._so.isSysProcFilterPresent() && this._so.isExcludeSysProcs()) {
            string = "not replicate system procedures";
            return string;
        }
        if (!list.isEmpty() && this._so.isExcludeSysProcs() && this._so.isSysProcFilterPresent()) {
            string = "not replicate system procedures in (";
        } else if (!list.isEmpty() && !this._so.isExcludeSysProcs() && this._so.isSysProcFilterPresent()) {
            string = "replicate system procedures in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String[] stringArray = new String[2];
                stringArray = (String[])listIterator.next();
                string = string + stringArray[0] + "." + stringArray[1];
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }
}

