/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbrepdef;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDef;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefFuncFilterPanel;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefGeneralPanel;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefItem;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefSysProcFilterPanel;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefTableFilterPanel;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDefTransFilterPanel;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.storedprocedure.DomainStoredProcedure;
import com.sybase.rsmplugin.components.table.DomainTable;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DBRepDefProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected DBRepDef _dbrepdef = null;
    protected DBRepDefItem _item = null;
    protected String _domainName = null;
    protected BaseContainer _container;
    protected boolean _newDBRepDef = false;
    protected String _name;
    private boolean _repDDL = false;
    private boolean _tableFilterPresent = false;
    private boolean _excludeTables = false;
    private boolean _transFilterPresent = false;
    private boolean _excludeTrans = false;
    private boolean _funcFilterPresent = false;
    private boolean _excludeFuncs = false;
    private boolean _sysprocFilterPresent = false;
    private boolean _excludeSysProcs = false;
    private ArrayList tableNames = new ArrayList();
    private String freeformTables = null;
    private ArrayList functionNames = new ArrayList();
    private ArrayList transNames = new ArrayList();
    private String freeformTransactions = null;
    private ArrayList sysProcNames = new ArrayList();
    private boolean _suspendDSI = false;

    DBRepDefProp(DBRepDefItem dBRepDefItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(dBRepDefItem != null, "Null DBRepDef item parameter.");
        this._item = dBRepDefItem;
        this._dbrepdef = this._item.getDBRepDef();
        this._newDBRepDef = false;
    }

    DBRepDefProp(String string, String string2, String string3, String string4, BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication ds parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication db parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty connection name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(baseContainer != null, "Null or empty container parameter.");
        this._domainName = string3;
        this._container = baseContainer;
        this._newDBRepDef = true;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._domainName);
        this._dbrepdef = semanticFactory.getDBRepDef("", string4, string, string2);
    }

    DBRepDef getDBRepDef() {
        Dbg.wassert(this._dbrepdef != null, "Null DBRepDef attribute.");
        return this._dbrepdef;
    }

    @Override
    public String getTitle() {
        if (this._newDBRepDef) {
            return BundleManager.getString("DBRepDefRes", "NEW_DBREPDEF_TITLE");
        }
        return BundleManager.getString("DBRepDefRes", "PROPERTIES_TITLE", this._item.getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = this.getDBRepDef().isMasterDBConnection() ? new SCPageController[]{new GeneralPage(this), new SysProcFilterPage(this)} : new SCPageController[]{new GeneralPage(this), new TableFilterPage(this), new TransFilterPage(this), new FuncFilterPage(this), new SysProcFilterPage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public void onApply() {
        if (this._pages[0].isModified()) {
            this._dbrepdef.setDDLFilter(this._repDDL);
            this._dbrepdef.setSuspendDSI(this._suspendDSI);
        }
        if (this._pages[1].isModified()) {
            this._dbrepdef.setTableFilters(this.tableNames);
            this._dbrepdef.setFreeFormTables(this.freeformTables);
            this._dbrepdef.setTableFilterPresent(this._tableFilterPresent);
            this._dbrepdef.setExcludeTables(this._excludeTables);
        }
        if (this._pages[2].isModified()) {
            this._dbrepdef.setTransactionFilters(this.transNames);
            this._dbrepdef.setFreeFormTransactions(this.freeformTransactions);
            this._dbrepdef.setTransFilterPresent(this._transFilterPresent);
            this._dbrepdef.setExcludeTrans(this._excludeTrans);
        }
        if (this._pages[3].isModified()) {
            this._dbrepdef.setFunctionFilters(this.functionNames);
            this._dbrepdef.setFuncFilterPresent(this._funcFilterPresent);
            this._dbrepdef.setExcludeFuncs(this._excludeFuncs);
        }
        if (this._pages[4].isModified()) {
            this._dbrepdef.setSysProcFilters(this.sysProcNames);
            this._dbrepdef.setSysProcFilterPresent(this._sysprocFilterPresent);
            this._dbrepdef.setExcludeSysProcs(this._excludeSysProcs);
        }
        try {
            this.getDBRepDef().alter(this._pages[0].isModified(), this._pages[1].isModified(), this._pages[2].isModified(), this._pages[3].isModified(), this._pages[4].isModified());
            super.onApply();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    public boolean onOk() {
        this.getDialogSupport().startWait();
        if (this._newDBRepDef) {
            this._dbrepdef.setName(this._name);
            this._dbrepdef.setDDLFilter(this._repDDL);
            this._dbrepdef.setTableFilters(this.tableNames);
            this._dbrepdef.setFreeFormTables(this.freeformTables);
            this._dbrepdef.setFunctionFilters(this.functionNames);
            this._dbrepdef.setTransactionFilters(this.transNames);
            this._dbrepdef.setFreeFormTransactions(this.freeformTransactions);
            this._dbrepdef.setSysProcFilters(this.sysProcNames);
            this._dbrepdef.setTableFilterPresent(this._tableFilterPresent);
            this._dbrepdef.setExcludeTables(this._excludeTables);
            this._dbrepdef.setTransFilterPresent(this._transFilterPresent);
            this._dbrepdef.setExcludeTrans(this._excludeTrans);
            this._dbrepdef.setFuncFilterPresent(this._funcFilterPresent);
            this._dbrepdef.setExcludeFuncs(this._excludeFuncs);
            this._dbrepdef.setSysProcFilterPresent(this._sysprocFilterPresent);
            this._dbrepdef.setExcludeSysProcs(this._excludeSysProcs);
            try {
                this._dbrepdef.create();
            }
            catch (SQLException sQLException) {
                this.getDialogSupport().endWait();
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                return false;
            }
        }
        this._dbrepdef.setDDLFilter(this._repDDL);
        this._dbrepdef.setSuspendDSI(this._suspendDSI);
        this._dbrepdef.setTableFilters(this.tableNames);
        this._dbrepdef.setFreeFormTables(this.freeformTables);
        this._dbrepdef.setFunctionFilters(this.functionNames);
        this._dbrepdef.setTransactionFilters(this.transNames);
        this._dbrepdef.setFreeFormTransactions(this.freeformTransactions);
        this._dbrepdef.setSysProcFilters(this.sysProcNames);
        this._dbrepdef.setTableFilterPresent(this._tableFilterPresent);
        this._dbrepdef.setExcludeTables(this._excludeTables);
        this._dbrepdef.setTransFilterPresent(this._transFilterPresent);
        this._dbrepdef.setExcludeTrans(this._excludeTrans);
        this._dbrepdef.setFuncFilterPresent(this._funcFilterPresent);
        this._dbrepdef.setExcludeFuncs(this._excludeFuncs);
        this._dbrepdef.setSysProcFilterPresent(this._sysprocFilterPresent);
        this._dbrepdef.setExcludeSysProcs(this._excludeSysProcs);
        try {
            this.getDBRepDef().alter(this._pages[0].isModified(), this._pages[1].isModified(), this._pages[2].isModified(), this._pages[3].isModified(), this._pages[4].isModified());
        }
        catch (SQLException sQLException) {
            this.getDialogSupport().endWait();
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            return false;
        }
        if (this._newDBRepDef) {
            PluginSupport.refreshDomain(this._container);
        } else {
            PluginSupport.refreshDomain(this._item);
        }
        this.getDialogSupport().endWait();
        return super.onOk();
    }

    class SysProcFilterPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener,
    ASAListCheckListener {
        private DBRepDefSysProcFilterPanel _goPage;

        public SysProcFilterPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DBRepDefRes", "SYSPROC_PAGE_TAG"));
            this._goPage = new DBRepDefSysProcFilterPanel();
        }

        @Override
        public void onInitDialog() {
            Object object;
            Object object2;
            String[] stringArray;
            ListIterator listIterator;
            this._goPage.tbl_SysProcs.requestFocus();
            try {
                listIterator = DBRepDefProp.this.getDBRepDef().getSystemProcedures().listIterator();
                while (listIterator.hasNext()) {
                    stringArray = (String[])listIterator.next();
                    object2 = new ASAIconTextData((String)stringArray);
                    object = new Object[]{object2};
                    this._goPage.tbl_SysProcs.addRow(false, object);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            if (!DBRepDefProp.this._newDBRepDef) {
                if (!DBRepDefProp.this._dbrepdef.isExcludeSysProcs()) {
                    if (DBRepDefProp.this._dbrepdef.isSysProcFilterPresent()) {
                        this._goPage.rb_includeSelected.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(true);
                        this._goPage.tbl_SysProcs.setEnabled(true);
                    } else {
                        this._goPage.rb_replicateAll.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(false);
                        this._goPage.tbl_SysProcs.setEnabled(false);
                    }
                } else if (DBRepDefProp.this._dbrepdef.isExcludeSysProcs()) {
                    if (DBRepDefProp.this._dbrepdef.isSysProcFilterPresent()) {
                        this._goPage.rb_excludeSelected.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(true);
                        this._goPage.tbl_SysProcs.setEnabled(true);
                    } else {
                        this._goPage.rb_replicateNone.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(false);
                        this._goPage.tbl_SysProcs.setEnabled(false);
                    }
                }
                listIterator = DBRepDefProp.this._dbrepdef.getSysProcFilters().listIterator();
                while (listIterator.hasNext()) {
                    stringArray = (String[])listIterator.next();
                    object2 = stringArray[0];
                    object = stringArray[1];
                    int n = this._goPage.tbl_SysProcs.findRow((String)object);
                    if (n < 0) continue;
                    this._goPage.tbl_SysProcs.setRowChecked(n, true);
                }
            } else {
                this._goPage.rb_replicateAll.setSelected(true);
                this._goPage.lbl_filters.setEnabled(false);
                this._goPage.tbl_SysProcs.setEnabled(false);
            }
            this._goPage.tbl_SysProcs.addListCheckListener((ASAListCheckListener)this);
            this._goPage.rb_replicateAll.addActionListener((ActionListener)this);
            this._goPage.rb_replicateNone.addActionListener((ActionListener)this);
            this._goPage.rb_includeSelected.addActionListener((ActionListener)this);
            this._goPage.rb_excludeSelected.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    DBRepDefProp.this._sysprocFilterPresent = false;
                    DBRepDefProp.this._excludeSysProcs = false;
                } else if (this._goPage.rb_replicateNone.isSelected()) {
                    DBRepDefProp.this._sysprocFilterPresent = false;
                    DBRepDefProp.this._excludeSysProcs = true;
                } else if (this._goPage.rb_excludeSelected.isSelected()) {
                    DBRepDefProp.this._sysprocFilterPresent = true;
                    DBRepDefProp.this._excludeSysProcs = true;
                } else if (this._goPage.rb_includeSelected.isSelected()) {
                    DBRepDefProp.this._sysprocFilterPresent = true;
                    DBRepDefProp.this._excludeSysProcs = false;
                }
                if (this._goPage.tbl_SysProcs.getCheckedRowCount() > 0) {
                    int[] nArray = this._goPage.tbl_SysProcs.getCheckedRows();
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object[] objectArray = this._goPage.tbl_SysProcs.getRowAsArray(nArray[i]);
                        String string = objectArray[0].toString();
                        DBRepDefProp.this.sysProcNames.add(string);
                    }
                }
            }
            return true;
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            Dbg.wassert(aSAListCheckEvent != null, "Null ASAListCheckEvent parameter.");
            this.setModified(true);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
            if (actionEvent.getSource() == this._goPage.btn_selectAll) {
                this._goPage.tbl_SysProcs.checkAllRows();
            } else if (actionEvent.getSource() == this._goPage.btn_clearAll) {
                this._goPage.tbl_SysProcs.uncheckAllRows();
            } else if (actionEvent.getSource() == this._goPage.rb_includeSelected) {
                if (this._goPage.rb_includeSelected.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(true);
                    this._goPage.tbl_SysProcs.setEnabled(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_excludeSelected) {
                if (this._goPage.rb_excludeSelected.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(true);
                    this._goPage.tbl_SysProcs.setEnabled(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateAll) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(false);
                    this._goPage.tbl_SysProcs.setEnabled(false);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateNone && this._goPage.rb_replicateNone.isSelected()) {
                this._goPage.lbl_filters.setEnabled(false);
                this._goPage.tbl_SysProcs.setEnabled(false);
            }
        }
    }

    class FuncFilterPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener,
    ASAListCheckListener {
        private DBRepDefFuncFilterPanel _goPage;

        public FuncFilterPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DBRepDefRes", "FUNCFILTER_PAGE_TAG"));
            this._goPage = new DBRepDefFuncFilterPanel();
        }

        @Override
        public void onInitDialog() {
            Object[] objectArray;
            String string;
            String string2;
            String[] stringArray;
            this._goPage.tbl_Funcs.requestFocus();
            ListIterator listIterator = null;
            if (DBRepDefProp.this._newDBRepDef) {
                stringArray = PluginSupport.getSemanticFactory(DBRepDefProp.this._domainName);
                try {
                    string2 = DBRepDefProp.this.getDBRepDef().getDS();
                    string = DBRepDefProp.this.getDBRepDef().getDB();
                    objectArray = DBRepDefProp.this.getDBRepDef().getControllingRS();
                    LogConnection logConnection = stringArray.getLogConnection((String)objectArray, string2, string);
                    logConnection.load();
                    if (logConnection.exists()) {
                        string2 = logConnection.getActiveDS();
                        string = logConnection.getActiveDB();
                    }
                    listIterator = stringArray.getStoredProcedures(string2, string).listIterator();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            } else {
                stringArray = PluginSupport.getSemanticFactory(DBRepDefProp.this._dbrepdef.getDomainName());
                try {
                    string2 = DBRepDefProp.this._dbrepdef.getDS();
                    string = DBRepDefProp.this._dbrepdef.getDB();
                    objectArray = stringArray.getLogConnection(DBRepDefProp.this._dbrepdef.getControllingRS(), string2, string);
                    objectArray.load();
                    if (objectArray.exists()) {
                        string2 = objectArray.getActiveDS();
                        string = objectArray.getActiveDB();
                    }
                    listIterator = stringArray.getStoredProcedures(string2, string).listIterator();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
            while (listIterator.hasNext()) {
                stringArray = (DomainStoredProcedure)listIterator.next();
                string2 = stringArray.getName();
                string = new ASAIconTextData(string2);
                objectArray = new Object[]{string};
                this._goPage.tbl_Funcs.addRow(false, objectArray);
            }
            if (!DBRepDefProp.this._newDBRepDef) {
                if (!DBRepDefProp.this._dbrepdef.isExcludeFunctions()) {
                    if (DBRepDefProp.this._dbrepdef.isFunctionFilterPresent()) {
                        this._goPage.rb_includeSelected.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(true);
                        this._goPage.tbl_Funcs.setEnabled(true);
                    } else {
                        this._goPage.rb_replicateAll.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(false);
                        this._goPage.tbl_Funcs.setEnabled(false);
                    }
                } else if (DBRepDefProp.this._dbrepdef.isExcludeFunctions()) {
                    if (DBRepDefProp.this._dbrepdef.isFunctionFilterPresent()) {
                        this._goPage.rb_excludeSelected.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(true);
                        this._goPage.tbl_Funcs.setEnabled(true);
                    } else {
                        this._goPage.rb_replicateNone.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(false);
                        this._goPage.tbl_Funcs.setEnabled(false);
                    }
                }
                listIterator = DBRepDefProp.this._dbrepdef.getFunctionFilters().listIterator();
                while (listIterator.hasNext()) {
                    stringArray = (String[])listIterator.next();
                    string2 = stringArray[0];
                    string = stringArray[1];
                    int n = this._goPage.tbl_Funcs.findRow(string);
                    if (n < 0) continue;
                    this._goPage.tbl_Funcs.setRowChecked(n, true);
                }
            } else {
                this._goPage.rb_replicateAll.setSelected(true);
                this._goPage.lbl_filters.setEnabled(false);
                this._goPage.tbl_Funcs.setEnabled(false);
            }
            this._goPage.tbl_Funcs.addListCheckListener((ASAListCheckListener)this);
            this._goPage.rb_replicateAll.addActionListener((ActionListener)this);
            this._goPage.rb_replicateNone.addActionListener((ActionListener)this);
            this._goPage.rb_includeSelected.addActionListener((ActionListener)this);
            this._goPage.rb_excludeSelected.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    DBRepDefProp.this._funcFilterPresent = false;
                    DBRepDefProp.this._excludeFuncs = false;
                } else if (this._goPage.rb_replicateNone.isSelected()) {
                    DBRepDefProp.this._funcFilterPresent = false;
                    DBRepDefProp.this._excludeFuncs = true;
                } else if (this._goPage.rb_excludeSelected.isSelected()) {
                    DBRepDefProp.this._funcFilterPresent = true;
                    DBRepDefProp.this._excludeFuncs = true;
                } else if (this._goPage.rb_includeSelected.isSelected()) {
                    DBRepDefProp.this._funcFilterPresent = true;
                    DBRepDefProp.this._excludeFuncs = false;
                }
                if (this._goPage.tbl_Funcs.getCheckedRowCount() > 0) {
                    int[] nArray = this._goPage.tbl_Funcs.getCheckedRows();
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object[] objectArray = this._goPage.tbl_Funcs.getRowAsArray(nArray[i]);
                        String string = objectArray[0].toString();
                        DBRepDefProp.this.functionNames.add(string);
                    }
                }
            }
            return true;
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            Dbg.wassert(aSAListCheckEvent != null, "Null ASAListCheckEvent parameter.");
            this.setModified(true);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
            if (actionEvent.getSource() == this._goPage.btn_selectAll) {
                this._goPage.tbl_Funcs.checkAllRows();
            } else if (actionEvent.getSource() == this._goPage.btn_clearAll) {
                this._goPage.tbl_Funcs.uncheckAllRows();
            } else if (actionEvent.getSource() == this._goPage.rb_includeSelected) {
                if (this._goPage.rb_includeSelected.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(true);
                    this._goPage.tbl_Funcs.setEnabled(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_excludeSelected) {
                if (this._goPage.rb_excludeSelected.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(true);
                    this._goPage.tbl_Funcs.setEnabled(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateAll) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(false);
                    this._goPage.tbl_Funcs.setEnabled(false);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateNone && this._goPage.rb_replicateNone.isSelected()) {
                this._goPage.lbl_filters.setEnabled(false);
                this._goPage.tbl_Funcs.setEnabled(false);
            }
        }
    }

    class TransFilterPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener {
        private DBRepDefTransFilterPanel _goPage;
        private DBRepDefGeneralPanel _goGeneralPage;

        public TransFilterPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DBRepDefRes", "TRANSFILTER_PAGE_TAG"));
            this._goPage = new DBRepDefTransFilterPanel();
            this._goGeneralPage = new DBRepDefGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_Filters.requestFocus();
            if (!DBRepDefProp.this._newDBRepDef) {
                if (!DBRepDefProp.this._dbrepdef.isExcludeTransactions()) {
                    if (DBRepDefProp.this._dbrepdef.isTransactionFilterPresent()) {
                        this._goPage.rb_includeSelected.setSelected(true);
                        this._goPage.lbl_enterFilters.setEnabled(true);
                        this._goPage.fld_Filters.setEnabled(true);
                        this._goPage.fld_Filters.setEditable(true);
                    } else {
                        this._goPage.rb_replicateAll.setSelected(true);
                        this._goPage.lbl_enterFilters.setEnabled(false);
                        this._goPage.fld_Filters.setEnabled(false);
                        this._goPage.fld_Filters.setEditable(false);
                    }
                } else if (DBRepDefProp.this._dbrepdef.isExcludeTransactions()) {
                    if (DBRepDefProp.this._dbrepdef.isTransactionFilterPresent()) {
                        this._goPage.rb_excludeSelected.setSelected(true);
                        this._goPage.lbl_enterFilters.setEnabled(true);
                        this._goPage.fld_Filters.setEnabled(true);
                        this._goPage.fld_Filters.setEditable(true);
                    } else {
                        this._goPage.rb_replicateNone.setSelected(true);
                        this._goPage.lbl_enterFilters.setEnabled(false);
                        this._goPage.fld_Filters.setEnabled(false);
                        this._goPage.fld_Filters.setEditable(false);
                    }
                }
                ListIterator listIterator = DBRepDefProp.this._dbrepdef.getTransactionFilters().listIterator();
                while (listIterator.hasNext()) {
                    String string;
                    String[] stringArray = (String[])listIterator.next();
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String string4 = this._goPage.fld_Filters.getText();
                    if (string4 != null && string4.length() > 0) {
                        string = string4 + "," + string2 + "." + string3;
                        this._goPage.fld_Filters.setText(string);
                        continue;
                    }
                    string = string2 + "." + string3;
                    this._goPage.fld_Filters.setText(string);
                }
            } else {
                this._goPage.rb_replicateAll.setSelected(true);
                this._goPage.lbl_enterFilters.setEnabled(false);
                this._goPage.fld_Filters.setEnabled(false);
                this._goPage.fld_Filters.setEditable(false);
            }
            this._goPage.fld_Filters.getDocument().addDocumentListener(this);
            this._goPage.rb_replicateAll.addActionListener((ActionListener)this);
            this._goPage.rb_replicateNone.addActionListener((ActionListener)this);
            this._goPage.rb_includeSelected.addActionListener((ActionListener)this);
            this._goPage.rb_excludeSelected.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    DBRepDefProp.this._transFilterPresent = false;
                    DBRepDefProp.this._excludeTrans = false;
                } else if (this._goPage.rb_replicateNone.isSelected()) {
                    DBRepDefProp.this._transFilterPresent = false;
                    DBRepDefProp.this._excludeTrans = true;
                } else if (this._goPage.rb_excludeSelected.isSelected()) {
                    DBRepDefProp.this._transFilterPresent = true;
                    DBRepDefProp.this._excludeTrans = true;
                } else if (this._goPage.rb_includeSelected.isSelected()) {
                    DBRepDefProp.this._transFilterPresent = true;
                    DBRepDefProp.this._excludeTrans = false;
                }
                String string = this._goPage.fld_Filters.getText();
                if (string.length() > 0) {
                    DBRepDefProp.this.freeformTransactions = string.toString();
                }
            }
            return true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            String string = this._goPage.fld_Filters.getText();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            String string = this._goPage.fld_Filters.getText();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            String string = this._goPage.fld_Filters.getText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
            if (actionEvent.getSource() == this._goPage.rb_includeSelected) {
                if (this._goPage.rb_includeSelected.isSelected()) {
                    this._goPage.lbl_enterFilters.setEnabled(true);
                    this._goPage.fld_Filters.setEnabled(true);
                    this._goPage.fld_Filters.setEditable(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_excludeSelected) {
                if (this._goPage.rb_excludeSelected.isSelected()) {
                    this._goPage.lbl_enterFilters.setEnabled(true);
                    this._goPage.fld_Filters.setEnabled(true);
                    this._goPage.fld_Filters.setEditable(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateAll) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    this._goPage.lbl_enterFilters.setEnabled(false);
                    this._goPage.fld_Filters.setEnabled(false);
                    this._goPage.fld_Filters.setEditable(false);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateNone && this._goPage.rb_replicateNone.isSelected()) {
                this._goPage.lbl_enterFilters.setEnabled(false);
                this._goPage.fld_Filters.setEnabled(false);
                this._goPage.fld_Filters.setEditable(false);
            }
        }
    }

    class TableFilterPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener,
    ASAListCheckListener {
        private DBRepDefTableFilterPanel _goPage;

        public TableFilterPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DBRepDefRes", "TABLEFILTER_PAGE_TAG"));
            this._goPage = new DBRepDefTableFilterPanel();
        }

        @Override
        public void onInitDialog() {
            Object object;
            Object object2;
            String string;
            String string2;
            String[] stringArray;
            ListIterator listIterator = null;
            this._goPage.tbl_tables.requestFocus();
            if (DBRepDefProp.this._newDBRepDef) {
                stringArray = PluginSupport.getSemanticFactory(DBRepDefProp.this._domainName);
                try {
                    string2 = DBRepDefProp.this.getDBRepDef().getDS();
                    string = DBRepDefProp.this.getDBRepDef().getDB();
                    object2 = DBRepDefProp.this.getDBRepDef().getControllingRS();
                    object = stringArray.getLogConnection((String)object2, string2, string);
                    object.load();
                    if (object.exists()) {
                        string2 = object.getActiveDS();
                        string = object.getActiveDB();
                    }
                    listIterator = stringArray.getTables(string2, string).listIterator();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            } else {
                stringArray = PluginSupport.getSemanticFactory(DBRepDefProp.this._dbrepdef.getDomainName());
                try {
                    string2 = DBRepDefProp.this._dbrepdef.getDS();
                    string = DBRepDefProp.this._dbrepdef.getDB();
                    object2 = stringArray.getLogConnection(DBRepDefProp.this._dbrepdef.getControllingRS(), string2, string);
                    object2.load();
                    if (object2.exists()) {
                        string2 = object2.getActiveDS();
                        string = object2.getActiveDB();
                    }
                    listIterator = stringArray.getTables(string2, string).listIterator();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
            while (listIterator.hasNext()) {
                stringArray = (DomainTable)listIterator.next();
                string2 = stringArray.getOwner();
                string = stringArray.getName();
                object2 = new ASAIconTextData(string2);
                object = new Object[]{object2, string};
                this._goPage.tbl_tables.addRow(false, (Object[])object);
            }
            if (!DBRepDefProp.this._newDBRepDef) {
                if (!DBRepDefProp.this._dbrepdef.isExcludeTables()) {
                    if (DBRepDefProp.this._dbrepdef.isTableFilterPresent()) {
                        this._goPage.rb_includeSelected.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(true);
                        this._goPage.lbl_freeformFilters.setEnabled(true);
                        this._goPage.tbl_tables.setEnabled(true);
                        this._goPage.fld_freeformFilters.setEnabled(true);
                        this._goPage.fld_freeformFilters.setEditable(true);
                    } else {
                        this._goPage.rb_replicateAll.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(false);
                        this._goPage.lbl_freeformFilters.setEnabled(false);
                        this._goPage.tbl_tables.setEnabled(false);
                        this._goPage.fld_freeformFilters.setEnabled(false);
                        this._goPage.fld_freeformFilters.setEditable(false);
                    }
                } else if (DBRepDefProp.this._dbrepdef.isExcludeTables()) {
                    if (DBRepDefProp.this._dbrepdef.isTableFilterPresent()) {
                        this._goPage.rb_excludeSelected.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(true);
                        this._goPage.lbl_freeformFilters.setEnabled(true);
                        this._goPage.tbl_tables.setEnabled(true);
                        this._goPage.fld_freeformFilters.setEnabled(true);
                        this._goPage.fld_freeformFilters.setEditable(true);
                    } else {
                        this._goPage.rb_replicateNone.setSelected(true);
                        this._goPage.lbl_filters.setEnabled(false);
                        this._goPage.lbl_freeformFilters.setEnabled(false);
                        this._goPage.tbl_tables.setEnabled(false);
                        this._goPage.fld_freeformFilters.setEnabled(false);
                        this._goPage.fld_freeformFilters.setEditable(false);
                    }
                }
                listIterator = DBRepDefProp.this._dbrepdef.getTableFilters().listIterator();
                while (listIterator.hasNext()) {
                    String string3;
                    stringArray = (String[])listIterator.next();
                    string2 = stringArray[0];
                    string = stringArray[1];
                    int n = this._goPage.tbl_tables.findRow(stringArray);
                    if (n >= 0) {
                        this._goPage.tbl_tables.setRowChecked(n, true);
                        continue;
                    }
                    object = this._goPage.fld_freeformFilters.getText();
                    if (object != null && ((String)object).length() > 0) {
                        string3 = (String)object + "," + string2 + "." + string;
                        this._goPage.fld_freeformFilters.setText(string3);
                        continue;
                    }
                    string3 = string2 + "." + string;
                    this._goPage.fld_freeformFilters.setText(string3);
                }
            } else {
                this._goPage.rb_replicateAll.setSelected(true);
                this._goPage.lbl_filters.setEnabled(false);
                this._goPage.lbl_freeformFilters.setEnabled(false);
                this._goPage.tbl_tables.setEnabled(false);
                this._goPage.fld_freeformFilters.setEnabled(false);
                this._goPage.fld_freeformFilters.setEditable(false);
            }
            this._goPage.tbl_tables.addListCheckListener((ASAListCheckListener)this);
            this._goPage.fld_freeformFilters.getDocument().addDocumentListener(this);
            this._goPage.rb_replicateAll.addActionListener((ActionListener)this);
            this._goPage.rb_replicateNone.addActionListener((ActionListener)this);
            this._goPage.rb_includeSelected.addActionListener((ActionListener)this);
            this._goPage.rb_excludeSelected.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                Object object;
                if (this._goPage.rb_replicateAll.isSelected()) {
                    DBRepDefProp.this._tableFilterPresent = false;
                    DBRepDefProp.this._excludeTables = false;
                } else if (this._goPage.rb_replicateNone.isSelected()) {
                    DBRepDefProp.this._tableFilterPresent = false;
                    DBRepDefProp.this._excludeTables = true;
                } else if (this._goPage.rb_excludeSelected.isSelected()) {
                    DBRepDefProp.this._tableFilterPresent = true;
                    DBRepDefProp.this._excludeTables = true;
                } else if (this._goPage.rb_includeSelected.isSelected()) {
                    DBRepDefProp.this._tableFilterPresent = true;
                    DBRepDefProp.this._excludeTables = false;
                }
                if (this._goPage.tbl_tables.getCheckedRowCount() > 0) {
                    DBRepDefProp.this.tableNames.clear();
                    object = this._goPage.tbl_tables.getCheckedRows();
                    int n = ((Object)object).length;
                    for (int i = 0; i < n; ++i) {
                        Object[] objectArray = this._goPage.tbl_tables.getRowAsArray((int)object[i]);
                        String string = objectArray[0].toString();
                        String string2 = objectArray[1].toString();
                        String string3 = objectArray[0].toString() + "." + objectArray[1].toString();
                        DBRepDefProp.this.tableNames.add(string3);
                    }
                }
                if (((String)(object = this._goPage.fld_freeformFilters.getText())).length() > 0) {
                    DBRepDefProp.this.freeformTables = ((String)object).toString();
                }
            }
            return true;
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            Dbg.wassert(aSAListCheckEvent != null, "Null ASAListCheckEvent parameter.");
            this.setModified(true);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
            if (actionEvent.getSource() == this._goPage.btn_selectAll) {
                this._goPage.tbl_tables.checkAllRows();
            } else if (actionEvent.getSource() == this._goPage.btn_clearAll) {
                this._goPage.tbl_tables.uncheckAllRows();
            } else if (actionEvent.getSource() == this._goPage.rb_includeSelected) {
                if (this._goPage.rb_includeSelected.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(true);
                    this._goPage.lbl_freeformFilters.setEnabled(true);
                    this._goPage.tbl_tables.setEnabled(true);
                    this._goPage.fld_freeformFilters.setEnabled(true);
                    this._goPage.fld_freeformFilters.setEditable(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_excludeSelected) {
                if (this._goPage.rb_excludeSelected.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(true);
                    this._goPage.lbl_freeformFilters.setEnabled(true);
                    this._goPage.tbl_tables.setEnabled(true);
                    this._goPage.fld_freeformFilters.setEnabled(true);
                    this._goPage.fld_freeformFilters.setEditable(true);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateAll) {
                if (this._goPage.rb_replicateAll.isSelected()) {
                    this._goPage.lbl_filters.setEnabled(false);
                    this._goPage.lbl_freeformFilters.setEnabled(false);
                    this._goPage.tbl_tables.setEnabled(false);
                    this._goPage.fld_freeformFilters.setEnabled(false);
                    this._goPage.fld_freeformFilters.setEditable(false);
                }
            } else if (actionEvent.getSource() == this._goPage.rb_replicateNone && this._goPage.rb_replicateNone.isSelected()) {
                this._goPage.lbl_filters.setEnabled(false);
                this._goPage.lbl_freeformFilters.setEnabled(false);
                this._goPage.tbl_tables.setEnabled(false);
                this._goPage.fld_freeformFilters.setEnabled(false);
                this._goPage.fld_freeformFilters.setEditable(false);
            }
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener {
        private DBRepDefGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DBRepDefRes", "GENERAL_PAGE_TAG"));
            this._goPage = new DBRepDefGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            if (DBRepDefProp.this.getDBRepDef().isMasterDBConnection()) {
                this._goPage.chk_DDL.setVisible(false);
            }
            if (DBRepDefProp.this._newDBRepDef) {
                SCDialogSupport2 sCDialogSupport2 = this.getDialogSupport();
                this.getDialogSupport();
                JButton jButton = sCDialogSupport2.getStandardButtonById(4);
                jButton.setVisible(false);
                jButton.setEnabled(false);
            }
            if (DBRepDefProp.this._newDBRepDef) {
                this._goPage.fld_dsdb.setText("");
                this._goPage.fld_dsdb.setEnabled(true);
                this._goPage.fld_dsdb.setEditable(true);
                this._goPage.fld_dsdb.requestFocus();
                this._goPage.fld_dsdb.getDocument().addDocumentListener(this);
                this._goPage.chk_suspendDSI.setEnabled(false);
                this._goPage.chk_suspendDSI.setVisible(false);
                this._goPage.fld_dsName.setText(DBRepDefProp.this.getDBRepDef().getDS());
                this._goPage.fld_dbName.setText(DBRepDefProp.this.getDBRepDef().getDB());
                this._goPage.fld_rsName.setText(DBRepDefProp.this.getDBRepDef().getControllingRS());
                this._goPage.lbl_minVer.setVisible(false);
                this._goPage.fld_minVer.setVisible(false);
                this._goPage.fld_minVer.setEnabled(false);
            } else {
                this._goPage.fld_dsdb.setText(DBRepDefProp.this._item.getName());
                this._goPage.fld_dsdb.setEnabled(false);
                this._goPage.fld_dsdb.setEditable(false);
                this._goPage.chk_suspendDSI.setEnabled(true);
                this._goPage.chk_DDL.requestFocus();
                if (DBRepDefProp.this._dbrepdef.getDDLFilter()) {
                    this._goPage.chk_DDL.setSelected(true);
                } else {
                    this._goPage.chk_DDL.setSelected(false);
                }
                this._goPage.fld_dsName.setText(DBRepDefProp.this.getDBRepDef().getDS());
                this._goPage.fld_dbName.setText(DBRepDefProp.this.getDBRepDef().getDB());
                this._goPage.fld_rsName.setText(DBRepDefProp.this.getDBRepDef().getControllingRS());
                this._goPage.fld_minVer.setText(DBRepDefProp.this.getDBRepDef().getMinVersion());
            }
            this._goPage.chk_DDL.addActionListener((ActionListener)this);
            this._goPage.chk_suspendDSI.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            String string = this._goPage.fld_dsdb.getText();
            if (string == null || string.length() <= 0) {
                PluginSupport.showValidationError(this.getDialogSupport().getJDialog(), BundleManager.getString("DBRepDefRes", "BLANK_DBRDNAME"));
                this._goPage.fld_dsdb.requestFocus();
                return false;
            }
            DBRepDefProp.this._name = string;
            if (this.isModified()) {
                if (DBRepDefProp.this.getDBRepDef().isMasterDBConnection()) {
                    DBRepDefProp.this._repDDL = false;
                } else {
                    DBRepDefProp.this._repDDL = this._goPage.chk_DDL.isSelected();
                }
                DBRepDefProp.this._suspendDSI = this._goPage.chk_suspendDSI.isSelected();
            }
            return true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
        }
    }
}

