/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbrepdef;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDef;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainDBRepDef
implements DBRepDef {
    private EnvDomain _domain = null;
    private String _rs = null;
    private String _dbrepdefName = null;
    private String _ds = null;
    private String _db = null;
    private int _minver;
    private boolean _suspendDSI = false;
    private boolean _repDDL = false;
    private boolean _tableFilterPresent = false;
    private boolean _excludeTables = false;
    private boolean _transFilterPresent = false;
    private boolean _excludeTrans = false;
    private boolean _funcFilterPresent = false;
    private boolean _excludeFuncs = false;
    private boolean _sysprocFilterPresent = false;
    private boolean _excludeSysProcs = false;
    private ArrayList tableNames = new ArrayList();
    private String _freeFormTables = null;
    private ArrayList functionNames = new ArrayList();
    private ArrayList transactionNames = new ArrayList();
    private String _freeFormTransactions = null;
    private ArrayList sysProcNames = new ArrayList();
    static final int onDDL = 256;
    static final int negProc = 128;
    static final int onProc = 64;
    static final int negTran = 32;
    static final int onTran = 16;
    static final int negFunc = 8;
    static final int onFunc = 4;
    static final int negTable = 2;
    static final int onTable = 1;
    private static final String SYSTEM_PROCS_DB = "sybsystemprocs";
    private static final String MASTER_DB_PROCS = "log_sproc";
    private final String[] sysProcList = new String[]{"sp_addalias", "sp_addgroup", "sp_addmessage", "sp_add_qpgroup", "sp_adduser", "sp_addtype", "sp_bindefault", "sp_bindmsg", "sp_bindrule", "sp_changegroup", "sp_chgattribute", "sp_commonkey", "sp_config_rep_agent", "sp_dropalias", "sp_drop_all_qplans", "sp_dropgroup", "sp_dropkey", "sp_dropmessage", "sp_drop_qpgroup", "sp_droptype", "sp_dropuser", "sp_export_qpgroup", "sp_foreignkey", "sp_import_qpgroup", "sp_primarykey", "sp_procxmode", "sp_recompile", "sp_rename", "sp_rename_qpgroup", "sp_setrepcol", "sp_setreplicate", "sp_setrepmode", "sp_setrepproc", "sp_setreptable", "sp_unbindefault", "sp_unbindmsg", "sp_unbindrule"};
    private static final String GET_ALL_DBREPDEFS = "GET_ALL_DBREPDEFS";
    private static final String GET_RS_DBREPDEFS = "GET_RS_DBREPDEFS";
    private static final String GET_DBREPDEFS = "GET_DBREPDEFS";
    private static final String LOAD_DBREPDEF = "LOAD_DBREPDEF";
    private static final String LOAD_FILTERS = "LOAD_FILTERS";
    private static final String ALTER_DBREPDEF = "ALTER_DBREPDEF";
    private static final String CREATE_DBREPDEF = "CREATE_DBREPDEF";
    private static final String DROP_DBREPDEF = "DROP_DBREPDEF";
    private static final String GET_SYSTEM_PROCS = "GET_SYSTEM_PROCS";
    private static final Object[][] contents = new Object[][]{{"GET_ALL_DBREPDEFS", new Integer(1260), "rmp_all_db_repdef"}, {"GET_RS_DBREPDEFS", new Integer(1260), "rmp_db_repdef ''{0}''"}, {"GET_DBREPDEFS", new Integer(1260), "rmp_db_repdef_for_conn ''{0}'', ''{1}''"}, {"LOAD_DBREPDEF", new Integer(1260), "rmp_load_db_repdef ''{0}'', ''{1}'', ''{2}''"}, {"LOAD_FILTERS", new Integer(1260), "rmp_load_db_repdef_filters ''{0}'', ''{1}'', ''{2}''"}, {"ALTER_DBREPDEF", new Integer(1260), "alter database replication definition {0} with primary at \"{1}\".\"{2}\"  {3} {4}"}, {"CREATE_DBREPDEF", new Integer(1260), "create database replication definition {0} with primary at \"{1}\".\"{2}\"  {3} {4} {5} {6} {7}"}, {"DROP_DBREPDEF", new Integer(1260), "drop database replication definition {0} with primary at \"{1}\".\"{2}\" "}, {"GET_SYSTEM_PROCS", new Integer(150000), "sp_setrepproc"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainDBRepDef(String string, String string2, String string3, String string4, EnvDomain envDomain) {
        Dbg.wassert(string != null, "Null name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty DB parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty Repserver parameter.");
        this._dbrepdefName = string;
        this._ds = string3;
        this._db = string4;
        this._domain = envDomain;
        this._rs = string2;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._ds != null && this._ds.length() > 0, "Null or empty data server name attribute.");
        return this._ds;
    }

    @Override
    public String getDB() {
        Dbg.wassert(this._db != null && this._db.length() > 0, "Null or empty database name attribute.");
        return this._db;
    }

    @Override
    public boolean isMasterDBConnection() {
        boolean bl = this.getDB().equals("master");
        return bl;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._dbrepdefName != null && this._dbrepdefName.length() > 0, "Null or empty dbrepdef name attribute.");
        return this._dbrepdefName;
    }

    @Override
    public void setName(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty dbrepdef name parameter.");
        this._dbrepdefName = string;
    }

    @Override
    public String getMinVersion() {
        return String.valueOf(this._minver);
    }

    public void setMinVersion(int n) {
        this._minver = n;
    }

    @Override
    public boolean isExcludeTables() {
        return this._excludeTables;
    }

    @Override
    public boolean isTableFilterPresent() {
        return this._tableFilterPresent;
    }

    @Override
    public boolean isExcludeTransactions() {
        return this._excludeTrans;
    }

    @Override
    public boolean isTransactionFilterPresent() {
        return this._transFilterPresent;
    }

    @Override
    public boolean isExcludeFunctions() {
        return this._excludeFuncs;
    }

    @Override
    public boolean isFunctionFilterPresent() {
        return this._funcFilterPresent;
    }

    @Override
    public boolean isExcludeSysProcs() {
        return this._excludeSysProcs;
    }

    @Override
    public boolean isSysProcFilterPresent() {
        return this._sysprocFilterPresent;
    }

    @Override
    public void setTableFilterPresent(boolean bl) {
        this._tableFilterPresent = bl;
    }

    @Override
    public void setExcludeTables(boolean bl) {
        this._excludeTables = bl;
    }

    @Override
    public void setTransFilterPresent(boolean bl) {
        this._transFilterPresent = bl;
    }

    @Override
    public void setExcludeTrans(boolean bl) {
        this._excludeTrans = bl;
    }

    @Override
    public void setFuncFilterPresent(boolean bl) {
        this._funcFilterPresent = bl;
    }

    @Override
    public void setExcludeFuncs(boolean bl) {
        this._excludeFuncs = bl;
    }

    @Override
    public void setSysProcFilterPresent(boolean bl) {
        this._sysprocFilterPresent = bl;
    }

    @Override
    public void setExcludeSysProcs(boolean bl) {
        this._excludeSysProcs = bl;
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._rs != null && this._rs.length() > 0, "Null or empty RS name attribute.");
        return this._rs;
    }

    @Override
    public boolean getSuspendDSI() {
        return this._suspendDSI;
    }

    @Override
    public void setSuspendDSI(boolean bl) {
        this._suspendDSI = bl;
    }

    @Override
    public boolean getDDLFilter() {
        return this._repDDL;
    }

    @Override
    public void setDDLFilter(boolean bl) {
        this._repDDL = bl;
    }

    @Override
    public List getTableFilters() {
        return this.tableNames;
    }

    @Override
    public void setTableFilters(List list) {
        this.tableNames.clear();
        this.tableNames.addAll(list);
    }

    @Override
    public String getFreeFormTables() {
        return this._freeFormTables;
    }

    @Override
    public void setFreeFormTables(String string) {
        this._freeFormTables = null;
        this._freeFormTables = string;
    }

    @Override
    public List getFunctionFilters() {
        return this.functionNames;
    }

    @Override
    public void setFunctionFilters(List list) {
        this.functionNames.clear();
        this.functionNames.addAll(list);
    }

    @Override
    public List getTransactionFilters() {
        return this.transactionNames;
    }

    @Override
    public void setTransactionFilters(List list) {
        this.transactionNames.clear();
        this.transactionNames.addAll(list);
    }

    @Override
    public String getFreeFormTransactions() {
        return this._freeFormTransactions;
    }

    @Override
    public void setFreeFormTransactions(String string) {
        this._freeFormTransactions = null;
        this._freeFormTransactions = string;
    }

    @Override
    public List getSysProcFilters() {
        return this.sysProcNames;
    }

    @Override
    public void setSysProcFilters(List list) {
        this.sysProcNames.clear();
        this.sysProcNames.addAll(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSystemProcedures() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getDomain().getVersionNumber(this.getDS());
        String string = _cmdBundle.getCommand(GET_SYSTEM_PROCS, n);
        if (string != null) {
            ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
            if (aSEConnection != null) {
                aSEConnection.use(SYSTEM_PROCS_DB);
                RSMResultSet rSMResultSet = new RSMResultSet(aSEConnection);
                try {
                    rSMResultSet.open(string);
                    while (rSMResultSet.getNextRow()) {
                        String string2 = rSMResultSet.getColumnString(1);
                        if (string2 == null) continue;
                        string2 = string2.trim();
                        if (this.isMasterDBConnection()) {
                            String string3 = rSMResultSet.getColumnString(3);
                            if (string3 == null || !(string3 = string3.trim()).equalsIgnoreCase(MASTER_DB_PROCS)) continue;
                            arrayList.add(string2);
                            continue;
                        }
                        arrayList.add(string2);
                    }
                }
                finally {
                    rSMResultSet.close();
                    aSEConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
        if (arrayList.size() == 0) {
            int n2 = this.sysProcList.length;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(this.sysProcList[i]);
            }
        }
        return arrayList;
    }

    public String formatSuspendDSI() {
        if (!this._suspendDSI) {
            return "";
        }
        return "with dsi_suspended";
    }

    public String formatDDLFilter(boolean bl) {
        if (!bl) {
            return "not replicate DDL";
        }
        return "replicate DDL";
    }

    public String formatTablesFilter(List list) {
        String string = "";
        if (!this._tableFilterPresent && !this._excludeTables) {
            string = "replicate tables";
            return string;
        }
        if (!this._tableFilterPresent && this._excludeTables) {
            string = "not replicate tables";
            return string;
        }
        if (!list.isEmpty() && this._excludeTables && this._tableFilterPresent) {
            string = "not replicate tables in (";
        } else if (!list.isEmpty() && !this._excludeTables && this._tableFilterPresent) {
            string = "replicate tables in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                string = string + (String)listIterator.next();
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            if (this._freeFormTables != null && this._freeFormTables.length() > 0) {
                string = string + ",";
                string = string + this._freeFormTables;
            }
            string = string + ")";
        } else if (this._freeFormTables != null && this._freeFormTables.length() > 0) {
            if (this._excludeTables) {
                string = "not replicate tables in (";
            } else if (!this._excludeTables) {
                string = "replicate tables in (";
            }
            string = string + this._freeFormTables;
            string = string + ")";
        }
        return string;
    }

    public String formatFunctionsFilter(List list) {
        String string = "";
        if (!this._funcFilterPresent && !this._excludeFuncs) {
            string = "replicate functions";
            return string;
        }
        if (!this._funcFilterPresent && this._excludeFuncs) {
            string = "not replicate functions";
            return string;
        }
        if (!list.isEmpty() && this._excludeFuncs && this._funcFilterPresent) {
            string = "not replicate functions in (";
        } else if (!list.isEmpty() && !this._excludeFuncs && this._funcFilterPresent) {
            string = "replicate functions in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                string = string + (String)listIterator.next();
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    public String formatTransactionsFilter(List list) {
        String string = "";
        if (!this._transFilterPresent && !this._excludeTrans) {
            string = "replicate transactions";
            return string;
        }
        if (!this._transFilterPresent && this._excludeTrans) {
            string = "not replicate transactions";
            return string;
        }
        if (!list.isEmpty() && this._excludeTrans && this._transFilterPresent) {
            string = "not replicate transactions in (";
        } else if (!list.isEmpty() && !this._excludeTrans && this._transFilterPresent) {
            string = "replicate transactions in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                string = string + (String)listIterator.next();
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            if (this._freeFormTransactions != null && this._freeFormTransactions.length() > 0) {
                string = string + ",";
                string = string + this._freeFormTransactions;
            }
            string = string + ")";
        } else if (this._freeFormTransactions != null && this._freeFormTransactions.length() > 0) {
            if (this._excludeTrans) {
                string = "not replicate transactions in (";
            } else if (!this._excludeTrans) {
                string = "replicate transactions in (";
            }
            string = string + this._freeFormTransactions;
            string = string + ")";
        }
        return string;
    }

    public String formatSysProcsFilter(List list) {
        String string = "";
        if (!this._sysprocFilterPresent && !this._excludeSysProcs) {
            string = "replicate system procedures";
            return string;
        }
        if (!this._sysprocFilterPresent && this._excludeSysProcs) {
            string = "not replicate system procedures";
            return string;
        }
        if (!list.isEmpty() && this._excludeSysProcs && this._sysprocFilterPresent) {
            string = "not replicate system procedures in (";
        } else if (!list.isEmpty() && !this._excludeSysProcs && this._sysprocFilterPresent) {
            string = "replicate system procedures in (";
        }
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                string = string + (String)listIterator.next();
                if (!listIterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop() throws SQLException {
        boolean bl = false;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getName(), this.getDS(), this.getDB()};
            String string = _cmdBundle.getCommand(DROP_DBREPDEF, n, objectArray);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDBRepDefs(String string, String string2, String string3, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        int n = envDomain.getVersionNumber(string);
        Object[] objectArray = new String[]{string2, string3};
        String string4 = _cmdBundle.getCommand(GET_DBREPDEFS, n, objectArray);
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty command string.");
        ArrayList<DomainDBRepDef> arrayList = new ArrayList<DomainDBRepDef>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(1);
                    String string6 = rSMResultSet.getColumnString(4);
                    if (string5 == null || string5.length() <= 0 || string6 == null || string6.length() <= 0) continue;
                    DomainDBRepDef domainDBRepDef = new DomainDBRepDef(string5, string6, string2, string3, envDomain);
                    domainDBRepDef.setMinVersion(rSMResultSet.getColumnInt(5));
                    arrayList.add(domainDBRepDef);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDBRepDefs(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        int n = envDomain.getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_ALL_DBREPDEFS, n);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command string.");
        ArrayList<DomainDBRepDef> arrayList = new ArrayList<DomainDBRepDef>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    String string6 = rSMResultSet.getColumnString(4);
                    if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0 || string6 == null || string6.length() <= 0) continue;
                    DomainDBRepDef domainDBRepDef = new DomainDBRepDef(string3, string6, string4, string5, envDomain);
                    domainDBRepDef.setMinVersion(rSMResultSet.getColumnInt(5));
                    arrayList.add(domainDBRepDef);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws SQLException {
        Object object;
        Object object2;
        Dbg.wassert(this._dbrepdefName != null && this._dbrepdefName.length() > 0, "Null or empty DB rep def name.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            object2 = new String[]{this.getName(), this.getDS(), this.getDB(), this.formatDDLFilter(this.getDDLFilter()), this.formatTablesFilter(this.getTableFilters()), this.formatFunctionsFilter(this.getFunctionFilters()), this.formatTransactionsFilter(this.getTransactionFilters()), this.formatSysProcsFilter(this.getSysProcFilters())};
            int n = rSMConnection.getVersionNumber();
            object = _cmdBundle.getCommand(CREATE_DBREPDEF, n, (Object[])object2);
            Dbg.wassert(object != null, "Unable to get Create DBRepDef command.");
            try {
                rSMConnection.execute((String)object);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("DBRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        object2 = PluginSupport.getSemanticFactory(this.getDomainName());
        LogConnection logConnection = object2.getLogConnection(this.getControllingRS(), this.getDS(), this.getDB());
        logConnection.load();
        if (!logConnection.exists()) {
            object = object2.getRepAgent(this.getDS(), this.getDB());
            object.setRepToStandby();
            object.setSendWarmStandbyXact();
            object.cycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException {
        String string;
        int n;
        Object[] objectArray;
        RSMConnection rSMConnection;
        if (bl) {
            rSMConnection = this.getDomain().getConnection(this.getControllingRS());
            if (rSMConnection != null) {
                objectArray = new String[]{this.getName(), this.getDS(), this.getDB(), this.formatDDLFilter(this.getDDLFilter()), this.formatSuspendDSI()};
                n = rSMConnection.getVersionNumber();
                string = _cmdBundle.getCommand(ALTER_DBREPDEF, n, objectArray);
                Dbg.wassert(string != null, "Unable to get Alter DBRepDef command.");
                try {
                    rSMConnection.execute(string);
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("DBRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
        if (bl2) {
            rSMConnection = this.getDomain().getConnection(this.getControllingRS());
            if (rSMConnection != null) {
                objectArray = new String[]{this.getName(), this.getDS(), this.getDB(), this.formatTablesFilter(this.getTableFilters()), this.formatSuspendDSI()};
                n = rSMConnection.getVersionNumber();
                string = _cmdBundle.getCommand(ALTER_DBREPDEF, n, objectArray);
                Dbg.wassert(string != null, "Unable to get Alter DBRepDef command.");
                try {
                    rSMConnection.execute(string);
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("DBRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
        if (bl4) {
            rSMConnection = this.getDomain().getConnection(this.getControllingRS());
            if (rSMConnection != null) {
                objectArray = new String[]{this.getName(), this.getDS(), this.getDB(), this.formatFunctionsFilter(this.getFunctionFilters()), this.formatSuspendDSI()};
                n = rSMConnection.getVersionNumber();
                string = _cmdBundle.getCommand(ALTER_DBREPDEF, n, objectArray);
                Dbg.wassert(string != null, "Unable to get Alter DBRepDef command.");
                try {
                    rSMConnection.execute(string);
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("DBRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
        if (bl3) {
            rSMConnection = this.getDomain().getConnection(this.getControllingRS());
            if (rSMConnection != null) {
                objectArray = new String[]{this.getName(), this.getDS(), this.getDB(), this.formatTransactionsFilter(this.getTransactionFilters()), this.formatSuspendDSI()};
                n = rSMConnection.getVersionNumber();
                string = _cmdBundle.getCommand(ALTER_DBREPDEF, n, objectArray);
                Dbg.wassert(string != null, "Unable to get Alter DBRepDef command.");
                try {
                    rSMConnection.execute(string);
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("DBRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
        if (bl5) {
            rSMConnection = this.getDomain().getConnection(this.getControllingRS());
            if (rSMConnection != null) {
                objectArray = new String[]{this.getName(), this.getDS(), this.getDB(), this.formatSysProcsFilter(this.getSysProcFilters()), this.formatSuspendDSI()};
                n = rSMConnection.getVersionNumber();
                string = _cmdBundle.getCommand(ALTER_DBREPDEF, n, objectArray);
                Dbg.wassert(string != null, "Unable to get Alter DBRepDef command.");
                try {
                    rSMConnection.execute(string);
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("DBRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDBRepDef() throws SQLException {
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        Object[] objectArray = new String[]{this.getName(), this.getDS(), this.getDB()};
        String string = _cmdBundle.getCommand(LOAD_DBREPDEF, n, objectArray);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty command string.");
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getControllingRS());
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    String string3 = rSMResultSet.getColumnString(2);
                    String string4 = rSMResultSet.getColumnString(3);
                    String string5 = rSMResultSet.getColumnString(4);
                    if (string2.equals(this.getName())) {
                        // empty if block
                    }
                    String string6 = rSMResultSet.getColumnString(5);
                    int n2 = rSMResultSet.getColumnInt(6);
                    String string7 = rSMResultSet.getColumnString(7);
                    String string8 = string3 + "." + string4;
                    this.loadFilterFlags(n2);
                    if (!(this._tableFilterPresent | this._funcFilterPresent | this._transFilterPresent | this._sysprocFilterPresent)) continue;
                    this.loadFilterData(rSMConnection);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    public void loadFilterFlags(int n) {
        this._repDDL = (n & 0x100) != 256;
        this._sysprocFilterPresent = (n & 0x40) == 64;
        this._excludeSysProcs = (n & 0x80) == 128;
        this._funcFilterPresent = (n & 4) == 4;
        this._excludeFuncs = (n & 8) == 8;
        this._transFilterPresent = (n & 0x10) == 16;
        this._excludeTrans = (n & 0x20) == 32;
        this._tableFilterPresent = (n & 1) == 1;
        this._excludeTables = (n & 2) == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFilterData(RSMConnection rSMConnection) throws SQLException {
        this.tableNames.clear();
        this.transactionNames.clear();
        this.functionNames.clear();
        this.sysProcNames.clear();
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        Object[] objectArray = new String[]{this.getName(), this.getDS(), this.getDB()};
        String string = _cmdBundle.getCommand(LOAD_FILTERS, n, objectArray);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty command string.");
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string);
            while (rSMResultSet.getNextRow()) {
                String[] stringArray;
                String string2 = rSMResultSet.getColumnString(4);
                if (string2.equalsIgnoreCase("T")) {
                    stringArray = new String[]{rSMResultSet.getColumnString(5), rSMResultSet.getColumnString(6)};
                    this.tableNames.add(stringArray);
                    continue;
                }
                if (string2.equalsIgnoreCase("F")) {
                    stringArray = new String[]{"*", rSMResultSet.getColumnString(6)};
                    this.functionNames.add(stringArray);
                    continue;
                }
                if (string2.equalsIgnoreCase("X")) {
                    stringArray = new String[]{rSMResultSet.getColumnString(5), rSMResultSet.getColumnString(6)};
                    this.transactionNames.add(stringArray);
                    continue;
                }
                if (string2.equalsIgnoreCase("P")) {
                    stringArray = new String[]{"*", rSMResultSet.getColumnString(6)};
                    this.sysProcNames.add(stringArray);
                    continue;
                }
                Dbg.wassert(false, "Filter Type does not match known filters.");
            }
        }
        finally {
            rSMResultSet.close();
        }
    }
}

