/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbsubscription;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseFolder;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.dbsubscription.DBSub;
import com.sybase.rsmplugin.components.dbsubscription.DBSubItem;
import com.sybase.rsmplugin.components.dbsubscription.DBSubWiz;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DBSubFolder
extends BaseFolder
implements RMContainer {
    public static final int CMD_ADD_DBSUB = 3000;
    private static final String CLASS_ID = "dbsubscription.DBSubFolder";
    private String _name;
    private String _ds;
    private String _db;
    private String _rs;
    private String _domainName;
    private DefaultSCMenu _creationMenu = null;

    public DBSubFolder(String string, BaseContainer baseContainer, String string2, String string3, String string4) {
        super(baseContainer);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DB parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty rs parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        this._name = BundleManager.getString("DBSubRes", "COL_FOLDER_NAME");
        this._domainName = string;
        this._ds = string2;
        this._db = string3;
        this._rs = string4;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty name parameter.");
        return this._name;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public SCMenu getCreationMenu() {
        if (this._creationMenu == null) {
            this._creationMenu = new DefaultSCMenu();
            String string = BundleManager.getString("DBSubRes", "MENU_ADD_DBSUB");
            String string2 = BundleManager.getString("DBSubRes", "MENU_HINT_ADD_DBSUB");
            char c = BundleManager.getMnemonic("DBSubRes", "MENU_MNEM_ADD_DBSUB");
            ImageIcon imageIcon = new ImageIcon(RSMImages.getDBSub());
            MenuItem menuItem = new MenuItem(3000, string, string2, c, imageIcon);
            this._creationMenu.addItem((SCMenuItem)menuItem);
        }
        return this._creationMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3000: {
                BaseController baseController = PluginSupport.getDialog(DBSubWiz.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                DBSubWiz dBSubWiz = new DBSubWiz(this._ds, this._db, this._domainName, this._rs, this.getParent(), PluginSupport.getDialogSupport(jFrame));
                dBSubWiz.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            this.addItem((SCItem)new AddDBSubItem(this));
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._domainName);
            try {
                ListIterator listIterator = semanticFactory.getDBSubs(this._rs, this._ds, this._db).listIterator();
                while (listIterator.hasNext()) {
                    DBSubItem dBSubItem = new DBSubItem((DBSub)listIterator.next(), this, this._rs, this._ds, this._db);
                    this.addItem((SCItem)dBSubItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DBSubRes", "COL_HEADER_NAME"), BundleManager.getString("DBSubRes", "COL_HEADER_STATUS"), BundleManager.getString("DBSubRes", "COL_HEADER_PRIMARY_DSDB"), BundleManager.getString("DBSubRes", "COL_HEADER_REPLICATE_DSDB")};
    }

    class AddDBSubItem
    extends BaseAddItem {
        public AddDBSubItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("DBSubRes", "ADD_DBSUB_ITEM"), RSMImages.getAddDBSub());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(DBSubWiz.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                DBSubWiz dBSubWiz = new DBSubWiz(DBSubFolder.this._ds, DBSubFolder.this._db, DBSubFolder.this._domainName, DBSubFolder.this._rs, this.getParent(), PluginSupport.getDialogSupport(jFrame));
                dBSubWiz.showDialog();
            }
        }
    }
}

