/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbsubscription;

import com.sybase.asa.ASACheckBox;
import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCHeader;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.dbsubscription.DBSub;
import com.sybase.rsmplugin.components.dbsubscription.DBSubProp;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RCLEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DBSubItem
extends BaseItem
implements RMItem,
StatusItem {
    private static final String CLASS_ID = "dbsubscription.DBSubContainer";
    private static final int CMD_VALIDATE = 3008;
    private static final int CMD_ACTIVATE = 3009;
    private static final int CMD_DIAGNOSE = 3010;
    private DBSub _so;
    private String _rs;
    private String _ds;
    private String _db;
    private static ImageIcon _icon = null;
    private static DefaultSCMenu _contextMenu = null;
    private SCHeader[] _headers = null;

    public DBSubItem(DBSub dBSub, BaseContainer baseContainer, String string, String string2, String string3) {
        super(baseContainer);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DB parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rs parameter.");
        Dbg.wassert(dBSub != null, "Null physical connection semantic object parameter.");
        this._so = dBSub;
        this._ds = string2;
        this._db = string3;
        this._rs = string;
        StatusManager.addStatusItem(this);
    }

    public DBSub getDBSub() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (_icon == null) {
            _icon = new ImageIcon(RSMImages.getDBSub());
        }
        return _icon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this._so.getReplicateStatus();
            }
            case 2: {
                return this._so.getPDSDB();
            }
            case 3: {
                return this._so.getRDSDB();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        _contextMenu = new DefaultSCMenu();
        String string = BundleManager.getString("DBSubRes", "MENU_ACTIVATE_DBSUB");
        String string2 = BundleManager.getString("DBSubRes", "MENU_HINT_ACTIVATE_DBSUB");
        char c = BundleManager.getMnemonic("DBSubRes", "MENU_MNEM_ACTIVATE_DBSUB");
        MenuItem menuItem = new MenuItem(3009, string, string2, c);
        _contextMenu.addItem((SCMenuItem)menuItem);
        if (this._so.isDefined()) {
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
        string = BundleManager.getString("DBSubRes", "MENU_VALIDATE_DBSUB");
        string2 = BundleManager.getString("DBSubRes", "MENU_HINT_VALIDATE_DBSUB");
        c = BundleManager.getMnemonic("DBSubRes", "MENU_MNEM_VALIDATE_DBSUB");
        menuItem = new MenuItem(3008, string, string2, c);
        _contextMenu.addItem((SCMenuItem)menuItem);
        if (this._so.isActive()) {
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
        _contextMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return _contextMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                ASACheckBox aSACheckBox = new ASACheckBox(BundleManager.getString("DBSubRes", "DELETE_PURGE"));
                aSACheckBox.setMnemonic(BundleManager.getMnemonic("DBSubRes", "DELETE_PURGE_MNEM"));
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list, (Component)aSACheckBox);
                if (deleteItemsDlg.showDialog()) {
                    ArrayList<DBSub> arrayList = new ArrayList<DBSub>();
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        BaseItem baseItem = (BaseItem)listIterator.next();
                        if (!(baseItem instanceof DBSubItem)) continue;
                        arrayList.add(((DBSubItem)baseItem).getDBSub());
                    }
                    if (arrayList.size() > 0) {
                        this.getDBSub().delete(arrayList, aSACheckBox.isSelected());
                    }
                }
                PluginSupport.refreshDomain(this);
                break;
            }
            case 3009: {
                if (PluginSupport.askQuestion(BundleManager.getString("DBSubRes", "CONFIRM_ACTIVATE"))) {
                    ArrayList<DBSub> arrayList = new ArrayList<DBSub>();
                    while (enumeration.hasMoreElements()) {
                        BaseItem baseItem = (BaseItem)enumeration.nextElement();
                        if (!(baseItem instanceof DBSubItem)) continue;
                        arrayList.add(((DBSubItem)baseItem).getDBSub());
                    }
                    if (arrayList.size() > 0) {
                        this.getDBSub().activate(arrayList);
                    }
                }
                PluginSupport.refreshDomain(this);
                break;
            }
            case 3008: {
                if (PluginSupport.askQuestion(BundleManager.getString("DBSubRes", "CONFIRM_VALIDATE"))) {
                    ArrayList<DBSub> arrayList = new ArrayList<DBSub>();
                    while (enumeration.hasMoreElements()) {
                        BaseItem baseItem = (BaseItem)enumeration.nextElement();
                        if (!(baseItem instanceof DBSubItem)) continue;
                        arrayList.add(((DBSubItem)baseItem).getDBSub());
                    }
                    if (arrayList.size() > 0) {
                        this.getDBSub().validate(arrayList);
                    }
                }
                PluginSupport.refreshDomain(this);
                break;
            }
            case 3010: {
                break;
            }
            case 100: 
            case 107: {
                BaseController baseController = PluginSupport.getDialog(DBSubProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                DBSubProp dBSubProp = new DBSubProp(this, sCDialogSupport2);
                dBSubProp.showDialog();
                break;
            }
            case 3001: {
                RCLEditor.open(this.getRCLScript());
            }
        }
    }

    @Override
    public void setState(int n) {
        this.getDBSub().setState(n);
    }

    @Override
    public void setReasons(List list) {
    }

    @Override
    public String getDomainName() {
        return this.getDBSub().getDomainName();
    }

    @Override
    public String getType() {
        return this.getDBSub().getType();
    }

    @Override
    public String getStateDescription() {
        return null;
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    public String getRCLScript() {
        String string = null;
        if (this._so.getbulkMethod().equalsIgnoreCase("Bulk Create")) {
            string = "-- Create Database Subscription " + this._so.getName() + "\n";
            string = string + "create subscription " + this._so.getName() + "\n";
            string = string + "\tfor database replication definition " + this._so.getRepDefName() + "\n";
            string = string + "\twith primary at " + this._so.getPDSDB() + "\n";
            string = string + "\twith replicate at " + this._so.getRDSDB() + "\n";
            string = string + "\twithout materialization\n";
            String string2 = this._so.getTruncateTable();
            if (string2.equalsIgnoreCase("yes")) {
                string = string + "\tsubscribe to truncate table";
            }
        } else {
            string = "-- Define Database Subscription " + this._so.getName() + "\n";
            string = string + "define subscription " + this._so.getName() + "\n";
            string = string + "\tfor database replication definition " + this._so.getRepDefName() + "\n";
            string = string + "\twith primary at " + this._so.getPDSDB() + "\n";
            string = string + "\twith replicate at " + this._so.getRDSDB() + "\n";
            String string3 = this._so.getTruncateTable();
            if (string3.equalsIgnoreCase("yes")) {
                string = string + "\tsubscribe to truncate table\n";
            }
            if (this._so.getbulkMethod().equalsIgnoreCase("Use Dump Marker")) {
                string = string + "\tuse dump marker";
            }
        }
        return string;
    }
}

