/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbsubscription;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDef;
import com.sybase.rsmplugin.components.dbsubscription.DBSub;
import com.sybase.rsmplugin.components.dbsubscription.DBSubWizSubPanel;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DBSubWiz
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected DBSub _dbSub = null;
    protected String _env = null;
    protected String _rs = null;
    protected String _ds = null;
    protected String _db = null;
    protected BaseContainer _container;
    protected String _name = null;
    protected String _repdef = null;
    protected String _priConn = null;
    protected boolean _subTrunc = false;
    protected String _subMethod = null;
    protected String _repConn = null;

    DBSubWiz(String string, String string2, String string3, String string4, BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication ds parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication db parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty domain environment name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(baseContainer != null, "Null or empty container parameter.");
        this._env = string3;
        this._rs = string4;
        this._container = baseContainer;
        this._ds = string;
        this._db = string2;
    }

    DBSub getDBSub() {
        Dbg.wassert(this._dbSub != null, "Null DBSub attribute.");
        return this._dbSub;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DBSubRes", "ADD_DBSUB_ITEM");
    }

    public String getDomainName() {
        return this._env;
    }

    public String getControllingRS() {
        return this._rs;
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new SubscriptionPage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        BaseItem baseItem = null;
        return baseItem;
    }

    @Override
    public void onApply() {
        super.onApply();
    }

    @Override
    public boolean onOk() {
        this.getDialogSupport().startWait();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        DBSub dBSub = semanticFactory.getDBSub(this._rs, this._repConn, this._priConn, this._name, this._repdef);
        dBSub.setbulkMethod(this._subMethod);
        if (this._subMethod.equalsIgnoreCase("Use Dump Marker")) {
            dBSub.setUseDumpMarkerCommand(this._subMethod);
        } else {
            dBSub.setUseDumpMarkerCommand("");
        }
        if (this._subTrunc) {
            dBSub.setTruncateTable("Yes");
        } else {
            dBSub.setTruncateTable("No");
        }
        try {
            dBSub.create();
        }
        catch (SQLException sQLException) {
            this.getDialogSupport().endWait();
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            return false;
        }
        PluginSupport.refreshDomain(this._container);
        this.getDialogSupport().endWait();
        return super.onOk();
    }

    class SubscriptionPage
    extends BasePropertyPage
    implements ActionListener,
    DocumentListener {
        private DBSubWizSubPanel _goPage;
        private List _connList;

        public SubscriptionPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DBSubRes", "GENERAL_PAGE_TAG"));
            this._goPage = new DBSubWizSubPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            SCDialogSupport2 sCDialogSupport2 = this.getDialogSupport();
            this.getDialogSupport();
            JButton jButton = sCDialogSupport2.getStandardButtonById(4);
            jButton.setVisible(false);
            jButton.setEnabled(false);
            this._goPage.fld_subName.setText("");
            this._goPage.fld_subName.requestFocus();
            try {
                this.loadConns();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._goPage.cbx_repConn.addItem((Object)(DBSubWiz.this._ds + "." + DBSubWiz.this._db));
            this._goPage.cbx_repConn.setEnabled(false);
            this._goPage.cbx_subMethod.addItem((Object)"Bulk");
            this._goPage.cbx_subMethod.addItem((Object)"Bulk Create");
            this._goPage.cbx_subMethod.addItem((Object)"Use Dump Marker");
            this._goPage.cbx_priConn.addActionListener((ActionListener)this);
            this._goPage.cbx_repdefName.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            String string = this._goPage.fld_subName.getText();
            if (string.length() <= 0 || string == null) {
                PluginSupport.showValidationError(this.getDialogSupport().getJDialog(), BundleManager.getString("DBSubRes", "BLANK_DBSUBNAME"));
                this._goPage.fld_subName.requestFocus();
                return false;
            }
            DBSubWiz.this._name = string;
            DBSubWiz.this._priConn = this._goPage.cbx_priConn.getSelectedString();
            Object object = this._goPage.cbx_repdefName.getSelectedItem();
            if (object == null) {
                PluginSupport.showValidationError(this.getDialogSupport().getJDialog(), BundleManager.getString("DBSubRes", "BLANK_DBREPDEF"));
                this._goPage.cbx_priConn.requestFocus();
                return false;
            }
            DBSubWiz.this._repdef = object.toString();
            DBSubWiz.this._subTrunc = this._goPage.chk_TruncTable.isSelected();
            Object object2 = this._goPage.cbx_subMethod.getSelectedItem();
            DBSubWiz.this._subMethod = object2.toString();
            DBSubWiz.this._repConn = this._goPage.cbx_repConn.getSelectedString();
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.cbx_priConn) {
                try {
                    Object object = this._goPage.cbx_priConn.getSelectedItem();
                    if (object != null) {
                        this.loadRepDefs();
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        protected void loadConns() throws SQLException {
            this._goPage.cbx_priConn.removeActionListener((ActionListener)this);
            this._goPage.cbx_priConn.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(DBSubWiz.this.getDomainName());
            if (semanticFactory != null) {
                this._connList = semanticFactory.getKnownPhyConnections(DBSubWiz.this.getControllingRS());
                ListIterator<LogConnection> listIterator = this._connList.listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    if (phyConnection.getDS().equals(DBSubWiz.this._ds) && phyConnection.getDB().equals(DBSubWiz.this._db)) {
                        listIterator.remove();
                        continue;
                    }
                    if (phyConnection.isRSSD()) {
                        listIterator.remove();
                        continue;
                    }
                    if (!phyConnection.isPrimary()) {
                        listIterator.remove();
                        continue;
                    }
                    if (phyConnection.isPartOfLogicalConnection()) {
                        LogConnection logConnection;
                        listIterator.remove();
                        if (!phyConnection.isStandby() || (logConnection = semanticFactory.getLogConnection(phyConnection.getControllingRS(), phyConnection.getLDS(), phyConnection.getLDB())).getLDS().equals(DBSubWiz.this._ds) && logConnection.getLDB().equals(DBSubWiz.this._db)) continue;
                        logConnection.load();
                        if (!logConnection.exists()) continue;
                        listIterator.add(logConnection);
                        this._goPage.cbx_priConn.addItem((Object)logConnection.getName());
                        continue;
                    }
                    this._goPage.cbx_priConn.addItem((Object)phyConnection.getName());
                }
            }
            this._goPage.cbx_priConn.addActionListener((ActionListener)this);
            this.loadRepDefs();
        }

        protected Object getSelectedConn() throws SQLException {
            Object var1_1 = null;
            int n = this._goPage.cbx_priConn.getSelectedIndex();
            if (n >= 0 && this._connList != null && this._connList.size() > n) {
                var1_1 = this._connList.get(n);
            }
            return var1_1;
        }

        protected void loadRepDefs() throws SQLException {
            Object object;
            this._goPage.cbx_repdefName.removeActionListener((ActionListener)this);
            this._goPage.cbx_repdefName.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(DBSubWiz.this.getDomainName());
            if (semanticFactory != null && (object = this.getSelectedConn()) != null) {
                String string = null;
                String string2 = null;
                String string3 = null;
                if (object instanceof PhyConnection) {
                    string = ((PhyConnection)object).getControllingRS();
                    string2 = ((PhyConnection)object).getDS();
                    string3 = ((PhyConnection)object).getDB();
                } else if (object instanceof LogConnection) {
                    string = ((LogConnection)object).getControllingRS();
                    string2 = ((LogConnection)object).getLDS();
                    string3 = ((LogConnection)object).getLDB();
                } else {
                    Dbg.wassert(false, "Unexpected connection type in connection list.");
                }
                if (string2 != null && string2.length() > 0) {
                    ListIterator listIterator = semanticFactory.getDBRepDefs(string, string2, string3).listIterator();
                    while (listIterator.hasNext()) {
                        DBRepDef dBRepDef = (DBRepDef)listIterator.next();
                        this._goPage.cbx_repdefName.addItem((Object)dBRepDef.getName());
                    }
                }
            }
            this._goPage.cbx_repdefName.addActionListener((ActionListener)this);
        }
    }
}

