/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.dbsubscription;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.DomainASE;
import com.sybase.rsmplugin.components.dbsubscription.DBSub;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainDBSub
implements DBSub {
    private static final int DB_SUB_DEFINED = 1;
    private static final int DB_SUB_ACTIVE = 2;
    private static final int DB_SUB_VALID = 3;
    private static final String DB_SUB_DEFINED_STR = "Defined";
    private static final String DB_SUB_ACTIVE_STR = "Active";
    private static final String DB_SUB_VALID_STR = "Valid";
    private static final String DB_SUB_UNKNOWN_STR = "Unknown";
    private EnvDomain _domain = null;
    private String _repServer = null;
    private String _dbsubName = null;
    private String _rdsdb = null;
    private String _rRS = null;
    private String _rrsStatus = null;
    private String _dbrepdefName = null;
    private String _pdsdb = null;
    private String _prsStatus = null;
    private String _createMethod = "";
    private String _truncateTable = "";
    private String _dumpMarker = "";
    private static final String GET_SUBS = "GET_SUBS";
    private static final String CREATE_SUB = "CREATE_SUB";
    private static final String DEFINE_SUB = "DEFINE_SUB";
    private static final String DROP_SUB = "DROP_SUB";
    private static final String ACTIVATE_SUB = "ACTIVATE_SUB";
    private static final String VALIDATE_SUB = "VALIDATE_SUB";
    private static final String CHECK_SUB = "CHECK_SUB";
    private static final Object[][] contents = new Object[][]{{"GET_SUBS", new Integer(1200), "rs_helpdbsub \"{0}\", {1}, {2}"}, {"CREATE_SUB", new Integer(1200), "create subscription \"{0}\" for database replication definition \"{1}\" with primary at {2} with replicate at {3} without materialization {4}"}, {"DEFINE_SUB", new Integer(1200), "define subscription \"{0}\" for database replication definition \"{1}\" with primary at {2} with replicate at {3} {4} {5}"}, {"DROP_SUB", new Integer(1200), "drop subscription \"{0}\" for database replication definition \"{1}\" with primary at {2} with replicate at {3} {4}"}, {"ACTIVATE_SUB", new Integer(1200), "activate subscription \"{0}\" for database replication definition \"{1}\" with primary at {2} with replicate at {3} "}, {"VALIDATE_SUB", new Integer(1200), "validate subscription \"{0}\" for database replication definition \"{1}\" with primary at {2} with replicate at {3} "}, {"CHECK_SUB", new Integer(1200), "check subscription \"{0}\" for database replication definition \"{1}\" with primary at {2} with replicate at {3} "}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainDBSub(String string, String string2, String string3, String string4, String string5, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rs parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DSDB parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DSDB parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._rdsdb = string2;
        this._pdsdb = string3;
        this._domain = envDomain;
        this._rRS = string;
        this._dbsubName = string4;
        this._dbrepdefName = string5;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRDSDB() {
        Dbg.wassert(this._rdsdb != null && this._rdsdb.length() > 0, "Null or empty data server name attribute.");
        return this._rdsdb;
    }

    @Override
    public String getPDSDB() {
        Dbg.wassert(this._pdsdb != null && this._pdsdb.length() > 0, "Null or empty data server name attribute.");
        return this._pdsdb;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._dbsubName != null && this._dbsubName.length() > 0, "Null or empty name attribute.");
        return this._dbsubName;
    }

    @Override
    public String getRepDefName() {
        Dbg.wassert(this._dbrepdefName != null && this._dbrepdefName.length() > 0, "Null or empty name attribute.");
        return this._dbrepdefName;
    }

    @Override
    public String getReplicateStatus() {
        Dbg.wassert(this._rrsStatus != null && this._rrsStatus.length() > 0, "Null or empty attribute.");
        return this._rrsStatus;
    }

    @Override
    public void setReplicateStatus(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty attribute.");
        this._rrsStatus = string;
    }

    @Override
    public void setTruncateTable(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty attribute.");
        this._truncateTable = string;
    }

    @Override
    public String getTruncateTable() {
        Dbg.wassert(this._truncateTable != null && this._truncateTable.length() > 0, "Null or empty attribute.");
        return this._truncateTable;
    }

    public String getTruncateTableCommand() {
        Dbg.wassert(this._truncateTable != null && this._truncateTable.length() > 0, "Null or empty attribute.");
        if (this._truncateTable.equalsIgnoreCase("yes")) {
            return "subscribe to truncate table";
        }
        return "";
    }

    @Override
    public String getUseDumpMarkerCommand() {
        return this._dumpMarker;
    }

    @Override
    public void setUseDumpMarkerCommand(String string) {
        this._dumpMarker = string;
    }

    public String getControllingRS() {
        Dbg.wassert(this._rRS != null && this._rRS.length() > 0, "Null or empty RS name attribute.");
        return this._rRS;
    }

    @Override
    public String getPrimaryStatus() {
        Dbg.wassert(this._prsStatus != null && this._prsStatus.length() > 0, "Null or empty attribute.");
        return this._prsStatus;
    }

    public void setPrimaryStatus(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty attribute.");
        this._prsStatus = string;
    }

    @Override
    public String getbulkMethod() {
        Dbg.wassert(this._createMethod != null && this._createMethod.length() > 0, "Null or empty attribute.");
        return this._createMethod;
    }

    @Override
    public void setbulkMethod(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty attribute.");
        this._createMethod = string;
    }

    @Override
    public void setState(int n) {
        switch (n) {
            case 1: {
                this.setReplicateStatus(DB_SUB_DEFINED_STR);
                break;
            }
            case 2: {
                this.setReplicateStatus(DB_SUB_ACTIVE_STR);
                break;
            }
            case 3: {
                this.setReplicateStatus(DB_SUB_VALID_STR);
                break;
            }
            default: {
                this.setReplicateStatus(DB_SUB_UNKNOWN_STR);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.getReplicateStatus().equalsIgnoreCase(DB_SUB_ACTIVE_STR);
    }

    @Override
    public boolean isDefined() {
        return this.getReplicateStatus().equalsIgnoreCase(DB_SUB_DEFINED_STR);
    }

    @Override
    public boolean isValid() {
        return this.getReplicateStatus().equalsIgnoreCase(DB_SUB_VALID_STR);
    }

    @Override
    public void delete(final List list, final boolean bl) {
        if (list != null && list.size() > 0) {
            DomainDBSub domainDBSub = (DomainDBSub)list.get(0);
            String string = domainDBSub.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("DBSubRes", "DELETE_BKGND_TITLE", string), this.getDomainName(), false){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    try {
                        DomainDBSub domainDBSub;
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            domainDBSub = (DomainDBSub)listIterator.next();
                            this.setStatus(BundleManager.getString("DBSubRes", "DELETE_BKGND_TITLE", domainDBSub.getName()));
                            arrayList.add(domainDBSub.getName());
                            domainDBSub.drop(bl);
                        }
                        this.setStatus(BundleManager.getString("DBSubRes", "DELETE_MONITORING"));
                        while (!1.interrupted() && list.size() > 0) {
                            Thread.sleep(2000L);
                            listIterator = list.listIterator();
                            while (!1.interrupted() && listIterator.hasNext()) {
                                domainDBSub = (DomainDBSub)listIterator.next();
                                String string = domainDBSub.getRDSDB();
                                int n = string.indexOf(".");
                                String string2 = string.substring(0, n);
                                String string3 = string.substring(n + 1);
                                DomainDBSub domainDBSub2 = DomainDBSub.getDBSub(domainDBSub.getControllingRS(), domainDBSub.getDomain(), domainDBSub.getName(), string2, string3);
                                if (domainDBSub2 != null) continue;
                                StatusManager.delete(domainDBSub.getDomainName(), domainDBSub.getType(), domainDBSub.getName());
                                listIterator.remove();
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("DBSubRes", "DELETE_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean drop(boolean bl) throws SQLException {
        boolean bl2 = false;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            String string = "";
            if (!bl) {
                string = " without purge ";
            }
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getName(), this.getRepDefName(), this.getPDSDB(), this.getRDSDB(), string};
            String string2 = _cmdBundle.getCommand(DROP_SUB, n, objectArray);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDBSubs(String string, EnvDomain envDomain, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        int n = envDomain.getVersionNumber(string);
        Object[] objectArray = new String[]{"%", string2, string3};
        String string4 = _cmdBundle.getCommand(GET_SUBS, n, objectArray);
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty command string.");
        ArrayList<DomainDBSub> arrayList = new ArrayList<DomainDBSub>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(1);
                    if (string5 == null || string5.length() <= 0) continue;
                    String string6 = rSMResultSet.getColumnString(2);
                    String string7 = rSMResultSet.getColumnString(3);
                    String string8 = rSMResultSet.getColumnString(4);
                    String string9 = rSMResultSet.getColumnString(5);
                    String string10 = rSMResultSet.getColumnString(6);
                    String string11 = rSMResultSet.getColumnString(7);
                    String string12 = rSMResultSet.getColumnString(8);
                    String string13 = rSMResultSet.getColumnString(9);
                    String string14 = rSMResultSet.getColumnString(10);
                    String string15 = rSMResultSet.getColumnString(11);
                    DomainDBSub domainDBSub = new DomainDBSub(string7, string6, string10, string5, string9, envDomain);
                    domainDBSub.setReplicateStatus(string8);
                    domainDBSub.setPrimaryStatus(string12);
                    domainDBSub.setTruncateTable(string14);
                    domainDBSub.setbulkMethod(string13);
                    arrayList.add(domainDBSub);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainDBSub getDBSub(String string, EnvDomain envDomain, String string2, String string3, String string4) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty subscription parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty database parameter.");
        int n = envDomain.getVersionNumber(string);
        Object[] objectArray = new String[]{string2, string3, string4};
        String string5 = _cmdBundle.getCommand(GET_SUBS, n, objectArray);
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty query command string.");
        DomainDBSub domainDBSub = null;
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                String string6;
                rSMResultSet.open(string5);
                if (rSMResultSet.getNextRow() && (string6 = rSMResultSet.getColumnString(1)) != null && string6.length() > 0) {
                    String string7 = rSMResultSet.getColumnString(2);
                    String string8 = rSMResultSet.getColumnString(3);
                    String string9 = rSMResultSet.getColumnString(4);
                    String string10 = rSMResultSet.getColumnString(5);
                    String string11 = rSMResultSet.getColumnString(6);
                    String string12 = rSMResultSet.getColumnString(7);
                    String string13 = rSMResultSet.getColumnString(8);
                    String string14 = rSMResultSet.getColumnString(9);
                    String string15 = rSMResultSet.getColumnString(10);
                    String string16 = rSMResultSet.getColumnString(11);
                    domainDBSub = new DomainDBSub(string8, string7, string11, string6, string10, envDomain);
                    domainDBSub.setReplicateStatus(string9);
                    domainDBSub.setPrimaryStatus(string13);
                    domainDBSub.setTruncateTable(string15);
                    domainDBSub.setbulkMethod(string14);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return domainDBSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws SQLException {
        Object object;
        int n;
        String string;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            string = null;
            n = rSMConnection.getVersionNumber();
            if (this._createMethod.equalsIgnoreCase("Bulk Create")) {
                object = new String[]{this.getName(), this.getRepDefName(), this.getPDSDB(), this.getRDSDB(), this.getTruncateTableCommand()};
                string = _cmdBundle.getCommand(CREATE_SUB, n, (Object[])object);
                Dbg.wassert(string != null, "Unable to get Create DBSub command.");
            } else {
                object = new String[]{this.getName(), this.getRepDefName(), this.getPDSDB(), this.getRDSDB(), this.getTruncateTableCommand(), this.getUseDumpMarkerCommand()};
                string = _cmdBundle.getCommand(DEFINE_SUB, n, (Object[])object);
                Dbg.wassert(string != null, "Unable to get Define DBSub command.");
            }
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("DBSubRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        string = this.getRDSDB();
        n = string.indexOf(".");
        object = string.substring(0, n);
        String string2 = string.substring(n + 1);
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        DomainASE domainASE = (DomainASE)semanticFactory.getASE((String)object);
        Dbg.wassert(domainASE != null, "Cannot retrieve ASESO for ASE: " + (String)object);
        LogConnection logConnection = semanticFactory.getLogConnection(this._rRS, (String)object, string2);
        logConnection.load();
        if (!logConnection.exists() && !string2.equalsIgnoreCase("master")) {
            domainASE.setDBOption(string2);
        }
        if (this._createMethod.equalsIgnoreCase("Bulk Create")) {
            this.monitorValidate();
        }
    }

    protected void monitorValidate() {
        final String string = this.getName();
        BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("DBSubRes", "VALIDATE_BKGND_TITLE", string), this.getDomainName(), false){

            @Override
            public void run() {
                try {
                    this.setStatus(BundleManager.getString("DBSubRes", "VALIDATE_MONITORING"));
                    boolean bl = false;
                    while (!2.interrupted() && !bl) {
                        Thread.sleep(2000L);
                        String string4 = DomainDBSub.this.getRDSDB();
                        int n = string4.indexOf(".");
                        String string2 = string4.substring(0, n);
                        String string3 = string4.substring(n + 1);
                        DomainDBSub domainDBSub = DomainDBSub.getDBSub(DomainDBSub.this.getControllingRS(), DomainDBSub.this.getDomain(), string, string2, string3);
                        if (domainDBSub == null) {
                            bl = true;
                            continue;
                        }
                        if (!domainDBSub.isValid()) continue;
                        StatusManager.redisplay(this.getDomainName(), DomainDBSub.this.getType(), string, 3, new ArrayList());
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    this.setError(true);
                    this.setStatus(MessageText.formatExceptionMessage(sQLException));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.close();
            }
        };
        bkgndThread.start();
    }

    @Override
    public void activate(final List list) {
        if (list != null && list.size() > 0) {
            DomainDBSub domainDBSub = (DomainDBSub)list.get(0);
            String string = domainDBSub.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("DBSubRes", "ACTIVATE_BKGND_TITLE", string), this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        DomainDBSub domainDBSub;
                        ListIterator listIterator = list.listIterator();
                        while (!3.interrupted() && listIterator.hasNext()) {
                            domainDBSub = (DomainDBSub)listIterator.next();
                            this.setStatus(BundleManager.getString("DBSubRes", "ACTIVATE_BKGND_TITLE", domainDBSub.getName()));
                            domainDBSub.activate();
                        }
                        this.setStatus(BundleManager.getString("DBSubRes", "ACTIVATE_MONITORING"));
                        while (!3.interrupted() && list.size() > 0) {
                            Thread.sleep(2000L);
                            listIterator = list.listIterator();
                            while (!3.interrupted() && listIterator.hasNext()) {
                                domainDBSub = (DomainDBSub)listIterator.next();
                                String string = domainDBSub.getRDSDB();
                                int n = string.indexOf(".");
                                String string2 = string.substring(0, n);
                                String string3 = string.substring(n + 1);
                                DomainDBSub domainDBSub2 = DomainDBSub.getDBSub(domainDBSub.getControllingRS(), domainDBSub.getDomain(), domainDBSub.getName(), string2, string3);
                                if (domainDBSub2 == null) {
                                    listIterator.remove();
                                    continue;
                                }
                                if (!domainDBSub2.isActive()) continue;
                                StatusManager.redisplay(domainDBSub2.getDomainName(), domainDBSub2.getType(), domainDBSub2.getName(), 2, new ArrayList());
                                listIterator.remove();
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            String string = null;
            int n = this.getDomain().getVersionNumber(this.getControllingRS());
            Object[] objectArray = new String[]{this.getName(), this.getRepDefName(), this.getPDSDB(), this.getRDSDB()};
            string = _cmdBundle.getCommand(ACTIVATE_SUB, n, objectArray);
            Dbg.wassert(string != null, "Unable to get ACTIVATE DBSub command.");
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("DBSubRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void validate(final List list) {
        if (list != null && list.size() > 0) {
            DomainDBSub domainDBSub = (DomainDBSub)list.get(0);
            String string = domainDBSub.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("DBSubRes", "VALIDATE_BKGND_TITLE", string), this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        DomainDBSub domainDBSub;
                        ListIterator listIterator = list.listIterator();
                        while (!4.interrupted() && listIterator.hasNext()) {
                            domainDBSub = (DomainDBSub)listIterator.next();
                            this.setStatus(BundleManager.getString("DBSubRes", "VALIDATE_BKGND_TITLE", domainDBSub.getName()));
                            domainDBSub.validate();
                        }
                        this.setStatus(BundleManager.getString("DBSubRes", "VALIDATE_MONITORING"));
                        while (!4.interrupted() && list.size() > 0) {
                            Thread.sleep(2000L);
                            listIterator = list.listIterator();
                            while (!4.interrupted() && listIterator.hasNext()) {
                                domainDBSub = (DomainDBSub)listIterator.next();
                                String string = domainDBSub.getRDSDB();
                                int n = string.indexOf(".");
                                String string2 = string.substring(0, n);
                                String string3 = string.substring(n + 1);
                                DomainDBSub domainDBSub2 = DomainDBSub.getDBSub(domainDBSub.getControllingRS(), domainDBSub.getDomain(), domainDBSub.getName(), string2, string3);
                                if (domainDBSub2 == null) {
                                    listIterator.remove();
                                    continue;
                                }
                                if (!domainDBSub2.isValid()) continue;
                                StatusManager.redisplay(domainDBSub2.getDomainName(), domainDBSub2.getType(), domainDBSub2.getName(), 3, new ArrayList());
                                listIterator.remove();
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            String string = null;
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getName(), this.getRepDefName(), this.getPDSDB(), this.getRDSDB()};
            string = _cmdBundle.getCommand(VALIDATE_SUB, n, objectArray);
            Dbg.wassert(string != null, "Unable to get VALIDATE DBSub command.");
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("DBSubRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }
}

