/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.directconnect;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ServerComponent;
import com.sybase.rsmplugin.components.connection.ConnectionItem;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.components.directconnect.DirectConnectProp;
import com.sybase.rsmplugin.components.events.EventDetailContainer;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DirectConnectContainer
extends BaseContainer
implements RMContainer,
ServerComponent,
StatusItem {
    private static final String CLASS_ID = "directconnect.DirectConnectContainer";
    private static final int CMD_SQL_EDITOR = 3008;
    private DirectConnect _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;

    public DirectConnectContainer(DirectConnect directConnect, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(directConnect != null, "Null DirectConnect Semantic object parameter.");
        this._so = directConnect;
        StatusManager.addStatusItem(this);
    }

    public DirectConnectContainer(DirectConnect directConnect) {
        Dbg.wassert(directConnect != null, "Null DirectConnect Semantic object parameter.");
        this._so = directConnect;
        StatusManager.addStatusItem(this);
    }

    public DirectConnect getDirectConnect() {
        return this._so;
    }

    @Override
    public void drop() {
        this.getDirectConnect().drop();
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getDirectConnectUp());
        }
        return _iconUp;
    }

    @Override
    public void setState(int n) {
        this.getDirectConnect().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getDirectConnect().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getDirectConnect().getDomainName();
    }

    @Override
    public String getType() {
        return this.getDirectConnect().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getDirectConnect().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getDirectConnectUp());
            }
            return _iconUp;
        }
        if (this.getDirectConnect().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getDirectConnectDown());
            }
            return _iconDown;
        }
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getDirectConnectSuspect());
        }
        return _iconSuspect;
    }

    @Override
    public int getAttributes() {
        if (!this.getDirectConnect().isError()) {
            return 1;
        }
        return super.getAttributes();
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getDirectConnect().getName();
            }
            case 1: {
                return this.getDirectConnect().getStateString();
            }
            case 2: {
                return this.getDirectConnect().getReason();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getDirectConnect().isError()) {
            return 32;
        }
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof ServerComponent)) continue;
                    ((ServerComponent)((Object)baseItem)).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(DirectConnectProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                DirectConnectProp directConnectProp = new DirectConnectProp(this.getDirectConnect(), this, sCDialogSupport2);
                directConnectProp.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDirectConnect().getDomainName());
            try {
                ListIterator listIterator = semanticFactory.getPhyConnectionsForDirectConnect(this.getName()).listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    ConnectionItem connectionItem = new ConnectionItem(phyConnection, this);
                    this.addItem((SCItem)connectionItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        String string = this.getParent().getName();
        if (this.getDirectConnect().isControlledByRSMS()) {
            SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
            SCViewerDetailsPanel2 sCViewerDetailsPanel22 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", (SCDetailsContainer)new EventDetailContainer(BundleManager.getString("EventsRes", "EVENT_TAB"), string, this.getName(), this));
            sCViewerDetailsPanel22.setPanelName(sCViewerDetailsPanel22.getSCDetailsContainer().getDisplayName());
            Object[] objectArray = new Object[]{sCViewerDetailsPanel2, sCViewerDetailsPanel22};
            return objectArray;
        }
        SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
        Object[] objectArray = new Object[]{sCViewerDetailsPanel2};
        return objectArray;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("ConnectionRes", "COL_HEADER_CONN"), BundleManager.getString("ConnectionRes", "COL_HEADER_RA_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_DSI_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_REASON")};
    }
}

