/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.directconnect;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.CommPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.components.directconnect.DirectConnectPropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;

public class DirectConnectProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected DirectConnect _directConnect;
    protected BaseItem _item;

    DirectConnectProp(DirectConnect directConnect, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(directConnect != null, "Null DirectConnect parameter.");
        this._directConnect = directConnect;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(directConnect.getDomainName());
        try {
            this._directConnect.loadProperties();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    DirectConnect getDirectConnect() {
        return this._directConnect;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DirectConnectRes", "PROPERTIES_TITLE", this.getDirectConnect().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new CommPage((BaseProperties)this, this.getDirectConnect())};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        return super.onOk();
    }

    @Override
    public void onApply() {
        super.onApply();
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private DirectConnectPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DirectConnectRes", "GENERAL_PAGE_TAG"));
            this._goPage = new DirectConnectPropGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(DirectConnectProp.this.getDirectConnect().getName());
            this._goPage.fld_version.setText(DirectConnectProp.this.getDirectConnect().getVersionString());
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(DirectConnectProp.this.getDirectConnect().getStateString());
            this._goPage.fld_reason.setText(DirectConnectProp.this.getDirectConnect().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(DirectConnectProp.this.getDirectConnect().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onOk() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), DirectConnectProp.this.getDirectConnect().getReasons(), DirectConnectProp.this.getDirectConnect().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }
    }
}

