/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.directconnect;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.DCConnection;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DomainDirectConnect
extends EnvServerStatusSO
implements DirectConnect,
Comparable {
    private static final String DC_VERSION = "DC_VERSION";
    private static final Object[][] contents = new Object[][]{{"DC_VERSION", new Integer(1260), "select @@version"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainDirectConnect(String string, EnvDomain envDomain) {
        super(string, envDomain);
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DomainDirectConnect) {
            return this.getName().compareTo(((DomainDirectConnect)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainDirectConnect object.");
        return -1;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public static DirectConnect getDirectConnect(String string, EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        DirectConnect directConnect = null;
        List list = DomainDirectConnect.getDirectConnects(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && directConnect == null) {
                DirectConnect directConnect2 = (DirectConnect)listIterator.next();
                if (!directConnect2.getName().equals(string)) continue;
                directConnect = directConnect2;
            }
        }
        return directConnect;
    }

    public static List getDirectConnects(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList<DomainDirectConnect> arrayList = new ArrayList<DomainDirectConnect>();
        ListIterator listIterator = envDomain.getDirectConnectServerNames().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            DomainDirectConnect domainDirectConnect = new DomainDirectConnect(string, envDomain);
            arrayList.add(domainDirectConnect);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDCState(DCConnection dCConnection) throws SQLException {
        int n = 0;
        try {
            dCConnection.open();
            n = 5;
        }
        catch (SQLException sQLException) {
            n = dCConnection.getState() == 3 ? 1 : 0;
        }
        finally {
            dCConnection.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        this.clearReasons();
        DCConnection dCConnection = (DCConnection)this.getDomain().getConnection(this.getName());
        if (dCConnection != null) {
            int n = 0;
            try {
                dCConnection.open();
                n = dCConnection.getState();
            }
            catch (SQLException sQLException) {
                n = dCConnection.getState();
            }
            finally {
                dCConnection.unlock();
            }
            switch (n) {
                case 1: {
                    try {
                        int n2 = this.getDCState(dCConnection);
                        this.setState(n2);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
                case 3: {
                    this.setState(1);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
            String string = dCConnection.getReason();
            if (string != null && string.length() > 0) {
                this.addReason(string);
            }
        } else {
            this.setState(3);
            return;
        }
    }

    @Override
    public String getVersionString() {
        String string = "";
        DCConnection dCConnection = (DCConnection)this.getDomain().getConnection(this.getName());
        if (dCConnection != null) {
            string = dCConnection.getVersionString();
            dCConnection.unlock();
        }
        return string;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("DirectConnectRes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("DirectConnectRes", "DOWN_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("DirectConnectRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("DirectConnectRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected DirectConnect State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        this.alter(string, string2, string3, string4, string5, string6, "DirectConnect");
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        ConnAttributes connAttributes = new ConnAttributes();
        connAttributes.setServer(this.getName());
        connAttributes.setType("DirectConnect");
        connAttributes.setUser(string);
        connAttributes.setPassword(string2);
        connAttributes.setCharset(string3);
        connAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
            connAttributes.setHost(string5);
            connAttributes.setPort(string6);
            connAttributes.setSaveAddress(true);
        } else {
            connAttributes.setHost("");
            connAttributes.setPort("");
            connAttributes.setSaveAddress(false);
        }
        DCConnection dCConnection = new DCConnection(connAttributes);
        try {
            dCConnection.open();
        }
        finally {
            if (dCConnection != null) {
                dCConnection.close();
            }
        }
    }
}

