/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.directconnect;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.RMSServerStatusSO;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RMSDirectConnect
extends RMSServerStatusSO
implements DirectConnect,
Comparable {
    protected String _lastMonitored = null;
    protected String _monitoredBy = null;
    protected String _versionString = null;
    private static final String GET_DIRECTCONNECTS = "GET_DIRECTCONNECTS";
    private static final String GET_DIRECTCONNECT = "GET_DIRECTCONNECT";
    private static final Object[][] contents = new Object[][]{{"GET_DIRECTCONNECTS", new Integer(1500), "get servers DirectConnect"}, {"GET_DIRECTCONNECT", new Integer(1260), "get servers {0}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSDirectConnect(String string, RMSDomain rMSDomain) {
        super(string, rMSDomain);
        this.setState(3);
        this.clearReasons();
    }

    public int compareTo(Object object) {
        if (object instanceof RMSDirectConnect) {
            return this.getName().compareTo(((RMSDirectConnect)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-RMSDirectConnect object.");
        return -1;
    }

    @Override
    public String getServerType() {
        return "DirectConnect Service";
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "DirectConnect";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectConnect getDirectConnect(String string, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        RMSDirectConnect rMSDirectConnect = null;
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_DIRECTCONNECT, n, string);
            Dbg.wassert(string2 != null, "Unable to get server command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (string3 != null && string3.equals(string) && string4 != null && string4.equalsIgnoreCase("DirectConnect")) {
                        rMSDirectConnect = new RMSDirectConnect(string, rMSDomain);
                        rMSDirectConnect._lastMonitored = rSMResultSet.getColumnString(3);
                        rMSDirectConnect._versionString = rSMResultSet.getColumnString(4);
                        rMSDirectConnect.setState(rSMResultSet.getColumnInt(5));
                        String string5 = rSMResultSet.getColumnString(7);
                        if (string5 != null && string5.length() > 0) {
                            rMSDirectConnect.addReason(string5);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return rMSDirectConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDirectConnects(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<RMSDirectConnect> arrayList = new ArrayList<RMSDirectConnect>(1);
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_DIRECTCONNECTS, n);
            Dbg.wassert(string != null, "Unable to get mirror rep agent command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    RMSDirectConnect rMSDirectConnect = new RMSDirectConnect(string2, rMSDomain);
                    String string3 = rSMResultSet.getColumnString(2);
                    if (!string3.equalsIgnoreCase(rMSDirectConnect.getRMSType())) continue;
                    rMSDirectConnect._lastMonitored = rSMResultSet.getColumnString(3);
                    rMSDirectConnect._versionString = rSMResultSet.getColumnString(4);
                    rMSDirectConnect.setState(rSMResultSet.getColumnInt(5));
                    String string4 = rSMResultSet.getColumnString(7);
                    if (string4 != null && string4.length() > 0) {
                        rMSDirectConnect.addReason(string4);
                    }
                    arrayList.add(rMSDirectConnect);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public String getVersionString() {
        return this._versionString != null ? this._versionString : "";
    }

    @Override
    public String getLastMonitoredDate() {
        return this._lastMonitored != null ? this._lastMonitored : "";
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("DirectConnectRes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("DirectConnectRes", "DOWN_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("DirectConnectRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("DirectConnectRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }
}

