/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.domain;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.domain.AddWizHDSNamePanel;
import com.sybase.rsmplugin.components.domain.AddWizHDSTypePanel;
import com.sybase.rsmplugin.components.domain.ConnectWizNamePanel;
import com.sybase.rsmplugin.components.domain.ConnectWizTypePanel;
import com.sybase.rsmplugin.components.domain.ConnectWizUserPanel;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.ConnectionManager;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.HDSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.ServerInterfaces;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddServerWizard
extends BaseWizard {
    protected ConnAttributes _connAtt = null;
    protected Domain _domain;
    protected SCPageController[] _pages = null;
    protected int _summaryPageIdx = 0;

    public AddServerWizard(SCDialogSupport2 sCDialogSupport2, Domain domain) {
        super(sCDialogSupport2);
        Dbg.wassert(domain != null, "Null domain parameter.");
        this._domain = domain;
    }

    public List getAttributes() {
        ArrayList<ConnAttributes> arrayList = new ArrayList<ConnAttributes>();
        arrayList.add(this._connAtt);
        if (this._connAtt instanceof HDSConnAttributes) {
            ConnAttributes connAttributes = ((HDSConnAttributes)this._connAtt).getInterface();
            if (!this.getDomain().isPartofDomain(connAttributes.getServer()) && !connAttributes.getType().equals("DirectConnect")) {
                arrayList.add(connAttributes);
            }
        }
        return arrayList;
    }

    public String getDomainName() {
        return this._domain.getName();
    }

    public Domain getDomain() {
        return this._domain;
    }

    public boolean showModalDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(true);
        this.getDialogSupport().setModal(true);
        this.getDialogSupport().setHelpButton(false);
        PluginSupport.registerDialog(this);
        return this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "CONNECT_WIZ_TITLE");
    }

    @Override
    public boolean onWizardFinish() {
        super.onWizardFinish();
        return true;
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new TypePage(this), new HDSTypePage(this), new NamePage(this), new UserPage(this), new RSSDNamePage(this), new RSSDUserPage(this), new HDSNamePage(this), new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    return AddServerWizard.this._connAtt.toFormattedString();
                }
            }};
            this._summaryPageIdx = this._pages.length;
        }
        return this._pages;
    }

    class HDSNamePage
    extends BaseWizardPage
    implements DocumentListener {
        private AddWizHDSNamePanel _goPage;

        public HDSNamePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "ADD_WIZ_HDS_NAME_TITLE"));
            this._goPage = new AddWizHDSNamePanel();
            this._goPage.fld_name.requestFocus();
            this._goPage.fld_name.getDocument().addDocumentListener(this);
            this._goPage.fld_db.getDocument().addDocumentListener(this);
            this.setPreferredWidth();
        }

        @Override
        public boolean onSetActive() {
            ConnAttributes connAttributes;
            if (AddServerWizard.this._connAtt instanceof HDSConnAttributes && (connAttributes = ((HDSConnAttributes)AddServerWizard.this._connAtt).getInterface()).getType().equalsIgnoreCase("DirectConnect")) {
                this._goPage.fld_name.setText(connAttributes.getServer());
                this._goPage.fld_name.setEnabled(false);
            }
            boolean bl = !AddServerWizard.this._connAtt.getType().equalsIgnoreCase("MSSS");
            this._goPage.txt_db_desc.setVisible(bl);
            this._goPage.lbl_db.setVisible(bl);
            this._goPage.fld_db.setVisible(bl);
            this._goPage.fld_db.setEnabled(bl);
            this.enableBackButton(true);
            this.setNextButton();
            this._goPage.fld_name.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            int n = -1;
            String string = this._goPage.fld_name.getText();
            if (AddServerWizard.this.getDomain().isPartofDomain(string)) {
                PluginSupport.showError(this.getDialogSupport().getParentWindow(), BundleManager.getString("DomainRes", "ADD_SERVER_DUPLICATE", string), null);
            } else {
                AddServerWizard.this._connAtt.setServer(string);
                if (!AddServerWizard.this._connAtt.getType().equalsIgnoreCase("MSSS")) {
                    ((HDSConnAttributes)AddServerWizard.this._connAtt).setDatabase(this._goPage.fld_db.getText());
                }
                n = 0;
            }
            return n;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        protected void setNextButton() {
            String string = this._goPage.fld_name.getText();
            String string2 = this._goPage.fld_db.getText();
            if (this._goPage.fld_db.isEnabled()) {
                this.enableNextButton(string != null && string.length() > 0 && string2 != null && string2.length() > 0);
            } else {
                this.enableNextButton(string != null && string.length() > 0);
            }
        }
    }

    class RSSDUserPage
    extends BaseWizardPage
    implements DocumentListener {
        private ConnectWizUserPanel _goPage;

        public RSSDUserPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "CONNECT_WIZ_RSSD_USER_TITLE"));
            this._goPage = new ConnectWizUserPanel();
            this.setPreferredWidth();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "CONNECT_WIZ_RSSD_USER_DESC"));
            this._goPage.fld_username.getDocument().addDocumentListener(this);
        }

        @Override
        public boolean onSetActive() {
            this.enableBackButton(true);
            this._goPage.fld_username.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            Dbg.wassert(AddServerWizard.this._connAtt instanceof RSConnAttributes, "ConnAttribute object should be a RSConnAttrbute.");
            ConnAttributes connAttributes = ((RSConnAttributes)AddServerWizard.this._connAtt).getRSSD();
            connAttributes.setUser(this._goPage.fld_username.getText());
            connAttributes.setPassword(this._goPage.fld_password.getPasswordString());
            connAttributes.setCharset(this._goPage.cbx_charset.getSelection());
            connAttributes.setLanguage(this._goPage.cbx_language.getSelection());
            return AddServerWizard.this._summaryPageIdx;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        protected void setNextButton() {
            String string = this._goPage.fld_username.getText();
            if (string != null && string.length() > 0) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class RSSDNamePage
    extends BaseWizardPage
    implements ChangeListener,
    DocumentListener {
        private ConnectWizNamePanel _goPage;

        public RSSDNamePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "CONNECT_WIZ_RSSD_NAME_TITLE"));
            this._goPage = new ConnectWizNamePanel();
            this.setPreferredWidth();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "CONNECT_WIZ_RSSD_NAME_DESC"));
            this._goPage.fld_name.getDocument().addDocumentListener(this);
            this._goPage.fld_host.getDocument().addDocumentListener(this);
            this._goPage.fld_port.getDocument().addDocumentListener(this);
            this._goPage.rbn_select.addChangeListener((ChangeListener)this);
            this._goPage.rbn_manual.addChangeListener((ChangeListener)this);
        }

        @Override
        public boolean onSetActive() {
            this.enableBackButton(true);
            Dbg.wassert(AddServerWizard.this._connAtt instanceof RSConnAttributes, "ConnAttribute object should be a RSConnAttrbute.");
            ConnAttributes connAttributes = ((RSConnAttributes)AddServerWizard.this._connAtt).getRSSD();
            String string = connAttributes.getServer();
            this.loadServers();
            if (this._goPage.cbx_servers.getItemCount() > 0) {
                if (string != null && string.length() > 0) {
                    int n = this._goPage.cbx_servers.findItem(string);
                    if (n > 0) {
                        this._goPage.rbn_select.setSelected(true);
                        this._goPage.rbn_select.requestFocus();
                        this._goPage.cbx_servers.setSelectedIndex(n);
                    } else {
                        this._goPage.rbn_manual.setSelected(true);
                        this._goPage.rbn_manual.requestFocus();
                    }
                    this._goPage.fld_name.setText(string);
                } else {
                    this._goPage.rbn_select.setSelected(true);
                    this._goPage.rbn_select.requestFocus();
                }
            } else {
                this._goPage.rbn_manual.setSelected(true);
                this._goPage.rbn_manual.requestFocus();
                if (string != null && string.length() > 0) {
                    this._goPage.fld_name.setText(string);
                }
            }
            this.enableControls();
            this.setNextButton();
            return true;
        }

        protected void loadServers() {
            try {
                ListIterator listIterator = AddServerWizard.this.getDomain().getAvailableServers().listIterator();
                while (listIterator.hasNext()) {
                    String string = listIterator.next().toString();
                    this._goPage.cbx_servers.addItem((Object)string);
                }
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            Dbg.wassert(AddServerWizard.this._connAtt instanceof RSConnAttributes, "ConnAttribute object should be a RSConnAttrbute.");
            ConnAttributes connAttributes = ((RSConnAttributes)AddServerWizard.this._connAtt).getRSSD();
            if (this._goPage.rbn_select.isSelected()) {
                try {
                    ServerInterfaces serverInterfaces = new ServerInterfaces();
                    String string = this._goPage.cbx_servers.getSelectedString();
                    Dbg.wassert(string != null && string.length() > 0, "Null or empty server selection.");
                    connAttributes.setServer(string);
                    connAttributes.setHost(serverInterfaces.getHostName(string));
                    connAttributes.setPort(serverInterfaces.getPortNumber(string));
                    connAttributes.setSaveAddress(false);
                }
                catch (Exception exception) {
                    PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
                }
            } else {
                connAttributes.setServer(this._goPage.fld_name.getText());
                connAttributes.setHost(this._goPage.fld_host.getText());
                connAttributes.setPort(this._goPage.fld_port.getText());
                connAttributes.setSaveAddress(true);
            }
            return 0;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.enableControls();
            this.setNextButton();
        }

        protected void enableControls() {
            this._goPage.lbl_name.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.fld_name.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.lbl_host.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.fld_host.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.lbl_port.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.fld_port.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.lbl_servers.setEnabled(this._goPage.rbn_select.isSelected());
            this._goPage.cbx_servers.setEnabled(this._goPage.rbn_select.isSelected());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        protected void setNextButton() {
            if (this._goPage.rbn_select.isSelected()) {
                String string = this._goPage.cbx_servers.getSelectedString();
                this.enableNextButton(string != null && string.length() > 0);
            } else {
                String string = this._goPage.fld_name.getText();
                String string2 = this._goPage.fld_host.getText();
                String string3 = this._goPage.fld_port.getText();
                this.enableNextButton(string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0);
            }
        }
    }

    class UserPage
    extends BaseWizardPage
    implements DocumentListener {
        private ConnectWizUserPanel _goPage;

        public UserPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "CONNECT_WIZ_USER_TITLE"));
            this._goPage = new ConnectWizUserPanel();
            this.setPreferredWidth();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
        }

        @Override
        public boolean onSetActive() {
            if (AddServerWizard.this._connAtt instanceof HDSConnAttributes) {
                this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "CONNECT_WIZ_HDS_USER_DESC"));
            } else {
                this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "CONNECT_WIZ_USER_DESC"));
            }
            this.enableBackButton(true);
            this._goPage.fld_username.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            ConnAttributes connAttributes = null;
            connAttributes = AddServerWizard.this._connAtt instanceof HDSConnAttributes ? ((HDSConnAttributes)AddServerWizard.this._connAtt).getInterface() : AddServerWizard.this._connAtt;
            connAttributes.setUser(this._goPage.fld_username.getText());
            connAttributes.setPassword(this._goPage.fld_password.getPasswordString());
            connAttributes.setCharset(this._goPage.cbx_charset.getSelection());
            connAttributes.setLanguage(this._goPage.cbx_language.getSelection());
            this.testConnection();
            int n = 0;
            n = AddServerWizard.this._connAtt.getType().equals("Replication Server") ? (AddServerWizard.this.getDomain().isEnvironment() ? 0 : 5) : (AddServerWizard.this._connAtt instanceof HDSConnAttributes ? 7 : AddServerWizard.this._summaryPageIdx);
            return n;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        protected void setNextButton() {
            String string = this._goPage.fld_username.getText();
            if (string != null && string.length() > 0) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }

        protected void testConnection() {
            if (AddServerWizard.this.getDomain().isEnvironment()) {
                ConnAttributes connAttributes = null;
                connAttributes = AddServerWizard.this._connAtt instanceof HDSConnAttributes ? ((HDSConnAttributes)AddServerWizard.this._connAtt).getInterface() : AddServerWizard.this._connAtt;
                RSMConnection rSMConnection = ConnectionManager.testConnection(connAttributes);
                if (rSMConnection != null && rSMConnection.isConnectionOpen()) {
                    if (connAttributes.getType().equals("Replication Server")) {
                        Dbg.wassert(AddServerWizard.this._connAtt instanceof RSConnAttributes, "ConnAttribute object should be a RSConnAttrbute.");
                        ConnAttributes connAttributes2 = ((RSConnAttributes)AddServerWizard.this._connAtt).getRSSD();
                        connAttributes2.setServer(((RSConnection)rSMConnection).getRSSDServer());
                        connAttributes2.setType(((RSConnection)rSMConnection).isEmbeddedRSSD() ? "ASA" : "ASE");
                    }
                    rSMConnection.close();
                } else {
                    PluginSupport.showWarning(this.getDialogSupport().getParentWindow(), BundleManager.getString("DomainRes", "CONNECT_WIZ_TEST_WARNING", AddServerWizard.this._connAtt.getServer()), null);
                    if (connAttributes.getType().equals("Replication Server")) {
                        ConnAttributes connAttributes3 = ((RSConnAttributes)connAttributes).getRSSD();
                        connAttributes3.setType("ASE");
                    }
                }
            }
        }
    }

    class NamePage
    extends BaseWizardPage
    implements ChangeListener,
    DocumentListener {
        private ConnectWizNamePanel _goPage;

        public NamePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "CONNECT_WIZ_NAME_TITLE"));
            this._goPage = new ConnectWizNamePanel();
            this.setPreferredWidth();
            this._goPage.rbn_select.addChangeListener((ChangeListener)this);
            this._goPage.rbn_manual.addChangeListener((ChangeListener)this);
        }

        @Override
        public boolean onSetActive() {
            this.enableBackButton(true);
            this._goPage.cbx_servers.clear();
            this.loadServers();
            if (AddServerWizard.this.getDomain().isEnvironment()) {
                this._goPage.fld_name.getDocument().addDocumentListener(this);
                this._goPage.fld_host.getDocument().addDocumentListener(this);
                this._goPage.fld_port.getDocument().addDocumentListener(this);
                if (this._goPage.cbx_servers.getItemCount() > 0) {
                    this._goPage.rbn_select.setSelected(true);
                    this._goPage.rbn_select.requestFocus();
                } else {
                    this._goPage.rbn_manual.setSelected(true);
                    this._goPage.rbn_manual.requestFocus();
                }
            } else {
                this._goPage.rbn_manual.setEnabled(false);
            }
            this.enableControls();
            this.setNextButton();
            if (AddServerWizard.this._connAtt instanceof HDSConnAttributes) {
                this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "CONNECT_WIZ_HDS_NAME_DESC"));
            } else {
                this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "CONNECT_WIZ_NAME_DESC"));
            }
            return true;
        }

        protected void loadServers() {
            boolean bl = AddServerWizard.this._connAtt.getType().equalsIgnoreCase("Oracle") || AddServerWizard.this._connAtt.getType().equalsIgnoreCase("MSSS") || AddServerWizard.this._connAtt.getType().equalsIgnoreCase("UDB") || AddServerWizard.this._connAtt.getType().equalsIgnoreCase("Informix");
            try {
                List list = AddServerWizard.this.getDomain().getServerNames();
                ListIterator listIterator = AddServerWizard.this.getDomain().getAvailableServers().listIterator();
                while (listIterator.hasNext()) {
                    String string = listIterator.next().toString();
                    if (!bl && CollectionUtility.find(list, string)) continue;
                    this._goPage.cbx_servers.addItem((Object)string);
                }
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            ConnAttributes connAttributes = null;
            connAttributes = AddServerWizard.this._connAtt instanceof HDSConnAttributes ? ((HDSConnAttributes)AddServerWizard.this._connAtt).getInterface() : AddServerWizard.this._connAtt;
            int n = 0;
            if (this._goPage.rbn_select.isSelected()) {
                String string = this._goPage.cbx_servers.getSelectedString();
                Dbg.wassert(string != null && string.length() > 0, "Null or empty server selection.");
                connAttributes.setServer(string);
                if (AddServerWizard.this.getDomain().isEnvironment()) {
                    try {
                        ServerInterfaces serverInterfaces = new ServerInterfaces();
                        connAttributes.setHost(serverInterfaces.getHostName(string));
                        connAttributes.setPort(serverInterfaces.getPortNumber(string));
                        connAttributes.setSaveAddress(false);
                    }
                    catch (Exception exception) {
                        PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
                    }
                }
            } else {
                String string = this._goPage.fld_name.getText();
                if (AddServerWizard.this._connAtt instanceof HDSConnAttributes && AddServerWizard.this.getDomain().isPartofDomain(string)) {
                    PluginSupport.showError(this.getDialogSupport().getParentWindow(), BundleManager.getString("DomainRes", "ADD_SERVER_DUPLICATE", string), null);
                    n = -1;
                } else {
                    connAttributes.setServer(string);
                    connAttributes.setHost(this._goPage.fld_host.getText());
                    connAttributes.setPort(this._goPage.fld_port.getText());
                    connAttributes.setSaveAddress(true);
                }
            }
            return n;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.enableControls();
            this.setNextButton();
        }

        protected void enableControls() {
            this._goPage.lbl_name.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.fld_name.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.lbl_host.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.fld_host.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.lbl_port.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.fld_port.setEnabled(!this._goPage.rbn_select.isSelected());
            this._goPage.lbl_servers.setEnabled(this._goPage.rbn_select.isSelected());
            this._goPage.cbx_servers.setEnabled(this._goPage.rbn_select.isSelected());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setNextButton();
        }

        protected void setNextButton() {
            if (this._goPage.rbn_select.isSelected()) {
                String string = this._goPage.cbx_servers.getSelectedString();
                this.enableNextButton(string != null && string.length() > 0);
            } else {
                String string = this._goPage.fld_name.getText();
                String string2 = this._goPage.fld_host.getText();
                String string3 = this._goPage.fld_port.getText();
                this.enableNextButton(string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0);
            }
        }
    }

    class HDSTypePage
    extends BaseWizardPage {
        private AddWizHDSTypePanel _goPage;

        public HDSTypePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "ADD_WIZ_HDS_TYPE_TITLE"));
            this._goPage = new AddWizHDSTypePanel();
            this.setPreferredWidth();
        }

        @Override
        public boolean onSetActive() {
            this._goPage.cbx_srvInterface.requestFocusInWindow();
            this.enableBackButton(true);
            this.enableNextButton(true);
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            ConnAttributes connAttributes = ((HDSConnAttributes)AddServerWizard.this._connAtt).getInterface();
            connAttributes.setTypeFromDisplayName(this._goPage.cbx_srvInterface.getSelectedString());
            return 0;
        }

        @Override
        public void onHelp() {
        }
    }

    class TypePage
    extends BaseWizardPage {
        private ConnectWizTypePanel _goPage;

        public TypePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "CONNECT_WIZ_TYPE_TITLE"));
            this._goPage = new ConnectWizTypePanel();
            this.setPreferredWidth();
        }

        @Override
        public boolean onSetActive() {
            String string;
            this._goPage.lst_types.requestFocusInWindow();
            this._goPage.lst_types.selectItem(0);
            if (AddServerWizard.this._connAtt != null && (string = AddServerWizard.this._connAtt.getType()) != null && string.length() > 0) {
                this._goPage.lst_types.selectItem(this._goPage.lst_types.findItem(string));
            }
            AddServerWizard.this._connAtt = null;
            if (AddServerWizard.this._domain.isEnvironment()) {
                int n = this._goPage.lst_types.findItem("Replication Monitoring Services");
                if (n >= 0) {
                    this._goPage.lst_types.removeItem(n);
                }
                if ((n = this._goPage.lst_types.findItem("DirectConnect Service")) >= 0) {
                    this._goPage.lst_types.removeItem(n);
                }
            }
            this.enableNextButton(true);
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            int n = -1;
            int n2 = this._goPage.lst_types.getSelectedIndex();
            if (n2 >= 0) {
                String string = this._goPage.lst_types.getStringAt(n2);
                if (string.equals("Replication Server")) {
                    AddServerWizard.this._connAtt = new RSConnAttributes();
                    n = 3;
                } else if (string.equalsIgnoreCase("Oracle DBMS") || string.equalsIgnoreCase("Microsoft SQL Server") || string.equalsIgnoreCase("IBM Universal Database") || string.equalsIgnoreCase("Informix DBMS")) {
                    AddServerWizard.this._connAtt = new HDSConnAttributes();
                    n = 0;
                } else {
                    AddServerWizard.this._connAtt = new ConnAttributes();
                    n = 3;
                }
                AddServerWizard.this._connAtt.setTypeFromDisplayName(string);
            }
            return n;
        }

        @Override
        public void onHelp() {
        }
    }
}

