/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.domain;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseModalDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.domain.ReconnectPanel;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReconnectDlg
extends BaseModalDialog {
    protected SCPageController[] _page = null;
    private Domain _domain = null;
    private String _domainName;
    private boolean _isRMS;

    public ReconnectDlg(SCDialogSupport2 sCDialogSupport2, String string, boolean bl) {
        super(sCDialogSupport2);
        Dbg.wassert(sCDialogSupport2 != null, "Null dialog support parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter.");
        this._isRMS = bl;
        this._domainName = string;
    }

    @Override
    public boolean showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(true);
        this.getDialogSupport().setHelpButton(false);
        return this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "RECONNECT_TITLE", this._domainName);
    }

    public Domain getDomain() {
        return this._domain;
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new ReconnectPage()};
        }
        return this._page;
    }

    class ReconnectPage
    extends BasePage
    implements ActionListener,
    DocumentListener {
        private ReconnectPanel _goPage = new ReconnectPanel();

        public ReconnectPage() {
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this.getJPanel().getRootPane().setDefaultButton((JButton)this._goPage.btn_ok);
            this._goPage.btn_ok.addActionListener((ActionListener)this);
            this._goPage.btn_cancel.addActionListener((ActionListener)this);
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_username.requestFocus();
        }

        @Override
        public boolean onSetActive() {
            this.enableButtons();
            return super.onSetActive();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public boolean onOk() {
            boolean bl = false;
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            if (ReconnectDlg.this._isRMS) {
                try {
                    ReconnectDlg.this._domain = new RMSDomain(ReconnectDlg.this._domainName);
                    ((RMSDomain)ReconnectDlg.this._domain).connect(string, string2, true);
                    bl = super.onOk();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showValidationError(sQLException.getMessage());
                    bl = false;
                }
            } else {
                try {
                    ReconnectDlg.this._domain = new EnvDomain(ReconnectDlg.this._domainName);
                    bl = super.onOk();
                    ReconnectDlg.this.getDialogSupport().getJDialog().setVisible(false);
                    ((EnvDomain)ReconnectDlg.this._domain).connect(string, string2);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showValidationError(sQLException.getMessage());
                    bl = false;
                }
            }
            if (!bl) {
                ReconnectDlg.this._domain = null;
                ReconnectDlg.this.getDialogSupport().getJDialog().setVisible(true);
            }
            return bl;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_ok) {
                if (this.onOk()) {
                    ReconnectDlg.this.getDialogSupport().closeDialog(true);
                    this.releaseResources();
                }
            } else if (actionEvent.getSource() == this._goPage.btn_cancel) {
                ReconnectDlg.this.getDialogSupport().closeDialog(false);
                this.releaseResources();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
            this.enableButtons();
        }

        protected void enableButtons() {
            String string = this._goPage.fld_username.getText();
            boolean bl = string != null && string.length() > 0;
            this._goPage.btn_ok.setEnabled(bl);
        }
    }
}

