/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.environment;

import com.sybase.asa.ASAIconTextUserData;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.environment.EnvWizNamePanel;
import com.sybase.rsmplugin.components.environment.EnvWizUserPanel;
import com.sybase.rsmplugin.components.environment.Environment;
import com.sybase.rsmplugin.components.environment.ServerWizSrvListPanel;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddEnvWizard
extends BaseWizard {
    protected SCPageController[] _pages = null;
    protected EnvDomain _domain;
    protected ArrayList _attList = new ArrayList();
    protected BaseContainer _container;

    public AddEnvWizard(BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null BaseContainer parameter.");
        this._container = baseContainer;
    }

    protected EnvDomain getEnvironment() {
        Dbg.wassert(this._domain != null, "EnvDomain null. Domain must be initialized before it is used.");
        return this._domain;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "ADD_DOMAIN_TITLE");
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new EnvNamePage(this), new EnvUserPage(this), new ServerListPage(this), new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    String string = AddEnvWizard.this.getEnvironment().toFormattedString();
                    ListIterator listIterator = AddEnvWizard.this._attList.listIterator();
                    while (listIterator.hasNext()) {
                        ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                        string = string + connAttributes.toFormattedString();
                    }
                    return string;
                }
            }};
        }
        return this._pages;
    }

    protected void addAttribute(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null connection attribute.");
        this.removeAttribute(connAttributes.getServer());
        this._attList.add(connAttributes);
    }

    protected void removeAttribute(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        ListIterator listIterator = this._attList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            if (!connAttributes.getServer().equals(string)) continue;
            listIterator.remove();
            break;
        }
    }

    @Override
    public boolean onWizardFinish() {
        this.getDialogSupport().startWait();
        this.getEnvironment().save();
        PluginSupport.registerDomain(this.getEnvironment());
        ListIterator listIterator = this._attList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            this.getEnvironment().addServer(connAttributes);
        }
        this.getEnvironment().refreshStatus();
        this._container.refresh();
        this.getDialogSupport().endWait();
        return super.onWizardFinish();
    }

    class ServerListPage
    extends BaseWizardPage
    implements ActionListener {
        private ServerWizSrvListPanel _goPage;

        public ServerListPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "SERVER_WIZ_LIST_TITLE"));
            this._goPage = new ServerWizSrvListPanel();
            this._goPage.btn_add.addActionListener((ActionListener)this);
            this._goPage.btn_remove.addActionListener((ActionListener)this);
            this.enableBackButton(true);
            this.enableNextButton(true);
        }

        @Override
        public void onInitDialog() {
            this.enableFinishButton(true);
        }

        @Override
        public boolean onSetActive() {
            this.getDialogSupport().setDefaultButtonById(32);
            this._goPage.btn_add.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_add) {
                AddServerWizard addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddEnvWizard.this.getJDialog()), AddEnvWizard.this.getEnvironment());
                if (addServerWizard.showModalDialog()) {
                    List list = addServerWizard.getAttributes();
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                        Object[] objectArray = new Object[]{new ASAIconTextUserData(this.getServerIcon(connAttributes), connAttributes.getServer()), connAttributes.getAddress()};
                        this._goPage.tbl_servers.addRow(objectArray);
                        AddEnvWizard.this.addAttribute(connAttributes);
                    }
                }
            } else {
                int n = this._goPage.tbl_servers.getSelectedColumn();
                if (n >= 0) {
                    this._goPage.tbl_servers.removeRow(n);
                    Object[] objectArray = this._goPage.tbl_servers.getRowAsArray(n);
                    AddEnvWizard.this.removeAttribute(objectArray[0].toString());
                }
            }
        }

        protected Icon getServerIcon(ConnAttributes connAttributes) {
            ImageIcon imageIcon = null;
            imageIcon = connAttributes.getType().equals("Replication Server") ? new ImageIcon(RSMImages.getRepServerUp()) : (connAttributes.getType().equals("ASE") ? new ImageIcon(RSMImages.getASEUp()) : (connAttributes.getType().equals("Replication Agent") ? new ImageIcon(RSMImages.getRepAgentUp()) : (connAttributes.getType().equals("Mirror Replication Agent") ? new ImageIcon(RSMImages.getMirrorRepAgentUp()) : (connAttributes.getType().equals("DirectConnect") ? new ImageIcon(RSMImages.getDirectConnectUp()) : new ImageIcon(RSMImages.getNonASEUp())))));
            return imageIcon;
        }
    }

    class EnvUserPage
    extends BaseWizardPage
    implements DocumentListener {
        private EnvWizUserPanel _goPage;

        public EnvUserPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "DOMAIN_WIZ_USER_TITLE"));
            this._goPage = new EnvWizUserPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
            this._goPage.fld_username.requestFocus();
        }

        @Override
        public boolean onSetActive() {
            this._goPage.fld_username.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            String string = this._goPage.fld_username.getText();
            Dbg.wassert(string != null && string.length() > 0, "Null or empty username, the Next button should be disabled.");
            AddEnvWizard.this.getEnvironment().setUsername(string);
            AddEnvWizard.this.getEnvironment().setPassword(this._goPage.fld_password.getPasswordString());
            return 0;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setNextButton();
        }

        protected void setNextButton() {
            String string;
            String string2;
            boolean bl = false;
            String string3 = this._goPage.fld_username.getText();
            if (string3 != null && string3.length() > 0 && (string2 = this._goPage.fld_password.getPasswordString()).equals(string = this._goPage.fld_confirmPwd.getPasswordString())) {
                bl = true;
            }
            this.enableNextButton(bl);
        }
    }

    class EnvNamePage
    extends BaseWizardPage
    implements DocumentListener {
        private EnvWizNamePanel _goPage;

        public EnvNamePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "DOMAIN_WIZ_NAME_TITLE"));
            this._goPage = new EnvWizNamePanel();
            this._goPage.fld_domainName.getDocument().addDocumentListener(this);
            this._goPage.fld_domainName.requestFocus();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            String string = this._goPage.fld_domainName.getText();
            Dbg.wassert(string != null && string.length() > 0, "Null or empty domainName, the Next button should be disabled.");
            List list = Environment.getDomains();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Environment environment = (Environment)listIterator.next();
                if (!environment.getName().equalsIgnoreCase(string)) continue;
                PluginSupport.showValidationError(this.getController().getJDialog(), BundleManager.getString("DomainRes", "DOMAIN_WIZ_NAME_ERROR", string));
                return -1;
            }
            AddEnvWizard.this._domain = new EnvDomain(string);
            return 0;
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setNextButton();
        }

        protected void setNextButton() {
            String string = this._goPage.fld_domainName.getText();
            if (string != null && string.length() > 0) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }
}

