/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.environment;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.ase.ASEContainer;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.components.directconnect.DirectConnectContainer;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.domain.ReconnectDlg;
import com.sybase.rsmplugin.components.environment.EnvProp;
import com.sybase.rsmplugin.components.environment.Environment;
import com.sybase.rsmplugin.components.environment.RepWizard;
import com.sybase.rsmplugin.components.hds.HDS;
import com.sybase.rsmplugin.components.hds.HDSContainer;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentContainer;
import com.sybase.rsmplugin.components.logical.LogServer;
import com.sybase.rsmplugin.components.logical.LogServerContainer;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentContainer;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.repserver.RepServerContainer;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class EnvContainer
extends BaseContainer
implements RMContainer,
StatusItem {
    private static final String CLASS_ID = "domain.DomainContainer";
    public static final int CMD_CONFIG_REP = 3008;
    public static final int CMD_ADD_SERVER = 3009;
    private Environment _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;
    private static ImageIcon _iconDisconnected = null;

    public EnvContainer(Environment environment, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(environment != null, "Null Environment Semantic object parameter.");
        this._so = environment;
        StatusManager.addStatusItem(this);
    }

    public Environment getEnvironment() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getEnvironment().getStateString();
            }
            case 2: {
                return this.getEnvironment().getReason();
            }
        }
        return "";
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getEnvironmentUp());
        }
        return _iconUp;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this._so.isConnected()) {
            if (this.getEnvironment().isError()) {
                if (_iconDown == null) {
                    _iconDown = new ImageIcon(RSMImages.getEnvironmentDown());
                }
                return _iconDown;
            }
            if (this.getEnvironment().isWarning()) {
                if (_iconSuspect == null) {
                    _iconSuspect = new ImageIcon(RSMImages.getEnvironmentSuspect());
                }
                return _iconSuspect;
            }
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getEnvironmentUp());
            }
            return _iconUp;
        }
        if (_iconDisconnected == null) {
            _iconDisconnected = new ImageIcon(RSMImages.getEnvironmentDisconnected());
        }
        return _iconDisconnected;
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu;
        if (this._so.isConnected()) {
            defaultSCMenu = new DefaultSCMenu();
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDisconnectMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        } else {
            defaultSCMenu = new DefaultSCMenu();
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        }
        return defaultSCMenu;
    }

    @Override
    public SCMenu getCreationMenu() {
        DefaultSCMenu defaultSCMenu = null;
        if (this._so.isConnected()) {
            defaultSCMenu = new DefaultSCMenu();
            String string = BundleManager.getString("DomainRes", "MENU_REP_WIZARD");
            String string2 = BundleManager.getString("DomainRes", "MENU_HINT_REP_WIZARD");
            char c = BundleManager.getMnemonic("DomainRes", "MENU_MNEM_REP_WIZARD");
            ImageIcon imageIcon = new ImageIcon(RSMImages.getAddRepWizard());
            MenuItem menuItem = new MenuItem(3008, string, string2, c, imageIcon);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            string = BundleManager.getString("DomainRes", "MENU_ADD_SERVER");
            string2 = BundleManager.getString("DomainRes", "MENU_HINT_ADD_SERVER");
            c = BundleManager.getMnemonic("DomainRes", "MENU_MNEM_ADD_SERVER");
            imageIcon = new ImageIcon(RSMImages.getRepServerUp());
            menuItem = new MenuItem(3009, string, string2, c, imageIcon);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public boolean onNotify(JFrame jFrame, int n, int n2) {
        boolean bl = true;
        if (!(n != 203 && n != 100 || this._so.isConnected())) {
            ReconnectDlg reconnectDlg = new ReconnectDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), this.getName(), false);
            if (reconnectDlg.showDialog()) {
                this._so.connect((EnvDomain)reconnectDlg.getDomain());
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 107: {
                BaseController baseController = PluginSupport.getDialog(EnvProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                EnvProp envProp = new EnvProp(this.getEnvironment(), this, sCDialogSupport2);
                envProp.showDialog();
                break;
            }
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof EnvContainer)) continue;
                    ((EnvContainer)baseItem).getEnvironment().delete();
                    listIterator.remove();
                }
                this.getParent().refresh();
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3003: {
                PluginSupport.getViewerSupport().startWait();
                this._so.getDomain().setMonitoring(false);
                this._so.disconnect();
                this.collapse();
                this.getParent().select();
                this.getParent().refresh();
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3008: {
                BaseController baseController = PluginSupport.getDialog(RepWizard.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                RepWizard repWizard = new RepWizard(this, PluginSupport.getDialogSupport(jFrame));
                repWizard.showDialog();
                break;
            }
            case 3009: {
                AddServerWizard addServerWizard;
                EnvDomain envDomain = this.getEnvironment().getDomain();
                if (envDomain == null || !(addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(jFrame), envDomain)).showModalDialog()) break;
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    envDomain.addServer(connAttributes);
                }
                if (list.isEmpty()) break;
                PluginSupport.refreshDomain(this);
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            super.open(n);
            if (this._so.isConnected()) {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getName());
                this.addItem((SCItem)new RepWizardItem(this));
                this.addItem((SCItem)new AddServerItem(this));
                if (semanticFactory != null) {
                    BaseContainer baseContainer;
                    ListIterator listIterator;
                    try {
                        listIterator = semanticFactory.getLogServers().listIterator();
                        while (listIterator.hasNext()) {
                            baseContainer = new LogServerContainer((LogServer)listIterator.next(), this);
                            this.addItem((SCItem)baseContainer);
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    listIterator = semanticFactory.getASEs().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new ASEContainer((ASE)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getHDSs().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new HDSContainer((HDS)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getRepServers().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new RepServerContainer((RepServer)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getLANRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new LANRepAgentContainer((LANRepAgent)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getMirrorRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new MirrorRepAgentContainer((MirrorRepAgent)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getDirectConnects().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new DirectConnectContainer((DirectConnect)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                }
            }
            super.open(n);
        }
    }

    @Override
    public void setState(int n) {
        this.getEnvironment().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getEnvironment().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getEnvironment().getDomainName();
    }

    @Override
    public String getType() {
        return this.getEnvironment().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DomainRes", "HDR_SERVER"), BundleManager.getString("DomainRes", "COL_HEADER_STATE"), BundleManager.getString("DomainRes", "COL_HEADER_REASON")};
    }

    class AddServerItem
    extends BaseAddItem {
        public AddServerItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("DomainRes", "ADD_SERVER_TITLE"), RSMImages.getAddEnvironment());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            AddServerWizard addServerWizard;
            EnvDomain envDomain = EnvContainer.this.getEnvironment().getDomain();
            if (envDomain != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(jFrame), envDomain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    envDomain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(this.getParent());
                }
            }
        }
    }

    class RepWizardItem
    extends BaseAddItem {
        public RepWizardItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("DomainRes", "REP_WIZARD_ITEM"), RSMImages.getAddRepWizard());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(RepWizard.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                RepWizard repWizard = new RepWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame));
                repWizard.showDialog();
            }
        }
    }
}

