/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.environment;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.environment.EnvPropGeneralPanel;
import com.sybase.rsmplugin.components.environment.EnvPropMonitorPanel;
import com.sybase.rsmplugin.components.environment.Environment;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnvProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected Environment _so;
    protected BaseItem _item;
    protected String _user = null;
    protected String _pwd;
    protected boolean _monitorFlag = false;
    protected int _monitoringInterval = 60;

    EnvProp(Environment environment, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(environment != null, "Null Environment parameter.");
        this._so = environment;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
    }

    Environment getDomain() {
        return this._so;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "PROPERTIES_TITLE", this.getDomain().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new MonitorPage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        this.getDomain().alter(this._user, this._pwd, this._monitorFlag, this._monitoringInterval);
        return super.onOk();
    }

    @Override
    public void onApply() {
        if (this._user != null) {
            this.getDomain().alter(this._user, this._pwd, this._monitorFlag, this._monitoringInterval);
        }
        super.onApply();
    }

    class MonitorPage
    extends BasePropertyPage
    implements ActionListener,
    ASASpinBoxChangeListener {
        private EnvPropMonitorPanel _goPage;

        public MonitorPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("ConnectionRes", "MONITOR_PAGE_TAG"));
            this._goPage = new EnvPropMonitorPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            EnvProp.this._monitorFlag = EnvProp.this.getDomain().isMonitoringOn();
            this._goPage.cbMonitor.setSelected(EnvProp.this._monitorFlag);
            EnvProp.this._monitoringInterval = EnvProp.this.getDomain().getMonitoringInterval();
            this._goPage.spinInterval.setValue(EnvProp.this._monitoringInterval);
            this._goPage.labelInterval.setEnabled(this._goPage.cbMonitor.isSelected());
            this._goPage.spinInterval.setEnabled(this._goPage.cbMonitor.isSelected());
            this._goPage.labelSeconds.setEnabled(this._goPage.cbMonitor.isSelected());
            this._goPage.cbMonitor.addActionListener((ActionListener)this);
            this._goPage.spinInterval.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
        }

        @Override
        public boolean onSetActive() {
            String string = null;
            Date date = EnvProp.this.getDomain().getLastMonitoredDate();
            if (date != null) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
                string = dateFormat.format(date);
            }
            if (string == null) {
                string = "";
            }
            this._goPage.lbl_date.setText(BundleManager.getString("DomainRes", "LAST_MONITOR_DATE", string));
            return true;
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                EnvProp.this._monitorFlag = this._goPage.cbMonitor.isSelected();
                EnvProp.this._monitoringInterval = this._goPage.spinInterval.getValue();
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setButtons();
            this._goPage.labelInterval.setEnabled(this._goPage.cbMonitor.isSelected());
            this._goPage.spinInterval.setEnabled(this._goPage.cbMonitor.isSelected());
            this._goPage.labelSeconds.setEnabled(this._goPage.cbMonitor.isSelected());
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.setButtons();
        }

        protected void setButtons() {
            this.setModified(true);
            int n = 7;
            this.getDialogSupport().setEnabledStandardButtons(n);
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener {
        private EnvPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("DomainRes", "GENERAL_PAGE_TAG"));
            this._goPage = new EnvPropGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(EnvProp.this.getDomain().getName());
            this._goPage.fld_state.setText(EnvProp.this.getDomain().getStateString());
            this._goPage.fld_reason.setText(EnvProp.this.getDomain().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(EnvProp.this.getDomain().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
            EnvProp.this._user = EnvProp.this.getDomain().getUsername();
            this._goPage.fld_username.setText(EnvProp.this._user);
            EnvProp.this._pwd = EnvProp.this.getDomain().getPassword();
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                EnvProp.this._user = this._goPage.fld_username.getText();
                EnvProp.this._pwd = this._goPage.fld_password.getPasswordString();
                if (EnvProp.this._pwd.equals("        ")) {
                    EnvProp.this._pwd = EnvProp.this.getDomain().getPassword();
                }
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), EnvProp.this.getDomain().getReasons(), EnvProp.this.getDomain().getName());
                reasonListDlg.showDialog();
            }
        }

        protected void setButtons() {
            this.setModified(true);
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            int n = 2;
            if (string.length() > 0 && string2.equals(string3)) {
                n |= 1;
                n |= 4;
            }
            this.getDialogSupport().setEnabledStandardButtons(n);
        }
    }
}

