/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.environment;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseStatusSO;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.Dbg;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class Environment
extends BaseStatusSO {
    public static final int DISCONNECT_STATE = 6;
    private EnvDomain _domain = null;
    private String _name;

    public Environment(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
        this._name = this._domain.getName();
        this.clearReasons();
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
        this.setReportEvent(false);
    }

    public Environment(String string) {
        this._name = string;
        this.setReportEvent(false);
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getDomainName() {
        return this.getName();
    }

    public static List getDomains() {
        List list = EnvDomain.getDomains();
        if (list != null && list.size() > 0) {
            ArrayList<Environment> arrayList = new ArrayList<Environment>();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = listIterator.next().toString();
                Domain domain = PluginSupport.getDomain(string);
                if (domain != null) {
                    if (!domain.isEnvironment()) continue;
                    arrayList.add(new Environment((EnvDomain)domain));
                    continue;
                }
                arrayList.add(new Environment(string));
            }
            return arrayList;
        }
        return new ArrayList();
    }

    public void alter(String string, String string2, boolean bl, int n) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        if (this.getDomain() != null) {
            this.getDomain().setUsername(string);
            this.getDomain().setPassword(string2);
            this.getDomain().setMonitoring(bl);
            this.getDomain().setMonitorInterval(n);
            this.getDomain().save();
        }
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty Domain name attribute.");
        return this._name;
    }

    public boolean isConnected() {
        return this._domain != null;
    }

    public void connect(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        EnvDomain envDomain = this._domain;
        synchronized (envDomain) {
            if (this._domain != null) {
                this._domain.disconnect();
                this._domain = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this._domain != null) {
            EnvDomain envDomain = this._domain;
            synchronized (envDomain) {
                this._domain.disconnect();
                this._domain.delete();
            }
        } else {
            this._domain = new EnvDomain(this.getName());
            this._domain.delete();
        }
        this._domain = null;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "EnvDomain attribute is null");
        return this._domain;
    }

    protected void setDomain(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null EnvDomain parameter.");
        this._domain = envDomain;
        this._name = envDomain.getName();
    }

    public String getUsername() {
        return this.getDomain().getUsername();
    }

    public boolean isMonitoringOn() {
        return this.getDomain().isMonitoring();
    }

    public int getMonitoringInterval() {
        return this.getDomain().getMonitorInterval();
    }

    public Date getLastMonitoredDate() {
        return this.getDomain().getLastMonitoredDate();
    }

    public String getPassword() {
        return this.getDomain().getPassword();
    }

    public String getStateString() {
        String string;
        if (this.isConnected()) {
            switch (this.getRSState()) {
                case 5: {
                    string = BundleManager.getString("DomainRes", "ACTIVE_STATE");
                    break;
                }
                case 0: {
                    string = BundleManager.getString("DomainRes", "DOWN_STATE");
                    break;
                }
                case 4: {
                    string = BundleManager.getString("DomainRes", "SUSPECT_STATE");
                    break;
                }
                case 3: {
                    string = BundleManager.getString("DomainRes", "UNKNOWN_STATE");
                    break;
                }
                default: {
                    Dbg.wassert(false, "Unexpected Domain State");
                    string = "";
                    break;
                }
            }
        } else {
            string = BundleManager.getString("DomainRes", "DISCONNECTED_STATE");
        }
        return string;
    }
}

