/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.environment;

import com.sybase.asa.ASAComboBox;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.CmdSummaryDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.components.dbrepdef.DBRepDef;
import com.sybase.rsmplugin.components.dbsubscription.DBSub;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.environment.RepWizLogicalPanel;
import com.sybase.rsmplugin.components.environment.RepWizMaintPanel;
import com.sybase.rsmplugin.components.environment.RepWizMatPanel;
import com.sybase.rsmplugin.components.environment.RepWizMultiPanel;
import com.sybase.rsmplugin.components.environment.RepWizRAPanel;
import com.sybase.rsmplugin.components.environment.RepWizRSPanel;
import com.sybase.rsmplugin.components.environment.RepWizSinglePanel;
import com.sybase.rsmplugin.components.environment.RepWizTypePanel;
import com.sybase.rsmplugin.components.environment.RepWizWSMatPanel;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RepWizard
extends BaseWizard {
    protected static final int WS_TYPE = 0;
    protected static final int MWS_TYPE = 1;
    protected static final int BIDIRECT_TYPE = 2;
    protected static final int TYPE_PAGE = 1;
    protected static final int ACTIVE_PAGE = 2;
    protected static final int STANDBY_PAGE = 3;
    protected static final int LOGICAL_PAGE = 4;
    protected static final int PRIMARY_PAGE = 5;
    protected static final int REPLICATE_PAGE = 6;
    protected static final int BIDIRECT_PAGE = 7;
    protected static final int RS_PAGE = 8;
    protected static final int MAINT_PAGE = 9;
    protected static final int RA_PAGE = 10;
    protected static final int MATERIAL_PAGE = 11;
    protected static final int WS_MATERIAL_PAGE = 12;
    protected static final int SUMMARY_PAGE = 13;
    protected static final int PAGE_SIZE = 13;
    protected SCPageController[] _pages = null;
    protected BaseContainer _container;
    protected int _type;
    protected String _primaryDS = null;
    protected String _primaryDB = null;
    protected String _standbyDS = null;
    protected String _standbyDB = null;
    protected ArrayList _connList = new ArrayList();
    protected String _logicalDS = null;
    protected String _logicalDB = null;
    protected String _controllingRS = null;
    protected String _maintUser = null;
    protected String _maintPwd = null;
    protected String _raUser = null;
    protected String _raPwd = null;
    protected boolean _materialize = false;
    protected boolean _wsMaterialize = false;
    protected boolean _useMarker = false;

    public RepWizard(BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null BaseContainer parameter.");
        this._container = baseContainer;
    }

    public String getConnectionName() {
        Dbg.wassert(this._container != null, "Null BaseContainer attribute.");
        return this._container.getName();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("DomainRes", "REP_WIZARD_TITLE");
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[13];
            this._pages[0] = new RepTypePage(this);
            this._pages[1] = new ActiveDBPage(this);
            this._pages[2] = new StandbyDBPage(this);
            this._pages[3] = new LogNamePage(this);
            this._pages[4] = new PrimaryDBPage(this);
            this._pages[5] = new ReplicateDBPage(this);
            this._pages[6] = new BiDirectDBPage(this);
            this._pages[7] = new ControllingRSPage(this);
            this._pages[8] = new MaintPage(this);
            this._pages[9] = new RAPage(this);
            this._pages[10] = new MaterializePage(this);
            this._pages[11] = new WSMaterializePage(this);
            this._pages[12] = new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    return RepWizard.this.toFormattedString();
                }
            };
        }
        return this._pages;
    }

    public String toFormattedString() {
        String string = "";
        switch (this._type) {
            case 0: {
                string = string + BundleManager.getString("DomainRes", "REP_SUM_WS_TYPE") + "\n";
                String string2 = this._logicalDS + "." + this._logicalDB;
                string = string + BundleManager.getString("DomainRes", "SUMMARY_LOGICAL", string2) + "\n";
                string2 = this._primaryDS + "." + this._primaryDB;
                string = string + BundleManager.getString("DomainRes", "SUMMARY_ACTIVE", string2) + "\n";
                string2 = this._standbyDS + "." + this._standbyDB;
                string = string + BundleManager.getString("DomainRes", "SUMMARY_STANDBY", string2) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_RS", this._controllingRS) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_MAINT_USER", this._maintUser) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_RA_USER", this._raUser) + "\n";
                if (!this._wsMaterialize) break;
                string = string + BundleManager.getString("DomainRes", "REP_WS_MAT_SUM") + "\n";
                if (!this._useMarker) break;
                string = string + BundleManager.getString("DomainRes", "REP_SUM_MARKER") + "\n";
                break;
            }
            case 1: {
                string = string + BundleManager.getString("DomainRes", "REP_SUM_MWS_TYPE") + "\n";
                String string3 = this._primaryDS + "." + this._primaryDB;
                string = string + BundleManager.getString("DomainRes", "REP_SUM_PRIMARY", string3) + "\n";
                string = string + BundleManager.getString("DomainRes", "REP_SUM_MWS") + "\n";
                ListIterator listIterator = this._connList.listIterator();
                while (listIterator.hasNext()) {
                    string = string + "\t" + listIterator.next().toString() + "\n";
                }
                string = string + BundleManager.getString("DomainRes", "SUMMARY_RS", this._controllingRS) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_MAINT_USER", this._maintUser) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_RA_USER", this._raUser) + "\n";
                if (this._materialize) {
                    string = string + BundleManager.getString("DomainRes", "REP_SUM_MAT") + "\n";
                    if (!this._useMarker) break;
                    string = string + BundleManager.getString("DomainRes", "REP_SUM_MARKER") + "\n";
                    break;
                }
                string = string + BundleManager.getString("DomainRes", "REP_SUM_NO_MAT") + "\n";
                break;
            }
            case 2: {
                string = string + BundleManager.getString("DomainRes", "REP_SUM_BI_TYPE") + "\n";
                string = string + BundleManager.getString("DomainRes", "REP_SUM_BI") + "\n";
                ListIterator listIterator = this._connList.listIterator();
                while (listIterator.hasNext()) {
                    string = string + "\t" + listIterator.next().toString() + "\n";
                }
                string = string + BundleManager.getString("DomainRes", "SUMMARY_RS", this._controllingRS) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_MAINT_USER", this._maintUser) + "\n";
                string = string + BundleManager.getString("DomainRes", "SUMMARY_RA_USER", this._raUser) + "\n";
                if (this._materialize) {
                    string = string + BundleManager.getString("DomainRes", "REP_SUM_MAT") + "\n";
                    if (!this._useMarker) break;
                    string = string + BundleManager.getString("DomainRes", "REP_SUM_MARKER") + "\n";
                    break;
                }
                string = string + BundleManager.getString("DomainRes", "REP_SUM_NO_MAT") + "\n";
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected environment type.");
            }
        }
        return string;
    }

    @Override
    public boolean onWizardFinish() {
        this.getDialogSupport().startWait();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string = "";
        switch (this._type) {
            case 0: {
                string = BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_WS");
                bl = this.createWS(arrayList);
                break;
            }
            case 1: {
                string = BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_MSA");
                bl = this.createMWS(arrayList);
                break;
            }
            case 2: {
                string = BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_BI");
                bl = this.createBiDirect(arrayList);
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected environment type.");
            }
        }
        this.getDialogSupport().endWait();
        if (arrayList.size() > 0) {
            arrayList.add(BundleManager.getString("ConnectionRes", "END_OF_PROCESS_SUMMARY"));
            CmdSummaryDlg cmdSummaryDlg = new CmdSummaryDlg(PluginSupport.getDialogSupport(this.getJDialog()), arrayList);
            cmdSummaryDlg.setDescription(string);
            cmdSummaryDlg.showDialog();
        }
        if (bl) {
            super.onWizardFinish();
        }
        PluginSupport.refreshAll();
        return bl;
    }

    protected boolean createWS(List list) {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getConnectionName());
        Dbg.wassert(semanticFactory != null, "Null semantic factory for connection: " + this.getConnectionName());
        PhyConnection phyConnection = null;
        try {
            phyConnection = semanticFactory.getPhyConnection(this._controllingRS, this._primaryDS, this._primaryDB);
            phyConnection.load();
            if (phyConnection.exists() && phyConnection.isReplicate()) {
                PluginSupport.showValidationError(BundleManager.getString("DomainRes", "REP_CONN_EXISTS", phyConnection.getName()));
                return false;
            }
            PhyConnection phyConnection2 = semanticFactory.getPhyConnection(this._controllingRS, this._standbyDS, this._standbyDB);
            phyConnection2.load();
            if (phyConnection2.exists()) {
                PluginSupport.showValidationError(BundleManager.getString("DomainRes", "REP_CONN_EXISTS", phyConnection2.getName()));
                return false;
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            return false;
        }
        boolean bl = true;
        LogConnection logConnection = semanticFactory.getLogConnection(this._controllingRS, this._logicalDS, this._logicalDB);
        Dbg.wassert(logConnection != null, "Cannot create logical connection: " + this._logicalDS + "." + this._logicalDB);
        try {
            list.add("I. " + BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_LOG", logConnection.getName()));
            logConnection.create();
        }
        catch (SQLException sQLException) {
            String string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string);
            bl = false;
        }
        if (bl) {
            if (!phyConnection.exists()) {
                phyConnection = semanticFactory.getPhyConnection(this._controllingRS, this._primaryDS, this._primaryDB);
                phyConnection.setMaintUser(this._maintUser);
                phyConnection.setMaintPwd(this._maintPwd);
                phyConnection.setLDS(this._logicalDS);
                phyConnection.setLDB(this._logicalDB);
                bl = phyConnection.createActive(this._raUser, this._raPwd, true, list);
            } else {
                bl = phyConnection.changeToActive(list);
            }
        }
        if (bl) {
            PhyConnection phyConnection3 = semanticFactory.getPhyConnection(this._controllingRS, this._standbyDS, this._standbyDB);
            phyConnection3.setMaintUser(this._maintUser);
            phyConnection3.setMaintPwd(this._maintPwd);
            phyConnection3.setLDS(this._logicalDS);
            phyConnection3.setLDB(this._logicalDB);
            bl = phyConnection3.createStandby(this._raUser, this._raPwd, this._wsMaterialize, this._useMarker, list);
        }
        return bl;
    }

    protected boolean createMWS(List list) {
        String string;
        Object object;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getConnectionName());
        Dbg.wassert(semanticFactory != null, "Null semantic factory for connection: " + this.getConnectionName());
        boolean bl = true;
        DBRepDef dBRepDef = null;
        PhyConnection phyConnection = semanticFactory.getPhyConnection(this._controllingRS, this._primaryDS, this._primaryDB);
        try {
            phyConnection.load();
            if (phyConnection.exists()) {
                if (phyConnection.isReplicate()) {
                    PluginSupport.showValidationError(BundleManager.getString("DomainRes", "REP_CONN_EXISTS", phyConnection.getName()));
                    bl = false;
                }
            } else {
                phyConnection.setMaintUser(this._maintUser);
                phyConnection.setMaintPwd(this._maintPwd);
                bl = phyConnection.createPrimary(this._raUser, this._raPwd, list);
            }
            if (bl) {
                dBRepDef = this.createDBRepDef(this._primaryDS, this._primaryDB);
                object = new ArrayList();
                dBRepDef.setDDLFilter(true);
                dBRepDef.setExcludeSysProcs(true);
                dBRepDef.setSysProcFilterPresent(true);
                ((ArrayList)object).add("sp_config_rep_agent");
                ((ArrayList)object).add("sp_adduser");
                dBRepDef.setSysProcFilters((List)object);
                dBRepDef.setExcludeTables(true);
                dBRepDef.setTableFilterPresent(true);
                ((ArrayList)object).clear();
                ((ArrayList)object).add("dbo.rs_lastcommit");
                dBRepDef.setTableFilters((List)object);
                dBRepDef.setExcludeFuncs(true);
                dBRepDef.setFuncFilterPresent(true);
                ((ArrayList)object).clear();
                ((ArrayList)object).add("rs_update_lastcommit");
                dBRepDef.setFunctionFilters((List)object);
                list.add("I. " + BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_REP_DEF", dBRepDef.getName()));
                dBRepDef.create();
            }
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + string);
            bl = false;
        }
        object = this._connList.listIterator();
        while (object.hasNext() && bl) {
            string = (String)object.next();
            String string2 = string.substring(0, string.indexOf("."));
            String string3 = string.substring(string.indexOf(".") + 1);
            PhyConnection phyConnection2 = semanticFactory.getPhyConnection(this._controllingRS, string2, string3);
            try {
                phyConnection2.load();
                if (!phyConnection2.exists()) {
                    phyConnection2.setMaintUser(this._maintUser);
                    phyConnection2.setMaintPwd(this._maintPwd);
                    bl = phyConnection2.createReplicate(list);
                }
                if (!bl) continue;
                DBSub dBSub = semanticFactory.getDBSub(this._controllingRS, string, phyConnection.getName(), dBRepDef.getName(), dBRepDef.getName());
                dBSub.setTruncateTable("Yes");
                if (this._materialize) {
                    dBSub.setbulkMethod("Bulk");
                    if (this._useMarker) {
                        dBSub.setUseDumpMarkerCommand("Use Dump Marker");
                    } else {
                        dBSub.setUseDumpMarkerCommand("");
                    }
                } else {
                    dBSub.setbulkMethod("Bulk Create");
                    dBSub.setUseDumpMarkerCommand("");
                }
                list.add("I. " + BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_SUB", dBSub.getName()));
                dBSub.create();
            }
            catch (SQLException sQLException) {
                String string4 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string4, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("E. " + string4);
                bl = false;
            }
        }
        return bl;
    }

    protected boolean createBiDirect(List list) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getConnectionName());
        Dbg.wassert(semanticFactory != null, "Null semantic factory for connection: " + this.getConnectionName());
        boolean bl = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ListIterator listIterator = this._connList.listIterator();
        while (listIterator.hasNext() && bl) {
            object5 = (String)listIterator.next();
            object4 = ((String)object5).substring(0, ((String)object5).indexOf("."));
            object3 = ((String)object5).substring(((String)object5).indexOf(".") + 1);
            object2 = semanticFactory.getPhyConnection(this._controllingRS, (String)object4, (String)object3);
            try {
                object2.load();
                if (object2.exists()) {
                    if (object2.isReplicate()) {
                        PluginSupport.showValidationError(BundleManager.getString("DomainRes", "REP_CONN_EXISTS", object2.getName()));
                        bl = false;
                    }
                } else {
                    object2.setMaintUser(this._maintUser);
                    object2.setMaintPwd(this._maintPwd);
                    bl = object2.createPrimary(this._raUser, this._raPwd, list);
                }
                arrayList.add(object2);
            }
            catch (SQLException sQLException) {
                string = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
                list.add("E. " + string);
                bl = false;
            }
        }
        object5 = new ArrayList();
        if (bl) {
            object4 = arrayList.listIterator();
            while (object4.hasNext()) {
                object3 = (PhyConnection)object4.next();
                try {
                    object2 = this.createDBRepDef(object3.getDS(), object3.getDB());
                    object = new ArrayList();
                    object2.setExcludeSysProcs(true);
                    object2.setSysProcFilterPresent(true);
                    ((ArrayList)object).add("sp_config_rep_agent");
                    ((ArrayList)object).add("sp_adduser");
                    object2.setSysProcFilters((List)object);
                    object2.setExcludeTables(true);
                    object2.setTableFilterPresent(true);
                    ((ArrayList)object).clear();
                    ((ArrayList)object).add("dbo.rs_lastcommit");
                    object2.setTableFilters((List)object);
                    object2.setExcludeFuncs(true);
                    object2.setFuncFilterPresent(true);
                    ((ArrayList)object).clear();
                    ((ArrayList)object).add("rs_update_lastcommit");
                    object2.setFunctionFilters((List)object);
                    list.add("I. " + BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_REP_DEF", object2.getName()));
                    object2.create();
                    ((ArrayList)object5).add(object2);
                }
                catch (SQLException sQLException) {
                    object = MessageText.formatExceptionMessage(sQLException);
                    PluginSupport.LogErrorMessage((String)object, MessageText.formatSQLExceptionDetails(sQLException));
                    list.add("E. " + (String)object);
                }
            }
        }
        if (bl) {
            object4 = ((ArrayList)object5).listIterator();
            while (object4.hasNext()) {
                object3 = (DBRepDef)object4.next();
                object2 = arrayList.listIterator();
                while (object2.hasNext()) {
                    object = (PhyConnection)object2.next();
                    if (object3.getDS().equals(object.getDS()) && object3.getDB().equals(object.getDB())) continue;
                    string = object3.getDS() + "." + object3.getDB();
                    DBSub dBSub = semanticFactory.getDBSub(this._controllingRS, object.getName(), string, object3.getName(), object3.getName());
                    dBSub.setTruncateTable("Yes");
                    if (this._materialize) {
                        dBSub.setbulkMethod("Bulk");
                        if (this._useMarker) {
                            dBSub.setUseDumpMarkerCommand("Use Dump Marker");
                        } else {
                            dBSub.setUseDumpMarkerCommand("");
                        }
                    } else {
                        dBSub.setbulkMethod("Bulk Create");
                        dBSub.setUseDumpMarkerCommand("");
                    }
                    try {
                        list.add("I. " + BundleManager.getString("DomainRes", "REP_WIZ_SUM_CREATE_SUB", dBSub.getName()));
                        dBSub.create();
                    }
                    catch (SQLException sQLException) {
                        String string2 = MessageText.formatExceptionMessage(sQLException);
                        PluginSupport.LogErrorMessage(string2, MessageText.formatSQLExceptionDetails(sQLException));
                        list.add("E. " + string2);
                    }
                }
            }
        }
        return bl;
    }

    protected DBRepDef createDBRepDef(String string, String string2) throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getConnectionName());
        Dbg.wassert(semanticFactory != null, "Null semantic object for environment: " + this.getConnectionName());
        List list = semanticFactory.getDBRepDefs(this._controllingRS, string, string2);
        for (int i = 1; i < 1000; ++i) {
            String string3 = string2 + "_" + String.valueOf(i);
            ListIterator listIterator = list.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                DBRepDef dBRepDef = (DBRepDef)listIterator.next();
                if (!dBRepDef.getName().equals(string3)) continue;
                bl = true;
            }
            if (bl) continue;
            return semanticFactory.getDBRepDef(string3, this._controllingRS, string, string2);
        }
        Dbg.wassert(false, "Unexpected programming error. Unable to create new name for DB repdef.");
        return null;
    }

    protected void loadASEServers(ASAComboBox aSAComboBox) {
        Dbg.wassert(aSAComboBox != null, "Null combobox parameter.");
        aSAComboBox.removeAllItems();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getConnectionName());
        if (semanticFactory != null) {
            ListIterator listIterator = semanticFactory.getASEs().listIterator();
            while (listIterator.hasNext()) {
                ASE aSE = (ASE)listIterator.next();
                aSAComboBox.addItem((Object)aSE.getName());
            }
        }
    }

    protected void loadDatabases(String string, ASAComboBox aSAComboBox) {
        SemanticFactory semanticFactory;
        Dbg.wassert(aSAComboBox != null, "Null combobox parameter.");
        aSAComboBox.removeAllItems();
        if (string != null && string.length() > 0 && (semanticFactory = PluginSupport.getSemanticFactory(this.getConnectionName())) != null) {
            try {
                ListIterator listIterator = semanticFactory.getDatabases(string).listIterator();
                while (listIterator.hasNext()) {
                    Database database = (Database)listIterator.next();
                    aSAComboBox.addItem((Object)database.getName());
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    class WSMaterializePage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizWSMatPanel _goPage;

        public WSMaterializePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_WS_MAT_TITLE"));
            this._goPage = new RepWizWSMatPanel();
            this.enableBackButton(true);
            this.enableNextButton(true);
            this._goPage.chk_useDumpLoad.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.chk_useDumpLoad.setSelected(RepWizard.this._wsMaterialize);
            if (RepWizard.this._wsMaterialize) {
                this._goPage.chk_useMarker.setEnabled(true);
                this._goPage.chk_useMarker.setSelected(RepWizard.this._useMarker);
            } else {
                this._goPage.chk_useMarker.setEnabled(false);
                this._goPage.chk_useMarker.setSelected(false);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._wsMaterialize = this._goPage.chk_useDumpLoad.isSelected();
            RepWizard.this._useMarker = this._goPage.chk_useMarker.isSelected();
            return 13;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._goPage.chk_useMarker.setEnabled(this._goPage.chk_useDumpLoad.isSelected());
        }
    }

    class MaterializePage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizMatPanel _goPage;

        public MaterializePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_MAT_TITLE"));
            this._goPage = new RepWizMatPanel();
            this.enableBackButton(true);
            this.enableNextButton(true);
            this._goPage.rbn_noMaterialize.addActionListener((ActionListener)this);
            this._goPage.rbn_bulkMaterialize.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.rbn_bulkMaterialize.setSelected(RepWizard.this._materialize);
            if (RepWizard.this._materialize) {
                this._goPage.chk_useMarker.setEnabled(true);
                this._goPage.chk_useMarker.setSelected(RepWizard.this._useMarker);
            } else {
                this._goPage.chk_useMarker.setEnabled(false);
                this._goPage.chk_useMarker.setSelected(false);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._materialize = this._goPage.rbn_bulkMaterialize.isSelected();
            RepWizard.this._useMarker = this._goPage.chk_useMarker.isSelected();
            return 13;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._goPage.chk_useMarker.setEnabled(this._goPage.rbn_bulkMaterialize.isSelected());
        }
    }

    class RAPage
    extends BaseWizardPage
    implements DocumentListener {
        private RepWizRAPanel _goPage;

        public RAPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "WIZ_RA_TITLE"));
            this._goPage = new RepWizRAPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = RepWizard.this._primaryDB + "_rep_agent";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._raUser = this._goPage.fld_username.getText();
            RepWizard.this._raPwd = this._goPage.fld_password.getPasswordString();
            if (RepWizard.this._raPwd.equals("        ")) {
                RepWizard.this._raPwd = "rep_agent_ps";
            }
            int n = -1;
            n = RepWizard.this._type == 0 ? 12 : 11;
            return n;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class MaintPage
    extends BaseWizardPage
    implements DocumentListener {
        private RepWizMaintPanel _goPage;

        public MaintPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "WIZ_MAINT_TITLE"));
            this._goPage = new RepWizMaintPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = RepWizard.this._primaryDB + "_maint";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._maintUser = this._goPage.fld_username.getText();
            RepWizard.this._maintPwd = this._goPage.fld_password.getPasswordString();
            if (RepWizard.this._maintPwd.equals("        ")) {
                RepWizard.this._maintPwd = "maint_ps";
            }
            return 10;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class ControllingRSPage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizRSPanel _goPage;

        public ControllingRSPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_WS_RS_TITLE"));
            this._goPage = new RepWizRSPanel();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "REP_WS_RS_DESC"));
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            this.load();
            if (RepWizard.this._controllingRS != null && RepWizard.this._controllingRS.length() > 0) {
                this._goPage.cbx_repserver.setSelectedItem(RepWizard.this._controllingRS);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._controllingRS = this._goPage.cbx_repserver.getSelectedItem().toString();
            if (RepWizard.this._type == 1 || RepWizard.this._type == 2) {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RepWizard.this.getConnectionName());
                Dbg.wassert(semanticFactory != null, "Null semantic factory for connection named: " + RepWizard.this.getConnectionName());
                RepServer repServer = semanticFactory.getRepServer(RepWizard.this._controllingRS);
                if (repServer.getVersionNumber() < 1260) {
                    PluginSupport.showValidationError(BundleManager.getString("DomainRes", "REP_RS_INVALID_VERSION"));
                    return -1;
                }
            }
            int n = -1;
            if (RepWizard.this._type == 0) {
                n = 3;
            } else if (RepWizard.this._type == 1) {
                n = 6;
            } else if (RepWizard.this._type == 2) {
                n = 9;
            }
            return n;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(RepWizard.this.getConnectionName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(RepWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(RepWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_repserver.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RepWizard.this.getConnectionName());
            if (semanticFactory != null) {
                ListIterator listIterator = semanticFactory.getRepServers().listIterator();
                while (listIterator.hasNext()) {
                    RepServer repServer = (RepServer)listIterator.next();
                    if (RepWizard.this._type != 0 && repServer.getVersionNumber() < 1260) continue;
                    this._goPage.cbx_repserver.addItem((Object)repServer.getName());
                }
            }
            this.setButtons();
        }

        protected void setButtons() {
            Object object = this._goPage.cbx_repserver.getSelectedItem();
            this.enableNextButton(object != null);
        }
    }

    class BiDirectDBPage
    extends BaseWizardPage
    implements ActionListener,
    ListSelectionListener {
        private RepWizMultiPanel _goPage;

        public BiDirectDBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_BIDIRECT_TITLE"));
            this._goPage = new RepWizMultiPanel();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "REP_BIDIRECT_DESC"));
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
            this._goPage.btn_addConn.addActionListener((ActionListener)this);
            this._goPage.btn_removeConn.addActionListener((ActionListener)this);
            this._goPage.lst_conns.addListSelectionListener((ListSelectionListener)this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            RepWizard.this._connList.clear();
            this.load();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            String string = this._goPage.lst_conns.getStringAt(0);
            Dbg.wassert(string != null, "Empty connection list.");
            String string2 = string.toString();
            RepWizard.this._primaryDS = string2.substring(0, string2.indexOf("."));
            RepWizard.this._primaryDB = string2.substring(string2.indexOf(".") + 1);
            RepWizard.this._connList.clear();
            for (int i = 0; i < this._goPage.lst_conns.getItemCount(); ++i) {
                RepWizard.this._connList.add(this._goPage.lst_conns.getStringAt(i));
            }
            return 8;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer) {
                AddServerWizard addServerWizard;
                Domain domain = PluginSupport.getDomain(RepWizard.this.getConnectionName());
                if (domain != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(RepWizard.this.getJDialog()), domain)).showModalDialog()) {
                    List list = addServerWizard.getAttributes();
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                        domain.addServer(connAttributes);
                    }
                    if (!list.isEmpty()) {
                        PluginSupport.refreshDomain(RepWizard.this._container);
                        this.load();
                    }
                }
            } else if (actionEvent.getSource() == this._goPage.btn_addConn) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                Object object2 = this._goPage.cbx_database.getSelectedItem();
                if (object != null && object2 != null) {
                    String string = object.toString();
                    String string2 = object2.toString();
                    String string3 = string + "." + string2;
                    boolean bl = false;
                    for (int i = 0; i < this._goPage.lst_conns.getItemCount(); ++i) {
                        if (!this._goPage.lst_conns.getStringAt(i).equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this._goPage.lst_conns.addItem((Object)string3);
                        this._goPage.lst_conns.setSelectedValue((Object)string3, true);
                    }
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_removeConn) {
                Object[] objectArray = this._goPage.lst_conns.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    int n = this._goPage.lst_conns.findItem((String)objectArray[i], 0, this._goPage.lst_conns.getItemCount(), false, true);
                    if (n < 0 || n >= this._goPage.lst_conns.getItemCount()) continue;
                    this._goPage.lst_conns.removeItem(n);
                }
                this.setButtons();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setButtons();
        }

        protected void load() {
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            RepWizard.this.loadASEServers(this._goPage.cbx_server);
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object = this._goPage.cbx_server.getSelectedItem();
            if (object != null) {
                RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.lst_conns.getItemCount() > 1);
            this._goPage.btn_addConn.setEnabled(this._goPage.cbx_database.getSelectedItem() != null);
            int n = this._goPage.lst_conns.getSelectedIndex();
            this._goPage.btn_removeConn.setEnabled(n >= 0);
        }
    }

    class ReplicateDBPage
    extends BaseWizardPage
    implements ActionListener,
    ListSelectionListener {
        private RepWizMultiPanel _goPage;

        public ReplicateDBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_REPLICATE_TITLE"));
            this._goPage = new RepWizMultiPanel();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "REP_REPLICATE_DESC"));
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
            this._goPage.btn_addConn.addActionListener((ActionListener)this);
            this._goPage.btn_removeConn.addActionListener((ActionListener)this);
            this._goPage.lst_conns.addListSelectionListener((ListSelectionListener)this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            RepWizard.this._connList.clear();
            this.load();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._connList.clear();
            for (int i = 0; i < this._goPage.lst_conns.getItemCount(); ++i) {
                RepWizard.this._connList.add(this._goPage.lst_conns.getStringAt(i));
            }
            return 9;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer) {
                AddServerWizard addServerWizard;
                Domain domain = PluginSupport.getDomain(RepWizard.this.getConnectionName());
                if (domain != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(RepWizard.this.getJDialog()), domain)).showModalDialog()) {
                    List list = addServerWizard.getAttributes();
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                        domain.addServer(connAttributes);
                    }
                    if (!list.isEmpty()) {
                        PluginSupport.refreshDomain(RepWizard.this._container);
                        this.load();
                    }
                }
            } else if (actionEvent.getSource() == this._goPage.btn_addConn) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                Object object2 = this._goPage.cbx_database.getSelectedItem();
                if (object != null && object2 != null) {
                    String string = object.toString();
                    String string2 = object2.toString();
                    String string3 = string + "." + string2;
                    boolean bl = false;
                    for (int i = 0; i < this._goPage.lst_conns.getItemCount(); ++i) {
                        if (!this._goPage.lst_conns.getStringAt(i).equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RepWizard.this.getConnectionName());
                        PhyConnection phyConnection = semanticFactory.getPhyConnection(RepWizard.this._controllingRS, string, string2);
                        try {
                            RepAgent repAgent;
                            phyConnection.load();
                            if (!phyConnection.exists() && (repAgent = semanticFactory.getRepAgent(string, string2)).isEnabled()) {
                                PluginSupport.showWarning(this.getDialogSupport().getParentWindow(), BundleManager.getString("ConnectionRes", "CONN_WIZ_ENABLED_RA_WARNING", string2), null);
                            }
                        }
                        catch (SQLException sQLException) {
                            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        }
                        this._goPage.lst_conns.addItem((Object)string3);
                        this._goPage.lst_conns.setSelectedValue((Object)string3, true);
                    }
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_removeConn) {
                Object[] objectArray = this._goPage.lst_conns.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    int n = this._goPage.lst_conns.findItem((String)objectArray[i], 0, this._goPage.lst_conns.getItemCount(), false, true);
                    if (n < 0 || n >= this._goPage.lst_conns.getItemCount()) continue;
                    this._goPage.lst_conns.removeItem(n);
                }
                this.setButtons();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setButtons();
        }

        protected void load() {
            int n;
            Object object;
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            RepWizard.this.loadASEServers(this._goPage.cbx_server);
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object2 = this._goPage.cbx_server.getSelectedItem();
            if (object2 != null) {
                RepWizard.this.loadDatabases(object2.toString(), this._goPage.cbx_database);
            }
            if ((object = this._goPage.cbx_server.getSelectedItem()) != null && object.toString().equals(RepWizard.this._primaryDS) && (n = this._goPage.cbx_database.findItem(RepWizard.this._primaryDB)) >= 0) {
                this._goPage.cbx_database.removeItemAt(n);
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.lst_conns.getItemCount() > 0);
            this._goPage.btn_addConn.setEnabled(this._goPage.cbx_database.getSelectedItem() != null);
            int n = this._goPage.lst_conns.getSelectedIndex();
            this._goPage.btn_removeConn.setEnabled(n >= 0);
        }
    }

    class PrimaryDBPage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizSinglePanel _goPage;

        public PrimaryDBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_PRIMARY_TITLE"));
            this._goPage = new RepWizSinglePanel();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "REP_PRIMARY_DESC"));
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            this.load();
            if (RepWizard.this._primaryDS != null && RepWizard.this._primaryDS.length() > 0) {
                this._goPage.cbx_server.setSelectedItem(RepWizard.this._primaryDS);
            }
            if (RepWizard.this._primaryDB != null && RepWizard.this._primaryDB.length() > 0) {
                this._goPage.cbx_database.setSelectedItem(RepWizard.this._primaryDB);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._primaryDS = this._goPage.cbx_server.getSelectedItem().toString();
            RepWizard.this._primaryDB = this._goPage.cbx_database.getSelectedItem().toString();
            return 8;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(RepWizard.this.getConnectionName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(RepWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(RepWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            RepWizard.this.loadASEServers(this._goPage.cbx_server);
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object = this._goPage.cbx_server.getSelectedItem();
            if (object != null) {
                RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_database.getSelectedItem() != null);
        }
    }

    class LogNamePage
    extends BaseWizardPage
    implements DocumentListener {
        private RepWizLogicalPanel _goPage;

        public LogNamePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_LOGICAL_TITLE"));
            this._goPage = new RepWizLogicalPanel();
            this._goPage.fld_server.getDocument().addDocumentListener(this);
            this._goPage.fld_database.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            RepWizard.this._logicalDS = BundleManager.getString("DomainRes", "LOG_SERVER_DEFAULT");
            RepWizard.this._logicalDB = RepWizard.this._primaryDB;
        }

        @Override
        public boolean onSetActive() {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RepWizard.this.getConnectionName());
            Dbg.wassert(semanticFactory != null, "Null semantic factory for connection: " + RepWizard.this.getConnectionName());
            PhyConnection phyConnection = semanticFactory.getPhyConnection(RepWizard.this._controllingRS, RepWizard.this._primaryDS, RepWizard.this._primaryDB);
            try {
                phyConnection.load();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (phyConnection.exists()) {
                this._goPage.fld_server.setText(RepWizard.this._primaryDS);
                this._goPage.fld_database.setText(RepWizard.this._primaryDB);
                this._goPage.fld_server.setEnabled(false);
                this._goPage.fld_database.setEnabled(false);
            } else {
                this._goPage.fld_server.setText(RepWizard.this._logicalDS);
                this._goPage.fld_database.setText(RepWizard.this._logicalDB);
                this._goPage.fld_server.setEnabled(true);
                this._goPage.fld_database.setEnabled(true);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._logicalDS = this._goPage.fld_server.getText();
            RepWizard.this._logicalDB = this._goPage.fld_database.getText();
            return 9;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "changedUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "insertUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Dbg.trace(16, "removeUpdate - " + documentEvent.toString());
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_server.getText().trim();
            String string2 = this._goPage.fld_database.getText().trim();
            this.enableNextButton(string.length() > 0 && string2.length() > 0);
        }
    }

    class StandbyDBPage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizSinglePanel _goPage;

        public StandbyDBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_STANDBY_TITLE"));
            this._goPage = new RepWizSinglePanel();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "REP_STANDBY_DESC"));
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            this.load();
            if (RepWizard.this._standbyDS != null && RepWizard.this._standbyDS.length() > 0) {
                this._goPage.cbx_server.setSelectedItem(RepWizard.this._standbyDS);
            }
            if (RepWizard.this._standbyDB != null && RepWizard.this._standbyDB.length() > 0) {
                this._goPage.cbx_database.setSelectedItem(RepWizard.this._standbyDB);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._standbyDS = this._goPage.cbx_server.getSelectedItem().toString();
            RepWizard.this._standbyDB = this._goPage.cbx_database.getSelectedItem().toString();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RepWizard.this.getConnectionName());
            PhyConnection phyConnection = semanticFactory.getPhyConnection(RepWizard.this._controllingRS, RepWizard.this._standbyDS, RepWizard.this._standbyDB);
            try {
                RepAgent repAgent;
                phyConnection.load();
                if (!phyConnection.exists() && (repAgent = semanticFactory.getRepAgent(RepWizard.this._standbyDS, RepWizard.this._standbyDB)).isEnabled()) {
                    PluginSupport.showWarning(this.getDialogSupport().getParentWindow(), BundleManager.getString("ConnectionRes", "CONN_WIZ_ENABLED_RA_WARNING", RepWizard.this._standbyDB), null);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            return 4;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    int n;
                    RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
                    Object object2 = this._goPage.cbx_server.getSelectedItem();
                    if (object2 != null && object2.toString().equals(RepWizard.this._primaryDS) && (n = this._goPage.cbx_database.findItem(RepWizard.this._primaryDB)) >= 0) {
                        this._goPage.cbx_database.removeItemAt(n);
                    }
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(RepWizard.this.getConnectionName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(RepWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(RepWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            RepWizard.this.loadASEServers(this._goPage.cbx_server);
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object = this._goPage.cbx_server.getSelectedItem();
            if (object != null) {
                int n;
                RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
                Object object2 = this._goPage.cbx_server.getSelectedItem();
                if (object2 != null && object2.toString().equals(RepWizard.this._primaryDS) && (n = this._goPage.cbx_database.findItem(RepWizard.this._primaryDB)) >= 0) {
                    this._goPage.cbx_database.removeItemAt(n);
                }
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_database.getSelectedItem() != null);
        }
    }

    class ActiveDBPage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizSinglePanel _goPage;

        public ActiveDBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_ACTIVE_TITLE"));
            this._goPage = new RepWizSinglePanel();
            this._goPage.txt_desc.setText(BundleManager.getString("DomainRes", "REP_ACTIVE_DESC"));
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            this.load();
            if (RepWizard.this._primaryDS != null && RepWizard.this._primaryDS.length() > 0) {
                this._goPage.cbx_server.setSelectedItem(RepWizard.this._primaryDS);
            }
            if (RepWizard.this._primaryDB != null && RepWizard.this._primaryDB.length() > 0) {
                this._goPage.cbx_database.setSelectedItem(RepWizard.this._primaryDB);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            RepWizard.this._primaryDS = this._goPage.cbx_server.getSelectedItem().toString();
            RepWizard.this._primaryDB = this._goPage.cbx_database.getSelectedItem().toString();
            return 8;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(RepWizard.this.getConnectionName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(RepWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(RepWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            RepWizard.this.loadASEServers(this._goPage.cbx_server);
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object = this._goPage.cbx_server.getSelectedItem();
            if (object != null) {
                RepWizard.this.loadDatabases(object.toString(), this._goPage.cbx_database);
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_database.getSelectedItem() != null);
        }
    }

    class RepTypePage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizTypePanel _goPage;

        public RepTypePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_TYPE_TITLE"));
            this._goPage = new RepWizTypePanel();
            this._goPage.btn_ws.addActionListener(this);
            this._goPage.btn_msa.addActionListener(this);
            this._goPage.btn_biDirect.addActionListener(this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public int onWizardNext() {
            int n = -1;
            if (this._goPage.btn_ws.isSelected()) {
                RepWizard.this._type = 0;
                n = 2;
            } else if (this._goPage.btn_msa.isSelected()) {
                RepWizard.this._type = 1;
                n = 5;
            } else if (this._goPage.btn_biDirect.isSelected()) {
                RepWizard.this._type = 2;
                n = 7;
            }
            return n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_ws && this._goPage.btn_ws.isSelected()) {
                this._goPage.btn_msa.setSelected(false);
                this._goPage.btn_biDirect.setSelected(false);
            }
            if (actionEvent.getSource() == this._goPage.btn_msa && this._goPage.btn_msa.isSelected()) {
                this._goPage.btn_ws.setSelected(false);
                this._goPage.btn_biDirect.setSelected(false);
            }
            if (actionEvent.getSource() == this._goPage.btn_biDirect && this._goPage.btn_biDirect.isSelected()) {
                this._goPage.btn_ws.setSelected(false);
                this._goPage.btn_msa.setSelected(false);
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.btn_ws.isSelected() || this._goPage.btn_msa.isSelected() || this._goPage.btn_biDirect.isSelected());
        }
    }
}

