/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.errorclass;

import com.sybase.rsmplugin.components.errorclass.ErrorClass;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainErrorClass
implements ErrorClass {
    private EnvDomain _domain = null;
    private String _name = null;
    private String _rs = null;
    private static final String GET_ERROR_CLASSES = "GET_ERROR_CLASSES";
    private static final Object[][] contents = new Object[][]{{"GET_ERROR_CLASSES", new Integer(1200), "rmp_error_class {0}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainErrorClass(String string, String string2, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._name = string;
        this._rs = string2;
        this._domain = envDomain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getErrorClasses(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<ErrorClass> arrayList = new ArrayList<ErrorClass>();
        int n = envDomain.getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_ERROR_CLASSES, n, string);
        Dbg.wassert(string2 != null, "Unable to get query, repserver version: " + n);
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    ErrorClass errorClass;
                    String string3 = rSMResultSet.getColumnString(2);
                    if (string3 == null || string3.length() <= 0) continue;
                    boolean bl = false;
                    ListIterator listIterator = arrayList.listIterator();
                    while (listIterator.hasNext() && !bl) {
                        errorClass = (ErrorClass)listIterator.next();
                        if (!string3.equals(errorClass.getName())) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    errorClass = new DomainErrorClass(string3, string, envDomain);
                    arrayList.add(errorClass);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty User name attribute.");
        return this._name;
    }

    @Override
    public String getRepServer() {
        Dbg.wassert(this._rs != null && this._rs.length() > 0, "Null or empty Replication Server name attribute.");
        return this._rs;
    }
}

