/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.events;

import com.sybase.central.SCItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseDetailContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASEContainer;
import com.sybase.rsmplugin.components.directconnect.DirectConnectContainer;
import com.sybase.rsmplugin.components.events.AddEventWiz;
import com.sybase.rsmplugin.components.events.EventDetailItem;
import com.sybase.rsmplugin.components.events.RMSEventSO;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentContainer;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentContainer;
import com.sybase.rsmplugin.components.remoterms.RemoteRMSContainer;
import com.sybase.rsmplugin.components.repserver.RepServerContainer;
import com.sybase.rsmplugin.components.rms.RMSContainer;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ListIterator;
import javax.swing.JFrame;

public class EventDetailContainer
extends BaseDetailContainer {
    private static final String CLASS_ID = "events.EventDetailContainer";
    private String _domainName;
    private String _svr;
    private BaseContainer _parent;
    private String[] _headers = null;

    public EventDetailContainer(String string, String string2, String string3, BaseContainer baseContainer) {
        super(string);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(baseContainer != null, "Null parent parameter.");
        this._domainName = string2;
        this._svr = string3;
        this._parent = baseContainer;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public String getServer() {
        return this._svr;
    }

    public BaseContainer getParent() {
        return this._parent;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("EventsRes", "COL_HEADER_TYPE"), BundleManager.getString("EventsRes", "COL_HEADER_SVR_TYPE"), BundleManager.getString("EventsRes", "COL_HEADER_SVR_NAME"), BundleManager.getString("EventsRes", "COL_HEADER_COMP_TYPE"), BundleManager.getString("EventsRes", "COL_HEADER_COMP_NAME"), BundleManager.getString("EventsRes", "COL_HEADER_CHANGE_STATE"), BundleManager.getString("EventsRes", "COL_HEADER_WAIT_TIME"), BundleManager.getString("EventsRes", "COL_HEADER_CONTINUOUS"), BundleManager.getString("EventsRes", "COL_HEADER_SCRIPT")};
    }

    @Override
    public void open(int n) {
        if (!this._parent.isOpen()) {
            return;
        }
        this.close();
        try {
            if (this._parent instanceof RepServerContainer) {
                this.addItem((SCItem)new AddServerTrigger(this._parent));
                this.addItem((SCItem)new AddComponentTrigger(this._parent));
            } else if (!(this._parent instanceof RMSContainer)) {
                this.addItem((SCItem)new AddServerTrigger(this._parent));
            }
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            if (this._parent instanceof RMSContainer) {
                ListIterator listIterator = semanticFactory.getEvents().listIterator();
                while (listIterator.hasNext()) {
                    EventDetailItem eventDetailItem = new EventDetailItem((RMSEventSO)listIterator.next(), this.getDomainName(), this.getParent());
                    this.addItem((SCItem)eventDetailItem);
                }
            } else if (this._parent instanceof RepServerContainer || this._parent instanceof MirrorRepAgentContainer || this._parent instanceof LANRepAgentContainer || this._parent instanceof RemoteRMSContainer || this._parent instanceof DirectConnectContainer || this._parent instanceof ASEContainer) {
                ListIterator listIterator = semanticFactory.getServerEvents(this._svr).listIterator();
                while (listIterator.hasNext()) {
                    EventDetailItem eventDetailItem = new EventDetailItem((RMSEventSO)listIterator.next(), this.getDomainName(), this.getParent());
                    this.addItem((SCItem)eventDetailItem);
                }
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    public boolean onNotify(JFrame jFrame, int n, int n2) {
        return n != 205 || n2 != 1 && n2 != -1;
    }

    class AddComponentTrigger
    extends BaseAddItem {
        public AddComponentTrigger(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("EventsRes", "ADD_COMPONENT_EVENT_ITEM"), RSMImages.getAddTrigger());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(AddEventWiz.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                AddEventWiz addEventWiz = new AddEventWiz(EventDetailContainer.this._domainName, EventDetailContainer.this._svr, this.getParent(), PluginSupport.getDialogSupport(jFrame), false);
                addEventWiz.showDialog();
            }
        }
    }

    class AddServerTrigger
    extends BaseAddItem {
        public AddServerTrigger(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("EventsRes", "ADD_SERVER_EVENT_ITEM"), RSMImages.getAddTrigger());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(AddEventWiz.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                AddEventWiz addEventWiz = new AddEventWiz(EventDetailContainer.this._domainName, EventDetailContainer.this._svr, this.getParent(), PluginSupport.getDialogSupport(jFrame), true);
                addEventWiz.showDialog();
            }
        }
    }
}

