/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.events;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.events.RMSEventSO;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class EventDetailItem
extends BaseItem
implements RMItem {
    private static final String CLASS_ID = "events.EventDetailItem";
    private RMSEventSO _so;
    private String _domain;
    private static ImageIcon _icon = null;
    private static DefaultSCMenu _contextMenu = null;
    private static final String CONNECTION = "connection";
    private static final String LATENCY = "latency";

    public EventDetailItem(RMSEventSO rMSEventSO, String string, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(rMSEventSO != null, "Null RMSEventSO parameter");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        this._so = rMSEventSO;
        this._domain = string;
    }

    public String getDomainName() {
        return this._domain;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (_icon == null) {
            _icon = new ImageIcon(RSMImages.getTrigger());
        }
        return _icon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this._so.getEventType();
            }
            case 1: {
                return this._so.getServerType();
            }
            case 2: {
                return this._so.getServerName();
            }
            case 3: {
                return this._so.getComponentType();
            }
            case 4: {
                String string = this._so.getEventType();
                string.trim();
                String string2 = this._so.getComponentType();
                string2.trim();
                if (string.equalsIgnoreCase(LATENCY) && string2.equalsIgnoreCase(CONNECTION)) {
                    String string3 = this._so.getPrimaryConnection();
                    string3 = string3 + " -> ";
                    string3 = string3 + this._so.getComponentName();
                    return string3;
                }
                return this._so.getComponentName();
            }
            case 5: {
                return this._so.getChangeState();
            }
            case 6: {
                return this._so.getWaitTime();
            }
            case 7: {
                return this._so.getContinuous();
            }
            case 8: {
                return this._so.getScript();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        _contextMenu = new DefaultSCMenu();
        _contextMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        return _contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof EventDetailItem)) continue;
                    ((EventDetailItem)baseItem).deleteEvent();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
        }
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    protected void deleteEvent() {
        try {
            this._so.drop();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }
}

