/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.events;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.BaseSemantic;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RMSEventSO
implements BaseSemantic {
    private RMSDomain _domain = null;
    private String _type = null;
    private String _serverType = null;
    private String _serverName = null;
    private String _componentType = null;
    private String _componentName = null;
    private String _primaryConnection = null;
    private int _changeValue;
    private String _changeState = null;
    private boolean _isExceeds = false;
    private int _waitTime;
    private boolean _continuousFlag = false;
    private String _script = null;
    private static final String GET_RMS_TRIGGERS = "GET_RMS_TRIGGERS";
    private static final String GET_SERVER_TRIGGERS = "GET_SERVER_TRIGGERS";
    private static final String DROP_STATUS_EVENT = "DROP_STATUS_EVENT";
    private static final String DROP_LATENCY_EVENT = "DROP_LATENCY_EVENT";
    private static final String DROP_SIZE_EVENT = "DROP_SIZE_EVENT";
    private static final String GET_RMS_COMPONENT = "GET_RMS_COMPONENT";
    private static final String CREATE_STATUS_EVENT = "CREATE_STATUS_EVENT";
    private static final String CREATE_SIZE_EVENT = "CREATE_SIZE_EVENT";
    private static final String CREATE_LATENCY_EVENT = "CREATE_LATENCY_EVENT";
    private static final String CREATE_LATENCY_PRI_CONN_EVENT = "CREATE_LATENCY_PRI_CONN_EVENT";
    private static final String DROP_LATENCY_PRI_CONN_EVENT = "DROP_LATENCY_PRI_CONN_EVENT";
    private static final Object[][] contents = new Object[][]{{"GET_RMS_TRIGGERS", new Integer(1260), "get triggers"}, {"GET_SERVER_TRIGGERS", new Integer(1260), "get triggers for {0}"}, {"DROP_STATUS_EVENT", new Integer(1260), "drop {0} trigger {1} {2} for {3} status changes to {4}"}, {"DROP_LATENCY_EVENT", new Integer(1260), "drop {0} trigger {1} {2} for {3} latency {4}"}, {"DROP_SIZE_EVENT", new Integer(1260), "drop {0} trigger {1} {2} for {3} size {4}"}, {"GET_RMS_COMPONENT", new Integer(1260), "get {0} for {1}"}, {"CREATE_STATUS_EVENT", new Integer(1260), "add {0} trigger {1} {2} for {3} status changes to {4} wait {5} continuous {6} execute {7}"}, {"CREATE_SIZE_EVENT", new Integer(1260), "add {0} trigger {1} {2} for {3} size {4} wait {5} continuous {6} execute {7}"}, {"CREATE_LATENCY_EVENT", new Integer(1260), "add {0} trigger {1} {2} for {3} latency {4} wait {5} continuous {6} execute {7}"}, {"CREATE_LATENCY_PRI_CONN_EVENT", new Integer(1260), "add latency trigger connection {0} with primary {1} for {2} latency {3} wait {4} continuous {5} execute {6}"}, {"DROP_LATENCY_PRI_CONN_EVENT", new Integer(1260), "drop latency trigger connection {0} with primary {1} for {2} latency {3}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSEventSO(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, int n2, boolean bl, String string8, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty type parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty serverName parameter.");
        Dbg.wassert(string8 != null && string8.length() > 0, "Null or empty script parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._type = string;
        this._serverType = string2;
        this._serverName = string3;
        this._componentType = string4;
        this._componentName = string5;
        this._primaryConnection = string6;
        this._changeValue = n;
        this._changeState = string7;
        this._waitTime = n2;
        this._continuousFlag = bl;
        this._script = string8;
        this._domain = rMSDomain;
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    public String getName() {
        String string = this._componentName != null && this._componentName.length() > 0 ? this.getEventType() + "." + this.getServerName() + "." + this.getComponentName() + "." + this.getChangeState() : this.getEventType() + "." + this.getServerName() + "." + this.getChangeState();
        return string;
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public String getEventType() {
        Dbg.wassert(this._type != null && this._type.length() > 0, "Null or empty data server name attribute.");
        return this._type;
    }

    public String getServerType() {
        Dbg.wassert(this._serverType != null && this._serverType.length() > 0, "Null or empty database name attribute.");
        return this._serverType;
    }

    public String getServerName() {
        Dbg.wassert(this._serverName != null && this._serverName.length() > 0, "Null or empty dbrepdef name attribute.");
        return this._serverName;
    }

    public String getComponentType() {
        return this._componentType;
    }

    public String getComponentName() {
        return this._componentName;
    }

    public String getPrimaryConnection() {
        return this._primaryConnection;
    }

    public String getChangeState() {
        return this._changeState;
    }

    public String getWaitTime() {
        return Integer.toString(this._waitTime);
    }

    public String getContinuous() {
        if (this._continuousFlag) {
            return BundleManager.getString("ComponentRes", "DISP_YES_TEXT");
        }
        return BundleManager.getString("ComponentRes", "DISP_NO_TEXT");
    }

    public String getScript() {
        return this._script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() throws SQLException {
        String string = "";
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            String string2 = this.getChangeState();
            int n = (string2 = string2.toLowerCase()).indexOf("seconds");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf("megabytes")) != -1) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf("percent")) != -1) {
                string2 = string2.substring(0, n);
            }
            int n2 = rMSConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getEventType(), this.getComponentType(), this.getComponentName(), this.getServerName(), string2};
            if (this.getEventType().equalsIgnoreCase("status")) {
                string = _cmdBundle.getCommand(DROP_STATUS_EVENT, n2, objectArray);
            } else if (this.getEventType().equalsIgnoreCase("latency")) {
                if (this.getComponentType().equalsIgnoreCase("connection")) {
                    Object[] objectArray2 = new String[]{this.getComponentName(), this.getPrimaryConnection(), this.getServerName(), string2};
                    string = _cmdBundle.getCommand(DROP_LATENCY_PRI_CONN_EVENT, n2, objectArray2);
                } else {
                    string = _cmdBundle.getCommand(DROP_LATENCY_EVENT, n2, objectArray);
                }
            } else if (this.getEventType().equalsIgnoreCase("SIZE")) {
                string = _cmdBundle.getCommand(DROP_SIZE_EVENT, n2, objectArray);
            }
            Dbg.wassert(string != null && string.length() > 0, "Null or empty command string.");
            try {
                rMSConnection.execute(string);
            }
            finally {
                rMSConnection.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getEvents(RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(rMSDomain != null, "Null domain connnection parameter.");
        ArrayList<RMSEventSO> arrayList = new ArrayList<RMSEventSO>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_RMS_TRIGGERS, n);
            Dbg.wassert(string != null && string.length() > 0, "Null or empty command string.");
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    string2 = string2.toLowerCase();
                    String string3 = rSMResultSet.getColumnString(2);
                    String string4 = rSMResultSet.getColumnString(3);
                    String string5 = rSMResultSet.getColumnString(4);
                    String string6 = rSMResultSet.getColumnString(5);
                    String string7 = rSMResultSet.getColumnString(6);
                    int n2 = rSMResultSet.getColumnInt(7);
                    String string8 = rSMResultSet.getColumnString(8);
                    int n3 = rSMResultSet.getColumnInt(9);
                    boolean bl = rSMResultSet.getColumnBool(10);
                    String string9 = rSMResultSet.getColumnString(11);
                    RMSEventSO rMSEventSO = new RMSEventSO(string2, string3, string4, string5, string6, string7, n2, string8, n3, bl, string9, rMSDomain);
                    arrayList.add(rMSEventSO);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getServerEvents(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(rMSDomain != null, "Null domain connnection parameter.");
        ArrayList<RMSEventSO> arrayList = new ArrayList<RMSEventSO>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            Object[] objectArray = new String[]{string};
            String string2 = _cmdBundle.getCommand(GET_SERVER_TRIGGERS, n, objectArray);
            Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command string.");
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    string3 = string3.toLowerCase();
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    String string6 = rSMResultSet.getColumnString(4);
                    String string7 = rSMResultSet.getColumnString(5);
                    String string8 = rSMResultSet.getColumnString(6);
                    int n2 = rSMResultSet.getColumnInt(7);
                    String string9 = rSMResultSet.getColumnString(8);
                    string9.trim();
                    int n3 = rSMResultSet.getColumnInt(9);
                    boolean bl = rSMResultSet.getColumnBool(10);
                    String string10 = rSMResultSet.getColumnString(11);
                    RMSEventSO rMSEventSO = new RMSEventSO(string3, string4, string5, string6, string7, string8, n2, string9, n3, bl, string10, rMSDomain);
                    arrayList.add(rMSEventSO);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRMSComponents(String string, String string2, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(rMSDomain != null, "Null domain connnection parameter.");
        ArrayList<String> arrayList = new ArrayList<String>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            Object[] objectArray = new String[]{string2, string};
            String string3 = _cmdBundle.getCommand(GET_RMS_COMPONENT, n, objectArray);
            Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty command string.");
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string3);
                while (rSMResultSet.getNextRow()) {
                    String string4 = rSMResultSet.getColumnString(1);
                    String string5 = rSMResultSet.getColumnString(2);
                    String string6 = rSMResultSet.getColumnString(3);
                    arrayList.add(string5);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws SQLException {
        String string = null;
        String string2 = this._continuousFlag ? "true" : "false";
        RMSConnection rMSConnection = this._domain.getRMSConnection();
        if (rMSConnection != null) {
            Object[] objectArray = new String[]{this.getEventType(), this.getComponentType(), this.getComponentName(), this.getServerName(), this.getChangeState(), this.getWaitTime(), string2, this.getScript()};
            int n = rMSConnection.getVersionNumber();
            if (this.getEventType().equalsIgnoreCase("status")) {
                string = _cmdBundle.getCommand(CREATE_STATUS_EVENT, n, objectArray);
            }
            if (this.getEventType().equalsIgnoreCase("latency")) {
                if (this.getComponentType().equalsIgnoreCase("connection")) {
                    Object[] objectArray2 = new String[]{this.getComponentName(), this.getPrimaryConnection(), this.getServerName(), this.getChangeState(), this.getWaitTime(), string2, this.getScript()};
                    string = _cmdBundle.getCommand(CREATE_LATENCY_PRI_CONN_EVENT, n, objectArray2);
                } else {
                    string = _cmdBundle.getCommand(CREATE_LATENCY_EVENT, n, objectArray);
                }
            }
            if (this.getEventType().equalsIgnoreCase("size")) {
                string = _cmdBundle.getCommand(CREATE_SIZE_EVENT, n, objectArray);
            }
            Dbg.wassert(string != null, "Unable to get Create Event command.");
            try {
                rMSConnection.execute(string);
            }
            finally {
                rMSConnection.unlock();
            }
        }
    }

    public static String parseName(String string) {
        String string2 = null;
        String string3 = null;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty queue name parameter.");
        String[] stringArray = string.split("[()]");
        if (stringArray.length < 2) {
            string2 = stringArray[0];
            string3 = "";
        } else {
            string2 = stringArray[0];
            string3 = stringArray[1];
        }
        return string2;
    }
}

