/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.functionrepdef;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.storedprocedure.Parameter;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RepDefParam
implements RSMObjectRow,
Cloneable {
    private String _procName;
    private String _procOwner;
    private boolean _isReplicated;
    private boolean _isSearchable;
    private Parameter _parameter = null;
    private String _repdefDatatype = null;
    private int _repdefLength = 0;
    private int _status = 0;
    protected boolean _isModified = false;
    private EnvDomain _domain = null;
    private static final int COLUMN_COUNT = 4;

    public RepDefParam(String string, String string2, Parameter parameter, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Invalid procOwner parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty procName parameter.");
        Dbg.wassert(parameter != null, "Null or empty param parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._procName = string2;
        this._procOwner = string;
        this._parameter = parameter;
        this._domain = envDomain;
    }

    public Object clone() {
        RepDefParam repDefParam = null;
        try {
            repDefParam = (RepDefParam)super.clone();
            repDefParam._parameter = (Parameter)this._parameter.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Dbg.wassert(false, "Unexpected exception thrown.");
        }
        return repDefParam;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain connection attribute.");
        return this._domain;
    }

    public static List getNewParameters(String string, String string2, String string3, String string4, EnvDomain envDomain) throws SQLException {
        ArrayList<RepDefParam> arrayList = new ArrayList<RepDefParam>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        DataServer dataServer = semanticFactory.getDataServer(string);
        if (dataServer != null) {
            ListIterator listIterator = dataServer.getParameters(string2, string3, string4).listIterator();
            while (listIterator.hasNext()) {
                Parameter parameter = (Parameter)listIterator.next();
                RepDefParam repDefParam = new RepDefParam(string3, string4, parameter, envDomain);
                repDefParam.setReplicated(true);
                repDefParam.setRepDefDatatype(parameter.getDatatype());
                repDefParam.setRepDefLength(parameter.getLength());
                arrayList.add(repDefParam);
            }
        }
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getParamName();
            }
            case 1: {
                return this.getIsReplicatedValue();
            }
            case 2: {
                return this.getIsSearchableValue();
            }
            case 3: {
                return this.getFormattedRepDefDatatype();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    public String getProcName() {
        return this._procName;
    }

    public String getProcOwner() {
        return this._procOwner;
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public String getIsReplicatedValue() {
        if (this.isReplicated()) {
            return BundleManager.getString("ComponentRes", "DISP_YES_TEXT");
        }
        return BundleManager.getString("ComponentRes", "DISP_NO_TEXT");
    }

    public void setReplicated(boolean bl) {
        this._isReplicated = bl;
    }

    public boolean isSearchable() {
        return this._isSearchable;
    }

    public String getIsSearchableValue() {
        if (this.isSearchable()) {
            return BundleManager.getString("ComponentRes", "DISP_YES_TEXT");
        }
        return BundleManager.getString("ComponentRes", "DISP_NO_TEXT");
    }

    public void setSearchable(boolean bl) {
        this._isSearchable = bl;
    }

    public String getParamName() {
        return this._parameter.getName();
    }

    public String getParamDatatype() {
        return this._parameter.getDatatype();
    }

    public int getParamLength() {
        return this._parameter.getLength();
    }

    public int getParamDatatypeID() {
        return this._parameter.getDatatypeID();
    }

    public int getParamID() {
        return this._parameter.getParameterID();
    }

    public String getFormattedParamDatatype() {
        return this._parameter.getFormattedDatatype();
    }

    public String getRepDefDatatype() {
        return this._repdefDatatype;
    }

    public void setRepDefDatatype(String string) {
        this._repdefDatatype = string;
    }

    public int getRepDefLength() {
        return this._repdefLength;
    }

    public void setRepDefLength(int n) {
        this._repdefLength = n;
    }

    public String getFormattedRepDefDatatype() {
        return Parameter.isVariableLengthDatatype(this.getRepDefDatatype()) ? this.getRepDefDatatype() + "(" + String.valueOf(this.getRepDefLength()) + ")" : this.getRepDefDatatype();
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public String getExtendedType() {
        return "";
    }
}

