/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.hds;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.DomainDatabase;
import com.sybase.rsmplugin.components.hds.HDS;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.storedprocedure.DomainStoredProcedure;
import com.sybase.rsmplugin.components.storedprocedure.Parameter;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedure;
import com.sybase.rsmplugin.components.table.Column;
import com.sybase.rsmplugin.components.table.DomainTable;
import com.sybase.rsmplugin.components.table.Table;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.HDSConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public abstract class DomainHDS
extends EnvServerStatusSO
implements HDS,
DataServer,
Comparable {
    private static final String USER_TABLE_TYPE = "U";
    private static final String GET_DATABASES = "GET_DATABASES";
    private static final String USE_DATABASE = "USE_DATABASE";
    private static final String GET_TABLES = "GET_TABLES";
    private static final String GET_TABLE = "GET_TABLE";
    private static final String GET_COLUMNS = "GET_COLUMNS";
    private static final String GET_COLUMNS_KEYS = "GET_COLUMNS_KEYS";
    private static final String GET_STORED_PROCEDURES = "GET_STORED_PROCEDURES";
    private static final String GET_STORED_PROCEDURE = "GET_STORED_PROCEDURE";
    private static final String GET_PARAMETERS = "GET_PARAMETERS";
    private static final String MARK_TABLE_FOR_REPLICATION = "MARK_TABLE_FOR_REPLICATION";
    private static final String MARK_OWNER_TABLE_FOR_REPLICATION = "MARK_OWNER_TABLE_FOR_REPLICATION";
    private static final String UNMARK_TABLE_FOR_REPLICATION = "UNMARK_TABLE_FOR_REPLICATION";
    private static final String MARK_TABLE_INFO = "MARK_TABLE_INFO";
    private static final String MARK_PROC_FOR_REPLICATION = "MARK_PROC_FOR_REPLICATION";
    private static final String UNMARK_PROC_FOR_REPLICATION = "UNMARK_PROC_FOR_REPLICATION";
    private static final String MARK_PROC_INFO = "MARK_PROC_INFO";
    private static final String MARK_COLUMN_FOR_REPLICATION = "MARK_COLUMN_FOR_REPLICATION";
    private static final Object[][] contents = new Object[][]{{"GET_DATABASES", new Integer(1200), "pdb_get_databases"}, {"USE_DATABASE", new Integer(1200), "pdb_set_sql_database {0}"}, {"GET_TABLES", new Integer(1200), "pdb_get_tables"}, {"GET_TABLE", new Integer(1200), "pdb_get_tables {0}, {1}"}, {"GET_COLUMNS", new Integer(1200), "pdb_get_columns {0}, {1}"}, {"GET_COLUMNS_KEYS", new Integer(1200), "pdb_get_primary_keys {0}, {1}"}, {"GET_STORED_PROCEDURES", new Integer(1200), "pdb_get_procedures"}, {"GET_STORED_PROCEDURE", new Integer(1200), "pdb_get_procedures {0}, {1}"}, {"GET_PARAMETERS", new Integer(1200), "pdb_get_procedure_parms {0}, {1}"}, {"MARK_TABLE_FOR_REPLICATION", new Integer(1200), "pdb_setreptable \"{0}\", mark"}, {"MARK_OWNER_TABLE_FOR_REPLICATION", new Integer(1200), "pdb_setreptable \"{0}\", mark, owner"}, {"UNMARK_TABLE_FOR_REPLICATION", new Integer(1200), "pdb_setreptable \"{0}\", unmark, force"}, {"MARK_TABLE_INFO", new Integer(1200), "pdb_setreptable \"{0}\""}, {"MARK_PROC_FOR_REPLICATION", new Integer(1200), "pdb_setrepproc \"{0}\", mark"}, {"UNMARK_PROC_FOR_REPLICATION", new Integer(1200), "pdb_setrepproc \"{0}\", unmark, force"}, {"MARK_PROC_INFO", new Integer(1200), "pdb_setrepproc \"{0}\""}, {"MARK_COLUMN_FOR_REPLICATION", new Integer(1200), "pdb_setrepcol \"{0}\", \"{1}\", {2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);
    private boolean _isInterfaceDC = false;

    public DomainHDS(String string, EnvDomain envDomain) {
        super(string, envDomain);
        Object object;
        HDSConnAttributes hDSConnAttributes = (HDSConnAttributes)envDomain.getServer(string);
        if (hDSConnAttributes != null && (object = hDSConnAttributes.getInterface()) != null) {
            this._isInterfaceDC = ((ConnAttributes)object).getType().equals("DirectConnect");
        }
        if ((object = this.getDomain().getStatus(this.getType(), this.getName())) != null) {
            this.setState(object.getRSState());
            this.setReasons(object.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DomainHDS) {
            return this.getName().compareTo(((DomainHDS)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainHDS object.");
        return -1;
    }

    public boolean isInterfaceDC() {
        return this._isInterfaceDC;
    }

    @Override
    protected ConnAttributes getConnAttributes() {
        HDSConnAttributes hDSConnAttributes = (HDSConnAttributes)this.getDomain().getServer(this.getName());
        return hDSConnAttributes.getInterface();
    }

    @Override
    public String getServerType() {
        String string = "";
        ConnAttributes connAttributes = super.getConnAttributes();
        if (connAttributes != null) {
            string = connAttributes.getDisplayTypeName();
        }
        return string;
    }

    @Override
    public boolean supportsDBs() {
        return true;
    }

    @Override
    public boolean supportsDBLevelReplication() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public abstract String getUDDClass();

    @Override
    public abstract String getFunctionStringClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getDatabases() throws SQLException {
        ArrayList<DomainDatabase> arrayList = new ArrayList<DomainDatabase>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(GET_DATABASES, n);
            Dbg.wassert(string != null, "Unable to get databases command, interface server version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(2);
                    if (string2 == null || string2.length() <= 0) continue;
                    DomainDatabase domainDatabase = new DomainDatabase(this.getName(), string2, this.getDomain());
                    domainDatabase.setStatus(rSMResultSet.getColumnInt(3));
                    domainDatabase.setDBID(rSMResultSet.getColumnInt(4));
                    arrayList.add(domainDatabase);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getTables(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        this.useDatabase(string);
        ArrayList<DomainTable> arrayList = new ArrayList<DomainTable>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_TABLES, n);
            Dbg.wassert(string2 != null, "Unable to retrieve the get_tables command, interface server version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(6);
                    if (!string3.equalsIgnoreCase(USER_TABLE_TYPE)) continue;
                    String string4 = rSMResultSet.getColumnString(3);
                    String string5 = rSMResultSet.getColumnString(4);
                    if (string4 != null && string4.length() > 0 && string5 != null && string5.length() > 0) {
                        DomainTable domainTable = new DomainTable(this.getName(), string, string4, string5, this.getDomain());
                        domainTable.setStatus(rSMResultSet.getColumnInt(5));
                        domainTable.setStat2(rSMResultSet.getColumnInt(7));
                        arrayList.add(domainTable);
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DomainTable getTable(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        this.useDatabase(string);
        DomainTable domainTable = null;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = rSMConnection.getVersionNumber();
        Object[] objectArray = new String[]{string2, string3};
        String string4 = _cmdBundle.getCommand(GET_TABLE, n, objectArray);
        Dbg.wassert(string4 != null, "Unable to retrieve the get_tables command, interface server version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            String string5;
            rSMResultSet.open(string4);
            if (!rSMResultSet.getNextRow() || !(string5 = rSMResultSet.getColumnString(6)).equalsIgnoreCase(USER_TABLE_TYPE)) return domainTable;
            String string6 = rSMResultSet.getColumnString(3);
            String string7 = rSMResultSet.getColumnString(4);
            if (string6 != null && string6.length() > 0 && string6.equals(string2) && string7 != null && string7.length() > 0 && string7.equals(string3)) {
                domainTable = new DomainTable(this.getName(), string, string6, string7, this.getDomain());
                domainTable.setStatus(rSMResultSet.getColumnInt(5));
                domainTable.setStat2(rSMResultSet.getColumnInt(7));
                return domainTable;
            } else {
                Dbg.wassert(false, "Unexpected null or empty column in table result set.");
            }
            return domainTable;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getColumns(String string, String string2, String string3) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        this.useDatabase(string);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            object3 = new String[]{string2, string3};
            String string4 = _cmdBundle.getCommand(GET_COLUMNS, n, (Object[])object3);
            Dbg.wassert(string4 != null, "Unable to retrieve the get columns command, interface server version: " + n);
            object2 = new RSMResultSet(rSMConnection);
            try {
                ((RSMResultSet)object2).open(string4);
                while (((RSMResultSet)object2).getNextRow()) {
                    object = ((RSMResultSet)object2).getColumnString(5);
                    int n2 = ((RSMResultSet)object2).getColumnInt(6);
                    String string5 = ((RSMResultSet)object2).getColumnString(7);
                    int n3 = ((RSMResultSet)object2).getColumnInt(8);
                    int n4 = ((RSMResultSet)object2).getColumnInt(9);
                    int n5 = ((RSMResultSet)object2).getColumnInt(10);
                    Column column = new Column((String)object, string5, n2, n4, n3, n5, this.getDomain());
                    arrayList.add(column);
                }
            }
            finally {
                ((RSMResultSet)object2).close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("HDSRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        ListIterator listIterator = this.getKeyColumns(string, string2, string3).listIterator();
        while (listIterator.hasNext()) {
            object3 = (String)listIterator.next();
            if (object3 == null || ((String)object3).length() <= 0) continue;
            boolean bl = false;
            object2 = arrayList.listIterator();
            while (object2.hasNext() && !bl) {
                object = (Column)object2.next();
                if (!((Column)object).getName().equals(object3)) continue;
                ((Column)object).setKey(true);
                bl = true;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getKeyColumns(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        this.useDatabase(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string2, string3};
            String string4 = _cmdBundle.getCommand(GET_COLUMNS_KEYS, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to retrieve the get key columns command, interface server version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(2);
                    if (string5 != null && string5.length() > 0) {
                        arrayList.add(string5);
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("HDSRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStoredProcedures(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        this.useDatabase(string);
        ArrayList<DomainStoredProcedure> arrayList = new ArrayList<DomainStoredProcedure>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_STORED_PROCEDURES, n);
            Dbg.wassert(string2 != null, "Unable to retrieve the get stored procedure command, interface server version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(3);
                    String string4 = rSMResultSet.getColumnString(4);
                    if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                        DomainStoredProcedure domainStoredProcedure = new DomainStoredProcedure(this.getName(), string, string3, string4, this.getDomain());
                        domainStoredProcedure.setStatus(rSMResultSet.getColumnInt(5));
                        arrayList.add(domainStoredProcedure);
                        continue;
                    }
                    Dbg.wassert(false, "Unexpected null or empty column in table result set.");
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DomainStoredProcedure getStoredProcedure(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty stored procedure name parameter.");
        this.useDatabase(string);
        DomainStoredProcedure domainStoredProcedure = null;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = rSMConnection.getVersionNumber();
        Object[] objectArray = new String[]{string2, string3};
        String string4 = _cmdBundle.getCommand(GET_STORED_PROCEDURE, n, objectArray);
        Dbg.wassert(string4 != null, "Unable to retrieve the get stored procedure command, interface server version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string4);
            if (!rSMResultSet.getNextRow()) return domainStoredProcedure;
            String string5 = rSMResultSet.getColumnString(3);
            String string6 = rSMResultSet.getColumnString(4);
            if (string5 != null && string5.length() > 0 && string5.equals(string2) && string6 != null && string6.length() > 0 && string6.equals(string3)) {
                domainStoredProcedure = new DomainStoredProcedure(this.getName(), string, string5, string6, this.getDomain());
                domainStoredProcedure.setStatus(rSMResultSet.getColumnInt(5));
                return domainStoredProcedure;
            } else {
                Dbg.wassert(false, "Unexpected null or empty column in table result set.");
            }
            return domainStoredProcedure;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getParameters(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string2, string3};
            String string4 = _cmdBundle.getCommand(GET_PARAMETERS, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to retrieve the get parameters command, interface server version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(5);
                    int n2 = rSMResultSet.getColumnInt(6);
                    String string6 = rSMResultSet.getColumnString(7);
                    int n3 = rSMResultSet.getColumnInt(8);
                    int n4 = rSMResultSet.getColumnInt(9);
                    Parameter parameter = new Parameter(string5, string6, n2, n4, n3, 0, this.getDomain());
                    arrayList.add(parameter);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ASERes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void useDatabase(String string) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(USE_DATABASE, n, string);
            Dbg.wassert(string2 != null, "Unable to get the use database command, interface server version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public static List getHDSs(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList<DataServer> arrayList = new ArrayList<DataServer>();
        ListIterator listIterator = envDomain.getHDSNames().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
            DataServer dataServer = semanticFactory.getDataServer(string);
            if (dataServer == null) continue;
            arrayList.add(dataServer);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void monitor() {
        this.setState(5);
        this.clearReasons();
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            try {
                rSMConnection.open();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            switch (rSMConnection.getState()) {
                case 1: {
                    this.setState(5);
                    break;
                }
                case 3: {
                    this.setState(1);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
            String string = rSMConnection.getReason();
            if (string != null && string.length() > 0) {
                this.addReason(string);
            }
        } else {
            this.setState(3);
            return;
        }
        rSMConnection.unlock();
        if (this.isUp()) {
            try {
                this.checkRollupStatus();
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                this.setState(0);
                this.addReason(sQLException.getLocalizedMessage());
            }
        }
    }

    private void checkRollupStatus() throws SQLException {
        this.clearReasons();
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            List list = semanticFactory.getPhyConnectionsForDataServer(this.getName());
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                PhyConnection phyConnection = (PhyConnection)listIterator.next();
                if (phyConnection.isPartOfLogicalConnection() || phyConnection.isUp()) continue;
                this.setState(4);
                this.addReason(phyConnection.getReasons());
            }
        }
        catch (SQLException sQLException) {
            this.setState(4);
            this.addReason(sQLException.getLocalizedMessage());
        }
    }

    @Override
    public String getVersionString() {
        String string = "";
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            string = rSMConnection.getVersionString();
            rSMConnection.unlock();
        }
        return string;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("HDSRes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("HDSRes", "DOWN_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("HDSRes", "SUSPECT_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("HDSRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("HDSRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected HDS State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        this.alter(string, string2, string3, string4, string5, string6, "ASE");
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        ConnAttributes connAttributes = new ConnAttributes();
        connAttributes.setServer(this.getName());
        connAttributes.setType("ASE");
        connAttributes.setUser(string);
        connAttributes.setPassword(string2);
        connAttributes.setCharset(string3);
        connAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
            connAttributes.setHost(string5);
            connAttributes.setPort(string6);
            connAttributes.setSaveAddress(true);
        } else {
            connAttributes.setHost("");
            connAttributes.setPort("");
            connAttributes.setSaveAddress(false);
        }
        ASEConnection aSEConnection = new ASEConnection(connAttributes);
        try {
            aSEConnection.open();
        }
        finally {
            if (aSEConnection != null) {
                aSEConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markTable(String string, String string2, String string3, boolean bl) throws SQLException {
        RSMConnection rSMConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((rSMConnection = this.getRAConnection(this.getName(), string)) != null) {
            try {
                int n = rSMConnection.getVersionNumber();
                String string4 = bl ? _cmdBundle.getCommand(MARK_OWNER_TABLE_FOR_REPLICATION, n, string3) : _cmdBundle.getCommand(MARK_TABLE_FOR_REPLICATION, n, string3);
                Dbg.wassert(string4 != null, "Unable to get mark table command, RA version: " + n);
                rSMConnection.execute(string4);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            Object[] objectArray = new String[]{this.getName(), string};
            throw new SQLException(BundleManager.getString("HDSRes", "RA_FOR_CONN_NOT_FND", objectArray), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkTable(String string, String string2, String string3) throws SQLException {
        RSMConnection rSMConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((rSMConnection = this.getRAConnection(this.getName(), string)) != null) {
            try {
                int n = rSMConnection.getVersionNumber();
                String string4 = _cmdBundle.getCommand(UNMARK_TABLE_FOR_REPLICATION, n, string3);
                Dbg.wassert(string4 != null, "Unable to get unmark table command, RA version: " + n);
                rSMConnection.execute(string4);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            Object[] objectArray = new String[]{this.getName(), string};
            throw new SQLException(BundleManager.getString("HDSRes", "RA_FOR_CONN_NOT_FND", objectArray), "_RSM_", 3);
        }
    }

    @Override
    public boolean isTableMarked(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        boolean bl = false;
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Table table = semanticFactory.getTable(this.getName(), string, string2, string3);
            table.loadTable();
            bl = table.getReplicateStatus();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return bl;
    }

    @Override
    public void ownerQualifyTable(String string, String string2, String string3, boolean bl) throws SQLException {
    }

    @Override
    public boolean isTableOwnerQualified(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        boolean bl = false;
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Table table = semanticFactory.getTable(this.getName(), string, string2, string3);
            table.loadTable();
            bl = table.getOwnerQualifiedStatus();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markStoredProcedure(String string, String string2, String string3) throws SQLException {
        RSMConnection rSMConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty procedure name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((rSMConnection = this.getRAConnection(this.getName(), string)) != null) {
            try {
                int n = rSMConnection.getVersionNumber();
                String string4 = _cmdBundle.getCommand(MARK_PROC_FOR_REPLICATION, n, string3);
                Dbg.wassert(string4 != null, "Unable to get mark procedure command, RA version: " + n);
                rSMConnection.execute(string4);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            Object[] objectArray = new String[]{this.getName(), string};
            throw new SQLException(BundleManager.getString("HDSRes", "RA_FOR_CONN_NOT_FND", objectArray), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkStoredProcedure(String string, String string2, String string3) throws SQLException {
        RSMConnection rSMConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty procedure name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((rSMConnection = this.getRAConnection(this.getName(), string)) != null) {
            try {
                int n = rSMConnection.getVersionNumber();
                String string4 = _cmdBundle.getCommand(UNMARK_PROC_FOR_REPLICATION, n, string3);
                Dbg.wassert(string4 != null, "Unable to get unmark procedure command, RA version: " + n);
                rSMConnection.execute(string4);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            Object[] objectArray = new String[]{this.getName(), string};
            throw new SQLException(BundleManager.getString("HDSRes", "RA_FOR_CONN_NOT_FND", objectArray), "_RSM_", 3);
        }
    }

    @Override
    public boolean isStoredProcedureMarked(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty procedure name parameter.");
        boolean bl = false;
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            StoredProcedure storedProcedure = semanticFactory.getStoredProcedure(this.getName(), string, string2, string3);
            storedProcedure.loadStoredProcedure();
            bl = storedProcedure.getReplicateStatus();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markLOBColumn(String string, String string2, String string3, String string4, boolean bl) throws SQLException {
        RSMConnection rSMConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((rSMConnection = this.getRAConnection(this.getName(), string)) != null) {
            try {
                int n = rSMConnection.getVersionNumber();
                Object[] objectArray = new String[]{string3, string4, "enable"};
                String string5 = _cmdBundle.getCommand(MARK_COLUMN_FOR_REPLICATION, n, objectArray);
                Dbg.wassert(string5 != null, "Unable to get procedure info command, RA version: " + n);
                rSMConnection.execute(string5);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            Object[] objectArray = new String[]{this.getName(), string};
            throw new SQLException(BundleManager.getString("HDSRes", "RA_FOR_CONN_NOT_FND", objectArray), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkLOBColumn(String string, String string2, String string3, String string4) throws SQLException {
        RSMConnection rSMConnection;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty table name parameter.");
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + "." + string3;
        }
        if ((rSMConnection = this.getRAConnection(this.getName(), string)) != null) {
            try {
                int n = rSMConnection.getVersionNumber();
                Object[] objectArray = new String[]{string3, string4, "disable"};
                String string5 = _cmdBundle.getCommand(MARK_COLUMN_FOR_REPLICATION, n, objectArray);
                Dbg.wassert(string5 != null, "Unable to get procedure info command, RA version: " + n);
                rSMConnection.execute(string5);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            Object[] objectArray = new String[]{this.getName(), string};
            throw new SQLException(BundleManager.getString("HDSRes", "RA_FOR_CONN_NOT_FND", objectArray), "_RSM_", 3);
        }
    }

    protected RSMConnection getRAConnection(String string, String string2) throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        LANRepAgent lANRepAgent = semanticFactory.getLANRepAgent(string, string2);
        if (lANRepAgent != null) {
            return this.getDomain().getConnection(lANRepAgent.getName());
        }
        MirrorRepAgent mirrorRepAgent = semanticFactory.getMirrorRepAgent(string, string2);
        if (mirrorRepAgent != null) {
            return this.getDomain().getConnection(mirrorRepAgent.getName());
        }
        return null;
    }
}

