/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.hds;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ServerComponent;
import com.sybase.rsmplugin.components.connection.ConnectionContainer;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.components.database.DatabaseContainer;
import com.sybase.rsmplugin.components.events.EventDetailContainer;
import com.sybase.rsmplugin.components.hds.HDS;
import com.sybase.rsmplugin.components.hds.HDSProp;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.SQLEditor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class HDSContainer
extends BaseContainer
implements RMContainer,
ServerComponent,
StatusItem {
    private static final String CLASS_ID = "hds.HDSContainer";
    private static final int CMD_SQL_EDITOR = 3008;
    private HDS _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;

    public HDSContainer(HDS hDS, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(hDS != null, "Null HDS Semantic object parameter.");
        this._so = hDS;
        StatusManager.addStatusItem(this);
    }

    public HDSContainer(HDS hDS) {
        Dbg.wassert(hDS != null, "Null HDS Semantic object parameter.");
        this._so = hDS;
        StatusManager.addStatusItem(this);
    }

    public HDS getHDS() {
        return this._so;
    }

    @Override
    public void drop() {
        this.getHDS().drop();
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getNonASEUp());
        }
        return _iconUp;
    }

    @Override
    public void setState(int n) {
        this.getHDS().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getHDS().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getHDS().getDomainName();
    }

    @Override
    public String getType() {
        return this.getHDS().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getHDS().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getNonASEUp());
            }
            return _iconUp;
        }
        if (this.getHDS().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getNonASEDown());
            }
            return _iconDown;
        }
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getNonASESuspect());
        }
        return _iconSuspect;
    }

    @Override
    public int getAttributes() {
        if (!this.getHDS().isError()) {
            return 1;
        }
        return super.getAttributes();
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getHDS().getStateString();
            }
            case 2: {
                return this.getHDS().getReason();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        if (!this.getHDS().isControlledByRSMS()) {
            String string = BundleManager.getString("ASERes", "MENU_SQL_EDITOR");
            String string2 = BundleManager.getString("ASERes", "MENU_HINT_SQL_EDITOR");
            char c = BundleManager.getMnemonic("ASERes", "MENU_MNEM_SQL_EDITOR");
            MenuItem menuItem = new MenuItem(3008, string, string2, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getHDS().isError()) {
            return 32;
        }
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3008: {
                SQLEditor.open("");
                break;
            }
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof ServerComponent)) continue;
                    ((ServerComponent)((Object)baseItem)).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(HDSProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                HDSProp hDSProp = new HDSProp(this.getHDS(), this, sCDialogSupport2);
                hDSProp.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            if (!this.getHDS().isError()) {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._so.getDomainName());
                try {
                    List list = semanticFactory.getPhyConnectionsForDataServer(this.getName());
                    ListIterator listIterator = semanticFactory.getDatabases(this.getName()).listIterator();
                    while (listIterator.hasNext()) {
                        BaseContainer baseContainer;
                        Database database = (Database)listIterator.next();
                        PhyConnection phyConnection = this.findConnection(list, database.getName());
                        if (phyConnection != null) {
                            if (phyConnection.isPartOfLogicalConnection() || phyConnection.isRSSD()) continue;
                            baseContainer = new ConnectionContainer(phyConnection, this);
                            this.addItem((SCItem)baseContainer);
                            continue;
                        }
                        baseContainer = new DatabaseContainer(database, this);
                        this.addItem((SCItem)baseContainer);
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
    }

    protected PhyConnection findConnection(List list, String string) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PhyConnection phyConnection = (PhyConnection)listIterator.next();
            if (!phyConnection.getDB().equals(string)) continue;
            return phyConnection;
        }
        return null;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DatabaseRes", "COL_HEADER_DATABASE"), BundleManager.getString("ConnectionRes", "COL_HEADER_RA_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_DSI_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_REASON")};
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        String string = this.getParent().getName();
        if (this.getHDS().isControlledByRSMS()) {
            SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
            SCViewerDetailsPanel2 sCViewerDetailsPanel22 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", (SCDetailsContainer)new EventDetailContainer(BundleManager.getString("EventsRes", "EVENT_TAB"), string, this.getName(), this));
            sCViewerDetailsPanel22.setPanelName(sCViewerDetailsPanel22.getSCDetailsContainer().getDisplayName());
            Object[] objectArray = new Object[]{sCViewerDetailsPanel2, sCViewerDetailsPanel22};
            return objectArray;
        }
        SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
        Object[] objectArray = new Object[]{sCViewerDetailsPanel2};
        return objectArray;
    }
}

