/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.hds;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.CommPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.hds.HDS;
import com.sybase.rsmplugin.components.hds.HDSPropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;

public class HDSProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected HDS _hds;
    protected BaseItem _item;

    HDSProp(HDS hDS, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(hDS != null, "Null HDS parameter.");
        this._hds = hDS;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        try {
            this._hds.loadProperties();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    HDS getHDS() {
        return this._hds;
    }

    @Override
    public String getTitle() {
        Object[] objectArray = new String[]{this.getHDS().getName(), this.getHDS().getServerType()};
        return BundleManager.getString("HDSRes", "PROPERTIES_TITLE", objectArray);
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new CommPage((BaseProperties)this, this.getHDS())};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        return super.onOk();
    }

    @Override
    public void onApply() {
        super.onApply();
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private HDSPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("ConnectionRes", "GENERAL_PAGE_TAG"));
            this._goPage = new HDSPropGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.lbl_name.setText(HDSProp.this.getHDS().getServerType());
            this._goPage.fld_name.setText(HDSProp.this.getHDS().getName());
            this._goPage.fld_version.setText(HDSProp.this.getHDS().getVersionString());
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(HDSProp.this.getHDS().getStateString());
            this._goPage.fld_reason.setText(HDSProp.this.getHDS().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(HDSProp.this.getHDS().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onOk() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), HDSProp.this.getHDS().getReasons(), HDSProp.this.getHDS().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }
    }
}

