/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.lanrepagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndSummaryThread;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentParameter;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RAConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DomainLANRepAgent
extends EnvServerStatusSO
implements LANRepAgent,
Comparable {
    private static final String SHUTDOWN = "SHUTDOWN";
    private static final String RESUME = "RESUME";
    private static final String SUSPEND = "SUSPEND";
    private static final String RA_STATUS = "RA_STATUS";
    private static final String TEST_CONNECTION = "TEST_CONNECTION";
    private static final String PDB_XLOG = "PDB_XLOG";
    private static final String PDB_REMOVE = "PDB_REMOVE";
    private static final Object[][] contents = new Object[][]{{"SHUTDOWN", new Integer(1200), "shutdown"}, {"RESUME", new Integer(1200), "resume"}, {"SUSPEND", new Integer(1200), "suspend"}, {"RA_STATUS", new Integer(1200), "ra_status"}, {"TEST_CONNECTION", new Integer(1200), "test_connection"}, {"PDB_XLOG", new Integer(1200), "pdb_xlog init"}, {"PDB_REMOVE", new Integer(1200), "pdb_xlog remove"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainLANRepAgent(String string, EnvDomain envDomain) {
        super(string, envDomain);
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DomainLANRepAgent) {
            return this.getName().compareTo(((DomainLANRepAgent)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainLANRepAgent object.");
        return -1;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public static LANRepAgent getLANRepAgent(String string, EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        LANRepAgent lANRepAgent = null;
        List list = DomainLANRepAgent.getLANRepAgents(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && lANRepAgent == null) {
                LANRepAgent lANRepAgent2 = (LANRepAgent)listIterator.next();
                if (!lANRepAgent2.getName().equals(string)) continue;
                lANRepAgent = lANRepAgent2;
            }
        }
        return lANRepAgent;
    }

    public static LANRepAgent getLANRepAgent(String string, String string2, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        DomainLANRepAgent domainLANRepAgent = null;
        List list = DomainLANRepAgent.getLANRepAgents(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && domainLANRepAgent == null) {
                DomainLANRepAgent domainLANRepAgent2 = (DomainLANRepAgent)listIterator.next();
                String string3 = domainLANRepAgent2.getConnectionName();
                if (string3 == null || !string3.equals(string + "." + string2)) continue;
                domainLANRepAgent = domainLANRepAgent2;
            }
        }
        return domainLANRepAgent;
    }

    public static List getLANRepAgents(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList<DomainLANRepAgent> arrayList = new ArrayList<DomainLANRepAgent>();
        ListIterator listIterator = envDomain.getLANRepAgentServerNames().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            DomainLANRepAgent domainLANRepAgent = new DomainLANRepAgent(string, envDomain);
            arrayList.add(domainLANRepAgent);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLRAState(RAConnection rAConnection) throws SQLException {
        String string = new String();
        if (rAConnection == null) throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = rAConnection.getVersionNumber();
        String string2 = _cmdBundle.getCommand(RA_STATUS, n);
        Dbg.wassert(string2 != null, "Unable to get ra_status command, LAN Rep Agent version: " + n);
        try {
            RSMResultSet rSMResultSet = new RSMResultSet(rAConnection);
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow()) return 3;
            String string3 = rSMResultSet.getColumnString(1);
            string3 = string3.trim();
            string = rSMResultSet.getColumnString(2);
            this.addReason(string);
            if (string3.equalsIgnoreCase("REPLICATING")) {
                int n2 = 5;
                return n2;
            }
            if (!string3.equalsIgnoreCase("ADMIN")) return 3;
            int n3 = 6;
            return n3;
        }
        finally {
            rAConnection.unlock();
        }
    }

    @Override
    public void loadStatus() {
        this.monitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        this.clearReasons();
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            int n = 0;
            try {
                rAConnection.open();
                n = rAConnection.getState();
            }
            catch (SQLException sQLException) {
                n = rAConnection.getState();
            }
            finally {
                rAConnection.unlock();
            }
            switch (n) {
                case 1: {
                    try {
                        int n2 = this.getLRAState(rAConnection);
                        this.setState(n2);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
                case 3: {
                    this.setState(1);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
            String string = rAConnection.getReason();
            if (string != null && string.length() > 0) {
                this.addReason(string);
            }
        } else {
            this.setState(3);
            return;
        }
    }

    @Override
    public String getVersionString() {
        String string = "";
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            string = rAConnection.getVersionString();
            rAConnection.unlock();
        }
        return string;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("LANRepAgentRes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("LANRepAgentRes", "DOWN_STATE");
                break;
            }
            case 6: {
                string = BundleManager.getString("LANRepAgentRes", "ADMIN_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("LANRepAgentRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("LANRepAgentRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected LANRepAgent State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        this.alter(string, string2, string3, string4, string5, string6, "Replication Agent");
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws SQLException {
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            int n = rAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SHUTDOWN, n);
            Dbg.wassert(string != null, "Unable to get shutdown command, LAN Rep Agent version: " + n);
            try {
                rAConnection.execute(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() == null || !sQLException.getSQLState().equals("JZ006")) {
                    throw sQLException;
                }
                rAConnection.setState(0);
                this.setState(0);
                this.clearReasons();
            }
            finally {
                rAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void resume(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("LANRepAgentRes", "RESUME_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            DomainLANRepAgent domainLANRepAgent = (DomainLANRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("LANRepAgentRes", "RESUME_DLG_TITLE", domainLANRepAgent.getName()));
                            domainLANRepAgent.resume();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainLANRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws SQLException {
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            int n = rAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(RESUME, n);
            Dbg.wassert(string != null, "Unable to get resume route command, repserver version: " + n);
            try {
                rAConnection.execute(string);
                rAConnection.setState(1);
                this.clearReasons();
            }
            finally {
                rAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void suspend(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("LANRepAgentRes", "SUSPEND_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            DomainLANRepAgent domainLANRepAgent = (DomainLANRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("LANRepAgentRes", "SUSPEND_DLG_TITLE", domainLANRepAgent.getName()));
                            domainLANRepAgent.suspend();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainLANRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws SQLException {
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            int n = rAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SUSPEND, n);
            Dbg.wassert(string != null, "Unable to get suspend route command, repserver version: " + n);
            try {
                rAConnection.execute(string);
                rAConnection.setState(1);
                this.setState(4);
                this.clearReasons();
            }
            finally {
                rAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void startInitialize(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("LANRepAgentRes", "INIT_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!3.interrupted() && listIterator.hasNext()) {
                            DomainLANRepAgent domainLANRepAgent = (DomainLANRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("LANRepAgentRes", "INIT_STATUS", domainLANRepAgent.getName()));
                            domainLANRepAgent.initialize();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainLANRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws SQLException {
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            int n = rAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(PDB_XLOG, n);
            Dbg.wassert(string != null, "Unable to get initialization command, rep agent version: " + n);
            try {
                rAConnection.execute(string);
            }
            finally {
                rAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("LANRepAgentRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePDB() throws SQLException {
        RAConnection rAConnection = (RAConnection)this.getDomain().getConnection(this.getName());
        if (rAConnection != null) {
            int n = rAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(PDB_REMOVE, n);
            Dbg.wassert(string != null, "Unable to get remove PDB command, rep agent version: " + n);
            try {
                rAConnection.execute(string);
            }
            finally {
                rAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("LANRepAgentRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void testConnection() {
        final String string = this.getName();
        BkgndSummaryThread bkgndSummaryThread = new BkgndSummaryThread(BundleManager.getString("LANRepAgentRes", "TEST_CONNECTION_TITLE", string), BundleManager.getString("LANRepAgentRes", "TEST_CONNECTION_DESC"), this.getDomainName(), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    try {
                        RAConnection rAConnection = (RAConnection)DomainLANRepAgent.this.getDomain().getConnection(string);
                        if (rAConnection == null) break block7;
                        int n = rAConnection.getVersionNumber();
                        String string3 = _cmdBundle.getCommand(DomainLANRepAgent.TEST_CONNECTION, n);
                        Dbg.wassert(string3 != null, "Unable to get the test connection command, lanrepagent version: " + n);
                        RSMResultSet rSMResultSet = new RSMResultSet(rAConnection);
                        try {
                            String string2;
                            rSMResultSet.open(string3);
                            while (rSMResultSet.getNextRow()) {
                                string2 = "";
                                for (int i = 1; i <= rSMResultSet.getColumnCount(); ++i) {
                                    string2 = string2 + rSMResultSet.getColumnString(i) + " ";
                                }
                                this.setStatus(string2);
                            }
                            string2 = BundleManager.getString("BkgndThreadRes", "STATE_COMPLETED");
                            this.setStatus(string2);
                        }
                        finally {
                            rSMResultSet.close();
                            rAConnection.unlock();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(2, MessageText.formatExceptionMessage(sQLException));
                    }
                }
                DomainLANRepAgent.this.getDomain().refreshStatus();
                this.close();
            }
        };
        bkgndSummaryThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        ConnAttributes connAttributes = new ConnAttributes();
        connAttributes.setServer(this.getName());
        connAttributes.setType("ASE");
        connAttributes.setUser(string);
        connAttributes.setPassword(string2);
        connAttributes.setCharset(string3);
        connAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
            connAttributes.setHost(string5);
            connAttributes.setPort(string6);
            connAttributes.setSaveAddress(true);
        } else {
            connAttributes.setHost("");
            connAttributes.setPort("");
            connAttributes.setSaveAddress(false);
        }
        RAConnection rAConnection = new RAConnection(connAttributes);
        try {
            rAConnection.open();
        }
        finally {
            if (rAConnection != null) {
                rAConnection.close();
            }
        }
    }

    @Override
    public String getSourceDS() throws SQLException {
        String string = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        LANRepAgentParameter lANRepAgentParameter = semanticFactory.getLANRepAgentParameter(this.getName(), "rs_source_ds");
        if (lANRepAgentParameter != null && (string = lANRepAgentParameter.getCurrentValue()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String getSourceDB() throws SQLException {
        String string = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        LANRepAgentParameter lANRepAgentParameter = semanticFactory.getLANRepAgentParameter(this.getName(), "rs_source_db");
        if (lANRepAgentParameter != null && (string = lANRepAgentParameter.getCurrentValue()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String getConnectionName() throws SQLException {
        String string = null;
        String string2 = this.getSourceDS();
        String string3 = this.getSourceDB();
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            string = string2 + "." + string3;
        }
        return string;
    }
}

