/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.lanrepagent;

import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentStatistic;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RAConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainRepAgentStatistic
extends LANRepAgentStatistic
implements RSMObjectRow {
    private EnvDomain _domain = null;
    private static final String GET_STATS = "GET_STATS";
    private static final String RESET_STATS = "RESET_STATS";
    private static final Object[][] contents = new Object[][]{{"GET_STATS", new Integer(1200), "ra_statistics"}, {"RESET_STATS", new Integer(1200), "ra_statistics reset"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainRepAgentStatistic(String string, String string2, String string3, EnvDomain envDomain) {
        super(string, string2, string3);
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRepAgentStatistics(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep agent name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<DomainRepAgentStatistic> arrayList = new ArrayList<DomainRepAgentStatistic>();
        RAConnection rAConnection = (RAConnection)envDomain.getConnection(string);
        if (rAConnection != null) {
            int n = envDomain.getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(GET_STATS, n);
            Dbg.wassert(string2 != null, "Unable to get statistics query command, repagent version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rAConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    DomainRepAgentStatistic domainRepAgentStatistic = new DomainRepAgentStatistic(string3, string4, string5, envDomain);
                    arrayList.add(domainRepAgentStatistic);
                }
            }
            finally {
                rSMResultSet.close();
                rAConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStatistics(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep agent name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        RAConnection rAConnection = (RAConnection)envDomain.getConnection(string);
        if (rAConnection != null) {
            int n = envDomain.getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(RESET_STATS, n);
            Dbg.wassert(string2 != null, "Unable to reset statistics query command, repagent version: " + n);
            try {
                rAConnection.execute(string2);
            }
            finally {
                rAConnection.unlock();
            }
        }
    }
}

