/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.lanrepagent;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ServerComponent;
import com.sybase.rsmplugin.components.connection.ConnectionItem;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.events.EventDetailContainer;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentProp;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentStatisticsDlg;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class LANRepAgentContainer
extends BaseContainer
implements RMContainer,
ServerComponent,
StatusItem {
    private static final String CLASS_ID = "lanrepagent.LANRepAgentContainer";
    private static final int CMD_TEST_CONNECTION = 3008;
    private static final int CMD_INITIALIZE = 3009;
    private static final int CMD_STATISTICS = 3010;
    private LANRepAgent _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;

    public LANRepAgentContainer(LANRepAgent lANRepAgent, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(lANRepAgent != null, "Null LANRepAgent Semantic object parameter.");
        this._so = lANRepAgent;
        StatusManager.addStatusItem(this);
    }

    public LANRepAgentContainer(LANRepAgent lANRepAgent) {
        Dbg.wassert(lANRepAgent != null, "Null LANRepAgent Semantic object parameter.");
        this._so = lANRepAgent;
        StatusManager.addStatusItem(this);
    }

    public LANRepAgent getLANRepAgent() {
        return this._so;
    }

    @Override
    public void drop() {
        this.getLANRepAgent().drop();
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getRepAgentUp());
        }
        return _iconUp;
    }

    @Override
    public void setState(int n) {
        this.getLANRepAgent().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getLANRepAgent().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getLANRepAgent().getDomainName();
    }

    @Override
    public String getType() {
        return this.getLANRepAgent().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getLANRepAgent().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getRepAgentUp());
            }
            return _iconUp;
        }
        if (this.getLANRepAgent().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getRepAgentDown());
            }
            return _iconDown;
        }
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getRepAgentSuspect());
        }
        return _iconSuspect;
    }

    @Override
    public int getAttributes() {
        if (!this.getLANRepAgent().isError()) {
            return 1;
        }
        return super.getAttributes();
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getLANRepAgent().getName();
            }
            case 1: {
                return this.getLANRepAgent().getStateString();
            }
            case 2: {
                return this.getLANRepAgent().getReason();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        if (this.getLANRepAgent().isError()) {
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        } else {
            MenuItem menuItem;
            char c;
            String string;
            String string2;
            if (!this.getLANRepAgent().isControlledByRSMS()) {
                string2 = BundleManager.getString("LANRepAgentRes", "MENU_TEST_CONNECTION");
                string = BundleManager.getString("LANRepAgentRes", "MENU_HINT_TEST_CONNECTION");
                c = BundleManager.getMnemonic("LANRepAgentRes", "MENU_MNEM_TEST_CONNECTION");
                menuItem = new MenuItem(3008, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("LANRepAgentRes", "MENU_INITIALIZE");
                string = BundleManager.getString("LANRepAgentRes", "MENU_HINT_INITIALIZE");
                c = BundleManager.getMnemonic("LANRepAgentRes", "MENU_MNEM_INITIALIZE");
                menuItem = new MenuItem(3009, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("LANRepAgentRes", "MENU_STATISTICS");
                string = BundleManager.getString("LANRepAgentRes", "MENU_HINT_STATISTICS");
                c = BundleManager.getMnemonic("LANRepAgentRes", "MENU_MNEM_STATISTICS");
                menuItem = new MenuItem(3010, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            }
            string2 = BundleManager.getString("LANRepAgentRes", "MENU_RESUME");
            string = BundleManager.getString("LANRepAgentRes", "MENU_HINT_RESUME");
            c = BundleManager.getMnemonic("LANRepAgentRes", "MENU_MNEM_RESUME");
            menuItem = new MenuItem(3006, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            string2 = BundleManager.getString("LANRepAgentRes", "MENU_SUSPEND");
            string = BundleManager.getString("LANRepAgentRes", "MENU_HINT_SUSPEND");
            c = BundleManager.getMnemonic("LANRepAgentRes", "MENU_MNEM_SUSPEND");
            menuItem = new MenuItem(3007, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            string2 = BundleManager.getString("LANRepAgentRes", "MENU_SHUTDOWN");
            string = BundleManager.getString("LANRepAgentRes", "MENU_HINT_SHUTDOWN");
            c = BundleManager.getMnemonic("LANRepAgentRes", "MENU_MNEM_SHUTDOWN");
            menuItem = new MenuItem(3005, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        }
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getLANRepAgent().isError()) {
            return 32;
        }
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106 || n == 3007 || n == 3006 || n == 3009;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3008: {
                this.getLANRepAgent().testConnection();
                break;
            }
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof ServerComponent)) continue;
                    ((ServerComponent)((Object)baseItem)).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(LANRepAgentProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                LANRepAgentProp lANRepAgentProp = new LANRepAgentProp(this.getLANRepAgent(), this, sCDialogSupport2);
                lANRepAgentProp.showDialog();
                break;
            }
            case 3010: {
                BaseController baseController = PluginSupport.getDialog(LANRepAgentStatisticsDlg.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                LANRepAgentStatisticsDlg lANRepAgentStatisticsDlg = new LANRepAgentStatisticsDlg(sCDialogSupport2, this.getLANRepAgent());
                lANRepAgentStatisticsDlg.showDialog();
                break;
            }
            case 3005: {
                String string = BundleManager.getString("RepServerRes", "CONFIRM_SHUTDOWN", this.getName());
                if (!PluginSupport.askQuestion(string, false)) break;
                PluginSupport.getViewerSupport().startWait();
                try {
                    this.getLANRepAgent().shutdown();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                StatusManager.refresh(this.getDomainName(), this.getType(), this.getName());
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3007: {
                if (!PluginSupport.askQuestion(BundleManager.getString("LANRepAgentRes", "CONFIRM_SUSPEND", this.getName()))) break;
                ArrayList<LANRepAgent> arrayList = new ArrayList<LANRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof LANRepAgentContainer)) continue;
                    arrayList.add(((LANRepAgentContainer)baseItem).getLANRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getLANRepAgent().suspend(arrayList);
                break;
            }
            case 3006: {
                if (!PluginSupport.askQuestion(BundleManager.getString("LANRepAgentRes", "CONFIRM_RESUME", this.getName()))) break;
                ArrayList<LANRepAgent> arrayList = new ArrayList<LANRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof LANRepAgentContainer)) continue;
                    arrayList.add(((LANRepAgentContainer)baseItem).getLANRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getLANRepAgent().resume(arrayList);
                break;
            }
            case 3009: {
                if (!PluginSupport.askQuestion(BundleManager.getString("LANRepAgentRes", "CONFIRM_INIT", this.getName()))) break;
                ArrayList<LANRepAgent> arrayList = new ArrayList<LANRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof LANRepAgentContainer)) continue;
                    arrayList.add(((LANRepAgentContainer)baseItem).getLANRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getLANRepAgent().startInitialize(arrayList);
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getLANRepAgent().getDomainName());
            try {
                ListIterator listIterator = semanticFactory.getPhyConnectionsForLANRepAgent(this.getName()).listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    ConnectionItem connectionItem = new ConnectionItem(phyConnection, this);
                    this.addItem((SCItem)connectionItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        String string = this.getParent().getName();
        if (this.getLANRepAgent().isControlledByRSMS()) {
            SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
            SCViewerDetailsPanel2 sCViewerDetailsPanel22 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", (SCDetailsContainer)new EventDetailContainer(BundleManager.getString("EventsRes", "EVENT_TAB"), string, this.getName(), this));
            sCViewerDetailsPanel22.setPanelName(sCViewerDetailsPanel22.getSCDetailsContainer().getDisplayName());
            Object[] objectArray = new Object[]{sCViewerDetailsPanel2, sCViewerDetailsPanel22};
            return objectArray;
        }
        SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
        Object[] objectArray = new Object[]{sCViewerDetailsPanel2};
        return objectArray;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("ConnectionRes", "COL_HEADER_CONN"), BundleManager.getString("ConnectionRes", "COL_HEADER_RA_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_DSI_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_REASON")};
    }
}

