/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.lanrepagent;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.CommPage;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentParameter;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentPropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;

public class LANRepAgentProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected LANRepAgent _lanrepagent;
    protected BaseItem _item;
    protected List _paramList;

    LANRepAgentProp(LANRepAgent lANRepAgent, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(lANRepAgent != null, "Null LANRepAgent parameter.");
        this._lanrepagent = lANRepAgent;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(lANRepAgent.getDomainName());
        try {
            this._paramList = semanticFactory.getLANRepAgentParameters(lANRepAgent.getName());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
        try {
            this._lanrepagent.loadProperties();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    LANRepAgent getLANRepAgent() {
        return this._lanrepagent;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("LANRepAgentRes", "PROPERTIES_TITLE", this.getLANRepAgent().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new CommPage((BaseProperties)this, this.getLANRepAgent()), new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            LANRepAgentParameter lANRepAgentParameter = (LANRepAgentParameter)listIterator.next();
            if (lANRepAgentParameter == null) continue;
            try {
                lANRepAgentParameter.alter(this.getLANRepAgent().getName());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            LANRepAgentParameter lANRepAgentParameter = (LANRepAgentParameter)listIterator.next();
            if (lANRepAgentParameter == null) continue;
            try {
                lANRepAgentParameter.alter(this.getLANRepAgent().getName());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            super.onApply();
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private LANRepAgentPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("LANRepAgentRes", "GENERAL_PAGE_TAG"));
            this._goPage = new LANRepAgentPropGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(LANRepAgentProp.this.getLANRepAgent().getName());
            this._goPage.fld_version.setText(LANRepAgentProp.this.getLANRepAgent().getVersionString());
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(LANRepAgentProp.this.getLANRepAgent().getStateString());
            this._goPage.fld_reason.setText(LANRepAgentProp.this.getLANRepAgent().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(LANRepAgentProp.this.getLANRepAgent().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onOk() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), LANRepAgentProp.this.getLANRepAgent().getReasons(), LANRepAgentProp.this.getLANRepAgent().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }
    }
}

