/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.lanrepagent;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.lanrepagent.DomainRepAgentStatistic;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.RepAgentStatsPanel;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;

public class LANRepAgentStatisticsDlg
extends BaseDialog {
    protected SCPageController[] _page = null;
    protected LANRepAgent _ra;

    public LANRepAgentStatisticsDlg(SCDialogSupport2 sCDialogSupport2, LANRepAgent lANRepAgent) {
        super(sCDialogSupport2);
        Dbg.wassert(lANRepAgent != null, "Null Rep Agent parameter.");
        this._ra = lANRepAgent;
    }

    public LANRepAgent getRepAgent() {
        return this._ra;
    }

    @Override
    public void showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(false);
        this.getDialogSupport().setHelpButton(false);
        PluginSupport.registerDialog(this);
        this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("LANRepAgentRes", "STAT_DLG_TITLE", this.getRepAgent().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new StatPage()};
        }
        return this._page;
    }

    class StatPage
    extends BasePage
    implements ActionListener {
        private RepAgentStatsPanel _goPage = new RepAgentStatsPanel();

        @Override
        public void onInitDialog() {
            this._goPage.btn_refresh.addActionListener((ActionListener)this);
            this._goPage.btn_reset.addActionListener((ActionListener)this);
            this._goPage.btn_close.addActionListener((ActionListener)this);
            this.displayStatistics();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_refresh) {
                this.displayStatistics();
            } else if (actionEvent.getSource() == this._goPage.btn_reset) {
                this.resetStatistics();
            } else if (actionEvent.getSource() == this._goPage.btn_close) {
                LANRepAgentStatisticsDlg.this.closeDialog();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayStatistics() {
            this._goPage.tbl_stats.clear();
            Domain domain = PluginSupport.getDomain(LANRepAgentStatisticsDlg.this.getRepAgent().getDomainName());
            try {
                LANRepAgentStatisticsDlg.this.getDialogSupport().startWait();
                List list = DomainRepAgentStatistic.getRepAgentStatistics(LANRepAgentStatisticsDlg.this.getRepAgent().getName(), (EnvDomain)domain);
                if (list.size() > 0) {
                    this._goPage.tbl_stats.addRows(list);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                LANRepAgentStatisticsDlg.this.getDialogSupport().endWait();
            }
            if (this._goPage.tbl_stats.getRowCount() > 0) {
                this._goPage.tbl_stats.requestFocus();
            }
            this._goPage.tbl_stats.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resetStatistics() {
            Domain domain = PluginSupport.getDomain(LANRepAgentStatisticsDlg.this.getRepAgent().getDomainName());
            try {
                LANRepAgentStatisticsDlg.this.getDialogSupport().startWait();
                DomainRepAgentStatistic.resetStatistics(LANRepAgentStatisticsDlg.this.getRepAgent().getName(), (EnvDomain)domain);
                this.displayStatistics();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                LANRepAgentStatisticsDlg.this.getDialogSupport().endWait();
            }
            if (this._goPage.tbl_stats.getRowCount() > 0) {
                this._goPage.tbl_stats.requestFocus();
            }
            this._goPage.tbl_stats.refresh();
        }
    }
}

