/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.CmdSummaryDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogWizConnPanel;
import com.sybase.rsmplugin.components.logical.LogWizEnablePanel;
import com.sybase.rsmplugin.components.logical.LogWizExistingPanel;
import com.sybase.rsmplugin.components.logical.LogWizNamePanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddLogConnWizard
extends BaseWizard {
    protected SCPageController[] _pages = null;
    protected BaseContainer _container;
    protected String _domainName = null;
    protected String _controllingRS = null;
    protected boolean _existingConn = false;
    protected String _LDS = null;
    protected String _LDB = null;
    protected boolean _enableDBRep = false;

    public AddLogConnWizard(BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2, String string, String string2) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null BaseContainer parameter.");
        this._container = baseContainer;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        this._controllingRS = string;
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty environment name parameter.");
        this._domainName = string2;
    }

    public String getDomainName() {
        Dbg.wassert(this._domainName != null && this._domainName.length() > 0, "Null or empty domain name attribute.");
        return this._domainName;
    }

    public String getControllingRS() {
        Dbg.wassert(this._controllingRS != null && this._controllingRS.length() > 0, "Null controlling rep server name attribute.");
        return this._controllingRS;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("LogicalConnectionRes", "ADD_LOG_CONN_TITLE");
    }

    public String getLogName() {
        if (this._LDS != null && this._LDS.length() > 0 && this._LDB != null && this._LDB.length() > 0) {
            return this._LDS + "." + this._LDB;
        }
        return "";
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new ExistingPage(this), new ConnectionPage(this), new EnablePage(this), new NamePage(this), new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    return AddLogConnWizard.this.toFormattedString();
                }
            }};
        }
        return this._pages;
    }

    public String toFormattedString() {
        String string = "";
        string = this._existingConn ? string + BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_SUM_EXIST_CONN") + "\n" : string + BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_SUM_NEW_LOG") + "\n";
        string = string + BundleManager.getString("LogicalConnectionRes", "SUMMARY_LOGICAL", this.getLogName()) + "\n";
        string = string + BundleManager.getString("LogicalConnectionRes", "SUMMARY_RS", this.getControllingRS()) + "\n";
        if (this._existingConn) {
            string = this._enableDBRep ? string + BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_ENABLE_DB") + "\n" : string + BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_REP_ONLY_SELECTED") + "\n";
        }
        return string;
    }

    @Override
    public boolean onWizardFinish() {
        Object object;
        boolean bl = true;
        this.getDialogSupport().startWait();
        ArrayList<String> arrayList = new ArrayList<String>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Null semantic factory for connection: " + this.getDomainName());
        LogConnection logConnection = semanticFactory.getLogConnection(this._controllingRS, this._LDS, this._LDB);
        Dbg.wassert(logConnection != null, "Cannot create logical connection: " + this._LDS + "." + this._LDB);
        try {
            arrayList.add("I. " + BundleManager.getString("LogicalConnectionRes", "SUMMARY_CREATE_LOG", logConnection.getName()));
            logConnection.create();
        }
        catch (SQLException sQLException) {
            String string = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            arrayList.add("E. " + string);
            bl = false;
        }
        if (bl && this._existingConn) {
            if (this._enableDBRep) {
                object = semanticFactory.getRepAgent(this._LDS, this._LDB);
                arrayList.add("I. " + BundleManager.getString("ConnectionRes", "CONN_CMD_SUM_CFG_RA", this._LDB));
                try {
                    object.setRepToStandby();
                }
                catch (SQLException sQLException) {
                    String string = MessageText.formatExceptionMessage(sQLException);
                    PluginSupport.LogErrorMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
                    arrayList.add("W. " + string);
                }
            }
            object = semanticFactory.getPhyConnection(this._controllingRS, this._LDS, this._LDB);
            object.changeToActive(arrayList);
        }
        this.getDialogSupport().endWait();
        if (arrayList.size() > 0) {
            arrayList.add(BundleManager.getString("LogicalConnectionRes", "END_OF_PROCESS_SUMMARY"));
            object = new CmdSummaryDlg(PluginSupport.getDialogSupport(this.getJDialog()), arrayList);
            ((CmdSummaryDlg)object).setDescription(this.getTitle());
            ((CmdSummaryDlg)object).showDialog();
        }
        if (bl) {
            bl = super.onWizardFinish();
        }
        PluginSupport.refreshDomain(this._container);
        return bl;
    }

    class NamePage
    extends BaseWizardPage
    implements DocumentListener {
        private LogWizNamePanel _goPage;

        public NamePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_NAME_DESC"));
            this._goPage = new LogWizNamePanel();
            this._goPage.fld_LDS.getDocument().addDocumentListener(this);
            this._goPage.fld_LDB.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.fld_LDS.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddLogConnWizard.this._LDS = this._goPage.fld_LDS.getText();
            AddLogConnWizard.this._LDB = this._goPage.fld_LDB.getText();
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_LDS.getText();
            String string2 = this._goPage.fld_LDB.getText();
            this.enableNextButton(string != null && string.length() > 0 && string2 != null && string2.length() > 0);
        }
    }

    class EnablePage
    extends BaseWizardPage {
        private LogWizEnablePanel _goPage;

        public EnablePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_ENABLE_TITLE"));
            this._goPage = new LogWizEnablePanel();
            this.enableBackButton(true);
            this.enableNextButton(true);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.cbx_enable.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddLogConnWizard.this._enableDBRep = this._goPage.cbx_enable.isSelected();
            return 5;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }
    }

    class ConnectionPage
    extends BaseWizardPage
    implements ListSelectionListener {
        private LogWizConnPanel _goPage;

        public ConnectionPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_CONN_TITLE"));
            this._goPage = new LogWizConnPanel();
            this.enableBackButton(true);
            this._goPage.lst_conns.setSelectionMode(0);
            this._goPage.lst_conns.addListSelectionListener((ListSelectionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this.loadConnList();
            int n = this._goPage.lst_conns.findItem(AddLogConnWizard.this.getLogName());
            if (n >= 0) {
                this._goPage.lst_conns.selectItem(n);
            }
            this.setButtons();
            this._goPage.lst_conns.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            int n = this._goPage.lst_conns.getSelectedIndex();
            Dbg.wassert(n >= 0, "No selection in list");
            String string = this._goPage.lst_conns.getStringAt(n);
            n = string.indexOf(".");
            Dbg.wassert(n >= 0, "Invalid connection name format.");
            AddLogConnWizard.this._LDS = string.substring(0, n);
            AddLogConnWizard.this._LDB = string.substring(n + 1, string.length());
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setButtons();
        }

        protected void loadConnList() {
            this._goPage.lst_conns.clear();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddLogConnWizard.this.getDomainName());
            if (semanticFactory != null) {
                try {
                    List list = semanticFactory.getPhyConnections(AddLogConnWizard.this.getControllingRS());
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        PhyConnection phyConnection = (PhyConnection)listIterator.next();
                        if (!phyConnection.isPrimary() || phyConnection.isRSSD() || phyConnection.isPartOfLogicalConnection()) continue;
                        this._goPage.lst_conns.addItem((Object)phyConnection.getName());
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }

        protected void setButtons() {
            this.enableNextButton(!this._goPage.lst_conns.isSelectionEmpty());
        }
    }

    class ExistingPage
    extends BaseWizardPage {
        private LogWizExistingPanel _goPage;

        public ExistingPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "LOG_WIZ_EXIST_TITLE"));
            this._goPage = new LogWizExistingPanel();
            this.enableNextButton(true);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.cbx_existing.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            if (this._goPage.cbx_existing.isSelected()) {
                AddLogConnWizard.this._existingConn = this._goPage.cbx_existing.isSelected();
                return 0;
            }
            return 4;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }
    }
}

