/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.CmdSummaryDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.database.Database;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.environment.RepWizRAPanel;
import com.sybase.rsmplugin.components.environment.RepWizWSMatPanel;
import com.sybase.rsmplugin.components.logical.ActiveWizMaintPanel;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionBase;
import com.sybase.rsmplugin.components.logical.StandbyWizDBPanel;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddStandbyConnWizard
extends BaseWizard {
    protected SCPageController[] _pages = null;
    protected LogConnectionBase _container;
    protected String _domainName = null;
    protected String _controllingRS = null;
    protected String _ds = null;
    protected String _db = null;
    protected String _maintUser = null;
    protected String _maintPwd = null;
    protected String _raUser = null;
    protected String _raPwd = null;
    protected boolean _wsMaterialize = false;
    protected boolean _useMarker = false;

    public AddStandbyConnWizard(LogConnectionBase logConnectionBase, SCDialogSupport2 sCDialogSupport2, String string, String string2) {
        super(sCDialogSupport2);
        Dbg.wassert(logConnectionBase != null, "Null BaseContainer parameter.");
        this._container = logConnectionBase;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server name parameter.");
        this._controllingRS = string;
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty environment name parameter.");
        this._domainName = string2;
    }

    public String getDomainName() {
        Dbg.wassert(this._domainName != null && this._domainName.length() > 0, "Null or empty domain name attribute.");
        return this._domainName;
    }

    public String getControllingRS() {
        Dbg.wassert(this._controllingRS != null && this._controllingRS.length() > 0, "Null controlling rep server name attribute.");
        return this._controllingRS;
    }

    public LogConnection getLogConnection() {
        return this._container.getLogConnection();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("LogicalConnectionRes", "ADD_STANDBY_CONN_TITLE");
    }

    public String getStandbyName() {
        if (this._ds != null && this._ds.length() > 0 && this._db != null && this._db.length() > 0) {
            return this._ds + "." + this._db;
        }
        return "";
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new DBPage(this), new MaintPage(this), new RAPage(this), new MaterializePage(this), new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    return AddStandbyConnWizard.this.toFormattedString();
                }
            }};
        }
        return this._pages;
    }

    public String toFormattedString() {
        String string = BundleManager.getString("LogicalConnectionRes", "SUMMARY_STANDBY", this.getStandbyName()) + "\n";
        string = string + BundleManager.getString("LogicalConnectionRes", "SUMMARY_RS", this.getControllingRS()) + "\n";
        string = string + BundleManager.getString("LogicalConnectionRes", "SUMMARY_MAINT_USER", this._maintUser) + "\n";
        string = string + BundleManager.getString("LogicalConnectionRes", "SUMMARY_RA_USER", this._raUser) + "\n";
        if (this._wsMaterialize) {
            string = string + BundleManager.getString("DomainRes", "REP_WS_MAT_SUM") + "\n";
            if (this._useMarker) {
                string = string + BundleManager.getString("DomainRes", "REP_SUM_MARKER") + "\n";
            }
        }
        return string;
    }

    @Override
    public boolean onWizardFinish() {
        boolean bl = true;
        this.getDialogSupport().startWait();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this._container.getLogConnection().getLDS();
        String string2 = this._container.getLogConnection().getLDB();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Null semantic factory for connection: " + this.getDomainName());
        PhyConnection phyConnection = semanticFactory.getPhyConnection(this._controllingRS, this._ds, this._db);
        phyConnection.setMaintUser(this._maintUser);
        phyConnection.setMaintPwd(this._maintPwd);
        phyConnection.setLDS(string);
        phyConnection.setLDB(string2);
        bl = phyConnection.createStandby(this._raUser, this._raPwd, this._wsMaterialize, this._useMarker, arrayList);
        this.getDialogSupport().endWait();
        if (arrayList.size() > 0) {
            arrayList.add(BundleManager.getString("LogicalConnectionRes", "END_OF_PROCESS_SUMMARY"));
            CmdSummaryDlg cmdSummaryDlg = new CmdSummaryDlg(PluginSupport.getDialogSupport(this.getJDialog()), arrayList);
            cmdSummaryDlg.setDescription(this.getTitle());
            cmdSummaryDlg.showDialog();
        }
        if (bl) {
            bl = super.onWizardFinish();
        }
        PluginSupport.refreshDomain(this._container);
        return bl;
    }

    class MaterializePage
    extends BaseWizardPage
    implements ActionListener {
        private RepWizWSMatPanel _goPage;

        public MaterializePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("DomainRes", "REP_WS_MAT_TITLE"));
            this._goPage = new RepWizWSMatPanel();
            this.enableBackButton(true);
            this.enableNextButton(true);
            this._goPage.chk_useDumpLoad.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this._goPage.chk_useDumpLoad.setSelected(AddStandbyConnWizard.this._wsMaterialize);
            if (AddStandbyConnWizard.this._wsMaterialize) {
                this._goPage.chk_useMarker.setEnabled(true);
                this._goPage.chk_useMarker.setSelected(AddStandbyConnWizard.this._useMarker);
            } else {
                this._goPage.chk_useMarker.setEnabled(false);
                this._goPage.chk_useMarker.setSelected(false);
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddStandbyConnWizard.this._wsMaterialize = this._goPage.chk_useDumpLoad.isSelected();
            AddStandbyConnWizard.this._useMarker = this._goPage.chk_useMarker.isSelected();
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._goPage.chk_useMarker.setEnabled(this._goPage.chk_useDumpLoad.isSelected());
        }
    }

    class RAPage
    extends BaseWizardPage
    implements DocumentListener {
        private RepWizRAPanel _goPage;

        public RAPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "WIZ_RA_TITLE"));
            this._goPage = new RepWizRAPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = AddStandbyConnWizard.this._db + "_rep_agent";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddStandbyConnWizard.this._raUser = this._goPage.fld_username.getText();
            AddStandbyConnWizard.this._raPwd = this._goPage.fld_password.getPasswordString();
            if (AddStandbyConnWizard.this._raPwd.equals("        ")) {
                AddStandbyConnWizard.this._raPwd = "rep_agent_ps";
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class MaintPage
    extends BaseWizardPage
    implements DocumentListener {
        private ActiveWizMaintPanel _goPage;

        public MaintPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "WIZ_MAINT_TITLE"));
            this._goPage = new ActiveWizMaintPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            try {
                PhyConnection phyConnection = AddStandbyConnWizard.this.getLogConnection().getActiveConnection();
                if (phyConnection != null) {
                    this._goPage.fld_username.setText(phyConnection.getMaintUser());
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._goPage.fld_username.setEditable(false);
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = AddStandbyConnWizard.this._db + "_maint";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddStandbyConnWizard.this._maintUser = this._goPage.fld_username.getText();
            AddStandbyConnWizard.this._maintPwd = this._goPage.fld_password.getPasswordString();
            if (AddStandbyConnWizard.this._maintPwd.equals("        ")) {
                AddStandbyConnWizard.this._maintPwd = "maint_ps";
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class DBPage
    extends BaseWizardPage
    implements ActionListener {
        private StandbyWizDBPanel _goPage;

        public DBPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("LogicalConnectionRes", "STBY_WIZ_DB_TITLE"));
            this._goPage = new StandbyWizDBPanel();
            this.enableBackButton(false);
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            if (this._goPage.cbx_server.isEnabled()) {
                this.load();
                if (AddStandbyConnWizard.this._ds != null && AddStandbyConnWizard.this._ds.length() > 0) {
                    this._goPage.cbx_server.setSelectedItem(AddStandbyConnWizard.this._ds);
                }
                if (AddStandbyConnWizard.this._db != null && AddStandbyConnWizard.this._db.length() > 0) {
                    this._goPage.cbx_database.setSelectedItem(AddStandbyConnWizard.this._db);
                }
            }
            this._goPage.cbx_server.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            if (this._goPage.cbx_server.isEnabled()) {
                AddStandbyConnWizard.this._ds = this._goPage.cbx_server.getSelectedItem().toString();
                AddStandbyConnWizard.this._db = this._goPage.cbx_database.getSelectedItem().toString();
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddStandbyConnWizard.this.getDomainName());
                RepAgent repAgent = semanticFactory.getRepAgent(AddStandbyConnWizard.this._ds, AddStandbyConnWizard.this._db);
                if (repAgent.isEnabled()) {
                    PluginSupport.showWarning(this.getDialogSupport().getParentWindow(), BundleManager.getString("ConnectionRes", "CONN_WIZ_ENABLED_RA_WARNING", AddStandbyConnWizard.this._db), null);
                }
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_server) {
                Object object = this._goPage.cbx_server.getSelectedItem();
                if (object != null) {
                    this.loadDatabases(object.toString());
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(AddStandbyConnWizard.this.getDomainName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddStandbyConnWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(AddStandbyConnWizard.this._container);
                    this.load();
                }
            }
        }

        protected void load() {
            this._goPage.cbx_server.removeActionListener((ActionListener)this);
            this.loadASEServers();
            this._goPage.cbx_server.addActionListener((ActionListener)this);
            Object object = this._goPage.cbx_server.getSelectedItem();
            if (object != null) {
                this.loadDatabases(object.toString());
            }
            this.setButtons();
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_database.getSelectedItem() != null);
        }

        protected void loadASEServers() {
            this._goPage.cbx_server.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddStandbyConnWizard.this.getDomainName());
            if (semanticFactory != null) {
                ListIterator listIterator = semanticFactory.getASEs().listIterator();
                while (listIterator.hasNext()) {
                    ASE aSE = (ASE)listIterator.next();
                    this._goPage.cbx_server.addItem((Object)aSE.getName());
                }
            }
        }

        protected void loadDatabases(String string) {
            SemanticFactory semanticFactory;
            this._goPage.cbx_database.removeAllItems();
            if (string != null && string.length() > 0 && (semanticFactory = PluginSupport.getSemanticFactory(AddStandbyConnWizard.this.getDomainName())) != null) {
                try {
                    List list = semanticFactory.getPhyConnectionsForDataServer(string);
                    ListIterator listIterator = semanticFactory.getDatabases(string).listIterator();
                    while (listIterator.hasNext()) {
                        Database database = (Database)listIterator.next();
                        boolean bl = false;
                        ListIterator listIterator2 = list.listIterator();
                        while (listIterator2.hasNext() && !bl) {
                            PhyConnection phyConnection = (PhyConnection)listIterator2.next();
                            if (!phyConnection.getDB().equals(database.getName())) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        this._goPage.cbx_database.addItem((Object)database.getName());
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
    }
}

