/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.EnvStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionParameter;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainLogConnection
extends EnvStatusSO
implements LogConnection {
    private String _repServer = null;
    private String _LDS = null;
    private String _LDB = null;
    private String _activeDS = null;
    private String _activeDB = null;
    private String _standbyDS = null;
    private String _standbyDB = null;
    private boolean _logConnExists = false;
    private static final int LOGICAL_CONN_NOT_EXIST = 41061;
    private static final int STDB_SWITCH_IN_PROGRESS = 20;
    private static final int STDB_SWITCH_FINISHING_UP = 38;
    private static final int STDB_SWITCHOVER_COMPLETED = 51;
    private static final int STDB_STATE_NONE = 79;
    private static final String PHY_CONN_NOT_SET = "None";
    private String _opInProgress = "";
    private String _opState = "";
    private static final String GET_LOG_CONNS = "GET_LOG_CONNS";
    private static final String GET_LOG_CONN = "GET_LOG_CONN";
    private static final String CONFIG_CONN = "CONFIG_CONN";
    private static final String CREATE_LOG_CONN = "CREATE_LOG_CONN";
    private static final String DROP_CONN = "DROP_CONN";
    private static final String SWITCH_CONN = "SWITCH_CONN";
    private static final String ABORT_SWITCH = "ABORT_SWITCH";
    private static final String LOGICAL_STATUS = "LOGICAL_STATUS";
    private static final Object[][] contents = new Object[][]{{"GET_LOG_CONNS", new Integer(1200), "admin logical_status, print_errno"}, {"GET_LOG_CONN", new Integer(1200), "admin logical_status, {0}, {1}, print_errno"}, {"CREATE_LOG_CONN", new Integer(1200), "create logical connection to \"{0}\".\"{1}\""}, {"DROP_CONN", new Integer(1200), "drop logical connection to \"{0}\".\"{1}\""}, {"SWITCH_CONN", new Integer(1200), "switch active for \"{0}\".\"{1}\" to \"{2}\".\"{3}\" {4}"}, {"ABORT_SWITCH", new Integer(1200), "abort switch for \"{0}\".\"{1}\""}, {"LOGICAL_STATUS", new Integer(1200), "admin logical_status,  \"{0}\", \"{1}\", print_errno"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainLogConnection(String string, String string2, String string3, EnvDomain envDomain) {
        super(string2 + "." + string3, envDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DB parameter.");
        this._repServer = string;
        this._LDS = string2;
        this._LDB = string3;
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        }
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getLDS() {
        Dbg.wassert(this._LDS != null && this._LDB.length() > 0, "Null or empty logical data server name attribute.");
        return this._LDS;
    }

    @Override
    public String getLDB() {
        Dbg.wassert(this._LDB != null && this._LDB.length() > 0, "Null or empty logical database name attribute.");
        return this._LDB;
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._repServer != null && this._repServer.length() > 0, "Null or empty RS name attribute.");
        return this._repServer;
    }

    @Override
    public String getActiveDS() {
        if (this._activeDS == null || this._activeDS.length() == 0) {
            return null;
        }
        return this._activeDS;
    }

    @Override
    public String getActiveDB() {
        if (this._activeDB == null || this._activeDB.length() == 0) {
            return null;
        }
        return this._activeDB;
    }

    @Override
    public String getActiveConnectionName() {
        if (this.getActiveDS() == null || this.getActiveDB() == null) {
            return "";
        }
        return this.getActiveDS() + "." + this.getActiveDB();
    }

    @Override
    public PhyConnection getActiveConnection() throws SQLException {
        SemanticFactory semanticFactory;
        PhyConnection phyConnection = null;
        if (this.isActiveDefined() && (phyConnection = (semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName())).getPhyConnection(this.getControllingRS(), this.getActiveDS(), this.getActiveDB())) != null) {
            phyConnection.load();
        }
        return phyConnection;
    }

    @Override
    public boolean isActiveDefined() {
        return this.getActiveDS() != null && this.getActiveDS().length() > 0;
    }

    @Override
    public String getStandbyDS() {
        if (this._standbyDS == null || this._standbyDS.length() == 0) {
            return "";
        }
        return this._standbyDS;
    }

    @Override
    public String getStandbyDB() {
        if (this._standbyDB == null || this._standbyDB.length() == 0) {
            return null;
        }
        return this._standbyDB;
    }

    @Override
    public String getStandbyConnectionName() {
        if (this.getStandbyDS() == null || this.getStandbyDB() == null) {
            return null;
        }
        return this.getStandbyDS() + "." + this.getStandbyDB();
    }

    @Override
    public PhyConnection getStandbyConnection() throws SQLException {
        SemanticFactory semanticFactory;
        PhyConnection phyConnection = null;
        if (this.isStandbyDefined() && (phyConnection = (semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName())).getPhyConnection(this.getControllingRS(), this.getStandbyDS(), this.getStandbyDB())) != null) {
            phyConnection.load();
        }
        return phyConnection;
    }

    @Override
    public boolean isStandbyDefined() {
        return this.getStandbyDS() != null && this.getStandbyDS().length() > 0;
    }

    @Override
    public boolean isUp() {
        return this.getRSState() == 5;
    }

    @Override
    public boolean isError() {
        return this.getRSState() == 2;
    }

    @Override
    public boolean isWarning() {
        return this.getRSState() == 3;
    }

    @Override
    public String getStateDescription() {
        String string = "";
        if (this.isUp()) {
            string = BundleManager.getString("LogicalConnectionRes", "ACTIVE_STATE");
        } else if (this.isWarning()) {
            string = BundleManager.getString("LogicalConnectionRes", "UNKNOWN_STATE");
        } else if (this.isError()) {
            string = BundleManager.getString("LogicalConnectionRes", "SUSPENDED_STATE");
        }
        return string;
    }

    protected String getOperationInProgress() {
        return this._opInProgress;
    }

    protected void setOperationInProgress(String string) {
        this._opInProgress = string == null ? "" : string;
    }

    protected String getStateOfOperation() {
        return this._opState;
    }

    protected void setStateOfOperation(String string) {
        this._opState = string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLogConnections(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<DomainLogConnection> arrayList = new ArrayList<DomainLogConnection>();
        RSMConnection rSMConnection = envDomain.getConnection(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                if (rSMConnection.isConnectionOpen()) {
                    int n = rSMConnection.getVersionNumber();
                    String string2 = _cmdBundle.getCommand(GET_LOG_CONNS, n);
                    Dbg.wassert(string2 != null, "Unable to get logical connection query, repserver version: " + n);
                    rSMResultSet.open(string2);
                    while (rSMResultSet.getNextRow()) {
                        String string3 = rSMResultSet.getColumnString(1);
                        String string4 = DomainLogConnection.getRSetDS(string3);
                        String string5 = DomainLogConnection.getRSetDB(string3);
                        if (string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                        DomainLogConnection domainLogConnection = new DomainLogConnection(string, string4, string5, envDomain);
                        domainLogConnection.loadDetails(rSMResultSet);
                        domainLogConnection._logConnExists = true;
                        arrayList.add(domainLogConnection);
                    }
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 41061) {
                    throw sQLException;
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getLDS(), this.getLDB()};
            String string = _cmdBundle.getCommand(GET_LOG_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get logical connection query, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.loadDetails(rSMResultSet);
                    this._logConnExists = true;
                } else {
                    this._logConnExists = false;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 41061) {
                    throw sQLException;
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
    }

    protected void loadDetails(RSMResultSet rSMResultSet) throws SQLException {
        String string = rSMResultSet.getColumnString(2);
        this._activeDS = DomainLogConnection.getRSetDS(string);
        this._activeDB = DomainLogConnection.getRSetDB(string);
        string = rSMResultSet.getColumnString(4);
        this._standbyDS = DomainLogConnection.getRSetDS(string);
        this._standbyDB = DomainLogConnection.getRSetDB(string);
        this.setOperationInProgress(rSMResultSet.getColumnString(7));
        this.setStateOfOperation(rSMResultSet.getColumnString(8));
    }

    public static List getLogConnections(EnvDomain envDomain) throws SQLException {
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList arrayList = new ArrayList();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = semanticFactory.getLogConnections(repServer.getName()).listIterator();
            while (listIterator2.hasNext()) {
                arrayList.add(listIterator2.next());
            }
        }
        return arrayList;
    }

    public static List getLogConnectionsforLDS(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical data server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<LogConnection> arrayList = new ArrayList<LogConnection>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = semanticFactory.getLogConnections(repServer.getName()).listIterator();
            while (listIterator2.hasNext()) {
                LogConnection logConnection = (LogConnection)listIterator2.next();
                if (!string.equals(logConnection.getLDS())) continue;
                arrayList.add(logConnection);
            }
        }
        return arrayList;
    }

    @Override
    public boolean exists() {
        return this._logConnExists;
    }

    protected static String getRSetDS(String string) {
        String string2 = null;
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase(PHY_CONN_NOT_SET)) {
            string2 = string.trim();
            int n = string2.indexOf(93);
            if (n >= 0 && n + 1 < string2.length()) {
                if ((n = (string2 = string2.substring(n + 1)).indexOf(46)) >= 0) {
                    string2 = string2.substring(0, n);
                }
                string2 = string2.trim();
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        }
        return string2;
    }

    protected static String getRSetDB(String string) {
        String string2 = null;
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase(PHY_CONN_NOT_SET)) {
            string2 = string.trim();
            int n = string2.indexOf(46);
            if (n >= 0 && n + 1 < string2.length()) {
                string2 = string2.substring(n + 1);
                string2 = string2.trim();
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getLDS(), this.getLDB()};
            String string = _cmdBundle.getCommand(CREATE_LOG_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get create command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getLDS(), this.getLDB()};
            String string = _cmdBundle.getCommand(DROP_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get drop command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void switchActive() {
        final String string = this.getName();
        BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("LogicalConnectionRes", "SWITCH_TITLE", string), this.getDomainName(), false){

            @Override
            public void run() {
                try {
                    Object[] objectArray;
                    this.setStatus(BundleManager.getString("LogicalConnectionRes", "EXEC_SWITCH_CMD"));
                    DomainLogConnection.this.switchActive(false);
                    boolean bl = true;
                    while (!1.interrupted() && bl) {
                        Thread.sleep(2000L);
                        bl = DomainLogConnection.this.getSwitchStatus();
                        objectArray = new String[]{DomainLogConnection.this.getOperationInProgress(), DomainLogConnection.this.getStateOfOperation()};
                        this.setStatus(BundleManager.getString("LogicalConnectionRes", "DISP_STATE", objectArray));
                    }
                    objectArray = PluginSupport.getSemanticFactory(this.getDomainName());
                    RepAgent repAgent = objectArray.getRepAgent(DomainLogConnection.this.getStandbyDS(), DomainLogConnection.this.getStandbyDB());
                    repAgent.start();
                    PhyConnection phyConnection = objectArray.getPhyConnection(DomainLogConnection.this.getControllingRS(), DomainLogConnection.this.getActiveDS(), DomainLogConnection.this.getActiveDB());
                    PhyConnection phyConnection2 = objectArray.getPhyConnection(DomainLogConnection.this.getControllingRS(), DomainLogConnection.this.getStandbyDS(), DomainLogConnection.this.getStandbyDB());
                    boolean bl2 = phyConnection.isRepAgentFiltered();
                    boolean bl3 = phyConnection.isDSIFiltered();
                    phyConnection.filter(phyConnection2.isRepAgentFiltered(), phyConnection2.isDSIFiltered());
                    phyConnection2.filter(bl2, bl3);
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    this.setError(true);
                    this.setStatus(MessageText.formatExceptionMessage(sQLException));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    try {
                        DomainLogConnection.this.abortSwitch();
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                }
                DomainLogConnection.this.getDomain().refreshStatus();
                StatusManager.refresh(this.getDomainName(), DomainLogConnection.this.getType(), string);
                this.close();
            }
        };
        bkgndThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchActive(boolean bl) throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        RepAgent repAgent = semanticFactory.getRepAgent(this.getActiveDS(), this.getActiveDB());
        repAgent.stop(false);
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getLDS(), this.getLDB(), this.getStandbyDS(), this.getStandbyDB(), bl ? "with suspension" : ""};
            String string = _cmdBundle.getCommand(SWITCH_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get switch command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortSwitch() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getLDS(), this.getLDB()};
            String string = _cmdBundle.getCommand(ABORT_SWITCH, n, objectArray);
            Dbg.wassert(string != null, "Unable to get abort switch, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean getSwitchStatus() throws SQLException {
        boolean bl = true;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        int n = rSMConnection.getVersionNumber();
        Object[] objectArray = new String[]{this.getLDS(), this.getLDB()};
        String string = _cmdBundle.getCommand(LOGICAL_STATUS, n, objectArray);
        Dbg.wassert(string != null, "Unable to get logical status command, repserver version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string);
            rSMResultSet.getNextRow();
            this.setOperationInProgress(rSMResultSet.getColumnString(7));
            this.setStateOfOperation(rSMResultSet.getColumnString(8));
            int n2 = rSMResultSet.getColumnInt(10);
            int n3 = rSMResultSet.getColumnInt(11);
            if (n2 != 79 && (n2 != 20 || n3 != 38 && n3 != 51)) return bl;
            bl = false;
            return bl;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    public void monitor() {
        this.setState(5);
        this.clearReasons();
        if (!this.isActiveDefined()) {
            this.setState(3);
            this.addReason(BundleManager.getString("LogicalConnectionRes", "ACTIVE_UNDEFINED", this.getName()));
        }
        if (!this.isStandbyDefined()) {
            this.setState(3);
            this.addReason(BundleManager.getString("LogicalConnectionRes", "STANDBY_UNDEFINED", this.getName()));
        }
        if (this.isUp()) {
            try {
                if (this.getSwitchStatus()) {
                    this.setState(2);
                    this.addReason(this.getStateOfOperation());
                }
            }
            catch (SQLException sQLException) {
                this.setState(2);
                this.addReason(MessageText.formatExceptionMessage(sQLException));
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
        if (this.isUp()) {
            PhyConnection phyConnection;
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            if (this.isActiveDefined()) {
                phyConnection = semanticFactory.getPhyConnection(this.getControllingRS(), this.getActiveDS(), this.getActiveDB());
                if (phyConnection.isRepAgentFiltered()) {
                    this.setState(5);
                } else if (phyConnection.isRepAgentSuspended()) {
                    this.setState(2);
                } else if (phyConnection.isRepAgentUnknown()) {
                    this.setState(3);
                }
                this.addReason(phyConnection.getReasons());
            }
            if (this.isStandbyDefined()) {
                phyConnection = semanticFactory.getPhyConnection(this.getControllingRS(), this.getStandbyDS(), this.getStandbyDB());
                if (phyConnection.isDSIFiltered()) {
                    this.setState(5);
                } else if (phyConnection.isDSISuspended()) {
                    this.setState(2);
                } else if (phyConnection.isDSIUnknown()) {
                    this.setState(3);
                }
                this.addReason(phyConnection.getReasons());
            }
        }
    }

    @Override
    public String getRCLScript() {
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        Object[] objectArray = new String[]{this.getLDS(), this.getLDB()};
        String string = _cmdBundle.getCommand(CREATE_LOG_CONN, n, objectArray);
        String string2 = "-- Create Logical Connection " + this.getName() + "\n" + string;
        try {
            PhyConnection phyConnection;
            PhyConnection phyConnection2 = this.getActiveConnection();
            if (phyConnection2 != null) {
                string2 = string2 + "\ngo\n";
                string2 = string2 + phyConnection2.getActiveRCLScript();
            }
            if ((phyConnection = this.getStandbyConnection()) != null) {
                string2 = string2 + "\ngo\n";
                string2 = string2 + phyConnection.getStandbyRCLScript();
            }
            String string3 = "";
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            List list = semanticFactory.getLogConnectionParameters(this.getControllingRS(), this.getLDS(), this.getLDB());
            if (list != null) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    LogConnectionParameter logConnectionParameter = (LogConnectionParameter)listIterator.next();
                    String string4 = logConnectionParameter.getRCLScript(this.getControllingRS(), this.getLDS(), this.getLDB());
                    if (string4 == null || string4.length() <= 0) continue;
                    string3 = string3 + string4 + "\n";
                }
            }
            if (string3.length() > 0) {
                string2 = string2 + "\ngo\n";
                string2 = string2 + "-- Logical Connection Configuration Parameters\n";
                string2 = string2 + string3;
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return string2;
    }
}

