/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.logical.LogConnectionParameter;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainLogConnectionParameter
extends LogConnectionParameter {
    private EnvDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_DIST = "SET_DIST";
    private static final String SET_PARAM = "SET_PARAM";
    private static final String GET_PARAMS_NEW = "GET_PARAMS_NEW";
    public static final int VIVACI_VERSION_NR = 1501;
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(1200), "rmp_lconnection_demand ''{0}'', ''{1}'', ''{2}''"}, {"GET_PARAMS_NEW", new Integer(1200), "admin config, \"logical_connection\", {0}, {1}"}, {"SET_DIST", new Integer(1200), "alter logical connection to \"{0}\".\"{1}\"\n\tset distribution {2}"}, {"SET_PARAM", new Integer(1200), "alter logical connection to \"{0}\".\"{1}\"\n\tset {2} to ''{3}''"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);
    private static final int ROUTE_WARNING_ERR_CODE = 6087;
    private static final int STRICT_WARNING_ERR_CODE = 15302;

    public DomainLogConnectionParameter(String string, String string2, String string3, EnvDomain envDomain) {
        super(string, string2, string3);
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public DomainLogConnectionParameter(String string, String string2, String string3, String string4, String string5, String string6, int n, EnvDomain envDomain) {
        super(string, string2, string3, string4, string5, string6, n);
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List getLogConnectionParameters(String string, String string2, String string3, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Replication Server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty logical server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty logical database name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<DomainLogConnectionParameter> arrayList = new ArrayList<DomainLogConnectionParameter>();
        int n = envDomain.getVersionNumber(string);
        if (n < 1501) {
            RSMConnection rSMConnection = envDomain.getRSSD(string);
            if (rSMConnection == null) return arrayList;
            int n2 = envDomain.getVersionNumber(string);
            Object[] objectArray = new String[]{string, string2, string3};
            String string4 = _cmdBundle.getCommand(GET_PARAMS, n2, objectArray);
            Dbg.wassert(string4 != null, "Unable to get parameter query command, RS version: " + n2);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                if (!rSMResultSet.getNextRow()) return arrayList;
                int n3 = rSMResultSet.getColumnInt(2);
                String string5 = n3 == 1 ? "on" : "off";
                DomainLogConnectionParameter domainLogConnectionParameter = new DomainLogConnectionParameter("distribution", string5, string5, envDomain);
                arrayList.add(domainLogConnectionParameter);
                string5 = rSMResultSet.getColumnString(3);
                domainLogConnectionParameter = new DomainLogConnectionParameter("save_interval", string5, string5, envDomain);
                arrayList.add(domainLogConnectionParameter);
                string5 = rSMResultSet.getColumnString(4);
                domainLogConnectionParameter = new DomainLogConnectionParameter("materialization_save_interval", string5, string5, envDomain);
                arrayList.add(domainLogConnectionParameter);
                return arrayList;
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        if (n < 1501) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string2), "_RSM_", 3);
        Object[] objectArray = new String[]{string2, string3};
        String string6 = _cmdBundle.getCommand(GET_PARAMS_NEW, n, objectArray);
        Dbg.wassert((string6 = string6.trim()) != null, "Unable to get load command, repserver version: " + n);
        RSMConnection rSMConnection = envDomain.getConnection(string);
        if (rSMConnection == null) return arrayList;
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string6);
            while (rSMResultSet.getNextRow()) {
                String string7 = rSMResultSet.getColumnString(1);
                String string8 = rSMResultSet.getColumnString(2);
                String string9 = rSMResultSet.getColumnString(3);
                String string10 = rSMResultSet.getColumnString(4);
                String string11 = rSMResultSet.getColumnString(5);
                String string12 = rSMResultSet.getColumnString(6);
                String string13 = rSMResultSet.getColumnString(7);
                int n4 = 2;
                if (string12.equalsIgnoreCase("integer")) {
                    n4 = 0;
                } else if (string12.equalsIgnoreCase("real")) {
                    n4 = 1;
                } else if (string12.equalsIgnoreCase("string")) {
                    n4 = 2;
                } else if (string12.equalsIgnoreCase("boolean")) {
                    n4 = 3;
                } else if (string12.equalsIgnoreCase("password")) {
                    n4 = 4;
                }
                DomainLogConnectionParameter domainLogConnectionParameter = new DomainLogConnectionParameter(string7, string9, string8, string10, string11, string13, n4, envDomain);
                arrayList.add(domainLogConnectionParameter);
            }
            return arrayList;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Replication Server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty logical server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty logical database name parameter.");
        if (this.isModified()) {
            RSMConnection rSMConnection = this.getDomain().getConnection(string);
            if (rSMConnection != null) {
                String string4;
                int n;
                if (this.getName().equals("distribution")) {
                    n = rSMConnection.getVersionNumber();
                    Object[] objectArray = new String[]{string2, string3, this.getPendingValue()};
                    string4 = _cmdBundle.getCommand(SET_DIST, n, objectArray);
                    Dbg.wassert(string4 != null, "Unable to get set parameter command, repserver version: " + n);
                } else {
                    n = rSMConnection.getVersionNumber();
                    Object[] objectArray = new String[]{string2, string3, this.getName(), this.getPendingValue()};
                    string4 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
                    Dbg.wassert(string4 != null, "Unable to get set parameter command, repserver version: " + n);
                }
                try {
                    rSMConnection.execute(string4);
                    this.resetOriginalPendingValue();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 15302) {
                        this.resetOriginalPendingValue();
                        throw sQLException;
                    }
                    if (sQLException.getErrorCode() != 6087) {
                        throw sQLException;
                    }
                    this.resetOriginalPendingValue();
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
            }
        }
    }

    @Override
    public String getRCLScript(String string, String string2, String string3) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Replication Server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty logical server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty logical database name parameter.");
        String string4 = "";
        if (!this.getCurrentValue().equals(this.getDefaultValue())) {
            if (this.getName().equals("distribution")) {
                int n = this.getDomain().getVersionNumber(string);
                Object[] objectArray = new String[]{string2, string3, this.getCurrentValue()};
                string4 = _cmdBundle.getCommand(SET_DIST, n, objectArray);
                Dbg.wassert(string4 != null, "Unable to get set parameter command, repserver version: " + n);
            } else {
                int n = this.getDomain().getVersionNumber(string);
                Object[] objectArray = new String[]{string2, string3, this.getName(), this.getCurrentValue()};
                string4 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
                Dbg.wassert(string4 != null, "Unable to get set parameter command, repserver version: " + n);
            }
        }
        return string4;
    }
}

